/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.controls.addressbook.AbstractAddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.DistributionListRenderer;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.addressbook.list.RecipientsList;
import com.novell.gw.jclient.application.controls.addressbook.table.AddressSelectorEntriesTable;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutFocusTraversalPolicy;
import org.apache.log4j.Logger;

public class DLSelectorDialog
extends AbstractAddressSelectorDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$DLSelectorDialog == null ? (class$com$novell$gw$jclient$application$controls$addressbook$DLSelectorDialog = DLSelectorDialog.class$("com.novell.gw.jclient.application.controls.addressbook.DLSelectorDialog")) : class$com$novell$gw$jclient$application$controls$addressbook$DLSelectorDialog));
    private JToggleButton tbTo;
    private JToggleButton tbCC;
    private JToggleButton tbBC;
    private static final String NAME = "DL Selector Dialog";
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$DLSelectorDialog;

    public DLSelectorDialog(JFrame jFrame, List list, MVCController mVCController) {
        super(jFrame, mVCController);
        this.init(list);
    }

    public DLSelectorDialog(JDialog jDialog, List list, MVCController mVCController) {
        super(jDialog, mVCController);
        this.init(list);
    }

    private void init(List list) {
        Command command = new Command(380, list);
        this.getController().processCommand(command);
        this.toggleSizeSaving(NAME);
        this.setFocusTraversalPolicy(new ABFocusTraversalPolicy());
    }

    protected void init() {
        this.listRecipients = new RecipientsList(this.getController());
        this.listRecipients.setCellRenderer(new DistributionListRenderer());
        this.tableAddressList = new AddressSelectorEntriesTable(this.getController(), this.tfSearch);
        super.init();
        this.buildRightPane();
        this.getContentPane().add((Component)this.pnlRight, "After");
    }

    protected void performOkAction() {
        this.setActionCompleteSuccessfully(true);
        Command command = new Command(700, this.listRecipients.getRecipientList());
        this.getController().processCommand(command);
    }

    public List getSelectedRecipients() {
        return this.listRecipients.getRecipientList();
    }

    public List getToRecipients() {
        return this.getRecipientsByCopyType(1);
    }

    public List getCCRecipients() {
        return this.getRecipientsByCopyType(2);
    }

    public List getBCRecipients() {
        return this.getRecipientsByCopyType(4);
    }

    private List getRecipientsByCopyType(int n) {
        List list = this.listRecipients.getRecipientList();
        ArrayList<Recipient> arrayList = new ArrayList<Recipient>();
        for (int i = 0; i < list.size(); ++i) {
            Recipient recipient = (Recipient)list.get(i);
            if ((recipient.getCopyType() & n) != n) continue;
            arrayList.add(recipient);
        }
        return arrayList;
    }

    protected JPanel buildToggleButtons() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(orientablePanel);
        gridBagAdapter.setColumnCount(3);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.tbTo = new DropToggleButton(new ButtonToAction());
        UIUtils.setText(this.tbTo, StringResources.TO);
        this.tbTo.setSelected(true);
        gridBagAdapter.setInsets(new Insets(0, 0, 0, 0));
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.setFill(0);
        gridBagAdapter.addComponent(this.tbTo);
        buttonGroup.add(this.tbTo);
        this.tbCC = new DropToggleButton(new ButtonCcAction());
        UIUtils.setText(this.tbCC, StringResources.CC);
        gridBagAdapter.setInsets(new Insets(0, 20, 0, 20));
        gridBagAdapter.setFill(0);
        gridBagAdapter.setAnchor(10);
        gridBagAdapter.setWidthX(1);
        gridBagAdapter.addComponent(this.tbCC);
        buttonGroup.add(this.tbCC);
        this.tbBC = new DropToggleButton(new ButtonBcAction());
        UIUtils.setText(this.tbBC, StringResources.BC);
        gridBagAdapter.setAnchor(13);
        gridBagAdapter.setFill(0);
        gridBagAdapter.setInsets(new Insets(0, 0, 0, 0));
        gridBagAdapter.addComponent(this.tbBC);
        buttonGroup.add(this.tbBC);
        return orientablePanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ABFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private ABFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            if (component.equals(DLSelectorDialog.this.tableAddressList)) {
                return DLSelectorDialog.this.tbTo;
            }
            return super.getComponentAfter(container, component);
        }

        public Component getComponentBefore(Container container, Component component) {
            if (component.equals(DLSelectorDialog.this.tbTo)) {
                return DLSelectorDialog.this.tableAddressList;
            }
            return super.getComponentBefore(container, component);
        }
    }

    private class DropToggleButton
    extends JToggleButton {
        public DropToggleButton(Action action) {
            super(action);
            this.setDropTarget(new DropTarget(this, 3, new DTDTListener()));
        }

        private class DTDTListener
        extends DropTargetAdapter {
            private DTDTListener() {
            }

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                if (!dropTargetDropEvent.isLocalTransfer()) {
                    return;
                }
                try {
                    if (dropTargetDropEvent.getTransferable().getTransferData(GWFlavors.contactsFlavor) instanceof Contact) {
                        if (DropToggleButton.this.getAction() instanceof ButtonToAction) {
                            DLSelectorDialog.this.getController().getActionList().performAction("Move To Recipients List to");
                        } else if (DropToggleButton.this.getAction() instanceof ButtonCcAction) {
                            DLSelectorDialog.this.getController().getActionList().performAction("Move To Recipients List cc");
                        } else if (DropToggleButton.this.getAction() instanceof ButtonBcAction) {
                            DLSelectorDialog.this.getController().getActionList().performAction("Move To Recipients List bc");
                        }
                    } else {
                        dropTargetDropEvent.rejectDrop();
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    logger.error((Object)unsupportedFlavorException);
                    logger.debug((Object)unsupportedFlavorException, (Throwable)unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException);
                    logger.debug((Object)iOException, (Throwable)iOException);
                }
            }
        }
    }

    private class ButtonBcAction
    extends AbstractAction {
        private ButtonBcAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DLSelectorDialog.this.setCopyType(4);
            DLSelectorDialog.this.getController().getActionList().performAction("Move To Recipients List bc");
        }
    }

    private class ButtonCcAction
    extends AbstractAction {
        private ButtonCcAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DLSelectorDialog.this.setCopyType(2);
            DLSelectorDialog.this.getController().getActionList().performAction("Move To Recipients List cc");
        }
    }

    private class ButtonToAction
    extends AbstractAction {
        private ButtonToAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DLSelectorDialog.this.setCopyType(1);
            DLSelectorDialog.this.getController().getActionList().performAction("Move To Recipients List to");
        }
    }
}

