/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.AddressBookEvent;
import com.novell.gw.ab.AddressBookEventListener;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.addressbook.DirectoriesTreeController;
import com.novell.gw.jclient.application.controls.addressbook.DirectoriesTreeModel;
import com.novell.gw.jclient.application.controls.folderstree.GWTree;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.menus.DirectoriesTreePopupMenu;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DirectoriesTree
extends GWTree
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$DirectoriesTree == null ? (class$com$novell$gw$jclient$application$controls$addressbook$DirectoriesTree = DirectoriesTree.class$("com.novell.gw.jclient.application.controls.addressbook.DirectoriesTree")) : class$com$novell$gw$jclient$application$controls$addressbook$DirectoriesTree));
    private DirectoriesTreeController controller;
    private AbstractAddressBook targetDirectory;
    private AddressBookEventListener addressBookEventListener;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$DirectoriesTree;

    public DirectoriesTree(MVCController mVCController) {
        this.controller = new DirectoriesTreeController(this, mVCController);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setCellRenderer(new Renderrer());
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(new SelectionListener());
        this.setModel(new DirectoriesTreeModel());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addMouseListener(new MouseListener());
        this.setDropTarget(new DropTarget(this, 3, new DTDropTargetListener()));
        this.setSelectedNode(OptionManager.getInstance().getGeneralOptions().getSelectedAddressBookID());
        this.addressBookEventListener = new AddressBookEventListener(){

            public void bookChanged(AddressBookEvent addressBookEvent) {
                DirectoriesTree.this.updateTree(addressBookEvent);
            }

            public void entryChanged(AddressBookEvent addressBookEvent) {
                DirectoriesTree.this.updateTree(addressBookEvent);
            }
        };
        EngineCommandManager.getAddressBookManager().addAddressBookEventListener(this.addressBookEventListener);
        this.setToolTipFont(this.getFont());
    }

    public void dispose() {
        ((DefaultMutableTreeNode)this.getModel().getRoot()).removeAllChildren();
        this.setModel(null);
        EngineCommandManager.getAddressBookManager().removeAddressBookEventListener(this.addressBookEventListener);
    }

    private void updateTree(final AddressBookEvent addressBookEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.update(addressBookEvent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DirectoriesTree.this.update(addressBookEvent);
                }
            });
        }
    }

    public void update(AddressBookEvent addressBookEvent) {
        String string = String.valueOf(addressBookEvent.getBookId());
        int n = this.getLeadSelectionRow();
        DirectoriesTreeModel directoriesTreeModel = (DirectoriesTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)directoriesTreeModel.getRoot();
        switch (addressBookEvent.getType()) {
            case 1: {
                AbstractAddressBook abstractAddressBook = EngineCommandManager.getAddressBook(string);
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(abstractAddressBook));
                directoriesTreeModel.nodeChanged(defaultMutableTreeNode);
                break;
            }
            case 2: {
                directoriesTreeModel.getDirectoryNode(string).removeFromParent();
                directoriesTreeModel.nodeChanged(defaultMutableTreeNode);
                break;
            }
            case 3: {
                directoriesTreeModel.nodeChanged(directoriesTreeModel.getDirectoryNode(string));
            }
        }
        this.clearSelection();
        this.updateUI();
        this.selectNearestRow(n);
    }

    private void setSelectedNode(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        AbstractAddressBook abstractAddressBook = null;
        if (string != null) {
            abstractAddressBook = (AbstractAddressBook)EngineCommandManager.getDirectories().getIDObject(string);
            if (defaultMutableTreeNode.getChildCount() > 0 && defaultMutableTreeNode.getFirstChild() != null) {
                TreePath treePath = null;
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                    if (!defaultMutableTreeNode2.getUserObject().equals(abstractAddressBook)) continue;
                    treePath = new TreePath(defaultMutableTreeNode2.getPath());
                }
                if (treePath == null) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
                    treePath = new TreePath(defaultMutableTreeNode3.getPath());
                }
                this.setSelectionPath(treePath);
            }
        }
    }

    private void selectNearestRow(int n) {
        int n2 = n;
        int n3 = this.getRowCount();
        n2 = n2 >= n3 ? n3 - 1 : n;
        this.setSelectionRow(n2);
    }

    public void setController(MVCController mVCController) {
        if (!(mVCController instanceof DirectoriesTreeController)) {
            throw new IllegalArgumentException("Bad controller");
        }
        this.controller = (DirectoriesTreeController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
    }

    public Object getMVCModel() {
        return null;
    }

    public void repaintDragFolder(Point point) {
        super.repaintDragFolder(point);
        this.getDirectoryForPath(this.getPathForRow(this.lastSelectedRow));
    }

    private void getDirectoryForPath(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (!defaultMutableTreeNode.isLeaf()) {
            this.expandPath(treePath);
        }
        this.targetDirectory = (AbstractAddressBook)defaultMutableTreeNode.getUserObject();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DTDropTargetListener
    extends DropTargetAdapter {
        private DTDropTargetListener() {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            DirectoriesTree.this.repaintDragFolder(dropTargetDragEvent.getLocation());
            if (DirectoriesTree.this.targetDirectory instanceof GroupWiseAddressBook) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(3);
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            DirectoriesTree.this.targetDirectory = null;
            DirectoriesTree.this.repaint();
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DirectoriesTree.this.repaint();
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.isLocalTransfer()) {
                try {
                    Object object = dropTargetDropEvent.getTransferable().getTransferData(GWFlavors.contactsFlavor);
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    if (object instanceof List) {
                        List list = (List)object;
                        ABUtils.copyContacts(DirectoriesTree.this.targetDirectory, list, DirectoriesTree.this);
                        dropTargetDropEvent.dropComplete(true);
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    logger.error((Object)unsupportedFlavorException);
                    logger.debug((Object)unsupportedFlavorException, (Throwable)unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException);
                    logger.debug((Object)iOException, (Throwable)iOException);
                }
                DirectoriesTree.this.targetDirectory = null;
                DirectoriesTree.this.repaint();
            }
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = DirectoriesTree.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n < 0) {
                    return;
                }
                DirectoriesTree.this.setSelectionRow(n);
                Object object = ((DefaultMutableTreeNode)DirectoriesTree.this.getSelectionPath().getLastPathComponent()).getUserObject();
                DirectoriesTreePopupMenu directoriesTreePopupMenu = new DirectoriesTreePopupMenu(DirectoriesTree.this.getController().getActionList(), (AbstractAddressBook)object);
                ((JPopupMenu)directoriesTreePopupMenu).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object = treeSelectionEvent.getPath().getLastPathComponent();
            if (((DefaultMutableTreeNode)object).getUserObject() instanceof AbstractAddressBook) {
                AbstractAddressBook abstractAddressBook = (AbstractAddressBook)((DefaultMutableTreeNode)object).getUserObject();
                Command command = new Command(360, abstractAddressBook);
                DirectoriesTree.this.getController().processCommand(command);
                GeneralOptions generalOptions = OptionManager.getInstance().getGeneralOptions();
                generalOptions.setSelectedAddressBookID(abstractAddressBook.getID());
                OptionManager.getInstance().setGeneralOptions(generalOptions);
            }
        }
    }

    private class Renderrer
    extends DefaultTreeCellRenderer
    implements TextTreeRenderer {
        public Renderrer() {
            this.backgroundNonSelectionColor = new ColorUIResource(DirectoriesTree.this.getBackground());
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            if (DirectoriesTree.this.targetDirectory != null) {
                object2 = ((DefaultMutableTreeNode)object).getUserObject();
                bl = object2 != null && object2.equals(DirectoriesTree.this.targetDirectory);
            }
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof AbstractAddressBook) {
                this.setIcon(ControlsUtils.getIconForAddressBook((AbstractAddressBook)object2));
            } else {
                this.setIcon(null);
            }
            return this;
        }

        public int getTextX() {
            return ImageResources.ICON_SHARED_BY_ME_ADDRESS_BOOK.getIconWidth() + this.getIconTextGap();
        }
    }
}

