/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.ApplicationFrame;
import com.appframework.components.GWTextArea;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.CenteredDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.SharedAddressBookNotificationItem;
import com.novell.gw.message.SharedAddressBookNotification;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class InstallSharedABDialog
extends CenteredDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$InstallSharedABDialog == null ? (class$com$novell$gw$jclient$application$controls$addressbook$InstallSharedABDialog = InstallSharedABDialog.class$("com.novell.gw.jclient.application.controls.addressbook.InstallSharedABDialog")) : class$com$novell$gw$jclient$application$controls$addressbook$InstallSharedABDialog));
    private SharedAddressBookNotificationItem notification;
    private JPanel pnlContent = new OrientablePanel(new GridBagLayout());
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$InstallSharedABDialog;
    static /* synthetic */ Class class$com$appframework$ApplicationFrame;

    public InstallSharedABDialog(Frame frame, SharedAddressBookNotificationItem sharedAddressBookNotificationItem) {
        super(frame, true);
        this.notification = sharedAddressBookNotificationItem;
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.INSTALL_SHARED_ADDRESS_BOOK);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.buildContentPane();
        container.add((Component)this.pnlContent, "Center");
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.add((Component)new JLabel(ImageResources.INSTALL_SHARED_AB), "Center");
        orientablePanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        container.add((Component)orientablePanel, "Before");
        this.buildBottomPane(container);
    }

    private void buildBottomPane(Container container) {
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(4, 5, 5));
        JButton jButton = new JButton(new ActionAccept());
        JButton jButton2 = new JButton(new ActionDecline());
        JButton jButton3 = new JButton(new ActionCancel());
        this.setDefaultButton(jButton);
        this.setCancelButton(jButton3);
        if (OS.isMacOS()) {
            orientablePanel.add(jButton3);
            orientablePanel.add(jButton2);
            orientablePanel.add(jButton);
        } else {
            orientablePanel.add(jButton);
            orientablePanel.add(jButton2);
            orientablePanel.add(jButton3);
        }
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        orientablePanel2.add((Component)jLabel, "North");
        orientablePanel2.add((Component)orientablePanel, "South");
        orientablePanel2.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        container.add((Component)orientablePanel2, "South");
    }

    private void buildContentPane() {
        this.pnlContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(12, 0, 5, 0);
        String string = StringResources.formatString(StringResources.SHARING_OF_ADDRESS_BOOK, new String[]{((SharedAddressBookNotification)this.notification.getNativeItem()).getAddressBookName()});
        this.pnlContent.add((Component)new JLabel(string), gridBagConstraints);
        this.pnlContent.add((Component)new JLabel(StringResources.TO_INSTALL_THIS_ADDRESS_BOOK), gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 20;
        string = StringResources.formatString(StringResources.MESSAGE_FROM_PC, new String[]{this.notification.getSender().getDisplayText()});
        this.pnlContent.add((Component)new JLabel(string), gridBagConstraints);
        GWTextArea gWTextArea = new GWTextArea(6, 1);
        ((JTextComponent)gWTextArea).setEditable(false);
        gWTextArea.setBackground(this.pnlContent.getBackground());
        ((JTextComponent)gWTextArea).setText(this.notification.getMessage().getMessage());
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.top = 3;
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(gWTextArea);
        orientableScrollPane.setVerticalScrollBarPolicy(22);
        gridBagConstraints.weighty = 1.0;
        this.pnlContent.add((Component)orientableScrollPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 0;
        this.pnlContent.add((Component)new JLabel(StringResources.YOU_HAVE_BEEN_GRANTED), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 23;
        this.pnlContent.add((Component)new JLabel(this.notification.getTextGrantedRights()), gridBagConstraints);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ActionDecline
    extends AbstractAction {
        public ActionDecline() {
            super(StringResources.DECLINE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                InstallSharedABDialog.this.dispose();
                String string = ((ApplicationFrame)SwingUtilities.getAncestorOfClass(class$com$appframework$ApplicationFrame == null ? (class$com$appframework$ApplicationFrame = InstallSharedABDialog.class$("com.appframework.ApplicationFrame")) : class$com$appframework$ApplicationFrame, InstallSharedABDialog.this)).getUserGuid();
                GWCommandManager.getInstance(string).rejectSharedAddressBook(InstallSharedABDialog.this.notification);
            }
            catch (GWCommandException gWCommandException) {
                logger.error((Object)gWCommandException);
                logger.debug((Object)gWCommandException, (Throwable)gWCommandException);
            }
        }
    }

    class ActionCancel
    extends AbstractAction {
        public ActionCancel() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InstallSharedABDialog.this.dispose();
        }
    }

    class ActionAccept
    extends AbstractAction {
        public ActionAccept() {
            super(StringResources.ACCEPT);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                InstallSharedABDialog.this.dispose();
                String string = ((ApplicationFrame)SwingUtilities.getAncestorOfClass(class$com$appframework$ApplicationFrame == null ? (class$com$appframework$ApplicationFrame = InstallSharedABDialog.class$("com.appframework.ApplicationFrame")) : class$com$appframework$ApplicationFrame, InstallSharedABDialog.this)).getUserGuid();
                GWCommandManager.getInstance(string).acceptSharedAddressBook(InstallSharedABDialog.this.notification);
            }
            catch (GWCommandException gWCommandException) {
                logger.error((Object)gWCommandException);
                logger.debug((Object)gWCommandException, (Throwable)gWCommandException);
            }
        }
    }
}

