/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.GWTextArea;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.ab.Address;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.GroupContact;
import com.novell.gw.ab.Recipient;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.addressbook.GroupMembersDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.MembersListRenderer;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

class GroupDetailsPane
extends ContactDetailsPane {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$dialogs$ContactDetailsPane == null ? (class$com$novell$gw$jclient$application$controls$addressbook$dialogs$ContactDetailsPane = GroupDetailsPane.class$("com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane")) : class$com$novell$gw$jclient$application$controls$addressbook$dialogs$ContactDetailsPane));
    private GroupContact contact;
    private JTextField tfName = new OrientableTextField();
    private JTextArea taComments = new GWTextArea(5, 1);
    private JList listMembers = new JList();
    private Model model = new Model();
    private JDialog parent;
    private List removedContacts = new ArrayList();
    private List originalContacts = new ArrayList();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$dialogs$ContactDetailsPane;

    public GroupDetailsPane(GroupContact groupContact, JDialog jDialog) {
        this.contact = groupContact;
        this.parent = jDialog;
        this.setName(StringResources.DETAILS);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void buildUI() {
        TitleValueContainer titleValueContainer = new TitleValueContainer(this);
        this.listMembers.setModel(this.model);
        this.listMembers.setCellRenderer(new MembersListRenderer());
        this.listMembers.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (keyEvent.getKeyCode() == n) {
                    GroupDetailsPane.this.removeSelectedMembers();
                }
            }
        });
        this.listMembers.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent)) {
                    GroupDetailsPane.this.viewDeails();
                }
            }
        });
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.NAME_C, this.tfName), this.tfName, 0);
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.taComments);
        orientableScrollPane.setVerticalScrollBarPolicy(22);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.COMMENTS_C, this.taComments), orientableScrollPane, 1);
        orientableScrollPane = new OrientableScrollPane(this.listMembers);
        orientableScrollPane.setPreferredSize(new Dimension(300, 230));
        titleValueContainer.buildRow((JComponent)new JButton(new SelectMembersActions()), (JComponent)orientableScrollPane, 2, true);
    }

    private void viewDeails() {
        Object e = this.listMembers.getSelectedValue();
        if (e instanceof Recipient) {
            Recipient recipient = (Recipient)e;
            ContactDetailsDialog contactDetailsDialog = ContactDetailsDialog.createContactDetailsDialog(this.parent, recipient.getAddressable());
            contactDetailsDialog.showMe();
        }
    }

    public boolean addRecipients(List list) {
        return this.model.getMembersList().addAll(list);
    }

    private void removeSelectedMembers() {
        Object[] objectArray = this.listMembers.getSelectedValues();
        int n = this.listMembers.getSelectedIndex();
        for (int i = 0; i < objectArray.length; ++i) {
            Recipient recipient = (Recipient)objectArray[i];
            this.model.getMembersList().remove(recipient);
            this.listMembers.setModel(this.model);
            this.removedContacts.add(recipient.getAddressable());
        }
        this.listMembers.repaint();
        if (n != -1) {
            this.selectNearestIndex(n);
        }
    }

    private void selectNearestIndex(int n) {
        int n2 = this.listMembers.getModel().getSize();
        if (n2 == 0) {
            return;
        }
        int n3 = n >= n2 ? n2 - 1 : n;
        this.listMembers.setSelectedIndex(n3);
    }

    public void readContactProperties() {
        this.tfName.setText(this.contact.getDisplayName());
        this.taComments.setText(this.contact.getComments());
        this.readGroupMembers();
    }

    private void readGroupMembers() {
        try {
            ItemList itemList = this.contact.getMembers();
            for (int i = 0; i < itemList.getSize(); ++i) {
                Contact contact = (Contact)itemList.getItemAt(i);
                this.originalContacts.add(new Recipient((Addressable)contact, contact.getDistributionType()));
            }
            this.model.getMembersList().addAll(this.originalContacts);
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException);
            logger.debug((Object)engineException, (Throwable)engineException);
        }
    }

    public void writeContactProperties() {
        this.contact.setDisplayName(this.tfName.getText());
        this.contact.setComments(this.taComments.getText());
    }

    public void writeGroupMembers() {
        ItemList itemList = null;
        try {
            itemList = this.contact.getMembers();
            for (int i = 0; i < itemList.getSize(); ++i) {
                Contact contact = (Contact)itemList.getItemAt(i);
                if (!this.removedContacts.contains(contact)) continue;
                this.contact.removeMember(contact);
            }
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException);
            logger.debug((Object)engineException, (Throwable)engineException);
        }
        List list = this.model.getMembersList();
        for (int i = 0; i < list.size(); ++i) {
            Recipient recipient = (Recipient)list.get(i);
            if (this.originalContacts.contains(recipient.getAddressable())) continue;
            try {
                Addressable addressable = recipient.getAddressable();
                if (addressable instanceof Address) {
                    PersonalAddressBook personalAddressBook = (PersonalAddressBook)EngineCommandManager.getAddressBook(String.valueOf(this.contact.getBookId()));
                    Contact contact = GWEngineUtils.createContact(personalAddressBook, 0);
                    contact.setEmailAddress(addressable.getEmailAddress());
                    contact.setDisplayName(addressable.getDisplayName());
                    addressable = contact;
                }
                this.contact.addMember((Contact)addressable, recipient.getCopyType());
                continue;
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException);
                logger.debug((Object)engineException, (Throwable)engineException);
            }
        }
    }

    private static List contactListFromRecipient(List list) {
        ArrayList<Addressable> arrayList = new ArrayList<Addressable>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(((Recipient)list.get(i)).getAddressable());
        }
        return arrayList;
    }

    public JComponent getDefaultComponent() {
        return this.tfName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SelectMembersActions
    extends AbstractAction {
        public SelectMembersActions() {
            super(StringResources.MEMBERS);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupMembersDialog groupMembersDialog = new GroupMembersDialog(GroupDetailsPane.this.parent, GroupDetailsPane.this.model.getMembersList(), (MVCController)GWClient.getApplication());
            groupMembersDialog.pack();
            groupMembersDialog.showMe();
            if (groupMembersDialog.isActionCompleteSuccessfully()) {
                List list = groupMembersDialog.getSelectedRecipients();
                List list2 = GroupDetailsPane.this.model.getContactsList();
                List list3 = GroupDetailsPane.contactListFromRecipient(list);
                for (int i = 0; i < list2.size(); ++i) {
                    if (list3.contains(list2.get(i))) continue;
                    GroupDetailsPane.this.removedContacts.add(list2.get(i));
                }
                GroupDetailsPane.this.model.getMembersList().clear();
                GroupDetailsPane.this.model.getMembersList().addAll(list);
                GroupDetailsPane.this.listMembers.updateUI();
            }
        }
    }

    private class Model
    extends DefaultListModel {
        private List membersList = new ArrayList();

        public void setMembersList(List list) {
            this.membersList = list;
        }

        public List getMembersList() {
            return this.membersList;
        }

        public int getSize() {
            if (this.membersList == null) {
                return 0;
            }
            return this.membersList.size();
        }

        public List getContactsList() {
            ArrayList<Addressable> arrayList = new ArrayList<Addressable>(this.membersList.size());
            for (int i = 0; i < this.membersList.size(); ++i) {
                arrayList.add(((Recipient)this.membersList.get(i)).getAddressable());
            }
            return arrayList;
        }

        public Object getElementAt(int n) {
            return this.membersList.get(n);
        }
    }
}

