/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.GWTextArea;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.SystemAddressBook;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ABListModel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.SaveableDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class NCSearchOrderDialog
extends SaveableDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$dialogs$NCSearchOrderDialog == null ? (class$com$novell$gw$jclient$application$controls$addressbook$dialogs$NCSearchOrderDialog = NCSearchOrderDialog.class$("com.novell.gw.jclient.application.controls.addressbook.dialogs.NCSearchOrderDialog")) : class$com$novell$gw$jclient$application$controls$addressbook$dialogs$NCSearchOrderDialog));
    private ABListModel modelAvailable = new ABListModel();
    private ABListModel modelSelected = new ABListModel();
    JList listAvailBooks = new OrientableList((ListModel)this.modelAvailable);
    JList listSelectedBooks = new OrientableList((ListModel)this.modelSelected);
    private JButton btnDown = new JButton(new DownAction());
    private JButton btnUp = new JButton(new UpAction());
    private JButton btnRemove = new JButton(new RemoveAction());
    private JButton btnAdd = new JButton(new AddAction());
    private JCheckBox cbDisable = new OrientableCheckBox(StringResources.DISABLE_NAME_COMPLETION);
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$dialogs$NCSearchOrderDialog;

    public NCSearchOrderDialog(JFrame jFrame) throws HeadlessException {
        super(jFrame, true);
        this.setTitle(StringResources.NAME_COMPLETION_SEARCH_ORDER);
        this.init();
        this.buildUI();
    }

    private void buildUI() {
        ComponentOrientation componentOrientation = UIUtils.getComponentOrientation();
        this.listAvailBooks.setComponentOrientation(componentOrientation);
        this.listSelectedBooks.setComponentOrientation(componentOrientation);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.buildAvailableBooksPane(), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 20;
        orientablePanel.add((Component)this.buildSelectedBooksPane(), gridBagConstraints);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(5, 10));
        jPanel.add((Component)orientablePanel, "Center");
        jPanel.add((Component)this.buildBottomPane(), "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private JPanel buildAvailableBooksPane() {
        Object object;
        ArrayList<AddressBook> arrayList = new ArrayList<AddressBook>();
        List<AddressBook> list = Arrays.asList(EngineCommandManager.getNCCSearchOrder());
        Iterator iterator = EngineCommandManager.getAddressBookManager().getPersonalAddressBooksIterator();
        while (iterator.hasNext()) {
            object = (AddressBook)iterator.next();
            if (list.contains(object)) continue;
            arrayList.add((AddressBook)object);
        }
        this.modelAvailable.setData(arrayList);
        this.listAvailBooks.getSelectionModel().setSelectionMode(0);
        if (this.listAvailBooks.getModel().getSize() > 0) {
            this.listAvailBooks.setSelectedIndex(0);
        }
        object = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.bottom = 10;
        ((Container)object).add((Component)new JMnemonicLabel(StringResources.AVAILABLE_BOOKS_C, this.listAvailBooks), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ((Container)object).add((Component)new OrientableScrollPane(this.listAvailBooks), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ((Container)object).add((Component)this.btnAdd, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        ((Container)object).add((Component)this.btnRemove, gridBagConstraints);
        return object;
    }

    private JPanel buildSelectedBooksPane() {
        this.modelSelected.setData(new ArrayList<AddressBook>(Arrays.asList(EngineCommandManager.getNCCSearchOrder())));
        this.listSelectedBooks.getSelectionModel().setSelectionMode(0);
        JButton jButton = new JButton(new CancelAction());
        this.setCancelButton(jButton);
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout());
        orientablePanel.add(this.btnDown);
        orientablePanel.add(this.btnUp);
        orientablePanel.setBorder(new TitledBorder(StringResources.BOOK_POSITION));
        OrientablePanel orientablePanel2 = new OrientablePanel(new GridBagLayout());
        orientablePanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom = 10;
        orientablePanel2.add((Component)new JMnemonicLabel(StringResources.SELECTED_BOOKS_C, this.listSelectedBooks), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        orientablePanel2.add((Component)new OrientableScrollPane(this.listSelectedBooks), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        orientablePanel2.add((Component)new JButton(new OkAction()), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        orientablePanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        orientablePanel2.add((Component)orientablePanel, gridBagConstraints);
        return orientablePanel2;
    }

    private void init() {
        this.listSelectedBooks.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = NCSearchOrderDialog.this.listSelectedBooks.getSelectedIndex();
                if (n >= 0) {
                    NCSearchOrderDialog.this.btnUp.setEnabled(n != 0);
                    NCSearchOrderDialog.this.btnDown.setEnabled(n != NCSearchOrderDialog.this.listSelectedBooks.getModel().getSize() - 1);
                    NCSearchOrderDialog.this.btnRemove.setEnabled(!(NCSearchOrderDialog.this.modelSelected.getData().get(n) instanceof SystemAddressBook));
                } else {
                    NCSearchOrderDialog.this.btnRemove.setEnabled(false);
                }
            }
        });
        this.listSelectedBooks.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (NCSearchOrderDialog.this.modelSelected.getData().get(n) instanceof SystemAddressBook) {
                    component.setEnabled(false);
                }
                return component;
            }
        });
        this.listAvailBooks.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = NCSearchOrderDialog.this.listAvailBooks.getSelectedIndex();
                NCSearchOrderDialog.this.btnAdd.setEnabled(n >= 0);
            }
        });
        this.listAvailBooks.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent) && NCSearchOrderDialog.this.btnAdd.isEnabled()) {
                    NCSearchOrderDialog.this.btnAdd.getAction().actionPerformed(null);
                }
            }
        });
        this.listSelectedBooks.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent) && NCSearchOrderDialog.this.btnRemove.isEnabled()) {
                    NCSearchOrderDialog.this.btnRemove.getAction().actionPerformed(null);
                }
            }
        });
        this.toggleSizeSaving("NCSearch order Dialog");
    }

    private JPanel buildBottomPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        this.cbDisable.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        orientablePanel.add((Component)this.cbDisable, gridBagConstraints);
        this.cbDisable.setEnabled(false);
        orientablePanel.add((Component)this.cbDisable, gridBagConstraints);
        GWTextArea gWTextArea = new GWTextArea();
        gWTextArea.setBackground(orientablePanel.getBackground());
        String string = "";
        string = EngineCommandManager.getGroupWiseAdressBook().getName();
        ((JTextComponent)gWTextArea).setText(StringResources.formatString(StringResources.THE_NOVELL_SYSTEM, new String[]{string}));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        orientablePanel.add((Component)new OrientableScrollPane(gWTextArea), gridBagConstraints);
        return orientablePanel;
    }

    private void selectNearestIndex(int n, JList jList) {
        int n2 = jList.getModel().getSize();
        if (n2 == 0) {
            return;
        }
        int n3 = n >= n2 ? n2 - 1 : n;
        jList.setSelectedIndex(n3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UpAction
    extends AbstractAction {
        public UpAction() {
            super(StringResources.UP);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = NCSearchOrderDialog.this.listSelectedBooks.getSelectedIndex();
            NCSearchOrderDialog.this.modelSelected.moveUp(n);
            NCSearchOrderDialog.this.listSelectedBooks.setSelectedIndex(--n);
        }
    }

    private class DownAction
    extends AbstractAction {
        public DownAction() {
            super(StringResources.DOWN);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = NCSearchOrderDialog.this.listSelectedBooks.getSelectedIndex();
            NCSearchOrderDialog.this.modelSelected.moveDown(n);
            NCSearchOrderDialog.this.listSelectedBooks.setSelectedIndex(++n);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NCSearchOrderDialog.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddressBook[] addressBookArray = new AddressBook[NCSearchOrderDialog.this.modelSelected.getSize()];
            for (int i = 0; i < addressBookArray.length; ++i) {
                addressBookArray[i] = (AddressBook)NCSearchOrderDialog.this.modelSelected.getData().get(i);
            }
            EngineCommandManager.setNCCSearchOrder(addressBookArray);
            NCSearchOrderDialog.this.dispose();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            String string = "<<";
            this.putValue("Name", string + StringResources.REMOVE + string);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = NCSearchOrderDialog.this.listSelectedBooks.getSelectedIndex();
            AddressBook addressBook = (AddressBook)NCSearchOrderDialog.this.modelSelected.getData().get(n);
            NCSearchOrderDialog.this.modelSelected.removeItem(addressBook);
            NCSearchOrderDialog.this.modelAvailable.addItem(addressBook);
            NCSearchOrderDialog.this.selectNearestIndex(n, NCSearchOrderDialog.this.listSelectedBooks);
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            String string = ">>";
            this.putValue("Name", string + StringResources.ADD + string);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = NCSearchOrderDialog.this.listAvailBooks.getSelectedIndex();
            AddressBook addressBook = (AddressBook)NCSearchOrderDialog.this.modelAvailable.getData().get(n);
            NCSearchOrderDialog.this.modelAvailable.removeItem(addressBook);
            NCSearchOrderDialog.this.modelSelected.addItem(addressBook);
            NCSearchOrderDialog.this.selectNearestIndex(n, NCSearchOrderDialog.this.listAvailBooks);
        }
    }
}

