/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.ApplicationFrame;
import com.appframework.components.EmptyStringDocumentListener;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class NewDirectoryDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$dialogs$NewDirectoryDialog == null ? (class$com$novell$gw$jclient$application$controls$addressbook$dialogs$NewDirectoryDialog = NewDirectoryDialog.class$("com.novell.gw.jclient.application.controls.addressbook.dialogs.NewDirectoryDialog")) : class$com$novell$gw$jclient$application$controls$addressbook$dialogs$NewDirectoryDialog));
    private JTextField tfDirectoryName = new OrientableTextField();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$dialogs$NewDirectoryDialog;

    public NewDirectoryDialog(ApplicationFrame applicationFrame) throws HeadlessException {
        super(applicationFrame);
        this.setTitle(StringResources.CREATE_NEW_ADDRESS_BOOK);
        this.buildUI();
    }

    private void buildUI() {
        this.btnOK = new JButton(new OkAction());
        this.setDefaultButton(this.btnOK);
        this.tfDirectoryName.getDocument().addDocumentListener(new EmptyStringDocumentListener(this.btnOK.getAction()));
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(orientablePanel);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.setRowCount(2);
        gridBagAdapter.setInsets(new Insets(10, 5, 10, 5));
        gridBagAdapter.setFill(0);
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.addComponent(new JMnemonicLabel(StringResources.CREATE_ADDRESS_BOOK_C, this.tfDirectoryName));
        gridBagAdapter.setWidthX(1);
        gridBagAdapter.setFill(2);
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.addComponent(this.tfDirectoryName);
        gridBagAdapter.setWidthY(1);
        gridBagAdapter.addComponent(new OrientableLabel());
        this.getContentPane().add((Component)orientablePanel, "Center");
        OrientablePanel orientablePanel2 = new OrientablePanel(new GridBagLayout());
        gridBagAdapter = new GridBagAdapter(orientablePanel2);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.setRowCount(2);
        gridBagAdapter.setInsets(new Insets(10, 5, 10, 5));
        gridBagAdapter.addComponent(this.btnOK);
        gridBagAdapter.addComponent(this.btnCancel);
        OrientablePanel orientablePanel3 = new OrientablePanel(new BorderLayout());
        orientablePanel3.add((Component)orientablePanel2, "North");
        this.getContentPane().setComponentOrientation(UIUtils.getComponentOrientation());
        this.getContentPane().add((Component)orientablePanel3, "After");
    }

    public String getDirectoryName() {
        return this.tfDirectoryName.getText();
    }

    private boolean createAddressBook() {
        String string = this.tfDirectoryName.getText();
        try {
            EngineCommandManager.createAddressBook(string);
            return true;
        }
        catch (EngineException engineException) {
            if (engineException.getErrorCode() == 59154) {
                JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.AN_ADDRESS_BOOK_ALREADY_EXIST, new String[]{string}), StringResources.ADDRESS_BOOK_ERROR, -1);
                this.tfDirectoryName.selectAll();
            } else {
                logger.error((Object)engineException, (Throwable)engineException);
            }
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NewDirectoryDialog.this.createAddressBook()) {
                NewDirectoryDialog.this.setVisible(false);
            }
        }
    }
}

