/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.GWTextArea;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.ResourceContact;
import com.novell.gw.ab.UserContact;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.SearchContactTextField;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

class ResourceDetailsPane
extends ContactDetailsPane {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$dialogs$ResourceDetailsPane == null ? (class$com$novell$gw$jclient$application$controls$addressbook$dialogs$ResourceDetailsPane = ResourceDetailsPane.class$("com.novell.gw.jclient.application.controls.addressbook.dialogs.ResourceDetailsPane")) : class$com$novell$gw$jclient$application$controls$addressbook$dialogs$ResourceDetailsPane));
    private ResourceContact contact;
    private UserContact owner;
    private JTextComponent tfName = new OrientableTextField();
    private JTextField tfPhone = new OrientableTextField();
    private JTextField tfType = new OrientableTextField();
    private JTextField tfEmailAddress = new OrientableTextField();
    private SearchContactTextField tfOwner;
    private JTextArea taComments = new GWTextArea(4, 1);
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$dialogs$ResourceDetailsPane;

    public ResourceDetailsPane(ResourceContact resourceContact, AbstractAddressBook abstractAddressBook) {
        this.contact = resourceContact;
        this.tfOwner = new SearchContactTextField(abstractAddressBook);
        this.setName(StringResources.DETAILS);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void buildUI() {
        TitleValueContainer titleValueContainer = new TitleValueContainer(this);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.NAME_C, this.tfName), this.tfName, 0);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.PHONE_C, this.tfPhone), this.tfPhone, 1);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.TYPE_C, this.tfType), this.tfType, 2);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.EMAIL_ADDRESS_C, this.tfEmailAddress), this.tfEmailAddress, 3);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.OWNER_C, this.tfOwner), this.tfOwner, 4);
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.taComments);
        orientableScrollPane.setVerticalScrollBarPolicy(22);
        orientableScrollPane.setPreferredSize(new Dimension(280, 180));
        titleValueContainer.buildRow((JComponent)new JMnemonicLabel(StringResources.COMMENTS_C, this.taComments), (JComponent)orientableScrollPane, 5, true);
    }

    public void readContactProperties() {
        this.owner = this.contact.getOwner();
        this.tfName.setText(this.contact.getDisplayName());
        this.tfPhone.setText(this.contact.getPhone());
        this.tfType.setText(this.contact.getResourceType());
        this.tfEmailAddress.setText(this.contact.getEmailAddress());
        this.tfOwner.setText(this.owner != null ? this.owner.getDisplayName() : "");
        this.taComments.setText(this.contact.getComments());
    }

    public void writeContactProperties() {
        Contact contact = this.tfOwner.getFoundContact();
        if (contact instanceof UserContact) {
            this.owner = (UserContact)contact;
            try {
                this.owner.save(0);
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException, (Throwable)engineException);
            }
        } else {
            this.owner = null;
        }
        this.contact.setDisplayName(this.tfName.getText());
        this.contact.setPhone(this.tfPhone.getText());
        this.contact.setResourceType(this.tfType.getText());
        this.contact.setEmailAddress(this.tfEmailAddress.getText());
        this.contact.setOwner(this.owner);
        this.contact.setComments(this.taComments.getText());
    }

    public JComponent getDefaultComponent() {
        return this.tfName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

