/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.properties;

import com.appframework.components.ComponentBorder;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.AddressBookSharedList;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.addressbook.properties.ShareListTableModel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SharingPane
extends OrientablePanel {
    private AbstractButton rbNotShare = new OrientableRadioButton(new NotShareAction());
    private AbstractButton rbShare = new OrientableRadioButton(new ShareWithAction());
    private JButton btnAddUser = new JButton(new AddUserAction());
    private AbstractButton btnRemoveUser = new JButton(new RemoveUserAction());
    private AbstractButton btnViewAddressBook = new JButton(new ViewABAction());
    private SearchTextField tfName = new SearchTextField();
    private AbstractButton rbReadOnly = new OrientableRadioButton(new ReadOnlyAccessAction());
    private AbstractButton rbAll = new OrientableRadioButton(new AllAccessAction());
    private ShareListTableModel model;
    private JTable tableShareList = new ExtendedGWTable();
    private Component[] components = new Component[]{this.tfName, this.btnViewAddressBook, this.tableShareList};
    private PersonalAddressBook addressBook;
    private GWDialog parentDialog;
    private boolean readOnly;
    private JButton btnDefault;

    public SharingPane(GWDialog gWDialog, PersonalAddressBook personalAddressBook) {
        super(new BorderLayout());
        this.parentDialog = gWDialog;
        this.btnDefault = this.parentDialog.getRootPane().getDefaultButton();
        this.addressBook = personalAddressBook;
        this.readOnly = this.addressBook.getNativeAddressBook().isSharedToMe();
        this.model = new ShareListTableModel(this.addressBook.getSharedList());
        this.tableShareList.setModel(this.model);
        this.setName(StringResources.SHARING);
        this.setBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15));
        this.add((Component)this.buildTopPane(), "North");
        this.add((Component)this.buildBottomPane(), "Center");
        this.btnAddUser.setEnabled(false);
        this.btnRemoveUser.setEnabled(false);
        this.tableShareList.setShowGrid(false);
        this.tableShareList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (keyEvent.getKeyCode() == n) {
                    SharingPane.this.btnRemoveUser.getAction().actionPerformed(null);
                }
            }
        });
        if (this.addressBook.getSharedList() == null) {
            this.rbNotShare.doClick();
        } else {
            this.rbShare.doClick();
        }
        this.tableShareList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SharingPane.this.processUserSelection();
            }
        });
        this.tfName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SharingPane.this.enableAddButton();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SharingPane.this.enableAddButton();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SharingPane.this.enableAddButton();
            }
        });
        if (this.readOnly) {
            this.markControlsReadOnly();
        }
        this.tfName.setListener(new SearchResultListener(){

            public void searchFinished(SearchEvent searchEvent) {
                if (searchEvent.getFoundContact() != null) {
                    SharingPane.this.rbReadOnly.setSelected(true);
                    SharingPane.this.model.addContact(searchEvent.getFoundContact());
                    SharingPane.this.tfName.setText("");
                    SharingPane.this.selectLastEntry();
                }
            }
        });
    }

    private void markControlsReadOnly() {
        this.rbShare.setEnabled(false);
        this.rbNotShare.setEnabled(false);
        this.btnAddUser.setEnabled(false);
        this.btnRemoveUser.setEnabled(false);
        this.btnViewAddressBook.setEnabled(false);
        this.tfName.setEnabled(false);
        this.rbReadOnly.setEnabled(false);
        this.rbAll.setEnabled(false);
    }

    private void processUserSelection() {
        boolean bl = this.tableShareList.getSelectedRowCount() == 0;
        boolean bl2 = this.tableShareList.getSelectedRowCount() > 1;
        this.btnRemoveUser.setEnabled(!bl && !this.readOnly);
        this.setAccessButtonsEnabled(!bl && !this.readOnly && !bl2);
        if (!bl) {
            int n = this.tableShareList.getSelectedRow();
            boolean bl3 = this.model.getAccessList().get(n).getAccessRights().hasAllAccess();
            if (bl3) {
                this.rbAll.setSelected(true);
            } else {
                this.rbReadOnly.setSelected(true);
            }
        } else {
            this.rbReadOnly.setSelected(true);
        }
    }

    private void enableAddButton() {
        if (this.readOnly || this.tfName.getText().trim().equals("")) {
            this.btnAddUser.setEnabled(false);
            ((JDialog)SwingUtilities.getWindowAncestor(this)).getRootPane().setDefaultButton(this.btnDefault);
        } else {
            this.btnAddUser.setEnabled(true);
            ((JDialog)SwingUtilities.getWindowAncestor(this)).getRootPane().setDefaultButton(this.btnAddUser);
        }
    }

    protected JPanel buildTopPane() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNotShare);
        buttonGroup.add(this.rbShare);
        this.rbShare.setSelected(true);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        orientablePanel.add((Component)this.rbNotShare, gridBagConstraints);
        return orientablePanel;
    }

    private JPanel buildBottomPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 21;
        orientablePanel.add((Component)new JLabel(StringResources.NAME_C), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        orientablePanel.add((Component)this.tfName, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.btnViewAddressBook.setPreferredSize(new Dimension(23, 23));
        orientablePanel.add((Component)this.btnViewAddressBook, gridBagConstraints);
        OrientablePanel orientablePanel2 = new OrientablePanel(new GridLayout(2, 1, 0, 5));
        orientablePanel2.add(this.btnAddUser);
        orientablePanel2.add(this.btnRemoveUser);
        OrientablePanel orientablePanel3 = new OrientablePanel(new BorderLayout());
        orientablePanel3.add((Component)orientablePanel, "Center");
        orientablePanel3.add((Component)orientablePanel2, "After");
        OrientablePanel orientablePanel4 = new OrientablePanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridy = 1;
        orientablePanel4.add((Component)this.rbShare, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 2;
        orientablePanel4.add((Component)orientablePanel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        ColoredScrollPane coloredScrollPane = new ColoredScrollPane(this.tableShareList);
        coloredScrollPane.setPreferredSize(new Dimension(350, 200));
        orientablePanel4.add((Component)coloredScrollPane, gridBagConstraints);
        JPanel jPanel = this.buildAccessPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        orientablePanel4.add((Component)jPanel, gridBagConstraints);
        ComponentBorder componentBorder = new ComponentBorder(this.rbShare);
        orientablePanel4.setBorder(BorderFactory.createCompoundBorder(componentBorder, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        return orientablePanel4;
    }

    public void saveChanges() {
        if (!this.readOnly) {
            AddressBookSharedList addressBookSharedList = this.model.getAccessList();
            if (this.rbNotShare.isSelected() || addressBookSharedList.getSize() == 0) {
                addressBookSharedList = null;
            }
            GWEngineUtils.shareAddressBook(this.addressBook, addressBookSharedList);
        }
    }

    private JPanel buildAccessPanel() {
        this.rbReadOnly.setSelected(true);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets.left = 10;
        orientablePanel.add((Component)this.rbReadOnly, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        orientablePanel.add((Component)this.rbAll, gridBagConstraints);
        buttonGroup.add(this.rbReadOnly);
        buttonGroup.add(this.rbAll);
        orientablePanel.setBorder(BorderFactory.createTitledBorder(StringResources.ACCESS));
        return orientablePanel;
    }

    private void setAccessButtonsEnabled(boolean bl) {
        this.rbReadOnly.setEnabled(bl);
        this.rbAll.setEnabled(bl);
    }

    private void selectLastEntry() {
        int n = this.model.getRowCount() - 1;
        if (n >= 0) {
            this.tableShareList.setRowSelectionInterval(n, n);
        }
    }

    private class ViewABAction
    extends AbstractAction {
        public ViewABAction() {
            super("", ImageResources.ICON_ACT_VIEW_ADDRESS_SELECTOR);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddressSelectorDialog addressSelectorDialog = new AddressSelectorDialog((JDialog)SharingPane.this.parentDialog, SharingPane.this.parentDialog.getController());
            addressSelectorDialog.showMe();
            if (addressSelectorDialog.isActionCompleteSuccessfully() && addressSelectorDialog.getSelectedContacts().size() > 0) {
                SharingPane.this.model.addContacts(addressSelectorDialog.getSelectedContacts());
            }
        }
    }

    private class AllAccessAction
    extends AbstractAction {
        public AllAccessAction() {
            super(StringResources.ALL_ACCESS);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SharingPane.this.model.getAccessList().get(SharingPane.this.tableShareList.getSelectedRow()).getAccessRights().setAccess(true);
            SharingPane.this.repaint();
        }
    }

    private class ReadOnlyAccessAction
    extends AbstractAction {
        public ReadOnlyAccessAction() {
            super(StringResources.READ_ONLY);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SharingPane.this.model.getAccessList().get(SharingPane.this.tableShareList.getSelectedRow()).getAccessRights().setAccess(false);
            SharingPane.this.repaint();
        }
    }

    private class RemoveUserAction
    extends AbstractAction {
        public RemoveUserAction() {
            super(StringResources.REMOVE_USER);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SharingPane.this.tableShareList.getSelectedRow();
            if (n != -1) {
                SharingPane.this.model.removeUser(n);
                if (SharingPane.this.model.getRowCount() == 0) {
                    SharingPane.this.btnRemoveUser.setEnabled(false);
                    SharingPane.this.setAccessButtonsEnabled(false);
                }
            }
        }
    }

    private class AddUserAction
    extends AbstractAction {
        public AddUserAction() {
            super(StringResources.ADD_USER);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SharingPane.this.tfName.updateListener();
        }
    }

    private class ShareWithAction
    extends AbstractAction {
        public ShareWithAction() {
            super(StringResources.SHARED_WITH);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UIUtils.setComponentsEnabled(SharingPane.this.components, true);
        }
    }

    private class NotShareAction
    extends AbstractAction {
        public NotShareAction() {
            super(StringResources.NOT_SHARED);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UIUtils.setComponentsEnabled(SharingPane.this.components, false);
        }
    }
}

