/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.table;

import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.AddressBookEvent;
import com.novell.gw.ab.AddressBookEventListener;
import com.novell.gw.ab.AddressBookItemList;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.GroupContact;
import com.novell.gw.ab.OrganizationContact;
import com.novell.gw.ab.PersonalAddressBook;
import com.novell.gw.ab.Recipient;
import com.novell.gw.ab.ResourceContact;
import com.novell.gw.ab.UserContact;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.ItemListListener;
import com.novell.gw.jclient.application.HeaderSortRenderer;
import com.novell.gw.jclient.application.OrientableTable;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.table.AddressSelectorEntriesTable;
import com.novell.gw.jclient.application.controls.addressbook.table.ContactNotFoundException;
import com.novell.gw.jclient.application.controls.addressbook.table.EntriesTableController;
import com.novell.gw.jclient.application.controls.standardgwitemtable.SortHeader;
import com.novell.gw.jclient.application.controls.standardgwitemtable.SortHeaderListener;
import com.novell.gw.jclient.application.frames.addressbook.FrameAddressBook;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public abstract class AbstractAddressBookTable
extends OrientableTable
implements MVCView,
SortHeaderListener {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$table$AbstractAddressBookTable == null ? (class$com$novell$gw$jclient$application$controls$addressbook$table$AbstractAddressBookTable = AbstractAddressBookTable.class$("com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTable")) : class$com$novell$gw$jclient$application$controls$addressbook$table$AbstractAddressBookTable));
    protected MVCController controller;
    protected Model model = new Model();
    protected AbstractAddressBook selectedDirectory;
    protected Collection selectedEntries = new ArrayList();
    private HeaderSortRenderer sortRenderer = new HeaderSortRenderer(ControlsUtils.getHeaderRendererSize());
    public int[] columnsIDs = new int[]{3, 9, 48, 28, 31, 11, 6, 4};
    private TimerAction timerAction = new TimerAction();
    private Timer timer = new Timer(400, this.timerAction);
    private StringBuffer searchText = new StringBuffer();
    public JTextField tfSearch;
    private MyDocumentListener documentListener = new MyDocumentListener();
    private AddressBookItemListFilter filter;
    private EntriesTableRendererr cellRenderer = new EntriesTableRendererr();
    private int searchField = 3;
    protected ItemListListener gwListDataListener;
    private AddressBookEventListener addressBookEventListener;
    protected ItemList addressBookItemList;
    private ItemList systemItemList;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$table$AbstractAddressBookTable;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$javax$swing$ImageIcon;

    public AbstractAddressBookTable(MVCController mVCController, JTextField jTextField) {
        this.controller = new EntriesTableController(this, mVCController);
        this.setShowGrid(false);
        this.setModel(this.model);
        this.tfSearch = jTextField;
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            if (this.getModel().getColumnClass(i) == (class$javax$swing$Icon == null ? AbstractAddressBookTable.class$("javax.swing.Icon") : class$javax$swing$Icon)) continue;
            this.getColumnModel().getColumn(i).setHeaderRenderer(this.sortRenderer);
        }
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectionListener());
        listSelectionModel.setValueIsAdjusting(true);
        this.setDefaultColumnSize();
        this.setTableHeader(new SortHeader(this.getColumnModel(), this));
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    AbstractAddressBookTable.this.performDefaultAction();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent)) {
                    AbstractAddressBookTable.this.performDefaultAction();
                }
            }
        });
        this.addFocusListener(new ABFocusListener());
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, new DGListener());
        this.setDropTarget(new DropTarget(this, 3, new ETDTListener()));
        this.timer.setRepeats(false);
        if (this.tfSearch != null) {
            this.tfSearch.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    if (FocusManager.getCurrentManager().getPermanentFocusOwner() == null) {
                        if (AbstractAddressBookTable.this.tfSearch != null) {
                            AbstractAddressBookTable.this.tfSearch.setText("");
                        }
                        AbstractAddressBookTable.this.searchText.delete(0, AbstractAddressBookTable.this.searchText.length());
                    }
                }
            });
            this.tfSearch.getDocument().addDocumentListener(this.documentListener);
        }
        this.addKeyListener(new SearchKeyListener());
        this.filter = new AddressBookItemListFilter(false);
        this.filter.setContactType(15);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setAutoResizeMode(0);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (AbstractAddressBookTable.this.getRowCount() > 0 && AbstractAddressBookTable.this.getSelectedRow() == -1) {
                    AbstractAddressBookTable.this.setRowSelectionInterval(0, 0);
                }
            }
        });
        this.gwListDataListener = new ItemListListener(){

            public void contentsChanged(ItemListEvent itemListEvent) {
                AbstractAddressBookTable.this.updateSystemAddressBook();
            }

            public void moreResultsAvailable(ItemListEvent itemListEvent) {
                AbstractAddressBookTable.this.updateSystemAddressBook();
            }

            public void queryResultsDone(ItemListEvent itemListEvent) {
                AbstractAddressBookTable.this.updateSystemAddressBook();
            }
        };
        this.addressBookEventListener = new AddressBookEventListener(){

            public void bookChanged(AddressBookEvent addressBookEvent) {
            }

            public void entryChanged(AddressBookEvent addressBookEvent) {
                AbstractAddressBookTable.this.update();
            }
        };
    }

    public void dispose() {
        this.removeListeners();
        if (this.tfSearch != null) {
            this.tfSearch.getDocument().removeDocumentListener(this.documentListener);
            this.tfSearch = null;
        }
        this.documentListener = null;
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this.timerAction);
            this.timer = null;
        }
        this.timerAction = null;
        this.model.itemList = null;
        this.addressBookItemList = null;
        this.systemItemList = null;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        boolean bl;
        Rectangle rectangle = this.getBounds();
        boolean bl2 = bl = !rectangle.isEmpty() && rectangle.y != n2;
        if (this.selectedDirectory instanceof GroupWiseAddressBook && bl) {
            ((AddressBookItemList)this.systemItemList).sabPreScrollAction();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void addListeners() {
        if (this.selectedDirectory instanceof GroupWiseAddressBook) {
            if (this.systemItemList == null) {
                this.systemItemList = this.selectedDirectory.getNativeAddressBook().getContents();
            }
            this.systemItemList.removeItemListListener(this.gwListDataListener);
            this.systemItemList.addItemListListener(this.gwListDataListener);
        } else {
            ((PersonalAddressBook)this.selectedDirectory.getNativeAddressBook()).removeAddressBookEventListener(this.addressBookEventListener);
            ((PersonalAddressBook)this.selectedDirectory.getNativeAddressBook()).addAddressBookEventListener(this.addressBookEventListener);
        }
    }

    public void removeListeners() {
        if (this.selectedDirectory instanceof GroupWiseAddressBook) {
            if (this.systemItemList != null) {
                this.systemItemList.removeItemListListener(this.gwListDataListener);
            }
        } else if (this.selectedDirectory != null) {
            ((PersonalAddressBook)this.selectedDirectory.getNativeAddressBook()).removeAddressBookEventListener(this.addressBookEventListener);
        }
    }

    private void updateSystemAddressBook() {
        this.update();
    }

    protected void update() {
        if (this.selectedDirectory instanceof GroupWiseAddressBook) {
            if (this.systemItemList == null) {
                this.systemItemList = this.selectedDirectory.getNativeAddressBook().getContents();
            }
            this.model.updateData(this.systemItemList);
        } else {
            this.model.updateData(this.addressBookItemList);
        }
        this.clearSelection();
    }

    private void setStatusBarText(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof FrameAddressBook) {
            FrameAddressBook frameAddressBook = (FrameAddressBook)window;
            frameAddressBook.setStatusText(bl ? StringResources.SEARCH_FAILED_WAITING_FOR_USER_INPUT : StringResources.WAITING_FOR_USER_INPUT);
        }
    }

    private int getColumnIndexById(int n) {
        for (int i = 0; i < this.columnsIDs.length; ++i) {
            if (this.columnsIDs[i] != n) continue;
            return i + 1;
        }
        return -1;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.cellRenderer;
    }

    public void columnSort(int n) {
        if ((n = this.convertColumnIndexToModel(n)) != 0) {
            boolean bl = false;
            int n2 = this.columnsIDs[n - 1];
            int n3 = this.getColumnIndexById(this.model.getItemList().getSortField());
            boolean bl2 = true;
            if (n == n3) {
                boolean bl3 = bl2 = !this.model.getItemList().isSortAscending();
            }
            if (this.selectedDirectory instanceof GroupWiseAddressBook) {
                bl = n2 == 3;
                int[] nArray = this.selectedDirectory.getNativeAddressBook().getIndexedFields();
                for (int i = 0; i < nArray.length && !bl; ++i) {
                    bl = nArray[i] == n2;
                }
                if (bl) {
                    this.removeListeners();
                    this.systemItemList = this.selectedDirectory.getNativeAddressBook().getContents(n2, bl2, (ItemListFilter)this.filter);
                    this.model.updateData(this.systemItemList);
                    this.addListeners();
                }
            } else {
                this.model.getItemList().sort(n2, bl2);
                bl = true;
            }
            if (bl) {
                this.searchField = n2;
                this.paintSortIcon();
                this.clearSelection();
                this.selectItems();
            }
        }
    }

    public void columnShowPopUpMenu(int n, MouseEvent mouseEvent) {
    }

    public void columnEndDrag(int n) {
    }

    public void columnBeginDrag(int n) {
    }

    private void paintSortIcon() {
        int n = this.getColumnIndexById(this.model.getItemList().getSortField());
        if (n != -1) {
            this.sortRenderer.setSorted(this.convertColumnIndexToView(n), this.model.getItemList().isSortAscending());
        } else {
            this.sortRenderer.setClear();
        }
        this.repaint();
    }

    public AbstractAddressBook getSelectedDirectory() {
        return this.selectedDirectory;
    }

    public void filterTable(AddressBookItemListFilter addressBookItemListFilter) {
        this.filter = addressBookItemListFilter;
        this.filterTable();
    }

    public void setFilter(AddressBookItemListFilter addressBookItemListFilter) {
        this.filter = addressBookItemListFilter;
    }

    public void filterTable() {
        if (this.selectedDirectory instanceof GroupWiseAddressBook) {
            this.systemItemList = this.selectedDirectory.getNativeAddressBook().getContents((ItemListFilter)this.filter);
            this.model.updateData(this.systemItemList);
        } else {
            this.model.getItemList().setFilter((ItemListFilter)this.filter);
            this.model.fireTableDataChanged();
        }
    }

    protected abstract void performDefaultAction();

    protected List getSelectedRecipients() {
        ArrayList<Recipient> arrayList = new ArrayList<Recipient>();
        if (this.getSelectedRowCount() > 0) {
            int[] nArray = this.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                Contact contact = (Contact)this.model.getItemList().getItemAt(nArray[i]);
                arrayList.add(new Recipient((Addressable)contact));
            }
        }
        return arrayList;
    }

    protected void setDefaultColumnSize() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        FontMetrics fontMetrics = this.getFontMetrics(new JLabel().getFont());
        block8: for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(20);
                tableColumn.setMaxWidth(20);
                tableColumn.setMinWidth(20);
                tableColumn.setResizable(false);
                continue;
            }
            switch (this.columnsIDs[i - 1]) {
                case 3: {
                    tableColumn.setPreferredWidth(fontMetrics.stringWidth("Firstname Lastname"));
                    continue block8;
                }
                case 9: {
                    tableColumn.setPreferredWidth(fontMetrics.stringWidth("first.lastname@internet.com"));
                    continue block8;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    tableColumn.setPreferredWidth(fontMetrics.stringWidth("(123) 456-7890"));
                    continue block8;
                }
                case 4: {
                    tableColumn.setPreferredWidth(fontMetrics.stringWidth("Firstname"));
                    continue block8;
                }
                case 6: {
                    tableColumn.setPreferredWidth(fontMetrics.stringWidth("Lastname"));
                    continue block8;
                }
                case 11: {
                    tableColumn.setPreferredWidth(fontMetrics.stringWidth("Username"));
                }
            }
        }
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnMoved(tableColumnModelEvent);
    }

    public void setController(MVCController mVCController) {
        if (!(mVCController instanceof EntriesTableController)) {
            throw new IllegalArgumentException("Incorect passed controller type");
        }
        this.controller = mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setSelectedEntry(Contact contact) throws ContactNotFoundException {
        int n = this.model.getItemList().indexOf((Item)contact);
        if (n == -1) {
            throw new ContactNotFoundException(contact);
        }
        this.selectedEntries.add(contact);
        this.selectItems();
    }

    public Contact getSelectedEntry() {
        int n = this.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return (Contact)this.model.getItemList().getItemAt(n);
    }

    private List getSelectedContacts() {
        int[] nArray = this.getSelectedRows();
        ArrayList<Item> arrayList = new ArrayList<Item>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            arrayList.add(this.model.getItemList().getItemAt(n));
        }
        return arrayList;
    }

    public void setMVCModel(Object object) {
        if (object instanceof AbstractAddressBook) {
            this.clearSelection();
            if (object.equals(this.selectedDirectory)) {
                return;
            }
            this.selectedEntries.clear();
            this.updateItemList((AbstractAddressBook)object, false);
            this.controller.processCommand(new Command(1160, this));
        }
    }

    protected void updateItemList(AbstractAddressBook abstractAddressBook, boolean bl) {
        this.removeListeners();
        this.selectedDirectory = abstractAddressBook;
        if (this.selectedDirectory instanceof GroupWiseAddressBook) {
            if (this.systemItemList == null || bl) {
                this.systemItemList = this.selectedDirectory.getNativeAddressBook().getContents();
            }
            this.model.updateData(this.systemItemList);
        } else {
            this.addressBookItemList = this.selectedDirectory.getNativeAddressBook().getContents();
            this.model.updateData(this.addressBookItemList);
        }
        this.addListeners();
    }

    private void selectItems() {
        Iterator iterator = this.selectedEntries.iterator();
        while (iterator.hasNext()) {
            Contact contact = (Contact)iterator.next();
            int n = this.model.getEntryIndex(contact);
            if (n < 0) continue;
            this.addRowSelectionInterval(n, n);
        }
    }

    public void scrollToVisible(int n) {
        this.scrollToVisible(n, 0);
    }

    public void scrollToVisible(int n, int n2) {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle rectangle = this.getCellRect(n, n2, true);
            Point point = jViewport.getViewPosition();
            rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
            jViewport.scrollRectToVisible(rectangle);
        }
    }

    public Object getMVCModel() {
        return null;
    }

    public void refreshDirectory(AbstractAddressBook abstractAddressBook) {
        int n = this.getSelectedRow();
        this.updateItemList(abstractAddressBook, true);
        this.selectNearestRow(n);
    }

    public DropTargetListener createDropTargetListener() {
        return new ETDTListener();
    }

    protected void selectNearestRow(int n) {
        int n2 = n;
        int n3 = this.getRowCount();
        n2 = n2 >= n3 ? n3 - 1 : n;
        if (n2 != -1) {
            this.setRowSelectionInterval(n2, n2);
        }
    }

    public void handle_REMOVE_ENTRY_FROM_RECIPIENTS_LIST(AppEvent appEvent) {
        List list = (List)appEvent.getData();
        for (int i = 0; i < list.size(); ++i) {
            Recipient recipient = (Recipient)list.get(i);
            if (!(recipient.getAddressable() instanceof Contact)) continue;
            Contact contact = (Contact)recipient.getAddressable();
            String string = String.valueOf(contact.getId());
            AddressSelectorEntriesTable.getMovedEntries().remove(string);
            this.repaint();
        }
    }

    public void handle_FOLDER_SELECTED(AbstractFolder abstractFolder) {
        if (abstractFolder instanceof ContactsFolder) {
            this.setMVCModel(abstractFolder);
        } else {
            this.dispose();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ABFocusListener
    extends FocusAdapter {
        private ABFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            AbstractAddressBookTable.this.controller.processCommand(new Command(1160, AbstractAddressBookTable.this));
        }
    }

    public class ABSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AbstractAddressBookTable abstractAddressBookTable = AbstractAddressBookTable.this;
            int n = abstractAddressBookTable.getSelectedRowCount();
            Command command = new Command(1050, new Integer(n));
            AbstractAddressBookTable.this.getController().processCommand(command);
            if (n > 0) {
                command = new Command(110, abstractAddressBookTable.getSelectedRecipients());
                AbstractAddressBookTable.this.getController().processCommand(command);
            }
        }
    }

    private class SearchKeyListener
    extends KeyAdapter {
        private SearchKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (Character.isLetterOrDigit(keyEvent.getKeyChar()) && !keyEvent.isAltDown()) {
                if (AbstractAddressBookTable.this.tfSearch == null) {
                    AbstractAddressBookTable.this.searchText.append(keyEvent.getKeyChar());
                    AbstractAddressBookTable.this.timer.restart();
                } else {
                    try {
                        AbstractAddressBookTable.this.tfSearch.getDocument().insertString(AbstractAddressBookTable.this.tfSearch.getText().length(), String.valueOf(keyEvent.getKeyChar()), null);
                    }
                    catch (BadLocationException badLocationException) {
                        logger.error((Object)badLocationException);
                        logger.debug((Object)badLocationException, (Throwable)badLocationException);
                    }
                }
            }
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbstractAddressBookTable.this.searchText.replace(0, AbstractAddressBookTable.this.searchText.length(), AbstractAddressBookTable.this.tfSearch.getText().substring(0, documentEvent.getOffset() + documentEvent.getLength()));
            if (AbstractAddressBookTable.this.searchText.length() > 0) {
                AbstractAddressBookTable.this.timer.restart();
            } else {
                AbstractAddressBookTable.this.timer.stop();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            boolean bl;
            AbstractAddressBookTable.this.searchText.replace(0, AbstractAddressBookTable.this.searchText.length(), AbstractAddressBookTable.this.tfSearch.getText().substring(0, documentEvent.getOffset()));
            int n = AbstractAddressBookTable.this.tfSearch.getSelectionEnd() - AbstractAddressBookTable.this.tfSearch.getSelectionStart();
            boolean bl2 = bl = n == documentEvent.getLength() && AbstractAddressBookTable.this.tfSearch.getSelectionStart() == documentEvent.getOffset();
            if (AbstractAddressBookTable.this.searchText.length() > 0 && !bl) {
                AbstractAddressBookTable.this.timer.restart();
            } else {
                AbstractAddressBookTable.this.timer.stop();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private class TimerAction
    implements ActionListener {
        private TimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ItemList itemList = AbstractAddressBookTable.this.model.getItemList();
            int n = itemList.indexOf(AbstractAddressBookTable.this.searchText.toString(), 0);
            AbstractAddressBookTable.this.setStatusBarText(n == -1);
            if (n >= 0 && itemList.getSize() > 0) {
                Contact contact = (Contact)itemList.getItemAt(n);
                String string = AbstractAddressBookTable.this.searchText.toString();
                String string2 = contact.getStringValue(AbstractAddressBookTable.this.searchField);
                int n2 = AbstractAddressBookTable.this.searchText.length();
                int n3 = string2.length();
                AbstractAddressBookTable.this.setRowSelectionInterval(n, n);
                AbstractAddressBookTable.this.scrollToVisible(n);
                AbstractAddressBookTable.this.scrollToVisible(n);
                if (n3 >= n2 && string.equalsIgnoreCase(string2.substring(0, n2))) {
                    if (AbstractAddressBookTable.this.tfSearch != null) {
                        AbstractAddressBookTable.this.tfSearch.getDocument().removeDocumentListener(AbstractAddressBookTable.this.documentListener);
                        AbstractAddressBookTable.this.tfSearch.requestFocus();
                        AbstractAddressBookTable.this.tfSearch.setText(string2);
                        AbstractAddressBookTable.this.tfSearch.select(n2, n3);
                        AbstractAddressBookTable.this.tfSearch.getDocument().addDocumentListener(AbstractAddressBookTable.this.documentListener);
                    } else {
                        AbstractAddressBookTable.this.searchText.delete(0, n2);
                    }
                }
            }
        }
    }

    private class ETDTListener
    extends DropTargetAdapter {
        private ETDTListener() {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!dropTargetDragEvent.isDataFlavorSupported(GWFlavors.rlFlavor)) {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                if (dropTargetDropEvent.getTransferable().getTransferData(GWFlavors.contactsFlavor) instanceof Contact) {
                    AppAction appAction = AbstractAddressBookTable.this.controller.getActionList().getAction("Remove from Recipients List");
                    if (appAction != null) {
                        AbstractAddressBookTable.this.controller.getActionList().performAction("Remove from Recipients List");
                    }
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                logger.error((Object)unsupportedFlavorException);
                logger.debug((Object)unsupportedFlavorException, (Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
                logger.debug((Object)iOException, (Throwable)iOException);
            }
        }
    }

    private class TransferableData
    implements Transferable {
        private DataFlavor[] dataFlavors = new DataFlavor[]{GWFlavors.contactsFlavor, DataFlavor.stringFlavor};

        private TransferableData() {
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.dataFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return Arrays.asList(this.dataFlavors).contains(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                return AbstractAddressBookTable.this.getSelectedEntry().getDisplayName();
            }
            return AbstractAddressBookTable.this.getSelectedContacts();
        }
    }

    private static class DSListener
    extends DragSourceAdapter {
        private DSListener() {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    private class DGListener
    implements DragGestureListener {
        private DGListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (dragGestureEvent.getTriggerEvent() instanceof MouseEvent && ((MouseEvent)dragGestureEvent.getTriggerEvent()).getButton() == 2) {
                return;
            }
            if ((dragGestureEvent.getDragAction() & 3) > 0) {
                dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, new TransferableData(), new DSListener());
            }
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Command command;
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
            if (defaultListSelectionModel.isSelectionEmpty()) {
                command = new Command(270);
            } else {
                int[] nArray = AbstractAddressBookTable.this.getSelectedRows();
                ArrayList<Item> arrayList = new ArrayList<Item>(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(AbstractAddressBookTable.this.model.getItemList().getItemAt(nArray[i]));
                }
                AbstractAddressBookTable.this.selectedEntries.clear();
                AbstractAddressBookTable.this.selectedEntries.addAll(arrayList);
                command = new Command(240, arrayList);
            }
            AbstractAddressBookTable.this.getController().processCommand(command);
        }
    }

    protected class EntriesTableRendererr
    extends DefaultTableCellRenderer {
        public EntriesTableRendererr() {
            this.setComponentOrientation(UIUtils.getComponentOrientation());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (!OptionManager.getInstance().getGeneralOptions().isSmartToolTipEnabled()) {
                this.setToolTipText(null);
            }
            Contact contact = (Contact)AbstractAddressBookTable.this.model.getItemList().getItemAt(n);
            if (object instanceof ImageIcon) {
                if (contact instanceof GroupContact) {
                    this.setIcon(ImageResources.ICON_ADDRESS_BOOK_GROUP);
                } else if (contact instanceof OrganizationContact) {
                    this.setIcon(ImageResources.ICON_ADDRESS_BOOK_ORGANIZATION);
                } else if (contact instanceof UserContact) {
                    this.setIcon(ImageResources.ICON_ADDRESS_BOOK_USER);
                } else if (contact instanceof ResourceContact) {
                    this.setIcon(ImageResources.ICON_ADDRESS_BOOK_RESOURSE);
                }
            } else {
                this.setIcon(null);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    public class Model
    extends AbstractTableModel {
        private ItemList itemList;

        public int getRowCount() {
            if (this.itemList == null) {
                return 0;
            }
            return this.itemList.getSize();
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = AbstractAddressBookTable.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon;
            }
            return super.getColumnClass(n);
        }

        public void updateData(ItemList itemList) {
            this.itemList = itemList;
            this.fireTableDataChanged();
            AbstractAddressBookTable.this.paintSortIcon();
            AbstractAddressBookTable.this.repaint();
        }

        public ItemList getItemList() {
            return this.itemList;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "";
            }
            return AddressBookManager.getPropertyLabel((int)AbstractAddressBookTable.this.columnsIDs[n - 1]);
        }

        public int getColumnCount() {
            return AbstractAddressBookTable.this.columnsIDs.length + 1;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ImageResources.ICON_ATTACHMENT;
            }
            String string = ((Contact)this.itemList.getItemAt(n)).getStringValue(AbstractAddressBookTable.this.columnsIDs[n2 - 1]);
            if (string == null) {
                return "";
            }
            return string;
        }

        public int getEntryIndex(Contact contact) {
            return this.itemList.indexOf((Item)contact);
        }
    }
}

