/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.autodate;

import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.autodate.AutoDateChangeEvent;
import com.novell.gw.jclient.application.controls.autodate.AutoDateChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.DayBorder;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.dailycalendar.DailyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class AutoDateCalendar
extends DailyCalendar {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$autodate$AutoDateCalendar == null ? (class$com$novell$gw$jclient$application$controls$autodate$AutoDateCalendar = AutoDateCalendar.class$("com.novell.gw.jclient.application.controls.autodate.AutoDateCalendar")) : class$com$novell$gw$jclient$application$controls$autodate$AutoDateCalendar));
    private HashMap multiselectedDates;
    private Font fntBold;
    private Dimension size;
    private DayBorder dayBorder;
    private Color clrDaysHolyLigth;
    private Color clrDaysWorkLigth;
    private JLabel btnToday;
    private ArrayList listeners;
    private static final float BTN_FONT_SIZE = (float)PLAFChanger.getFontSize() - 3.5f;
    private static final float LBL_FONT_SIZE = (float)PLAFChanger.getFontSize() - 2.0f;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$autodate$AutoDateCalendar;

    protected void buildUI() {
        super.buildUI();
        this.setMinimumSize(this.size);
        this.setPreferredSize(this.size);
    }

    protected void init() {
        super.init();
        this.listeners = new ArrayList();
        this.multiselectedDates = new HashMap();
        this.fntBold = Utils.deriveFont(this.fntDates, 1);
        this.clrDaysHolyLigth = new Color(255, 125, 125);
        this.clrDaysWorkLigth = new Color(125, 125, 125);
        int n = PLAFChanger.getFontSize();
        this.size = new Dimension(n * 10 + 4, n * 10 - 10);
        this.dayBorder = new DayBorder(DayBorder.BORDER_TODAY_UNSELECTED);
        this.isSelectedRectangleShowing = false;
        this.dimMinDaysButtSize = new Dimension(17, 10);
        this.dimMinMonthSize = new Dimension(94, 12);
        this.lblHeader.setFont(Utils.deriveFont(this.lblHeader.getFont(), 1, BTN_FONT_SIZE));
        this.fntDates = Utils.deriveFontForSize(this.fntDates, BTN_FONT_SIZE);
        this.fntDays = Utils.deriveFontForSize(this.fntDays, BTN_FONT_SIZE);
        this.fntBold = Utils.deriveFont(this.fntDates, 1, BTN_FONT_SIZE);
        this.setFont(Utils.deriveFontForSize(this.lblHeader.getFont(), LBL_FONT_SIZE));
    }

    public void refreshView() {
        super.refreshView();
        this.repaint();
    }

    private void addMultiselectDate(GregorianCalendar gregorianCalendar) {
        if (gregorianCalendar != null && this.isDateBelongsToThisMonth(gregorianCalendar)) {
            String string = GWCalendarUtils.calendarToString(gregorianCalendar);
            this.multiselectedDates.put(string, gregorianCalendar);
        }
    }

    public void clearMultiselectDates() {
        this.multiselectedDates.clear();
    }

    private void removeMultiselectDate(GregorianCalendar gregorianCalendar) {
        String string = GWCalendarUtils.calendarToString(gregorianCalendar);
        this.multiselectedDates.remove(string);
    }

    public Collection getMultiselectDates() {
        return this.multiselectedDates.values();
    }

    public void addMultiselectDates(GregorianCalendar[] gregorianCalendarArray) {
        for (int i = 0; i < gregorianCalendarArray.length; ++i) {
            this.addMultiselectDate(gregorianCalendarArray[i]);
        }
    }

    public void setCurrDay(GregorianCalendar gregorianCalendar) {
        this.gcCurrDay = (GregorianCalendar)gregorianCalendar.clone();
    }

    public boolean isDateBelongsToThisMonth(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)this.gcCurrDay.clone();
        gregorianCalendar2.set(5, 1);
        gregorianCalendar2.set(11, 0);
        gregorianCalendar2.set(12, 0);
        gregorianCalendar2.set(13, 0);
        GregorianCalendar gregorianCalendar3 = (GregorianCalendar)gregorianCalendar2.clone();
        gregorianCalendar3.add(2, 1);
        gregorianCalendar3.add(12, -1);
        return gregorianCalendar.getTime().after(gregorianCalendar2.getTime()) && gregorianCalendar.getTime().before(gregorianCalendar3.getTime());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isDateBelongsToThisMonth(GWCalendarUtils.getToday()) && this.btnToday != null) {
            int n = 1;
            Rectangle rectangle = SwingUtilities.convertRectangle(this.btnToday.getParent(), this.btnToday.getBounds(), this);
            this.dayBorder.paintBorder(this, graphics, rectangle.x - n, rectangle.y - n, rectangle.width + n, rectangle.height + n * 2);
        }
    }

    protected void setTodayColor(GregorianCalendar gregorianCalendar, int n) {
        String string = GWCalendarUtils.getDateFormat().format(GWCalendarUtils.getToday().getTime());
        String string2 = GWCalendarUtils.getDateFormat().format(gregorianCalendar.getTime());
        if (string2.equals(string)) {
            this.btnToday = this.btnDates[n];
        }
    }

    protected void refreshDateLabelView(int n) {
        String string = "";
        if (this.days[n] != null) {
            string = "" + this.days[n].get(5);
            String string2 = GWCalendarUtils.calendarToString(this.days[n]);
            if (this.multiselectedDates.containsKey(string2)) {
                if (this.btnDates[n].getForeground().equals(this.clrDaysHolyLigth)) {
                    this.btnDates[n].setForeground(ColorConstants.clrDaysHoly);
                } else if (this.btnDates[n].getForeground().equals(this.clrDaysWorkLigth)) {
                    this.btnDates[n].setForeground(ColorConstants.clrDaysWork);
                }
                this.btnDates[n].setFont(this.fntBold);
            } else {
                this.btnDates[n].setFont(this.fntDates);
            }
        }
        this.btnDates[n].setText(string);
        this.btnDates[n].setEnabled(this.days[n] != null);
        this.btnDates[n].setBorder(null);
    }

    protected void setWeekEndColor(GregorianCalendar gregorianCalendar, int n) {
        if (gregorianCalendar.get(7) == 1 || gregorianCalendar.get(7) == 7) {
            this.btnDates[n].setForeground(this.clrDaysHolyLigth);
        } else {
            this.btnDates[n].setForeground(this.clrDaysWorkLigth);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        GregorianCalendar gregorianCalendar = this.days[((DailyCalendar.DailyLabel)mouseEvent.getSource()).getIndex()];
        if (gregorianCalendar == null) {
            mouseEvent.consume();
            return;
        }
        String string = GWCalendarUtils.calendarToString(gregorianCalendar);
        if (this.multiselectedDates.containsKey(string)) {
            this.removeMultiselectDate(gregorianCalendar);
            this.fireAutoDateChanged(new AutoDateChangeEvent(gregorianCalendar, false));
        } else {
            this.addMultiselectDate(gregorianCalendar);
            this.fireAutoDateChanged(new AutoDateChangeEvent(gregorianCalendar, true));
        }
        this.refreshView();
    }

    public void addAutoDateChangeListener(AutoDateChangeListener autoDateChangeListener) {
        this.listeners.add(autoDateChangeListener);
    }

    public void removeAutoDateChangeListener(AutoDateChangeListener autoDateChangeListener) {
        this.listeners.remove(autoDateChangeListener);
    }

    private void fireAutoDateChanged(AutoDateChangeEvent autoDateChangeEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            AutoDateChangeListener autoDateChangeListener = (AutoDateChangeListener)this.listeners.get(i);
            autoDateChangeListener.selectionChanged(autoDateChangeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

