/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.TimeGridPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DayLabelsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.HourLabelsPanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class AvailableTimeGrid
extends TimeGridPanel
implements MVCView {
    public static int MINUTES_PER_ROW = 15;
    private static final Color GRID_COLOR = new Color(170, 170, 170);
    private static final int ROW_COUNT = 96;
    public static final int CELL_HEIGHT = PLAFChanger.getFontSize() / 4 + 1;

    public AvailableTimeGrid(GWBusySearch gWBusySearch, MVCController mVCController) {
        super(mVCController);
        this.busySearch = gWBusySearch;
        this.addKeyListener(new ATGKeyListener());
    }

    protected void buildView() {
        this.setColumnCount(this.daysCount);
        this.setRowCount(this.rowCount);
        this.setMinimumCellSize(26, CELL_HEIGHT);
        this.setHorizontallyResizible(false);
    }

    protected boolean isDayEnd() {
        return (float)(this.recDragged.y + this.recDragged.height) / this.rowHeight % 96.0f == 0.0f;
    }

    protected boolean isDayStart() {
        return this.selectedRow == 0;
    }

    protected boolean nextRow() {
        boolean bl;
        float f = (float)(this.recDragged.y + this.recDragged.height) / this.rowHeight;
        boolean bl2 = bl = f * this.rowHeight <= (float)this.getHeight();
        if (bl) {
            if (this.isDayEnd()) {
                if (this.selectedColumn < this.columnCount - 1) {
                    this.selectedRow = (int)f;
                }
            } else {
                ++this.selectedRow;
            }
        }
        return bl;
    }

    protected boolean prevRow() {
        boolean bl;
        boolean bl2 = bl = this.selectedColumn != 0 || !this.isDayStart();
        if (bl) {
            if (this.isDayStart()) {
                if (this.selectedColumn > 0) {
                    this.selectedRow = (int)((float)this.rowCount - (float)this.recDragged.height / this.rowHeight);
                    --this.selectedColumn;
                }
            } else {
                --this.selectedRow;
            }
        }
        return bl;
    }

    protected boolean prevColumn() {
        boolean bl;
        boolean bl2 = bl = this.selectedColumn > 0;
        if (bl) {
            --this.selectedColumn;
        }
        return bl;
    }

    protected boolean nextColumn() {
        boolean bl;
        boolean bl2 = bl = this.recDragged.x + this.recDragged.width < this.getWidth();
        if (bl) {
            ++this.selectedColumn;
        }
        return bl;
    }

    protected void drawRectangles(Graphics graphics, Map map, Color color, boolean bl) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        int n = 1;
        int n2 = 0;
        if (bl) {
            n = 3;
            n2 = 3;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList = (ArrayList)iterator.next();
            for (int i = 0; i < arrayList.size(); ++i) {
                TimeGridPanel.VisibleIndividualInfo visibleIndividualInfo = (TimeGridPanel.VisibleIndividualInfo)arrayList.get(i);
                rectangle2 = visibleIndividualInfo.getVisibleRectangle();
                rectangle.x = Math.round(this.fromLogicalXToPthysical(rectangle2.x)) + n;
                rectangle.y = Math.round(this.fromLogicalYToPthysical(rectangle2.y));
                rectangle.width = Math.round(this.fromLogicalXToPthysical(rectangle2.width)) - n2 * 2;
                rectangle.height = Math.round(this.fromLogicalYToPthysical(rectangle2.height));
                if (!this.getComponentOrientation().isLeftToRight()) {
                    rectangle.x = this.getWidth() - rectangle.x - rectangle.width + 1;
                }
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (!bl) continue;
                graphics.setColor(Color.BLACK);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    protected void drawGrid(Graphics graphics) {
        int n;
        graphics.setColor(GRID_COLOR);
        for (n = 1; n < this.rowCount; ++n) {
            if (n % 4 != 0) continue;
            graphics.drawLine(0, Math.round((float)n * this.rowHeight), this.getWidth(), Math.round((float)n * this.rowHeight));
        }
        for (n = 0; n < this.columnCount; ++n) {
            graphics.drawLine(Math.round((float)n * this.columnWidth), 0, Math.round((float)n * this.columnWidth), this.getHeight());
        }
    }

    public void setDaysCount(int n) {
        this.daysCount = n;
        this.setColumnCount(this.daysCount);
    }

    protected void setAppointmentTime(TimeInterval timeInterval) {
        this.initCalendar();
        int n = 1440;
        this.gcAppointmentTime.setTime(timeInterval.getStartDateAsDate());
        long l = (this.gcAppointmentTime.getTimeInMillis() - this.gcStartDay.getTimeInMillis()) / 60000L;
        int n2 = (int)(l += (long)(this.calculateShiftHours(timeInterval) * 60)) / n;
        int n3 = (int)(l % (long)n) / MINUTES_PER_ROW;
        int n4 = (int)(timeInterval.getEndDate() - timeInterval.getStartDate()) / (MINUTES_PER_ROW * 60000);
        this.setLogicalPosition(n2, n3);
        this.setLogicalHeight(n4);
        this.setLogicalWidth(1);
    }

    protected Rectangle getLogicalRectangle(TimeInterval timeInterval, int n) {
        int n2 = 1440;
        long l = 0L;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        float f = 0.0f;
        l = (timeInterval.getStartDate() - this.gcStartDay.getTimeInMillis()) / 60000L;
        n3 = (int)(l += (long)(this.calculateShiftHours(timeInterval) * 60)) / n2;
        f = l % (long)n2;
        n4 = Math.round(f / (float)MINUTES_PER_ROW);
        f = timeInterval.getEndDate() - timeInterval.getStartDate();
        n5 = Math.round(f / (float)(60000 * MINUTES_PER_ROW));
        return new Rectangle(n3, n4, 1, n5);
    }

    protected TimeInterval getAppointmentTimeInterval() {
        this.gcAppointmentTime.setTime(this.gcStartDay.getTime());
        this.gcAppointmentTime.add(5, this.getSelectedColumn());
        this.gcAppointmentTime.add(12, this.getSelectedRow() * MINUTES_PER_ROW);
        TimeInterval timeInterval = new TimeInterval(this.gcAppointmentTime.getTimeInMillis(), this.gcAppointmentTime.getTimeInMillis() + (long)(this.getSelectedHeight() * MINUTES_PER_ROW * 60000));
        return timeInterval;
    }

    public Object getMVCModel() {
        return null;
    }

    private class ATGKeyListener
    extends KeyAdapter {
        private ATGKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 225) {
                if (keyEvent.isShiftDown()) {
                    if (AvailableTimeGrid.this.isDayEnd() && !AvailableTimeGrid.this.isDayStart()) {
                        AvailableTimeGrid.this.prevRow();
                        AvailableTimeGrid.this.updateRecPosition();
                    }
                    if (!AvailableTimeGrid.this.isDayStart() || !AvailableTimeGrid.this.isDayEnd()) {
                        AvailableTimeGrid.this.recDragged.height = (int)((float)AvailableTimeGrid.this.recDragged.height + AvailableTimeGrid.this.rowHeight);
                        AvailableTimeGrid.this.convertPhysicalXYToLogical(AvailableTimeGrid.this.recDragged);
                    }
                }
                if (AvailableTimeGrid.this.recDragged.x + AvailableTimeGrid.this.recDragged.width <= AvailableTimeGrid.this.getWidth() && (float)AvailableTimeGrid.this.selectedColumn * AvailableTimeGrid.this.columnWidth < (float)AvailableTimeGrid.this.getWidth()) {
                    AvailableTimeGrid.this.updateRecPosition();
                    AvailableTimeGrid.this.getController().processCommand(new Command(1370));
                }
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 224) {
                if (keyEvent.isShiftDown()) {
                    AvailableTimeGrid.this.recDragged.height = (int)((float)AvailableTimeGrid.this.recDragged.height - AvailableTimeGrid.this.rowHeight);
                    AvailableTimeGrid.this.convertPhysicalXYToLogical(AvailableTimeGrid.this.recDragged);
                }
                AvailableTimeGrid.this.updateRecPosition();
                AvailableTimeGrid.this.getController().processCommand(new Command(1370));
            }
        }
    }

    private static class BusyHourLabelBorder
    extends AbstractBorder {
        private BusyHourLabelBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.BLACK);
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(0, 0, 0, n4 - 1);
            graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawLine(n3 - 1, n4 - 1, 0, n4 - 1);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(1, 1, 1, n4 - 2);
            graphics.drawLine(1, 1, n3 - 2, 1);
        }
    }

    public static class BusyDayLabelBorder
    extends AbstractBorder {
        private boolean isLast;

        public BusyDayLabelBorder(boolean bl) {
            this.isLast = bl;
        }

        public BusyDayLabelBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawLine(0, 0, 0, n4);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(1, 1, 1, n4);
            graphics.drawLine(1, 1, n3, 1);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(0, 0, n3, 0);
            graphics.drawLine(0, n4 - 1, n3, n4 - 1);
            if (this.isLast) {
                graphics.setColor(Color.BLACK);
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4);
            }
        }
    }

    static class HourLabels
    extends HourLabelsPanel {
        public static final int ROW_WIDTH = PLAFChanger.getFontSize() * 2 + 11;

        public HourLabels() {
            super(new BusyHourLabelBorder());
            Dimension dimension = new Dimension(ROW_WIDTH, 96 * CELL_HEIGHT);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.setOpaque(true);
            this.setBackground(UIManager.getColor("Frame.background"));
        }

        protected void init() {
        }

        protected DateFormat getTimeFormat() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("h", EngineCommandManager.getLocale());
            simpleDateFormat.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
            return simpleDateFormat;
        }

        protected JComponent getLabel(GregorianCalendar gregorianCalendar, DateFormat dateFormat) {
            OrientableLabel orientableLabel = new OrientableLabel(dateFormat.format(gregorianCalendar.getTime()));
            orientableLabel.setHorizontalAlignment(0);
            return orientableLabel;
        }
    }

    static class DayLabels
    extends DayLabelsPanel {
        protected SimpleDateFormat sdf;
        private int minCellWidth = 10;

        public DayLabels() {
            this(7);
        }

        public DayLabels(int n) {
            super(n);
            this.setLayout(null);
            this.setDaysCount(n);
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(EngineCommandManager.getLocale());
            String[] stringArray = new String[8];
            System.arraycopy(GWCalendarUtils.dayShortestNames, 0, stringArray, 1, GWCalendarUtils.dayShortestNames.length);
            stringArray[0] = "";
            dateFormatSymbols.setShortWeekdays(stringArray);
            this.sdf = new SimpleDateFormat("E", dateFormatSymbols);
            this.sdf.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }

        protected void init() {
            super.init();
            this.labelBorder = new BusyDayLabelBorder();
            this.height = PLAFChanger.getFontSize() * 2 + 10;
        }

        protected void setTextToLabel(JLabel jLabel, GregorianCalendar gregorianCalendar, boolean bl) {
            jLabel.setText("<html> <P ALIGN=CENTER>" + this.sdf.format(gregorianCalendar.getTime()) + "<br>" + gregorianCalendar.get(5) + "</P> </html>");
        }

        public void setDaysCount(int n) {
            super.setDaysCount(n);
            Dimension dimension = new Dimension(26 * n, this.height);
            this.setPreferredSize(dimension);
        }

        public void doLayout() {
            Component component = null;
            float f = this.getWidth();
            if ((f /= (float)this.getComponentCount()) < (float)this.minCellWidth) {
                f = this.minCellWidth;
            }
            int n = this.getComponentCount();
            boolean bl = this.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < n; ++i) {
                component = this.getComponent(bl ? i : n - i - 1);
                component.setBounds(Math.round(f * (float)i), 0, Math.round(f * (float)(i + 1)) - Math.round(f * (float)i), this.getHeight());
            }
        }

        public void setMinimumCellWidth(int n) {
            this.minCellWidth = n;
        }
    }
}

