/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.novell.gw.ab.Recipient;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.controls.busysearch.TimeBlockInfo;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import com.novell.gw.message.BusySearch;
import com.novell.gw.message.BusySearchListener;
import com.novell.gw.message.BusySearchRecipientResult;
import com.novell.gw.message.BusySearchTimeBlock;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class GWBusySearch {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$busysearch$GWBusySearch == null ? (class$com$novell$gw$jclient$application$controls$busysearch$GWBusySearch = GWBusySearch.class$("com.novell.gw.jclient.application.controls.busysearch.GWBusySearch")) : class$com$novell$gw$jclient$application$controls$busysearch$GWBusySearch));
    private RecipientDescriptionsList recipientsList = new RecipientDescriptionsList();
    TreeMap tmOutOfOfficeTime = new TreeMap();
    TreeMap tmBusyTime = new TreeMap();
    TreeMap tmTentativeTime = new TreeMap();
    TreeMap tmWorkshedule = new TreeMap();
    private TimeInterval appointmentTime = new TimeInterval();
    private Date startDate = GWCalendarUtils.getToday().getTime();
    private int daysCount = 7;
    private BusySearch nativeBusySearch;
    private GregorianCalendar start = GWCalendarUtils.getToday();
    private GregorianCalendar end = GWCalendarUtils.getToday();
    private GregorianCalendar dayEnd = GWCalendarUtils.getToday();
    private boolean isStillWorking = true;
    private BusySearchListener busySearchListener;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$busysearch$GWBusySearch;

    public GWBusySearch(BusySearch busySearch) {
        this.nativeBusySearch = busySearch;
    }

    public void setBusySearchListener(BusySearchListener busySearchListener) {
        if (this.busySearchListener != null) {
            this.nativeBusySearch.removeBusySearchListener(this.busySearchListener);
        }
        this.busySearchListener = busySearchListener;
        this.nativeBusySearch.addBusySearchListener(this.busySearchListener);
    }

    public TimeInterval getAppointmentTime() {
        return this.appointmentTime;
    }

    public void setAppointmentTime(TimeInterval timeInterval) {
        this.appointmentTime = timeInterval;
    }

    public RecipientDescriptionsList getRecipientsList() {
        return this.recipientsList;
    }

    public void setRecipientDescriptionsList(RecipientDescriptionsList recipientDescriptionsList) {
        this.recipientsList = recipientDescriptionsList;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getEndDate() {
        return new Date(this.startDate.getTime() + (long)(this.daysCount * 24 * 3600000));
    }

    public int getDaysCount() {
        return this.daysCount;
    }

    public void setDaysCount(int n) {
        this.daysCount = n;
    }

    public void init() {
        this.tmOutOfOfficeTime.clear();
        this.tmBusyTime.clear();
        this.tmTentativeTime.clear();
        this.tmWorkshedule.clear();
        Enumeration enumeration = null;
        try {
            enumeration = this.nativeBusySearch.recipientEnumeration();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    BusySearchRecipientResult busySearchRecipientResult = (BusySearchRecipientResult)enumeration.nextElement();
                    logger.debug((Object)busySearchRecipientResult.getRecipient().getAddressable().getDisplayName());
                    logger.debug((Object)busySearchRecipientResult.getRecipient().isUnresolved());
                    if (busySearchRecipientResult.getRecipient().isUnresolved()) continue;
                    if (busySearchRecipientResult.getRecipientStatus() == 1) {
                        this.recipientsList.setNewRecipientDescription(new RecipientDescription(busySearchRecipientResult.getRecipient(), true));
                        continue;
                    }
                    for (int i = 0; i < busySearchRecipientResult.getRecipientTimeBlockSize(); ++i) {
                        BusySearchTimeBlock busySearchTimeBlock = busySearchRecipientResult.getRecipientTimeBlock(i);
                        TimeBlockInfo timeBlockInfo = new TimeBlockInfo(new TimeInterval(busySearchTimeBlock.getBeginDate(), busySearchTimeBlock.getEndDate()), busySearchTimeBlock.getStartDateText(), busySearchTimeBlock.getStartTimeText(), busySearchTimeBlock.getDurationText(), busySearchTimeBlock.getReasonText(), busySearchTimeBlock.getFromText(), busySearchTimeBlock.getSubjectText(), busySearchTimeBlock.getPlaceText());
                        if (busySearchTimeBlock.getBusySearchReason() == 2) {
                            this.addTimeIntervalToMap(this.tmBusyTime, busySearchRecipientResult.getRecipient(), timeBlockInfo);
                            continue;
                        }
                        if (busySearchTimeBlock.getBusySearchReason() == 4) {
                            this.addTimeIntervalToMap(this.tmWorkshedule, busySearchRecipientResult.getRecipient(), timeBlockInfo);
                            continue;
                        }
                        if (busySearchTimeBlock.getBusySearchReason() == 3) {
                            this.addTimeIntervalToMap(this.tmOutOfOfficeTime, busySearchRecipientResult.getRecipient(), timeBlockInfo);
                            continue;
                        }
                        if (busySearchTimeBlock.getBusySearchReason() != 1) continue;
                        this.addTimeIntervalToMap(this.tmTentativeTime, busySearchRecipientResult.getRecipient(), timeBlockInfo);
                    }
                }
            }
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
            ErrorDialog.processThrowable(engineException);
        }
    }

    private void addTimeIntervalToList(List list, TimeBlockInfo timeBlockInfo) {
        this.start.setTime(timeBlockInfo.getTimeInterval().getStartDateAsDate());
        this.end.setTime(timeBlockInfo.getTimeInterval().getEndDateAsDate());
        if (this.start.get(5) == this.end.get(5)) {
            list.add(timeBlockInfo);
        } else {
            this.dayEnd.setTime(timeBlockInfo.getTimeInterval().getStartDateAsDate());
            this.dayEnd.set(11, 23);
            this.dayEnd.set(12, 59);
            TimeBlockInfo timeBlockInfo2 = new TimeBlockInfo(new TimeInterval(timeBlockInfo.getTimeInterval().getStartDate(), this.dayEnd.getTimeInMillis()), timeBlockInfo.getStartDate(), timeBlockInfo.getStartTime(), timeBlockInfo.getDuration(), timeBlockInfo.getReason(), timeBlockInfo.getFrom(), timeBlockInfo.getSubject(), timeBlockInfo.getPlace());
            list.add(timeBlockInfo2);
            this.dayEnd.add(12, 2);
            timeBlockInfo.getTimeInterval().setStartDate(this.dayEnd.getTimeInMillis());
            this.addTimeIntervalToList(list, timeBlockInfo);
        }
    }

    void addTimeIntervalToMap(TreeMap treeMap, Recipient recipient, TimeBlockInfo timeBlockInfo) {
        ArrayList arrayList = (ArrayList)treeMap.get(BusySearchFrame.getRecipientID(recipient));
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.addTimeIntervalToList(arrayList, timeBlockInfo);
        treeMap.put(BusySearchFrame.getRecipientID(recipient), arrayList);
    }

    public List getOutOfOfficeList(Recipient recipient) {
        return (ArrayList)this.tmOutOfOfficeTime.get(BusySearchFrame.getRecipientID(recipient));
    }

    public List getBusyList(Recipient recipient) {
        return (ArrayList)this.tmBusyTime.get(BusySearchFrame.getRecipientID(recipient));
    }

    public List getTentativeList(Recipient recipient) {
        return (ArrayList)this.tmTentativeTime.get(BusySearchFrame.getRecipientID(recipient));
    }

    public List getWorkshedule(Recipient recipient) {
        return (ArrayList)this.tmWorkshedule.get(BusySearchFrame.getRecipientID(recipient));
    }

    public boolean isStillWorking() {
        return this.isStillWorking;
    }

    public void setStillWorking(boolean bl) {
        this.isStillWorking = bl;
    }

    public void cancel() {
        this.nativeBusySearch.cancelBusySearch();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

