/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.busysearch.AvailableTimeGrid;
import com.novell.gw.jclient.application.controls.busysearch.TimeGridPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class IndividShedules
extends TimeGridPanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$busysearch$IndividShedules == null ? (class$com$novell$gw$jclient$application$controls$busysearch$IndividShedules = IndividShedules.class$("com.novell.gw.jclient.application.controls.busysearch.IndividShedules")) : class$com$novell$gw$jclient$application$controls$busysearch$IndividShedules));
    private static final Color GRID_COLOR = new Color(170, 170, 170);
    public static int MINUTES_PER_ROW = 15;
    public static int COLUMN_IN_HOUR = 4;
    public static int CELL_WIDTH = PLAFChanger.getFontSize() / 2;
    private static int cellHeight = 16;
    private static int hoursCount = 10;
    private static int startHour = 8;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$busysearch$IndividShedules;

    public IndividShedules(MVCController mVCController) {
        super(mVCController);
        this.isOnlySelectedRecipientShowing = false;
        this.setDaysCount(7);
        this.addKeyListener(new ISKeyListener());
    }

    protected void buildView() {
        this.setColumnCount(this.daysCount);
        this.setRowCount(this.rowCount);
        this.rowHeight = cellHeight;
        this.setMinimumCellSize(CELL_WIDTH, cellHeight);
        this.setVerticallyResizible(false);
    }

    public int getCellHeight() {
        return cellHeight;
    }

    protected boolean prevColumn() {
        boolean bl;
        boolean bl2 = bl = this.selectedColumn != 0;
        if (bl) {
            this.selectedColumn = this.selectedColumn % (hoursCount * COLUMN_IN_HOUR) == 0 ? (int)((float)this.selectedColumn - (float)this.recDragged.width / this.columnWidth) : --this.selectedColumn;
        }
        return bl;
    }

    protected boolean isDayEnd() {
        return (float)(this.recDragged.x + this.recDragged.width) / this.columnWidth % (float)(hoursCount * COLUMN_IN_HOUR) == 0.0f;
    }

    protected boolean isDayStart() {
        return this.selectedColumn % (hoursCount * COLUMN_IN_HOUR) == 0;
    }

    protected boolean nextColumn() {
        boolean bl;
        float f = (float)(this.recDragged.x + this.recDragged.width) / this.columnWidth;
        boolean bl2 = bl = f * this.columnWidth < (float)this.getWidth();
        if (bl) {
            this.selectedColumn = this.isDayEnd() ? (int)f : ++this.selectedColumn;
        }
        return bl;
    }

    protected boolean prevRow() {
        boolean bl;
        boolean bl2 = bl = this.selectedRow > 0;
        if (bl) {
            --this.selectedRow;
        }
        return bl;
    }

    protected boolean nextRow() {
        boolean bl;
        boolean bl2 = bl = this.selectedRow < this.rowCount - 1;
        if (bl) {
            ++this.selectedRow;
        }
        return bl;
    }

    protected void drawRectangles(Graphics graphics, Map map, Color color, boolean bl) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        int n = 0;
        int n2 = 0;
        if (bl) {
            n = 3;
            n2 = 3;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList = (ArrayList)iterator.next();
            for (int i = 0; i < arrayList.size(); ++i) {
                rectangle2 = ((TimeGridPanel.VisibleIndividualInfo)arrayList.get(i)).getVisibleRectangle();
                rectangle.x = Math.round(this.fromLogicalXToPthysical(rectangle2.x));
                rectangle.y = Math.round(this.fromLogicalYToPthysical(rectangle2.y)) + n;
                rectangle.width = Math.round(this.fromLogicalXToPthysical(rectangle2.width));
                rectangle.height = Math.round(this.fromLogicalYToPthysical(rectangle2.height)) - n2 * 2;
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (!bl) continue;
                graphics.setColor(Color.black);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    protected void drawGrid(Graphics graphics) {
        graphics.setColor(GRID_COLOR);
        int n = 0;
        while (Math.round((float)n * this.rowHeight) < this.getHeight()) {
            graphics.drawLine(0, Math.round((float)n * this.rowHeight), this.getWidth(), Math.round((float)n * this.rowHeight));
            ++n;
        }
        n = 0;
        while (Math.round((float)n * this.columnWidth) < this.getWidth()) {
            if (n % COLUMN_IN_HOUR == 0) {
                int n2 = Math.round((float)n * this.columnWidth);
                graphics.drawLine(n2, 0, n2, this.getHeight());
                if (n % (hoursCount * COLUMN_IN_HOUR) == 0) {
                    graphics.drawLine(n2 + 1, 0, n2 + 1, this.getHeight());
                }
            }
            ++n;
        }
    }

    public void setDaysCount(int n) {
        this.daysCount = n;
        this.setColumnCount(this.daysCount * hoursCount * COLUMN_IN_HOUR);
    }

    public void setAppointmentTime(TimeInterval timeInterval) {
        this.initCalendar();
        this.gcAppointmentTime.setTime(timeInterval.getStartDateAsDate());
        Dimension dimension = this.getLogicalTimeInterval(timeInterval);
        double d = ((double)this.gcAppointmentTime.getTimeInMillis() - (double)this.gcStartDay.getTimeInMillis()) / 60000.0 / 60.0;
        int n = (int)((d - (double)startHour) * (double)COLUMN_IN_HOUR);
        if (this.getSelectedColumn() == 0) {
            this.setLogicalPosition(n, this.getSelectedRow());
        } else {
            this.setLogicalPosition(this.getSelectedColumn(), this.getSelectedRow());
        }
        this.setLogicalWidth(dimension.width);
    }

    private Dimension getLogicalTimeInterval(TimeInterval timeInterval) {
        int n = 1440;
        float f = 0.0f;
        long l = (timeInterval.getStartDate() - this.gcStartDay.getTimeInMillis()) / 60000L;
        int n2 = (int)l / n;
        int n3 = n2 * hoursCount * COLUMN_IN_HOUR;
        f = l % (long)n;
        int n4 = Math.round(f / (float)AvailableTimeGrid.MINUTES_PER_ROW) - startHour * COLUMN_IN_HOUR;
        if (n4 >= 0) {
            n3 += n4;
        }
        n3 += this.calculateShiftHours(timeInterval) * COLUMN_IN_HOUR;
        f = timeInterval.getEndDate() - timeInterval.getStartDate();
        int n5 = Math.round(f / (float)(AvailableTimeGrid.MINUTES_PER_ROW * 60000));
        if (n4 < 0) {
            n5 += n4;
        }
        if (n3 + n5 > (n2 + 1) * hoursCount * COLUMN_IN_HOUR) {
            n5 = (n2 + 1) * hoursCount * COLUMN_IN_HOUR - n3;
        }
        return new Dimension(n5, n3);
    }

    protected TimeInterval getAppointmentTimeInterval() {
        TimeInterval timeInterval = new TimeInterval();
        this.initCalendar();
        this.gcAppointmentTime.setTime(this.gcStartDay.getTime());
        int n = this.getSelectedColumn() / (hoursCount * COLUMN_IN_HOUR);
        this.gcAppointmentTime.add(5, n);
        this.gcAppointmentTime.set(11, startHour);
        int n2 = AvailableTimeGrid.MINUTES_PER_ROW * (this.getSelectedColumn() % (hoursCount * COLUMN_IN_HOUR));
        this.gcAppointmentTime.add(12, n2);
        timeInterval.setStartDate(this.gcAppointmentTime.getTimeInMillis());
        int n3 = this.getSelectedWidth();
        if (n3 == 0) {
            n3 = 1;
        }
        timeInterval.setEndDate(this.gcAppointmentTime.getTimeInMillis() + (long)(n3 * AvailableTimeGrid.MINUTES_PER_ROW * 60000));
        return timeInterval;
    }

    public void setUsersCount(int n) {
        this.setRowCount(n);
    }

    public int getSelectedRow() {
        return super.getSelectedRow();
    }

    public int getSelectedColumn() {
        return super.getSelectedColumn();
    }

    protected void doRectangleDragging(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(12));
        int n = this.getSnappedRectanglePosition(mouseEvent.getX() - this.dx, this.colX);
        if (n < 0) {
            return;
        }
        if (n + this.recDragged.width > this.getWidth()) {
            return;
        }
        int n2 = Math.round(this.columnWidth * (float)COLUMN_IN_HOUR * (float)hoursCount);
        int n3 = mouseEvent.getX() / n2;
        if (n3 == (n + this.recDragged.width - 2) / n2) {
            if (n / n2 != n3) {
                n = n2 * n3;
            }
            this.recDragged.x = n;
        }
        this.recDragged.y = this.getSnappedRectanglePosition(mouseEvent.getY() - this.dy, this.rowY);
    }

    protected void doLeftSideDragging(MouseEvent mouseEvent) {
        int n = this.getSnappedRectanglePosition(mouseEvent.getX() - this.dx, this.colX);
        int n2 = this.recDragged.x + this.recDragged.width;
        int n3 = Math.round(this.columnWidth * (float)COLUMN_IN_HOUR * (float)hoursCount);
        int n4 = mouseEvent.getX() / n3;
        if ((float)(n2 - n) >= this.columnWidth && n4 == (n2 - 2) / n3) {
            this.recDragged.x = n;
            this.recDragged.width = n2 - n;
        } else {
            logger.debug((Object)("can't drag: current day - " + n4));
        }
    }

    protected void doRightSideDragging(MouseEvent mouseEvent) {
        int n = this.getSnappedRectanglePosition(mouseEvent.getX() - this.dx, this.colX);
        int n2 = Math.round(this.columnWidth * (float)COLUMN_IN_HOUR * (float)hoursCount);
        int n3 = (mouseEvent.getX() - 2) / n2;
        if (n3 <= this.recDragged.x / n2) {
            this.recDragged.width = n - this.recDragged.x;
            if (this.recDragged.width < 3) {
                this.recDragged.width = (int)this.columnWidth;
            }
        }
    }

    protected Rectangle getLogicalRectangle(TimeInterval timeInterval, int n) {
        Dimension dimension = this.getLogicalTimeInterval(timeInterval);
        return new Rectangle(dimension.height, n, dimension.width, 1);
    }

    protected void doComponentResized() {
        float f = this.getWidth();
        this.columnWidth = f / (float)this.columnCount;
        this.calculateGrid();
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ISKeyListener
    extends KeyAdapter {
        private ISKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 227) {
                if (keyEvent.isShiftDown()) {
                    if (IndividShedules.this.isDayEnd() && !IndividShedules.this.isDayStart()) {
                        IndividShedules.this.prevColumn();
                        IndividShedules.this.updateRecPosition();
                    }
                    if (!IndividShedules.this.isDayStart() || !IndividShedules.this.isDayEnd()) {
                        IndividShedules.this.recDragged.width += CELL_WIDTH;
                        IndividShedules.this.convertPhysicalXYToLogical(IndividShedules.this.recDragged);
                    }
                }
                if (IndividShedules.this.recDragged.x + IndividShedules.this.recDragged.width <= IndividShedules.this.getWidth() && (float)IndividShedules.this.selectedColumn * IndividShedules.this.columnWidth < (float)IndividShedules.this.getWidth()) {
                    IndividShedules.this.updateRecPosition();
                }
            } else if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 226) {
                if (keyEvent.isShiftDown()) {
                    IndividShedules.this.recDragged.width -= CELL_WIDTH;
                    IndividShedules.this.convertPhysicalXYToLogical(IndividShedules.this.recDragged);
                }
                IndividShedules.this.updateRecPosition();
            }
        }
    }

    public static class DayHoursPanel
    extends AvailableTimeGrid.DayLabels {
        private DateFormat sdf = GWCalendarUtils.getDateFormatFull();
        private ArrayList dayLabels;
        static int labelHeight = PLAFChanger.getFontSize() + 10;

        public DayHoursPanel(int n) {
            super(n);
        }

        protected void init() {
            super.init();
            this.dayLabels = new ArrayList();
            this.height = labelHeight;
        }

        protected void setTextToLabel(JLabel jLabel, GregorianCalendar gregorianCalendar, boolean bl) {
            jLabel.setText(this.sdf.format(gregorianCalendar.getTime()));
        }

        protected JLabel getLabel(int n) {
            return (JLabel)this.dayLabels.get(n);
        }

        public void setDaysCount(int n) {
            this.dayLabels.clear();
            super.setDaysCount(n);
            Dimension dimension = new Dimension(CELL_WIDTH * COLUMN_IN_HOUR * hoursCount * n, this.height * 2);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
        }

        public void addLabel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            OrientableLabel orientableLabel = new OrientableLabel(" ");
            orientableLabel.setHorizontalAlignment(0);
            this.dayLabels.add(orientableLabel);
            jPanel.add((Component)orientableLabel, "North");
            jPanel.add((Component)new SimpleHourLabel(hoursCount), "South");
            jPanel.setBorder(this.labelBorder);
            this.add(jPanel);
        }

        public void removeLabel() {
            super.removeLabel();
            this.dayLabels.remove(this.dayLabels.size() - 1);
        }

        class SimpleHourLabel
        extends AvailableTimeGrid.DayLabels {
            private SimpleDateFormat sdf = new SimpleDateFormat("hh", EngineCommandManager.getLocale());
            private GregorianCalendar gc = GWCalendarUtils.getToday();

            public SimpleHourLabel(int n) {
                this.setDaysCount(n);
                this.setTitles(GWCalendarUtils.getToday().getTime(), GWCalendarUtils.getToday().getTime());
            }

            protected void init() {
                super.init();
                this.height = labelHeight;
            }

            public void setTitles(Date date, Date date2) {
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    JLabel jLabel = this.getLabel(i);
                    if (jLabel == null) {
                        return;
                    }
                    this.gc.set(11, startHour + i);
                    String string = this.sdf.format(this.gc.getTime());
                    if (string.startsWith("0") && string.length() > 1) {
                        string = string.substring(1);
                    }
                    jLabel.setText(string);
                }
            }
        }
    }
}

