/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.resources.GWIcons;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.busysearch.BSScrollPane;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.IndividShedules;
import com.novell.gw.jclient.application.controls.busysearch.InfoPanel;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.ShedulesInfoPanel;
import com.novell.gw.jclient.application.controls.busysearch.ShedulesWithListController;
import com.novell.gw.jclient.application.controls.gwcalendar.AbstractCalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ShedulesWithListPanel
extends AbstractCalendarView
implements MVCView {
    private ShedulesWithListController controller;
    private GWBusySearch busySearch;
    private Dimension dim = new Dimension(468, 195);
    private int recipientsWidth = 146;
    private JList listRecipients;
    private JScrollPane scrollRecipients;
    private DefaultListModel modelRecipients;
    private int listLabelHeight = 10;
    private JScrollPane spShedules = new OrientableScrollPane();
    private JButton inviteButton = new OrientableButton();
    private IndividShedules individShedules;
    private IndividShedules.DayHoursPanel dayHoursPanel;
    private InfoPanel infoIndividualPanel;
    private ShedulesInfoPanel shedulesInfoPanel;
    private Rectangle rectListRecipients = new Rectangle();

    public ShedulesWithListPanel(GWBusySearch gWBusySearch, JButton jButton, MVCController mVCController) {
        this.controller = new ShedulesWithListController(this, mVCController);
        this.busySearch = gWBusySearch;
        this.inviteButton = jButton;
        this.init();
        this.buildUI();
    }

    private void init() {
        this.initIndividualShedules();
        this.initRecipientsList();
    }

    private void initRecipientsList() {
        this.modelRecipients = new DefaultListModel();
        this.listRecipients = new JList(this.modelRecipients);
        this.listRecipients.setCellRenderer(new ListLabel());
        this.listRecipients.setSelectionMode(0);
        this.listRecipients.addListSelectionListener(new RecipientsSelectionListener());
        this.scrollRecipients = new OrientableScrollPane(this.listRecipients);
        this.scrollRecipients.setHorizontalScrollBarPolicy(31);
        this.scrollRecipients.setVerticalScrollBarPolicy(21);
        this.scrollRecipients.getVerticalScrollBar().addAdjustmentListener(new RecipientsAdjustmentListener());
    }

    private void initIndividualShedules() {
        this.individShedules = new IndividShedules(this.getController());
        this.individShedules.addMouseListener(new IndividSheduleMouse());
        this.individShedules.addMouseMotionListener(new IndividSheduleMouseMoution());
        this.listLabelHeight = this.individShedules.getCellHeight();
        this.dayHoursPanel = new IndividShedules.DayHoursPanel(7);
        this.dayHoursPanel.setTitles(GWCalendarUtils.getToday().getTime(), GWCalendarUtils.getToday().getTime());
        this.spShedules = new BSScrollPane(this.individShedules);
        this.spShedules.setColumnHeaderView(this.dayHoursPanel);
        this.spShedules.setHorizontalScrollBarPolicy(32);
        this.spShedules.setVerticalScrollBarPolicy(22);
        JScrollBar jScrollBar = new JScrollBar(1, 0, 1, 0, 13);
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                ShedulesWithListPanel.this.scrollRecipientsToPosition(adjustmentEvent.getValue());
            }
        });
        this.spShedules.setVerticalScrollBar(jScrollBar);
    }

    public void selectDefaultComponent() {
        this.individShedules.requestFocusInWindow();
    }

    public JComponent getDefaultComponent() {
        return this.individShedules;
    }

    private void buildUI() {
        this.setMinimumSize(this.dim);
        this.setPreferredSize(this.dim);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 27);
        this.add((Component)this.inviteButton, gridBagConstraints);
        int n = this.spShedules.getColumnHeader().getPreferredSize().height - this.inviteButton.getPreferredSize().height;
        int n2 = this.spShedules.getHorizontalScrollBar().getPreferredSize().height;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(n, 0, n2, 27);
        this.add((Component)this.scrollRecipients, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.spShedules, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.buildInfoPanel(), gridBagConstraints);
    }

    private JPanel buildInfoPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.infoIndividualPanel = new InfoPanel(this.getController());
        this.infoIndividualPanel.setBusyShowing(true);
        jPanel.add((Component)this.infoIndividualPanel, "South");
        this.shedulesInfoPanel = new ShedulesInfoPanel(this.getController());
        jPanel.add((Component)this.shedulesInfoPanel, "North");
        jPanel.setBorder(BusySearchFrame.lineBorder);
        return jPanel;
    }

    protected void refreshView() {
        if (!this.isShowing()) {
            this.wasViewRefreshed = true;
            return;
        }
        this.wasViewRefreshed = false;
        this.modelRecipients.clear();
        List list = this.busySearch.getRecipientsList().getResolvedList();
        for (int i = 0; i < list.size(); ++i) {
            this.modelRecipients.add(i, list.get(i));
        }
        this.listRecipients.validate();
        this.individShedules.setUsersCount(this.modelRecipients.getSize());
        Dimension dimension = new Dimension(this.recipientsWidth, this.individShedules.getPreferredSize().height);
        this.listRecipients.setMinimumSize(dimension);
        this.listRecipients.setPreferredSize(dimension);
        this.listRecipients.setSelectedIndex(0);
        boolean bl = this.busySearch.isStillWorking();
        this.listRecipients.setEnabled(!bl);
        this.individShedules.setMVCModel(this.busySearch);
        this.dayHoursPanel.setDaysCount(this.busySearch.getDaysCount());
        this.dayHoursPanel.setTitles(this.busySearch.getStartDate(), null);
    }

    public void setController(MVCController mVCController) {
        this.controller = (ShedulesWithListController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (object instanceof GWBusySearch) {
            this.busySearch = (GWBusySearch)object;
            this.refreshView();
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private void scrollRecipientsToPosition(int n) {
        this.rectListRecipients.x = 0;
        this.rectListRecipients.y = n;
        this.rectListRecipients.width = this.scrollRecipients.getWidth();
        this.rectListRecipients.height = this.scrollRecipients.getHeight() - 2;
        this.listRecipients.scrollRectToVisible(this.rectListRecipients);
    }

    void updateSelectRecipient() {
        this.listRecipients.setSelectedIndex(this.individShedules.getSelectedRow());
    }

    class RecipientsSelectionListener
    implements ListSelectionListener {
        RecipientsSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ShedulesWithListPanel.this.updateSelectRecipient();
        }
    }

    class IndividSheduleMouse
    extends MouseAdapter {
        IndividSheduleMouse() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ShedulesWithListPanel.this.updateSelectRecipient();
        }
    }

    class IndividSheduleMouseMoution
    extends MouseMotionAdapter {
        IndividSheduleMouseMoution() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ShedulesWithListPanel.this.updateSelectRecipient();
        }
    }

    class RecipientsAdjustmentListener
    implements AdjustmentListener {
        RecipientsAdjustmentListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Rectangle rectangle = new Rectangle(ShedulesWithListPanel.this.spShedules.getHorizontalScrollBar().getValue(), adjustmentEvent.getValue(), ((ShedulesWithListPanel)ShedulesWithListPanel.this).spShedules.getViewport().getSize().width, ((ShedulesWithListPanel)ShedulesWithListPanel.this).spShedules.getViewport().getSize().height);
            ShedulesWithListPanel.this.individShedules.scrollRectToVisible(rectangle);
        }
    }

    class ListLabel
    extends OrientablePanel
    implements ListCellRenderer {
        private Color colorSelected = new Color(8, 36, 106);
        private JLabel lblImg;
        private JLabel lblName = new OrientableLabel();
        private JLabel lblCC = new OrientableLabel();
        private boolean isCrossOver = false;

        public ListLabel() {
            this("");
        }

        public ListLabel(String string) {
            this.setLayout(new BorderLayout());
            this.buildUI();
            this.setDisplayName(string);
        }

        private void buildUI() {
            this.lblName.setIcon(GWIcons.EMPTY_ICON);
            this.lblName.setDisabledIcon(GWIcons.EMPTY_ICON);
            this.add((Component)this.lblName, "Center");
            this.add((Component)this.lblCC, "After");
        }

        void setDisplayName(String string) {
            this.lblName.setText(string);
        }

        void setCC(String string) {
            this.lblCC.setText(string);
        }

        public void setForeground(Color color) {
            if (this.lblName != null && this.lblCC != null) {
                this.lblName.setForeground(color);
                this.lblCC.setForeground(color);
            }
        }

        public void setEnabled(boolean bl) {
            if (this.lblName != null && this.lblCC != null) {
                this.lblName.setEnabled(bl);
                this.lblCC.setEnabled(bl);
            }
        }

        public void setFont(Font font) {
            if (this.lblName != null && this.lblCC != null) {
                this.lblName.setFont(font);
                this.lblCC.setFont(font);
            }
        }

        void setCrossOver(boolean bl) {
            this.isCrossOver = bl;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.isCrossOver) {
                Shape shape = graphics.getClip();
                Rectangle rectangle = this.lblName.getBounds();
                graphics.setClip(rectangle);
                graphics.setColor(this.lblName.getForeground());
                int n = rectangle.height / 2;
                int n2 = 1000;
                graphics.drawLine(0, n, n2, n);
                graphics.setClip(shape);
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof RecipientDescription)) {
                throw new IllegalArgumentException("Value must be instance of Recipient");
            }
            RecipientDescription recipientDescription = (RecipientDescription)object;
            Recipient recipient = recipientDescription.getRecipient();
            ListLabel listLabel = new ListLabel(recipient.getAddressable().getDisplayName());
            listLabel.setCrossOver(recipientDescription.isFailed());
            if (recipient.getCopyType() == 2) {
                listLabel.setCC(StringResources.CC);
            } else if (recipient.getCopyType() == 4) {
                listLabel.setCC(StringResources.BC);
            }
            String string = ControlsUtils.getUserGuid(ShedulesWithListPanel.this.controller);
            if (recipient.getAddressable().getDisplayName().equals(GWCommandManager.getInstance(string).getCurrentUserInfo().getName())) {
                if (bl) {
                    this.lblName.setIcon(ImageResources.ICON_BUSY_I_YELLOW);
                } else {
                    this.lblName.setIcon(ImageResources.ICON_BUSY_I_BLACK);
                }
            } else {
                this.lblName.setIcon(GWIcons.EMPTY_ICON);
            }
            listLabel.setBackground(this.colorSelected);
            if (bl) {
                listLabel.setForeground(Color.white);
                listLabel.setOpaque(true);
            } else {
                listLabel.setForeground(Color.black);
                listLabel.setOpaque(false);
            }
            listLabel.setEnabled(jList.isEnabled());
            listLabel.setFont(jList.getFont());
            return listLabel;
        }
    }
}

