/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.DragRectanglePanel;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.controls.busysearch.TimeBlockInfo;
import com.novell.gw.jclient.application.controls.busysearch.TimeGridPanelController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class TimeGridPanel
extends DragRectanglePanel
implements MVCView {
    protected HashMap hmOutOfOffice = new HashMap();
    protected HashMap hmBusy = new HashMap();
    protected HashMap hmTentative = new HashMap();
    protected HashMap hmWorkshedule = new HashMap();
    protected Map hmNewState = new HashMap();
    protected GregorianCalendar gcStartDay = GWCalendarUtils.getToday();
    protected GregorianCalendar gcAppointmentTime = GWCalendarUtils.getToday();
    protected GWBusySearch busySearch = null;
    protected int daysCount = 7;
    protected boolean isOnlySelectedRecipientShowing = true;
    private TimeBlockInfo timeBlockInfo = new TimeBlockInfo();
    private MVCController mvcController;

    public TimeGridPanel(MVCController mVCController) {
        super(7, 96);
        this.mvcController = new TimeGridPanelController(this, mVCController);
        this.initCalendar();
        this.buildView();
        this.addKeyListener(new TGPKeyListener());
        this.setFocusable(true);
    }

    protected abstract boolean isDayEnd();

    protected abstract boolean isDayStart();

    protected abstract boolean prevRow();

    protected abstract boolean prevColumn();

    protected abstract boolean nextColumn();

    protected abstract boolean nextRow();

    protected void initCalendar() {
        this.gcStartDay.set(11, 0);
        this.gcStartDay.set(12, 0);
        this.gcStartDay.set(13, 0);
        this.gcStartDay.set(14, 0);
    }

    protected abstract void buildView();

    protected abstract void drawRectangles(Graphics var1, Map var2, Color var3, boolean var4);

    protected abstract void drawGrid(Graphics var1);

    protected abstract void setDaysCount(int var1);

    protected abstract void setAppointmentTime(TimeInterval var1);

    protected abstract Rectangle getLogicalRectangle(TimeInterval var1, int var2);

    public void paint(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawRectangles(graphics, this.hmWorkshedule, BusySearchFrame.COLOR_OUT_OF_OFFICE, false);
        this.drawGrid(graphics);
        this.drawRectangles(graphics, this.hmBusy, BusySearchFrame.COLOR_BUSY, true);
        this.drawRectangles(graphics, this.hmTentative, BusySearchFrame.COLOR_TENTATIVE, true);
        this.drawRectangles(graphics, this.hmOutOfOffice, BusySearchFrame.COLOR_OUT_OF_OFFICE, true);
        super.paint(graphics);
    }

    protected void updateRecPosition() {
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
        this.scrollRectToVisible(this.recDragged);
        this.checkAvailableTimePosition(false);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        mouseEvent = this.localizeMouseEvent(mouseEvent);
        super.mouseDragged(mouseEvent);
        if (this.draggingMode != 0) {
            this.checkAvailableTimePosition(false);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent = this.localizeMouseEvent(mouseEvent);
        super.mousePressed(mouseEvent);
        this.checkAvailableTimePosition(false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent = this.localizeMouseEvent(mouseEvent);
        super.mouseReleased(mouseEvent);
    }

    private MouseEvent localizeMouseEvent(MouseEvent mouseEvent) {
        if (!this.getComponentOrientation().isLeftToRight()) {
            mouseEvent = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), this.getWidth() - mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        }
        return mouseEvent;
    }

    protected void checkAvailableTimePosition(boolean bl) {
        this.initCalendar();
        if (this.updateRecipientDescriptions() || bl) {
            Command command = new Command(690, this.busySearch.getRecipientsList());
            this.getController().processCommand(command);
        }
    }

    protected boolean updateRecipientDescriptions() {
        Rectangle rectangle = new Rectangle(this.getSelectedColumn(), this.getSelectedRow(), this.getSelectedWidth(), this.getSelectedHeight());
        if (rectangle.width <= 0) {
            rectangle.width = 1;
        }
        if (rectangle.height <= 0) {
            rectangle.height = 1;
        }
        this.hmNewState.clear();
        this.timeBlockInfo = new TimeBlockInfo();
        this.checkIntersectedTimes(rectangle, this.hmWorkshedule, 4);
        this.checkIntersectedTimes(rectangle, this.hmOutOfOffice, 3);
        this.checkIntersectedTimes(rectangle, this.hmTentative, 1);
        this.checkIntersectedTimes(rectangle, this.hmBusy, 2);
        TimeInterval timeInterval = this.getAppointmentTimeInterval();
        this.busySearch.setAppointmentTime(timeInterval);
        this.timeBlockInfo.setTimeInterval(timeInterval);
        Command command = new Command(680, this.timeBlockInfo);
        this.getController().processCommand(command);
        return this.isRecipientStateChanged();
    }

    protected TimeInterval getAppointmentTimeInterval() {
        return new TimeInterval();
    }

    protected void checkIntersectedTimes(Rectangle rectangle, Map map, int n) {
        for (int i = 0; i < this.busySearch.getRecipientsList().getResolvedList().size(); ++i) {
            Recipient recipient = ((RecipientDescription)this.busySearch.getRecipientsList().getResolvedList().get(i)).getRecipient();
            List list = (List)map.get(BusySearchFrame.getRecipientID(recipient));
            if (list == null || list.size() == 0) continue;
            for (int j = 0; j < list.size(); ++j) {
                VisibleIndividualInfo visibleIndividualInfo = (VisibleIndividualInfo)list.get(j);
                Rectangle rectangle2 = visibleIndividualInfo.getVisibleRectangle();
                if (!rectangle.intersects(rectangle2)) continue;
                this.hmNewState.put(BusySearchFrame.getRecipientID(recipient), new Integer(n));
                this.timeBlockInfo = new TimeBlockInfo(visibleIndividualInfo.getTimeBlockInfo());
            }
        }
    }

    private boolean isRecipientStateChanged() {
        boolean bl = false;
        for (int i = 0; i < this.busySearch.getRecipientsList().getResolvedList().size(); ++i) {
            RecipientDescription recipientDescription = (RecipientDescription)this.busySearch.getRecipientsList().getResolvedList().get(i);
            Integer n = (Integer)this.hmNewState.get(BusySearchFrame.getRecipientID(recipientDescription.getRecipient()));
            if (n == null) {
                if (recipientDescription.getState() == 0) continue;
                bl = true;
                recipientDescription.setState(0);
                this.busySearch.getRecipientsList().setNewRecipientDescription(recipientDescription);
                continue;
            }
            if (n.intValue() == recipientDescription.getState()) continue;
            bl = true;
            recipientDescription.setState(n);
            this.busySearch.getRecipientsList().setNewRecipientDescription(recipientDescription);
        }
        return bl;
    }

    public void setRecipientDescriptionList(RecipientDescriptionsList recipientDescriptionsList) {
        this.busySearch.setRecipientDescriptionsList(recipientDescriptionsList);
        this.createRectangles();
        this.repaint();
        this.updateRecipientDescriptions();
    }

    protected void createRectangles() {
        this.hmOutOfOffice.clear();
        this.hmBusy.clear();
        this.hmTentative.clear();
        this.hmWorkshedule.clear();
        for (int i = 0; i < this.busySearch.getRecipientsList().getResolvedList().size(); ++i) {
            RecipientDescription recipientDescription = (RecipientDescription)this.busySearch.getRecipientsList().getResolvedList().get(i);
            if (this.isOnlySelectedRecipientShowing && !recipientDescription.isSelected()) continue;
            Recipient recipient = recipientDescription.getRecipient();
            this.fillRectanglesMap(recipient, i, this.busySearch.getOutOfOfficeList(recipient), this.hmOutOfOffice);
            this.fillRectanglesMap(recipient, i, this.busySearch.getBusyList(recipient), this.hmBusy);
            this.fillRectanglesMap(recipient, i, this.busySearch.getTentativeList(recipient), this.hmTentative);
            this.fillRectanglesMap(recipient, i, this.busySearch.getWorkshedule(recipient), this.hmWorkshedule);
        }
    }

    private void fillRectanglesMap(Recipient recipient, int n, List list, Map map) {
        if (list == null) {
            return;
        }
        this.initCalendar();
        for (int i = 0; i < list.size(); ++i) {
            TimeBlockInfo timeBlockInfo = (TimeBlockInfo)list.get(i);
            ArrayList<VisibleIndividualInfo> arrayList = (ArrayList<VisibleIndividualInfo>)map.get(BusySearchFrame.getRecipientID(recipient));
            if (arrayList == null) {
                arrayList = new ArrayList<VisibleIndividualInfo>();
            }
            arrayList.add(new VisibleIndividualInfo(this.getLogicalRectangle(timeBlockInfo.getTimeInterval(), n), timeBlockInfo));
            map.put(BusySearchFrame.getRecipientID(recipient), arrayList);
        }
    }

    public void setController(MVCController mVCController) {
        this.mvcController = mVCController;
    }

    public MVCController getController() {
        return this.mvcController;
    }

    public void setMVCModel(Object object) {
        this.busySearch = (GWBusySearch)object;
        this.setStartDay(this.busySearch.getStartDate());
        this.setDaysCount(this.busySearch.getDaysCount());
        this.setAppointmentTime(this.busySearch.getAppointmentTime());
        this.createRectangles();
        this.repaint();
        this.checkAvailableTimePosition(true);
    }

    public Object getMVCModel() {
        return null;
    }

    public void setStartDay(Date date) {
        this.gcStartDay.setTime(date);
    }

    protected int calculateShiftHours(TimeInterval timeInterval) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(timeInterval.getStartDate());
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeInMillis(this.gcStartDay.getTimeInMillis());
        gregorianCalendar2.set(11, 0);
        gregorianCalendar2.set(12, 0);
        gregorianCalendar2.set(13, 0);
        gregorianCalendar2.set(14, 0);
        int n = 0;
        if ((gregorianCalendar.getTimeInMillis() - gregorianCalendar2.getTimeInMillis()) % 86400000L == 3600000L) {
            n = -1;
        } else if ((gregorianCalendar.getTimeInMillis() - gregorianCalendar2.getTimeInMillis()) % 86400000L == 82800000L) {
            n = 1;
        }
        return n;
    }

    private class TGPKeyListener
    extends KeyAdapter {
        private TGPKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 227) {
                if (!keyEvent.isShiftDown()) {
                    TimeGridPanel.this.nextColumn();
                }
                if (TimeGridPanel.this.recDragged.x + TimeGridPanel.this.recDragged.width <= TimeGridPanel.this.getWidth() && (float)TimeGridPanel.this.selectedColumn * TimeGridPanel.this.columnWidth < (float)TimeGridPanel.this.getWidth()) {
                    TimeGridPanel.this.updateRecPosition();
                }
            } else if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 226) {
                if (!keyEvent.isShiftDown()) {
                    TimeGridPanel.this.prevColumn();
                }
                TimeGridPanel.this.updateRecPosition();
            }
            if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 225) {
                if (!keyEvent.isShiftDown()) {
                    TimeGridPanel.this.nextRow();
                }
                if (TimeGridPanel.this.recDragged.x + TimeGridPanel.this.recDragged.width <= TimeGridPanel.this.getWidth() && (float)TimeGridPanel.this.selectedColumn * TimeGridPanel.this.columnWidth < (float)TimeGridPanel.this.getWidth()) {
                    TimeGridPanel.this.updateRecPosition();
                    TimeGridPanel.this.getController().processCommand(new Command(1370));
                }
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 224) {
                if (!keyEvent.isShiftDown()) {
                    TimeGridPanel.this.prevRow();
                }
                TimeGridPanel.this.updateRecPosition();
                TimeGridPanel.this.getController().processCommand(new Command(1370));
            }
        }
    }

    class VisibleIndividualInfo {
        private Rectangle visibleRectangle;
        private TimeBlockInfo timeBlockInfo;

        public VisibleIndividualInfo(Rectangle rectangle, TimeBlockInfo timeBlockInfo) {
            this.visibleRectangle = rectangle;
            this.timeBlockInfo = timeBlockInfo;
        }

        public Rectangle getVisibleRectangle() {
            return this.visibleRectangle;
        }

        public TimeBlockInfo getTimeBlockInfo() {
            return this.timeBlockInfo;
        }
    }
}

