/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.search.PlainFoldersTree;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.folders.UnopenedFolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckFoldersTree
extends PlainFoldersTree {
    private AbstractFolder selectedFolder;
    private AbstractButton btnToEnable;

    public CheckFoldersTree(MVCController mVCController, AbstractButton abstractButton, String string) {
        super(mVCController, string);
        this.setCellRenderer(new TreeRenderrer());
        this.addMouseListener(new CheckedTreeMouseListener());
        this.btnToEnable = abstractButton;
        this.btnToEnable.setEnabled(false);
    }

    private boolean canSelectFolder(AbstractFolder abstractFolder) {
        return !(abstractFolder instanceof UnopenedFolder) && !(abstractFolder instanceof SentItemsFolder) && !(abstractFolder instanceof TrashFolder) && !(abstractFolder instanceof ContactsFolder) && !(abstractFolder instanceof QueryFolder);
    }

    public AbstractFolder getSelectedFolder() {
        return this.selectedFolder;
    }

    public void selectFolder(AbstractFolder abstractFolder) {
        this.selectedFolder = abstractFolder;
        this.repaint();
        super.selectFolder(this.selectedFolder);
        this.btnToEnable.setEnabled(true);
    }

    private class TreeLabel
    extends OrientableLabel {
        boolean isSelected;
        boolean hasFocus;

        private TreeLabel() {
        }

        public void paint(Graphics graphics) {
            String string = this.getText();
            if (string != null && 0 < string.length()) {
                if (this.isSelected) {
                    graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    graphics.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension dimension = this.getPreferredSize();
                int n = 0;
                Icon icon = this.getIcon();
                if (icon != null) {
                    n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                graphics.fillRect(n, 0, dimension.width - 1 - n, dimension.height);
            }
            super.paint(graphics);
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }
    }

    private class CheckedTreeMouseListener
    extends MouseAdapter {
        private CheckedTreeMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = CheckFoldersTree.this.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = CheckFoldersTree.this.getPathForRow(n3);
            if (treePath != null) {
                boolean bl;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                AbstractFolder abstractFolder = (AbstractFolder)defaultMutableTreeNode.getUserObject();
                TreeRenderrer treeRenderrer = (TreeRenderrer)CheckFoldersTree.this.getCellRenderer();
                Rectangle rectangle = CheckFoldersTree.this.getPathBounds(treePath);
                boolean bl2 = bl = n2 > rectangle.x && n2 < rectangle.x + treeRenderrer.CHECK_WIDTH;
                if (CheckFoldersTree.this.canSelectFolder(abstractFolder) && bl) {
                    if (abstractFolder.equals(CheckFoldersTree.this.selectedFolder)) {
                        CheckFoldersTree.this.selectedFolder = null;
                        CheckFoldersTree.this.btnToEnable.setEnabled(false);
                    } else {
                        CheckFoldersTree.this.selectedFolder = abstractFolder;
                        CheckFoldersTree.this.btnToEnable.setEnabled(true);
                    }
                }
                ((DefaultTreeModel)CheckFoldersTree.this.getModel()).nodeChanged(defaultMutableTreeNode);
            }
        }
    }

    private class TreeRenderrer
    extends OrientablePanel
    implements TreeCellRenderer,
    TextTreeRenderer {
        private final JCheckBox check = new OrientableCheckBox();
        private final TreeLabel label = new TreeLabel();
        public final int CHECK_WIDTH;
        private int rowHeight;

        public TreeRenderrer() {
            this.CHECK_WIDTH = this.check.getPreferredSize().width;
            this.rowHeight = UIUtils.TREE_ROW_HEIGHT;
            this.setLayout(new FlowLayout(3, 0, 0));
            this.add(this.check);
            this.add(this.label);
            this.check.setOpaque(!UIUtils.GTK_LAF_USED);
            this.label.setOpaque(false);
            this.check.setPreferredSize(new Dimension(this.CHECK_WIDTH, this.rowHeight));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            AbstractFolder abstractFolder = (AbstractFolder)((DefaultMutableTreeNode)object).getUserObject();
            this.check.setEnabled(CheckFoldersTree.this.canSelectFolder(abstractFolder));
            this.label.setSelected(bl);
            if (CheckFoldersTree.this.selectedFolder != null && CheckFoldersTree.this.selectedFolder.equals(abstractFolder)) {
                this.check.setSelected(true);
            } else {
                this.check.setSelected(false);
            }
            if (bl) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBackground(jTree.getBackground());
                this.label.setForeground(UIManager.getColor("Tree.foreground"));
            }
            this.check.setBackground(jTree.getBackground());
            this.label.setText(object.toString() + ' ');
            this.label.setFont(jTree.getFont());
            int n2 = this.label.getPreferredSize().width + this.CHECK_WIDTH + 3;
            if (jTree.getRowHeight() != 0) {
                this.rowHeight = jTree.getRowHeight();
            }
            if (abstractFolder instanceof AbstractFolder) {
                this.label.setIcon(ControlsUtils.getImageForFolder(abstractFolder));
            }
            return this;
        }

        public Component getComponent() {
            return this;
        }

        public int getTextX() {
            return this.CHECK_WIDTH + this.label.getIcon().getIconWidth() + this.label.getIconTextGap();
        }
    }
}

