/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTree;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class GWFoldersTreeSerializer {
    private static boolean loaded = false;
    private static final List EXPANDED_NODES_IDS = new LinkedList();

    public static synchronized void save(GWFoldersTree gWFoldersTree) {
        int n;
        EXPANDED_NODES_IDS.clear();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < gWFoldersTree.getRowCount(); ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object;
            if (!gWFoldersTree.isExpanded(n) || !((object = (defaultMutableTreeNode = (DefaultMutableTreeNode)gWFoldersTree.getPathForRow(n).getLastPathComponent()).getUserObject()) instanceof AbstractFolder)) continue;
            String string = ((AbstractFolder)object).getID();
            EXPANDED_NODES_IDS.add(string);
            stringBuffer.append(string);
            stringBuffer.append(',');
        }
        n = stringBuffer.length();
        if (n > 0) {
            stringBuffer.delete(n - 1, n);
        }
        ApplicationOptions.getInstance().put("FOLDERS_TREE_EXPANDED_NODES", stringBuffer.toString());
        loaded = true;
    }

    public static void restore(JTree jTree) {
        TreeModel treeModel = jTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
        GWFoldersTreeSerializer.doRestore(defaultMutableTreeNode, jTree);
    }

    private static void doRestore(DefaultMutableTreeNode defaultMutableTreeNode, JTree jTree) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            try {
                AbstractFolder abstractFolder = (AbstractFolder)defaultMutableTreeNode2.getUserObject();
                if (GWFoldersTreeSerializer.isExpaded(abstractFolder.getID())) {
                    TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
                    jTree.expandPath(treePath);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (defaultMutableTreeNode2.isLeaf()) continue;
            GWFoldersTreeSerializer.doRestore(defaultMutableTreeNode2, jTree);
        }
    }

    public static synchronized boolean isExpaded(String string) {
        if (!loaded) {
            GWFoldersTreeSerializer.loadTreeState();
        }
        return EXPANDED_NODES_IDS.contains(string);
    }

    private static synchronized void loadTreeState() {
        String string = ApplicationOptions.getInstance().getString("FOLDERS_TREE_EXPANDED_NODES", null);
        if (string != null) {
            EXPANDED_NODES_IDS.clear();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || string2.length() <= 0) continue;
                EXPANDED_NODES_IDS.add(string2);
            }
        }
        loaded = true;
    }

    private GWFoldersTreeSerializer() {
    }
}

