/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree.dnd;

import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.DocumentFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class FoldersTreeDropTargetListener
extends DropTargetAdapter {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$folderstree$dnd$FoldersTreeDropTargetListener == null ? (class$com$novell$gw$jclient$application$controls$folderstree$dnd$FoldersTreeDropTargetListener = FoldersTreeDropTargetListener.class$("com.novell.gw.jclient.application.controls.folderstree.dnd.FoldersTreeDropTargetListener")) : class$com$novell$gw$jclient$application$controls$folderstree$dnd$FoldersTreeDropTargetListener));
    private MainGWFoldersTree tree;
    private Timer timerExpander;
    private TreePath lastPath;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$folderstree$dnd$FoldersTreeDropTargetListener;

    public FoldersTreeDropTargetListener(MainGWFoldersTree mainGWFoldersTree) {
        this.tree = mainGWFoldersTree;
        this.initTimer();
    }

    private void initTimer() {
        this.timerExpander = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FoldersTreeDropTargetListener.this.tree.isExpanded(FoldersTreeDropTargetListener.this.lastPath)) {
                    FoldersTreeDropTargetListener.this.tree.collapsePath(FoldersTreeDropTargetListener.this.lastPath);
                } else {
                    FoldersTreeDropTargetListener.this.tree.expandPath(FoldersTreeDropTargetListener.this.lastPath);
                }
                FoldersTreeDropTargetListener.this.tree.repaint();
            }
        });
        this.timerExpander.setRepeats(false);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.tree.getClosestPathForLocation(point.x, point.y);
        if (this.lastPath == null || !this.lastPath.equals(treePath)) {
            this.lastPath = treePath;
            this.timerExpander.restart();
            this.tree.repaintDragFolder(point);
        }
        if (this.isDataFlavorSupported(dropTargetDragEvent.getCurrentDataFlavorsAsList()) && this.isDropAllowed()) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private boolean isDropAllowed() {
        if (this.lastPath == null) {
            return true;
        }
        AbstractFolder abstractFolder = MainGWFoldersTree.getFolderForPath(this.lastPath);
        return !(abstractFolder instanceof SentItemsFolder) && !(abstractFolder instanceof ContactsFolder) && !(abstractFolder instanceof QueryFolder) && !(abstractFolder instanceof DocumentFolder);
    }

    private boolean isDataFlavorSupported(List list) {
        String string = ControlsUtils.getUserGuid(this.tree.getController());
        return list.contains(GWFlavors.itemsFlavor) && string.equals(GWFlavors.itemsFlavor.getUserGuid()) || list.contains(GWFlavors.folderFlavor) && string.equals(GWFlavors.itemsFlavor.getUserGuid());
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.tree.repaint();
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.stopRepaintTree();
        this.lastPath = null;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.stopRepaintTree();
        if (dropTargetDropEvent.isLocalTransfer() && dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(GWFlavors.itemsFlavor)) {
            this.acceptItemList(dropTargetDropEvent);
        }
        this.lastPath = null;
    }

    private void acceptItemList(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            TransferItems transferItems = (TransferItems)transferable.getTransferData(GWFlavors.itemsFlavor);
            AbstractFolder abstractFolder = MainGWFoldersTree.getFolderForPath(this.lastPath);
            int n = dropTargetDropEvent.getDropAction() == 1 ? 8192 : 4;
            if ("Trash".equals(abstractFolder.getType())) {
                n = 16;
            }
            if (abstractFolder.transfer(transferItems, n)) {
                dropTargetDropEvent.dropComplete(true);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            logger.debug((Object)exception, (Throwable)exception);
        }
    }

    private void stopRepaintTree() {
        this.timerExpander.stop();
        this.tree.setDragTargetFolder(null);
        this.tree.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

