/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarRefreshEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateListener;
import com.novell.gw.jclient.application.controls.gwcalendar.ClockListener;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggleChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggleEvent;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public abstract class CalendarView
extends OrientablePanel
implements MVCView,
CalendarStateListener,
ClockListener {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$CalendarView == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$CalendarView = CalendarView.class$("com.novell.gw.jclient.application.controls.gwcalendar.CalendarView")) : class$com$novell$gw$jclient$application$controls$gwcalendar$CalendarView));
    public static Dimension HEADER_LABEL_SIZE = new Dimension(20, PLAFChanger.getFontSize() + 8);
    protected GregorianCalendar currentDay;
    protected TypesToggle typesToggle;
    protected JLabel lblTitle;
    protected MVCController controller;
    private int activeViewType;
    private boolean isActive;
    private boolean needRefreshAppointments = true;
    private boolean needRefreshNotes = true;
    private boolean needRefreshTasks = true;
    protected TimeInterval refreshedInterval;
    private boolean refreshedAppointments;
    private boolean refreshedNotes;
    private boolean refreshedTasks;
    private boolean needRefresh;
    protected OrientablePanel titlePanel;
    protected String optionFrameName;
    private AbstractFolder folder;
    private ItemList itemList;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$CalendarView;

    public CalendarView(GregorianCalendar gregorianCalendar, TypesToggle typesToggle, MVCController mVCController) {
        this.currentDay = gregorianCalendar;
        this.typesToggle = typesToggle;
        this.typesToggle.addChangeListener(new ChangeListener());
        this.controller = this.createController(mVCController);
        this.refreshedInterval = new TimeInterval(-1L, -1L);
        this.optionFrameName = ControlsUtils.getFrameForController(this.controller).getOptionFrameName();
        this.buildUI();
    }

    protected abstract MVCController createController(MVCController var1);

    private void adjustViews(TypesToggleEvent typesToggleEvent) {
        int n = typesToggleEvent.getToggleID();
        switch (n) {
            case 0: {
                this.adjustAppointments();
                break;
            }
            case 1: {
                this.adjustNotes();
                break;
            }
            case 2: {
                this.adjustTasks();
            }
        }
        this.updateUI();
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    public void setFolder(AbstractFolder abstractFolder) {
        this.folder = abstractFolder;
        this.itemList = abstractFolder.getItemList();
    }

    public ItemList getItemList() {
        return this.itemList;
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.titlePanel = new OrientablePanel(new BorderLayout());
        this.lblTitle = new OrientableLabel("Header");
        this.lblTitle.setOpaque(true);
        this.lblTitle.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.lblTitle.setBackground(Color.WHITE);
        this.lblTitle.setPreferredSize(HEADER_LABEL_SIZE);
        this.lblTitle.setMinimumSize(HEADER_LABEL_SIZE);
        this.titlePanel.add((Component)this.lblTitle, "First");
        this.add((Component)this.titlePanel, "North");
    }

    public Object getMVCModel() {
        return null;
    }

    protected final void refresh(boolean bl) {
        this.refresh(bl, null);
    }

    protected void refresh(boolean bl, TimeInterval timeInterval) {
        if (this.canRefresh()) {
            this.prepareRefresh(bl);
            if (this.typesToggle.isShowAppointments() && this.needRefreshAppointments) {
                this.refreshAppointments(this.getItemList(), timeInterval);
                this.refreshAllDayEvents(this.getItemList(), timeInterval);
                this.needRefreshAppointments = false;
            }
            if (this.typesToggle.isShowNotes() && this.needRefreshNotes) {
                this.refreshNotes(this.getItemList(), timeInterval);
                this.needRefreshNotes = false;
            }
            if (this.typesToggle.isShowTasks() && this.needRefreshTasks) {
                this.refreshTasks(this.getItemList(), timeInterval);
                this.needRefreshTasks = false;
            }
            this.adjustClock();
            this.needRefresh = false;
        }
    }

    protected abstract int getViewType();

    protected void prepareRefresh(boolean bl) {
    }

    protected void refreshTasks(ItemList itemList, TimeInterval timeInterval) {
    }

    protected void refreshNotes(ItemList itemList, TimeInterval timeInterval) {
    }

    protected void refreshAppointments(ItemList itemList, TimeInterval timeInterval) {
    }

    protected void refreshAllDayEvents(ItemList itemList, TimeInterval timeInterval) {
    }

    protected void adjustTasks() {
    }

    protected void adjustNotes() {
    }

    protected void adjustAppointments() {
    }

    protected final boolean canRefresh() {
        return this.isActive && this.activeViewType == this.getViewType();
    }

    protected boolean isNeedRefresh() {
        return this.needRefreshAppointments || this.needRefreshNotes || this.needRefreshTasks;
    }

    private void needRefresh() {
        this.needRefreshAppointments = true;
        this.needRefreshNotes = true;
        this.needRefreshTasks = true;
    }

    public void setController(MVCController mVCController) {
        this.controller = mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void change(CalendarStateEvent calendarStateEvent) {
        this.activeViewType = calendarStateEvent.getViewType();
        this.isActive = calendarStateEvent.isActivated();
        this.needRefresh();
        this.refresh(true);
    }

    public void refresh(CalendarRefreshEvent calendarRefreshEvent) {
        this.needRefresh();
        this.refresh(true, calendarRefreshEvent.getRefreshInterval());
    }

    protected void needRefresh(boolean bl) {
        if (this.needRefresh != bl) {
            this.needRefresh = bl;
            if (this.needRefresh) {
                this.backupStates();
            } else {
                this.restoreStates();
            }
        }
    }

    private void restoreStates() {
        this.needRefreshAppointments = !this.refreshedAppointments;
        this.needRefreshTasks = !this.refreshedTasks;
        this.needRefreshNotes = !this.refreshedNotes;
        this.refreshedAppointments = false;
        this.refreshedTasks = false;
        this.refreshedNotes = false;
    }

    private void backupStates() {
        if (!this.needRefreshAppointments) {
            this.needRefreshAppointments = true;
            this.refreshedAppointments = true;
        }
        if (!this.needRefreshNotes) {
            this.needRefreshNotes = true;
            this.refreshedNotes = true;
        }
        if (!this.needRefreshTasks) {
            this.needRefreshTasks = true;
            this.refreshedTasks = true;
        }
    }

    public void clockTik() {
        this.adjustClock();
    }

    protected void adjustClock() {
    }

    public void setMVCModel(Object object) {
        if (object instanceof Date) {
            this.currentDay.setTime((Date)object);
            this.adjustCurrentDay();
        }
    }

    public Date getCurrentDate() {
        return this.currentDay.getTime();
    }

    protected abstract void adjustCurrentDay();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ChangeListener
    implements TypesToggleChangeListener {
        private ChangeListener() {
        }

        public void changed(TypesToggleEvent typesToggleEvent) {
            CalendarView.this.refresh(false);
            CalendarView.this.adjustViews(typesToggleEvent);
        }
    }
}

