/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.AppAction;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.actions.ActionNewCalendarItem;
import com.novell.gw.jclient.application.actions.send.DefaultSendCallbackImpl;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveTypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarRefreshEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateListener;
import com.novell.gw.jclient.application.controls.gwcalendar.ClockListener;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.ViewsToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.ViewsToggleChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.ViewsToggleEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.calendarpanel.CalendarToolBar;
import com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview.DailyView;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.MonthlyView;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.WeeklyView;
import com.novell.gw.jclient.application.controls.gwcalendar.yearly.YearlyView;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendar;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GWCalendar
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$GWCalendar == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$GWCalendar = GWCalendar.class$("com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar")) : class$com$novell$gw$jclient$application$controls$gwcalendar$GWCalendar));
    private static final String daily = "daily";
    private static final String weekly = "weekly";
    private static final String monthly = "monthly";
    private static final String yearly = "yearly";
    private MVCController controller;
    private JPanel pnlGWCalendar;
    private DailyView pnlDaily;
    private WeeklyView pnlWeekly;
    private MonthlyView pnlMonthly;
    private YearlyView pnlYear;
    private GregorianCalendar currentDay;
    private TypesToggle typesToggle;
    private ViewsToggle viewsToggle;
    private TypesToggle typesToggleDaily;
    private TypesToggle typesToggleWeekly;
    private TypesToggle typesToggleMonthly;
    private TypesToggle typesToggleYearly;
    private boolean activated;
    private ArrayList stateListeners;
    private static final int CLOCK_PERIOD = 3000;
    private boolean isDailyOnly;
    private CalendarTimer clock;
    private ClockAction clockAction;
    private ArrayList clockListeners;
    private int resizingCount;
    private AbstractFolder folder;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$GWCalendar;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$AppointmentItem;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$TaskItem;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$ReminderNote;

    public GWCalendar(GregorianCalendar gregorianCalendar, boolean bl, MVCController mVCController) {
        this.init(gregorianCalendar, bl, mVCController);
        this.buildDailyPanel();
        if (!this.isDailyOnly) {
            this.buildWeeklyPanel();
            this.buildMonthlyPanel();
            this.buildYearlyPanel();
            this.adjustView(this.viewsToggle.getType());
        } else {
            this.adjustView(0);
        }
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    public void setFolder(AbstractFolder abstractFolder) {
        this.folder = abstractFolder;
        this.pnlDaily.setFolder(this.folder);
        if (!this.isDailyOnly) {
            this.pnlWeekly.setFolder(this.folder);
            this.pnlMonthly.setFolder(this.folder);
            this.pnlYear.setFolder(this.folder);
        }
        if (this.activated) {
            this.notifyRefresh(null);
        }
    }

    private void adjustView(int n) {
        CardLayout cardLayout = (CardLayout)this.pnlGWCalendar.getLayout();
        switch (n) {
            case 0: {
                cardLayout.show(this.pnlGWCalendar, daily);
                break;
            }
            case 1: {
                cardLayout.show(this.pnlGWCalendar, weekly);
                break;
            }
            case 2: {
                cardLayout.show(this.pnlGWCalendar, monthly);
                break;
            }
            case 3: {
                cardLayout.show(this.pnlGWCalendar, yearly);
            }
        }
        this.fireStateChanged(new CalendarStateEvent(this.activated, n));
        this.requestFocus(n);
    }

    public void activate(boolean bl) {
        if (bl != this.activated) {
            this.activated = bl;
            if (this.activated) {
                this.clock.start();
            } else {
                this.clock.stop();
            }
            int n = !this.isDailyOnly ? this.viewsToggle.getType() : 0;
            this.fireStateChanged(new CalendarStateEvent(this.activated, n));
        }
    }

    public void setController(MVCController mVCController) {
        if (mVCController instanceof GWCalendarController) {
            this.controller = mVCController;
        }
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
    }

    public Object getMVCModel() {
        return null;
    }

    public static void createNewCalendarItem(String string, Date date, MVCController mVCController, boolean bl) {
        ActionNewCalendarItem actionNewCalendarItem = null;
        if (bl) {
            if (string == "Appointment") {
                actionNewCalendarItem = (ActionNewCalendarItem)((Object)mVCController.getActionList().getAction("Posted Appointment"));
            } else if (string == "AllDayEvent") {
                actionNewCalendarItem = (ActionNewCalendarItem)((Object)mVCController.getActionList().getAction("Posted All Day Event"));
            } else if (string == "Task") {
                actionNewCalendarItem = (ActionNewCalendarItem)((Object)mVCController.getActionList().getAction("Posted Task"));
            } else if (string == "Note") {
                actionNewCalendarItem = (ActionNewCalendarItem)((Object)mVCController.getActionList().getAction("Posted Reminder Note"));
            }
        } else if (string == "Appointment") {
            actionNewCalendarItem = (ActionNewCalendarItem)((Object)mVCController.getActionList().getAction("New Appointment"));
        } else if (string == "AllDayEvent") {
            actionNewCalendarItem = (ActionNewCalendarItem)((Object)mVCController.getActionList().getAction("New All Day Event"));
        } else if (string == "Note") {
            actionNewCalendarItem = (ActionNewCalendarItem)((Object)mVCController.getActionList().getAction("New Reminder Note"));
        } else if (string == "Task") {
            actionNewCalendarItem = (ActionNewCalendarItem)((Object)mVCController.getActionList().getAction("New Task"));
        }
        actionNewCalendarItem.setSelectedDate(date);
        ((AppAction)((Object)actionNewCalendarItem)).actionPerformed(null);
    }

    public void postNewCalendarItem(String string, GregorianCalendar gregorianCalendar, String string2) {
        String string3 = ControlsUtils.getUserGuid(this);
        AbstractCalendarItem abstractCalendarItem = null;
        try {
            AbstractFolder abstractFolder = this.getFolder();
            GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
            gregorianCalendar2.add(14, 3600000);
            if (string == "Appointment") {
                abstractCalendarItem = (AppointmentItem)GWCommandManager.getInstance(string3).composeNewItem(class$com$novell$gw$jclient$bl$om$items$AppointmentItem == null ? (class$com$novell$gw$jclient$bl$om$items$AppointmentItem = GWCalendar.class$("com.novell.gw.jclient.bl.om.items.AppointmentItem")) : class$com$novell$gw$jclient$bl$om$items$AppointmentItem, abstractFolder);
            } else if (string == "AllDayEvent") {
                abstractCalendarItem = (AppointmentItem)GWCommandManager.getInstance(string3).composeNewItem(class$com$novell$gw$jclient$bl$om$items$AppointmentItem == null ? (class$com$novell$gw$jclient$bl$om$items$AppointmentItem = GWCalendar.class$("com.novell.gw.jclient.bl.om.items.AppointmentItem")) : class$com$novell$gw$jclient$bl$om$items$AppointmentItem, abstractFolder);
                ((AppointmentItem)abstractCalendarItem).setAllDayEvent(true);
                GWCalendarUtils.clearTime(gregorianCalendar);
                gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
                gregorianCalendar2.add(11, 24);
            } else if (string == "Task") {
                abstractCalendarItem = (TaskItem)GWCommandManager.getInstance(string3).composeNewItem(class$com$novell$gw$jclient$bl$om$items$TaskItem == null ? (class$com$novell$gw$jclient$bl$om$items$TaskItem = GWCalendar.class$("com.novell.gw.jclient.bl.om.items.TaskItem")) : class$com$novell$gw$jclient$bl$om$items$TaskItem, abstractFolder);
            } else if (string == "Note") {
                abstractCalendarItem = (ReminderNote)GWCommandManager.getInstance(string3).composeNewItem(class$com$novell$gw$jclient$bl$om$items$ReminderNote == null ? (class$com$novell$gw$jclient$bl$om$items$ReminderNote = GWCalendar.class$("com.novell.gw.jclient.bl.om.items.ReminderNote")) : class$com$novell$gw$jclient$bl$om$items$ReminderNote, abstractFolder);
            }
            if (abstractCalendarItem != null) {
                abstractCalendarItem.setStartDates(new Date[]{gregorianCalendar.getTime()});
                abstractCalendarItem.setEndDate(gregorianCalendar2.getTime());
                abstractCalendarItem.setSubject(string2);
                GWCommandManager.getInstance(string3).postItem(abstractCalendarItem, new DefaultSendCallbackImpl());
            }
        }
        catch (GWCommandException gWCommandException) {
            ErrorDialog.processGWException(gWCommandException);
        }
    }

    private void init(GregorianCalendar gregorianCalendar, boolean bl, MVCController mVCController) {
        this.currentDay = gregorianCalendar;
        this.controller = new GWCalendarController(this, mVCController);
        this.stateListeners = new ArrayList();
        this.pnlGWCalendar = new OrientablePanel(new CardLayout());
        this.clockListeners = new ArrayList();
        this.clockAction = new ClockAction();
        this.clock = new CalendarTimer(3000, this.clockAction);
        this.isDailyOnly = bl;
        this.setPreferredSize(new Dimension(500, 360));
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlGWCalendar, "Center");
        this.viewsToggle = new ViewsToggle();
        this.viewsToggle.addChangeListener(new ViewsChangeListener());
        if (this.isDailyOnly) {
            this.typesToggle = this.typesToggleDaily = new TypesToggle("CALENDAR_DAILY", ApplicationOptions.getInstance().getBoolean("CALENDAR_DAILY.SHOW_APPOINTMENTS"), ApplicationOptions.getInstance().getBoolean("CALENDAR_DAILY.SHOW_TASKS"), ApplicationOptions.getInstance().getBoolean("CALENDAR_DAILY.SHOW_NOTES"));
        } else {
            this.typesToggleDaily = new ActiveTypesToggle("CALENDAR_DAILY", ApplicationOptions.getInstance().getBoolean("CALENDAR_DAILY.SHOW_APPOINTMENTS"), ApplicationOptions.getInstance().getBoolean("CALENDAR_DAILY.SHOW_TASKS"), ApplicationOptions.getInstance().getBoolean("CALENDAR_DAILY.SHOW_NOTES"));
            this.typesToggleWeekly = new ActiveTypesToggle("CALENDAR_WEEKLY", ApplicationOptions.getInstance().getBoolean("CALENDAR_WEEKLY.SHOW_APPOINTMENTS"), ApplicationOptions.getInstance().getBoolean("CALENDAR_WEEKLY.SHOW_TASKS"), ApplicationOptions.getInstance().getBoolean("CALENDAR_WEEKLY.SHOW_NOTES"));
            this.typesToggleMonthly = new ActiveTypesToggle("CALENDAR_MONTHLY", ApplicationOptions.getInstance().getBoolean("CALENDAR_MONTHLY.SHOW_APPOINTMENTS"), ApplicationOptions.getInstance().getBoolean("CALENDAR_MONTHLY.SHOW_TASKS"), ApplicationOptions.getInstance().getBoolean("CALENDAR_MONTHLY.SHOW_NOTES"));
            this.typesToggleYearly = new ActiveTypesToggle("CALENDAR_YEARLY", true, true, true);
            this.typesToggle = this.viewsToggle.getType() == 0 ? this.typesToggleDaily : (this.viewsToggle.getType() == 1 ? this.typesToggleWeekly : (this.viewsToggle.getType() == 2 ? this.typesToggleMonthly : this.typesToggleYearly));
        }
        if (!this.isDailyOnly) {
            CalendarToolBar calendarToolBar = new CalendarToolBar(this.currentDay, this.typesToggle, this.viewsToggle, this.getController(), this.typesToggleDaily, this.typesToggleWeekly, this.typesToggleMonthly, this.typesToggleYearly);
            this.add((Component)calendarToolBar, "North");
        }
    }

    public void doLayout() {
        Window window = SwingUtilities.getWindowAncestor(this);
        boolean bl = ApplicationOptions.getInstance().getBoolean("QUICKVIEWER_VISIBLE", false);
        if (this.isVisible()) {
            if (window instanceof FrameCalendar || this.resizingCount >= 2 || !bl) {
                super.doLayout();
            }
            ++this.resizingCount;
        }
    }

    public void setVisible(boolean bl) {
        boolean bl2 = ApplicationOptions.getInstance().getBoolean("QUICKVIEWER_VISIBLE", false);
        if (bl2 && bl) {
            this.resizingCount = 0;
        }
        super.setVisible(bl);
    }

    private void buildDailyPanel() {
        this.pnlDaily = new DailyView(this.currentDay, this.typesToggleDaily, this.getController());
        this.stateListeners.add(this.pnlDaily);
        this.clockListeners.add(this.pnlDaily);
        this.pnlGWCalendar.add(daily, this.pnlDaily);
    }

    private void buildWeeklyPanel() {
        this.pnlWeekly = new WeeklyView(this.currentDay, this.typesToggleWeekly, this.getController());
        this.stateListeners.add(this.pnlWeekly);
        this.clockListeners.add(this.pnlWeekly);
        this.pnlGWCalendar.add(weekly, this.pnlWeekly);
    }

    private void buildMonthlyPanel() {
        this.pnlMonthly = new MonthlyView(this.currentDay, this.typesToggleMonthly, this.getController());
        this.stateListeners.add(this.pnlMonthly);
        this.clockListeners.add(this.pnlMonthly);
        this.pnlGWCalendar.add(monthly, this.pnlMonthly);
    }

    private void buildYearlyPanel() {
        this.pnlYear = new YearlyView(this.currentDay, this.typesToggleYearly, this.getController());
        this.stateListeners.add(this.pnlYear);
        this.pnlGWCalendar.add(yearly, this.pnlYear);
    }

    public void notifyRefresh(TimeInterval timeInterval) {
        CalendarRefreshEvent calendarRefreshEvent = new CalendarRefreshEvent();
        calendarRefreshEvent.setRefreshInterval(timeInterval);
        this.fireNotifyRefresh(calendarRefreshEvent);
    }

    private void fireNotifyRefresh(CalendarRefreshEvent calendarRefreshEvent) {
        int n = this.stateListeners.size();
        for (int i = 0; i < n; ++i) {
            CalendarStateListener calendarStateListener = (CalendarStateListener)this.stateListeners.get(i);
            calendarStateListener.refresh(calendarRefreshEvent);
        }
    }

    private void fireStateChanged(CalendarStateEvent calendarStateEvent) {
        int n = this.stateListeners.size();
        for (int i = 0; i < n; ++i) {
            CalendarStateListener calendarStateListener = (CalendarStateListener)this.stateListeners.get(i);
            calendarStateListener.change(calendarStateEvent);
        }
    }

    private void fireClockTik() {
        int n = this.clockListeners.size();
        for (int i = 0; i < n; ++i) {
            ClockListener clockListener = (ClockListener)this.clockListeners.get(i);
            clockListener.clockTik();
        }
    }

    public void requestFocus() {
        int n = this.isDailyOnly ? 0 : this.viewsToggle.getType();
        this.requestFocus(n);
    }

    private void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.pnlDaily.requestFocus();
                break;
            }
            case 1: {
                this.pnlWeekly.requestFocus();
                break;
            }
            case 2: {
                this.pnlMonthly.requestFocus();
                break;
            }
            case 3: {
                this.pnlYear.requestFocus();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ViewsChangeListener
    implements ViewsToggleChangeListener {
        private ViewsChangeListener() {
        }

        public void changed(ViewsToggleEvent viewsToggleEvent) {
            GWCalendar.this.adjustView(viewsToggleEvent.getNewValue());
        }
    }

    public static class CalendarTimer {
        private int delay = 500;
        private ActionListener actionListener = null;
        private Thread thread;
        private boolean started = false;

        public CalendarTimer(int n, ActionListener actionListener) {
            logger.debug((Object)"### Creating new CalendarTimer...");
            this.delay = n;
            this.actionListener = actionListener;
        }

        public void start() {
            if (!this.started) {
                this.startThread();
                this.started = true;
            }
        }

        public void stop() {
            if (this.started) {
                this.stopThread();
                this.started = false;
            }
        }

        private void startThread() {
            this.thread = new Thread(){

                public void run() {
                    CalendarTimer calendarTimer = this;
                    while (!this.isInterrupted()) {
                        if (calendarTimer.actionListener != null) {
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    CalendarTimer.access$400(1.access$500(this.this$1)).actionPerformed(null);
                                }
                            });
                        }
                        try {
                            1.sleep(calendarTimer.delay);
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.isInterrupted()) continue;
                            this.interrupt();
                        }
                    }
                }

                static /* synthetic */ CalendarTimer access$500(1 var0) {
                    return var0.this;
                }
            };
            this.thread.start();
        }

        private void stopThread() {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    private class ClockAction
    extends AbstractAction {
        boolean isDateChanged = false;

        private ClockAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
            if (gregorianCalendar.get(11) == 0 && !this.isDateChanged) {
                this.isDateChanged = true;
                Command command = new Command(70, gregorianCalendar.getTime());
                GWCalendar.this.getController().processCommand(command);
            }
            if (gregorianCalendar.get(11) == 23) {
                this.isDateChanged = false;
            }
            GWCalendar.this.fireClockTik();
        }
    }
}

