/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.novell.gw.jclient.application.controls.gwcalendar.MultilineLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarConstants;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTip;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipManager;
import com.novell.gw.jclient.application.options.ColorsOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public abstract class StaticItemLabel
extends MultilineLabel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$StaticItemLabel == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$StaticItemLabel = StaticItemLabel.class$("com.novell.gw.jclient.application.controls.gwcalendar.StaticItemLabel")) : class$com$novell$gw$jclient$application$controls$gwcalendar$StaticItemLabel));
    AbstractItem item;
    private Color selectedColor = ColorsOptions.CALENDAR_ITEM_SELECTED_COLOR;
    private Color unselectedColor = ColorsOptions.CALENDAR_ITEM_UNSELECTED_BACKGROUND;
    private boolean checkAlignIcons;
    private boolean selected;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$StaticItemLabel;

    public StaticItemLabel(boolean bl, AbstractItem abstractItem, Color color, boolean bl2) {
        this.item = abstractItem;
        this.isMultiLine = bl;
        this.checkAlignIcons = bl2;
        this.setUnselectedColor(color);
        this.setBackground(this.getUnselectedColor());
        if (abstractItem instanceof AppointmentItem) {
            String string = ((AppointmentItem)this.item).getPlace();
            if (!string.equals("")) {
                string = " (" + string + ")";
            }
            if ((this.item.getNativeItem().getSendOptions() & 2) > 0) {
                this.setText(string);
            } else {
                this.setText(this.item.getSubject() + string);
            }
        } else {
            this.setText(this.item.getSubject());
        }
        this.init();
    }

    protected int getStatusIconWidth() {
        if (this.alignIcons()) {
            return CalendarConstants.ICON_PLACE_WIDTH;
        }
        return super.getStatusIconWidth();
    }

    protected void init() {
        this.setFont();
        this.doSetForegroundColor();
        ArrayList<ImageIcon> arrayList = new ArrayList<ImageIcon>();
        if (!this.item.isPersonal()) {
            arrayList.add(ImageResources.ICON_GROUP_APPOINTMENT);
        }
        if (this.item.isPrivate()) {
            arrayList.add(ImageResources.ICON_CALENDAR_PRIVATE);
        }
        this.setStatusIcon(arrayList);
        if (OptionManager.getInstance().getGeneralOptions().isSmartToolTipEnabled()) {
            this.setToolTipText(GWToolTip.getString(this.item));
        } else {
            this.setToolTipText(null);
        }
    }

    protected void setFont() {
        Font font = "Appointment".equals(this.item.getType()) || "Note".equals(this.item.getType()) || "Task".equals(this.item.getType()) ? (((AbstractCalendarItem)this.item).isAccepted() ? FontOptions.getFontFor(100) : (this.item.isStatusRead() ? FontOptions.getFontFor(170) : FontOptions.getFontFor(180))) : (this.item.isStatusRead() ? FontOptions.getFontFor(100) : FontOptions.getFontFor(110));
        this.setFont(font);
    }

    private void doSetForegroundColor() {
        if (this.item.isProcessing()) {
            this.setForeground(Color.GRAY);
            return;
        }
        this.setForegroundColor();
    }

    protected void setForegroundColor() {
    }

    public void setToolTipText(String string) {
        GWToolTipManager.setToolTipText(this, string);
    }

    public AbstractItem getItem() {
        return this.item;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof StaticItemLabel) {
            StaticItemLabel staticItemLabel = (StaticItemLabel)object;
            return this.item.equals(staticItemLabel.getItem());
        }
        return false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        if (!this.selected == bl) {
            this.selected = bl;
            this.repaint();
        }
    }

    protected void paintSelection(Graphics graphics) {
        Color color = graphics.getColor();
        boolean bl = this.isSelected();
        if (bl) {
            graphics.setColor(this.getSelectedColor());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.BLACK);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        if (this.alignIcons()) {
            if (!bl) {
                graphics.setColor(Color.LIGHT_GRAY);
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            }
            graphics.setColor(new Color(246, 238, 238));
            graphics.fillRect(this.getSelectionX(1), 1, this.getStatusIconWidth() + 1, this.getHeight() - 2);
            graphics.setColor(Color.LIGHT_GRAY);
            int n = this.getSelectionX(this.getStatusIconWidth() + 2);
            graphics.drawLine(n, 1, n, this.getHeight() - 2);
        }
        graphics.setColor(color);
    }

    boolean isCheckAlighIcons() {
        return this.checkAlignIcons;
    }

    protected boolean alignIcons() {
        return false;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
    }

    public Color getUnselectedColor() {
        return this.unselectedColor;
    }

    public void setUnselectedColor(Color color) {
        this.unselectedColor = color;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

