/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.calendarpanel;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.components.customizedbutton.ToolBarSeparator;
import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.ViewsToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.calendarpanel.CalendarToolBarController;
import com.novell.gw.jclient.application.controls.gwcalendar.calendarpanel.ToolbarDateSelector;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateSelector;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CalendarToolBar
extends OrientablePanel
implements MVCView {
    private CalendarToolBarController controller;
    private DateSelector dateSelector;
    private GregorianCalendar currentDay;
    private TypesToggle typesToggle;
    private ViewsToggle viewsToggle;
    private TypesToggle typesToggleDaily;
    private TypesToggle typesToggleWeekly;
    private TypesToggle typesToggleMonthly;
    private TypesToggle typesToggleYearly;
    private ToolBarToggleButton tbtnShowAppointments;
    private ToolBarToggleButton tbtnShowTasks;
    private ToolBarToggleButton tbtnShowNotes;
    private static final int MNEMONIC_APPOINTMENT = 80;
    private static final int MNEMONIC_TASK = 83;
    private static final int MNEMONIC_REMINDER = 82;
    private static final int MNEMONIC_GOTO_TODAY = 71;
    private ToolBarButton btnPlus;
    private ToolBarButton btnMinus;
    private BntCalendarType btnDailyAction;
    private BntCalendarType btnWeeklyAction;
    private BntCalendarType btnMonthlyAction;
    private BntCalendarType btnYearlyAction;
    private ToolBarToggleButton btnDaily;
    private ToolBarToggleButton btnWeekly;
    private ToolBarToggleButton btnMonthly;
    private ToolBarToggleButton btnYearly;
    private DateSelectorListener dateSelectorListener;

    public CalendarToolBar(GregorianCalendar gregorianCalendar, TypesToggle typesToggle, ViewsToggle viewsToggle, MVCController mVCController, TypesToggle typesToggle2, TypesToggle typesToggle3, TypesToggle typesToggle4, TypesToggle typesToggle5) {
        this.controller = new CalendarToolBarController(this, mVCController);
        this.currentDay = gregorianCalendar;
        this.typesToggle = typesToggle;
        this.viewsToggle = viewsToggle;
        this.typesToggleDaily = typesToggle2;
        this.typesToggleWeekly = typesToggle3;
        this.typesToggleMonthly = typesToggle4;
        this.typesToggleYearly = typesToggle5;
        this.buildUI();
        this.updateDateLabel();
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getBackground(), 4), BorderFactory.createEtchedBorder()));
        this.add((Component)this.buildLeftPanel(), "Before");
        this.add((Component)this.buildRightPanel(), "After");
        this.tbtnShowAppointments.setSelected(this.typesToggle.isShowAppointments());
        this.tbtnShowTasks.setSelected(this.typesToggle.isShowTasks());
        this.tbtnShowNotes.setSelected(this.typesToggle.isShowNotes());
        this.btnDaily.setSelected(this.viewsToggle.getType() == 0);
        this.btnWeekly.setSelected(this.viewsToggle.getType() == 1);
        this.btnMonthly.setSelected(this.viewsToggle.getType() == 2);
        this.btnYearly.setSelected(this.viewsToggle.getType() == 3);
        this.setPlusMinusEnable(this.viewsToggle.getType() == 1);
        this.setTypesToggleDisable(this.viewsToggle.getType() == 3);
    }

    private JComponent buildLeftPanel() {
        GWToolBar gWToolBar = new GWToolBar(new FlowLayout(1, 0, 3));
        gWToolBar.setBorder(null);
        gWToolBar.add(this.buildCalendarButtonPanel());
        gWToolBar.add(new JLabel(" "));
        BtnTodayAction btnTodayAction = new BtnTodayAction();
        ToolBarButton toolBarButton = new ToolBarButton(btnTodayAction);
        gWToolBar.add(toolBarButton);
        boolean bl = this.getComponentOrientation().isLeftToRight();
        this.addLessMoreButtons(gWToolBar, 1, bl);
        this.addLessMoreButtons(gWToolBar, 7, bl);
        this.addLessMoreButtons(gWToolBar, 31, bl);
        this.addLessMoreButtons(gWToolBar, 365, bl);
        return gWToolBar;
    }

    private void addLessMoreButtons(JComponent jComponent, int n, boolean bl) {
        Insets insets = new Insets(4, 2, 4, 2);
        GWToolBar gWToolBar = new GWToolBar();
        gWToolBar.setBorder(null);
        ((Container)gWToolBar).setLayout(new BorderLayout());
        ToolBarButton toolBarButton = new ToolBarButton(ImageResources.ACT_LESS_BLACK);
        toolBarButton.setMargin(insets);
        toolBarButton.addActionListener(new ChangeSelectedDay((bl ? -1 : 1) * n));
        gWToolBar.add((Component)toolBarButton, "West");
        gWToolBar.add((Component)new JLabel("" + n), "Center");
        toolBarButton = new ToolBarButton(ImageResources.ACT_MORE_BLACK);
        toolBarButton.setMargin(insets);
        toolBarButton.addActionListener(new ChangeSelectedDay((bl ? 1 : -1) * n));
        gWToolBar.add((Component)toolBarButton, "East");
        jComponent.add(gWToolBar);
    }

    private JPanel buildCalendarButtonPanel() {
        this.dateSelector = new ToolbarDateSelector();
        this.dateSelectorListener = new DateSelectorListener();
        this.dateSelector.addDateChangeListener(this.dateSelectorListener);
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getBackground(), 4), BorderFactory.createEtchedBorder()));
        orientablePanel.add((Component)this.dateSelector, "Center");
        return orientablePanel;
    }

    private JComponent buildRightPanel() {
        GWToolBar gWToolBar = new GWToolBar(new FlowLayout(1, 0, 3));
        this.btnDaily = new ToolBarToggleButton(ImageResources.ACT_CALENDAR_DAILY);
        this.btnDailyAction = new BntCalendarType(0);
        this.btnDaily.addActionListener(this.btnDailyAction);
        gWToolBar.add(this.btnDaily);
        this.btnWeekly = new ToolBarToggleButton(ImageResources.ACT_CALENDAR_WEEKLY);
        this.btnWeeklyAction = new BntCalendarType(1);
        this.btnWeekly.addActionListener(this.btnWeeklyAction);
        gWToolBar.add(this.btnWeekly);
        this.btnMonthly = new ToolBarToggleButton(ImageResources.ACT_CALENDAR_MONTHLY);
        this.btnMonthlyAction = new BntCalendarType(2);
        this.btnMonthly.addActionListener(this.btnMonthlyAction);
        gWToolBar.add(this.btnMonthly);
        this.btnYearly = new ToolBarToggleButton(ImageResources.ACT_CALENDAR_YEARLY);
        this.btnYearlyAction = new BntCalendarType(3);
        this.btnYearly.addActionListener(this.btnYearlyAction);
        gWToolBar.add(this.btnYearly);
        ToolBarToggleButton toolBarToggleButton = new ToolBarToggleButton(ImageResources.ACT_CALENDAR_GROUP);
        toolBarToggleButton.setEnabled(false);
        gWToolBar.add(toolBarToggleButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.btnDaily);
        buttonGroup.add(this.btnWeekly);
        buttonGroup.add(this.btnMonthly);
        buttonGroup.add(this.btnYearly);
        buttonGroup.add(toolBarToggleButton);
        this.tbtnShowAppointments = this.createToggleButton(ImageResources.ACT_SHOW_APPOINTMENTS, 80);
        this.tbtnShowTasks = this.createToggleButton(ImageResources.ACT_SHOW_TASKS, 83);
        this.tbtnShowNotes = this.createToggleButton(ImageResources.ACT_SHOW_NOTES, 82);
        this.btnPlus = new ToolBarButton(new BtnPlusAction());
        this.btnMinus = new ToolBarButton(new BtnMinusAction());
        this.addListenersToItemsToggle();
        gWToolBar.add(this.tbtnShowAppointments);
        gWToolBar.add(this.tbtnShowTasks);
        gWToolBar.add(this.tbtnShowNotes);
        gWToolBar.add(new ToolBarSeparator());
        gWToolBar.add(this.btnPlus);
        gWToolBar.add(this.btnMinus);
        return gWToolBar;
    }

    private ToolBarToggleButton createToggleButton(ImageIcon imageIcon, int n) {
        ToolBarToggleButton toolBarToggleButton = new ToolBarToggleButton(imageIcon);
        toolBarToggleButton.setMargin(new Insets(2, 2, 2, 2));
        if (!OS.isMacOS()) {
            toolBarToggleButton.setMnemonic(n);
        }
        return toolBarToggleButton;
    }

    private void addListenersToItemsToggle() {
        this.tbtnShowAppointments.addActionListener(new TbtnViewItems(this.tbtnShowTasks, this.tbtnShowNotes));
        this.tbtnShowTasks.addActionListener(new TbtnViewItems(this.tbtnShowAppointments, this.tbtnShowNotes));
        this.tbtnShowNotes.addActionListener(new TbtnViewItems(this.tbtnShowAppointments, this.tbtnShowTasks));
    }

    protected void updateDateLabel() {
        this.dateSelector.setDate(this.currentDay);
    }

    public void setPlusMinusEnable(boolean bl) {
        this.btnPlus.setEnabled(bl);
        this.btnMinus.setEnabled(bl);
    }

    private void setTypesToggleDisable(boolean bl) {
        this.tbtnShowAppointments.setEnabled(!bl);
        this.tbtnShowTasks.setEnabled(!bl);
        this.tbtnShowNotes.setEnabled(!bl);
    }

    public void setController(MVCController mVCController) {
        this.controller = (CalendarToolBarController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (object instanceof Date) {
            this.currentDay.setTime((Date)object);
            this.updateDateLabel();
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private class DateSelectorListener
    implements DateValueChangeListener {
        private DateSelectorListener() {
        }

        public void valueChanged(DateChangeEvent dateChangeEvent) {
            Command command = new Command(70, dateChangeEvent.getDate().getTime());
            CalendarToolBar.this.getController().processCommand(command);
        }
    }

    private class BtnMinusAction
    extends AbstractAction {
        public BtnMinusAction() {
            this.putValue("SmallIcon", ImageResources.ICON_MINUS);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Command command = new Command(90, new Integer(-1));
            CalendarToolBar.this.getController().processCommand(command);
        }
    }

    private class BtnPlusAction
    extends AbstractAction {
        public BtnPlusAction() {
            this.putValue("SmallIcon", ImageResources.ICON_PLUS);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Command command = new Command(90, new Integer(1));
            CalendarToolBar.this.getController().processCommand(command);
        }
    }

    private class BtnTodayAction
    extends AbstractAction {
        public BtnTodayAction() {
            this.putValue("SmallIcon", ImageResources.ACT_GOTO_TODAY);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Command command = new Command(70, GWCalendarUtils.getToday().getTime());
            CalendarToolBar.this.getController().processCommand(command);
        }
    }

    class TbtnViewItems
    extends AbstractAction {
        private ToolBarToggleButton another1;
        private ToolBarToggleButton another2;

        public TbtnViewItems(ToolBarToggleButton toolBarToggleButton, ToolBarToggleButton toolBarToggleButton2) {
            this.another1 = toolBarToggleButton;
            this.another2 = toolBarToggleButton2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(actionEvent.getSource() instanceof ToolBarToggleButton)) {
                return;
            }
            ToolBarToggleButton toolBarToggleButton = (ToolBarToggleButton)actionEvent.getSource();
            if (!this.another1.isSelected() && !this.another2.isSelected()) {
                toolBarToggleButton.setSelected(true);
                return;
            }
            CalendarToolBar.this.typesToggle.setShowAppointments(CalendarToolBar.this.tbtnShowAppointments.isSelected());
            CalendarToolBar.this.typesToggle.setShowNotes(CalendarToolBar.this.tbtnShowNotes.isSelected());
            CalendarToolBar.this.typesToggle.setShowTasks(CalendarToolBar.this.tbtnShowTasks.isSelected());
        }
    }

    private class BntCalendarType
    extends AbstractAction {
        int calendarType;

        public BntCalendarType(int n) {
            this.calendarType = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarToolBar.this.setPlusMinusEnable(this.calendarType == 1);
            if (this.calendarType == 0) {
                CalendarToolBar.this.typesToggle = CalendarToolBar.this.typesToggleDaily;
            } else if (this.calendarType == 1) {
                CalendarToolBar.this.typesToggle = CalendarToolBar.this.typesToggleWeekly;
            } else if (this.calendarType == 2) {
                CalendarToolBar.this.typesToggle = CalendarToolBar.this.typesToggleMonthly;
            } else if (this.calendarType == 3) {
                CalendarToolBar.this.typesToggle = CalendarToolBar.this.typesToggleYearly;
            }
            CalendarToolBar.this.tbtnShowAppointments.setSelected(CalendarToolBar.this.typesToggle.isShowAppointments());
            CalendarToolBar.this.tbtnShowNotes.setSelected(CalendarToolBar.this.typesToggle.isShowNotes());
            CalendarToolBar.this.tbtnShowTasks.setSelected(CalendarToolBar.this.typesToggle.isShowTasks());
            CalendarToolBar.this.setTypesToggleDisable(this.calendarType == 3);
            CalendarToolBar.this.viewsToggle.setType(this.calendarType);
        }
    }

    private class ChangeSelectedDay
    extends AbstractAction {
        int dayShift = 0;

        public ChangeSelectedDay(int n) {
            this.dayShift = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.dayShift) {
                case -1: {
                    CalendarToolBar.this.currentDay.add(5, -1);
                    break;
                }
                case 1: {
                    CalendarToolBar.this.currentDay.add(5, 1);
                    break;
                }
                case -7: {
                    CalendarToolBar.this.currentDay.add(5, -7);
                    break;
                }
                case 7: {
                    CalendarToolBar.this.currentDay.add(5, 7);
                    break;
                }
                case -31: {
                    CalendarToolBar.this.currentDay.add(2, -1);
                    break;
                }
                case 31: {
                    CalendarToolBar.this.currentDay.add(2, 1);
                    break;
                }
                case -365: {
                    CalendarToolBar.this.currentDay.add(1, -1);
                    break;
                }
                case 365: {
                    CalendarToolBar.this.currentDay.add(1, 1);
                }
            }
            CalendarToolBar.this.getController().processCommand(new Command(70, CalendarToolBar.this.currentDay.getTime()));
        }
    }
}

