/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.dailycalendar;

import com.novell.gw.jclient.application.controls.gwcalendar.DayBorder;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class DailyCalendar
extends OrientablePanel
implements MouseListener {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$dailycalendar$DailyCalendar == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$dailycalendar$DailyCalendar = DailyCalendar.class$("com.novell.gw.jclient.application.controls.gwcalendar.dailycalendar.DailyCalendar")) : class$com$novell$gw$jclient$application$controls$gwcalendar$dailycalendar$DailyCalendar));
    protected GregorianCalendar gcSelectedDay = GWCalendarUtils.getToday();
    protected GregorianCalendar gcCurrDay = GWCalendarUtils.getToday();
    protected Dimension dimMinMonthSize = new Dimension(164, 18);
    protected JLabel lblHeader = new OrientableLabel();
    protected DayBorder todayBorderSelected = new DayBorder(DayBorder.BORDER_TODAY_SELECTED);
    protected DayBorder todayBorderUnselected = new DayBorder(DayBorder.BORDER_TODAY_UNSELECTED);
    protected DayBorder dayBorderSelected = new DayBorder(DayBorder.BORDER_DAY_SELECTED);
    protected JPanel pnlHeader;
    protected static final int CAL_SIZE = 42;
    protected Font fntDates = FontOptions.getFontFor(140);
    protected Font fntDays = FontOptions.getFontFor(150);
    protected int iHgap = 1;
    protected int iVgap = 1;
    protected JLabel[] lblDays = new JLabel[7];
    protected JLabel[] btnDates = new JLabel[42];
    protected Dimension dimMinDaysButtSize = new Dimension(24, 16);
    protected GregorianCalendar[] days = new GregorianCalendar[42];
    protected boolean isSelectedRectangleShowing = true;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$dailycalendar$DailyCalendar;

    public DailyCalendar() {
        this(GWCalendarUtils.getToday().getTime());
    }

    public DailyCalendar(Date date) {
        this.init();
        this.gcSelectedDay.setTime(date);
        this.gcCurrDay.setTime(date);
        this.buildUI();
        this.refreshView();
    }

    protected void init() {
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.setBackground(Color.white);
        this.setOpaque(false);
        this.add((Component)this.buildHeader(), "North");
        this.add((Component)this.buildDaysDatesPanel(), "Center");
    }

    protected JPanel buildHeader() {
        this.pnlHeader = new OrientablePanel(new BorderLayout());
        this.pnlHeader.setBackground(Color.blue);
        this.lblHeader.setHorizontalAlignment(0);
        this.lblHeader.setForeground(Color.white);
        Font font = new Font(this.lblHeader.getFont().getName(), 1, this.lblHeader.getFont().getSize());
        this.lblHeader.setFont(font);
        this.pnlHeader.add(this.lblHeader);
        return this.pnlHeader;
    }

    protected JPanel buildDaysDatesPanel() {
        int n;
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setBackground(Color.white);
        orientablePanel.setLayout(new GridLayout(7, 7, this.iHgap, this.iVgap));
        int n2 = GWCalendarUtils.getToday().getFirstDayOfWeek();
        for (n = 0; n < 7; ++n) {
            int n3 = n + n2 - 1;
            if (n3 >= 7) {
                n3 %= 7;
            }
            this.lblDays[n] = new OrientableLabel(GWCalendarUtils.dayShortestNames[n3], 0);
            this.lblDays[n].setFont(this.fntDays);
            this.lblDays[n].setForeground(ColorConstants.clrDaysWork);
            if (n2 == 1) {
                if (n == 0 || n == 6) {
                    this.lblDays[n].setForeground(ColorConstants.clrDaysHoly);
                }
            } else if (n == 5 || n == 6) {
                this.lblDays[n].setForeground(ColorConstants.clrDaysHoly);
            }
            orientablePanel.add(this.lblDays[n]);
        }
        for (n = 0; n < 42; ++n) {
            this.btnDates[n] = new DailyLabel(n);
            this.btnDates[n].addMouseListener(this);
            this.btnDates[n].setHorizontalAlignment(0);
            this.btnDates[n].setVerticalAlignment(0);
            this.btnDates[n].setBackground(Color.white);
            this.btnDates[n].setForeground(Color.white);
            this.btnDates[n].setBorder(BorderFactory.createEmptyBorder());
            orientablePanel.add(this.btnDates[n]);
        }
        return orientablePanel;
    }

    public void refreshView() {
        GregorianCalendar gregorianCalendar = GWCalendarUtils.initCalendar(this.gcCurrDay);
        for (int i = 0; i < 42; ++i) {
            gregorianCalendar.add(5, 1);
            this.days[i] = (GregorianCalendar)gregorianCalendar.clone();
            if (gregorianCalendar.get(2) != this.gcCurrDay.get(2)) {
                this.days[i] = null;
                this.refreshDateLabelView(i);
                continue;
            }
            this.setWeekEndColor(gregorianCalendar, i);
            this.refreshDateLabelView(i);
            if (this.isSelectedRectangleShowing) {
                this.setSelectedDayBorder(gregorianCalendar, i);
            }
            this.setTodayColor(gregorianCalendar, i);
        }
        this.setHeaderTitle();
        this.setHeaderColor();
        this.validate();
    }

    protected void refreshDateLabelView(int n) {
        String string = "";
        if (this.days[n] != null) {
            string = "" + this.days[n].get(5);
        }
        this.btnDates[n].setText(string);
        this.btnDates[n].setEnabled(this.days[n] != null);
        this.btnDates[n].setBorder(BorderFactory.createEmptyBorder());
    }

    private void setSelectedDayBorder(GregorianCalendar gregorianCalendar, int n) {
        String string;
        String string2 = GWCalendarUtils.getDateFormat().format(gregorianCalendar.getTime());
        if (string2.equals(string = GWCalendarUtils.getDateFormat().format(this.gcSelectedDay.getTime()))) {
            this.btnDates[n].setBorder(this.dayBorderSelected);
        } else {
            this.btnDates[n].setBorder(BorderFactory.createEmptyBorder());
        }
    }

    protected void setTodayColor(GregorianCalendar gregorianCalendar, int n) {
        String string = GWCalendarUtils.getDateFormat().format(GWCalendarUtils.getToday().getTime());
        String string2 = GWCalendarUtils.getDateFormat().format(gregorianCalendar.getTime());
        String string3 = GWCalendarUtils.getDateFormat().format(this.gcSelectedDay.getTime());
        if (string2.equals(string)) {
            if (string2.equals(string3)) {
                this.btnDates[n].setBorder(this.todayBorderSelected);
            } else {
                this.btnDates[n].setBorder(this.todayBorderUnselected);
            }
        }
    }

    protected void setWeekEndColor(GregorianCalendar gregorianCalendar, int n) {
        if (gregorianCalendar.get(7) == 1 || gregorianCalendar.get(7) == 7) {
            this.btnDates[n].setForeground(ColorConstants.clrDaysHoly);
        } else {
            this.btnDates[n].setForeground(ColorConstants.clrDaysWork);
        }
    }

    private void setHeaderTitle() {
        this.lblHeader.setText(GWCalendarUtils.monthNames[this.gcCurrDay.get(2)] + " " + this.gcCurrDay.get(1));
    }

    protected void setHeaderColor() {
        if (this.gcSelectedDay.get(2) == this.gcCurrDay.get(2) && this.gcSelectedDay.get(1) == this.gcCurrDay.get(1)) {
            this.pnlHeader.setBackground(Color.blue);
        } else {
            this.pnlHeader.setBackground(Color.gray);
        }
    }

    public static GregorianCalendar getToday() {
        return GWCalendarUtils.getToday();
    }

    public void goToToday() {
        this.gcSelectedDay = GWCalendarUtils.getToday();
        this.gcCurrDay = GWCalendarUtils.getToday();
        this.refreshView();
    }

    public void changeDate(Date date) {
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.setTime(date);
        this.setSelectedDay(gregorianCalendar);
    }

    public void setCurrDay(GregorianCalendar gregorianCalendar) {
        this.gcCurrDay = (GregorianCalendar)gregorianCalendar.clone();
        this.refreshView();
    }

    public GregorianCalendar getCurrentDate() {
        return this.gcCurrDay;
    }

    public void setSelectedDay(GregorianCalendar gregorianCalendar) {
        this.gcSelectedDay = (GregorianCalendar)gregorianCalendar.clone();
        this.refreshView();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class DailyLabel
    extends OrientableLabel {
        int index;

        public DailyLabel(int n) {
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

