/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigateCreateItem;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigationCreateItemKeyboardListener;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentsPanelController;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DateWatchPanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class AppointmentsPanel
extends DateWatchPanel
implements NavigateCreateItem {
    public static final Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$AppointmentsPanel == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$AppointmentsPanel = AppointmentsPanel.class$("com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentsPanel")) : class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$AppointmentsPanel));
    private MVCController controller;
    private Point clockPosistion = new Point(-1, -1);
    private ArrayList appointments = new ArrayList();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$AppointmentsPanel;

    public AppointmentsPanel(int n, MVCController mVCController, Date date) {
        super(mVCController);
        this.setLayout(new GridLayout(1, 0, 0, 0));
        this.setCurrentDate(date);
        this.controller = new AppointmentsPanelController(this, mVCController);
        this.setFocusable(true);
        this.addKeyListener(new NavigationCreateItemKeyboardListener(this));
        this.addComponentListener(new ClockAdjustmentListener());
        for (int i = 0; i < n; ++i) {
            this.addPanel();
        }
    }

    public void addBox(ItemList itemList) {
        AppointmentPanel appointmentPanel = (AppointmentPanel)this.appointments.get(this.appointments.size() - 1);
        GregorianCalendar gregorianCalendar = (GregorianCalendar)appointmentPanel.getDay().clone();
        gregorianCalendar.add(5, 1);
        AppointmentPanel appointmentPanel2 = this.addPanel();
        appointmentPanel2.loadItemsForDate(gregorianCalendar.getTime(), itemList);
        this.validate();
        this.adjustClock();
    }

    private AppointmentPanel addPanel() {
        AppointmentPanel appointmentPanel = new AppointmentPanel(this.controller, this);
        appointmentPanel.setBorder(new LineBorder(ColorConstants.HEADER_BORDER_COLOR, 1));
        this.appointments.add(appointmentPanel);
        this.add(appointmentPanel);
        return appointmentPanel;
    }

    public void removeBox() {
        if (this.appointments.size() >= 1) {
            AppointmentPanel appointmentPanel = (AppointmentPanel)this.appointments.get(this.appointments.size() - 1);
            this.remove(appointmentPanel);
            this.appointments.remove(appointmentPanel);
            LevelManager.getInstance().release(appointmentPanel.getController().getLevel());
            this.validate();
            this.adjustClock();
        }
    }

    public void paint(Graphics graphics) {
        graphics = UIUtils.enableAntialiasing(graphics);
        super.paint(graphics);
        int n = this.clockPosistion.x - ImageResources.CLOCK_SMALL.getImage().getWidth(this) / 2 - 1;
        int n2 = this.clockPosistion.y - ImageResources.CLOCK_SMALL.getImage().getHeight(this) / 2 - 1;
        if (n > 0 && n2 > 0) {
            graphics.drawImage(ImageResources.CLOCK_SMALL.getImage(), n, n2, null);
        }
    }

    public AppointmentPanel getBox(GregorianCalendar gregorianCalendar) {
        for (int i = 0; i < this.appointments.size(); ++i) {
            AppointmentPanel appointmentPanel = (AppointmentPanel)this.appointments.get(i);
            if (!GWCalendarUtils.isSameDate(appointmentPanel.getDay(), gregorianCalendar)) continue;
            return appointmentPanel;
        }
        return null;
    }

    public void adjustClock() {
        AppointmentPanel appointmentPanel = this.getBox(GWCalendarUtils.getToday());
        if (appointmentPanel != null) {
            int n = GWCalendarUtils.getClockPosition();
            appointmentPanel.adjustClock(n);
            this.clockPosistion.x = appointmentPanel.getX();
            this.clockPosistion.y = n;
        } else {
            this.clockPosistion.x = -1;
            this.clockPosistion.y = -1;
        }
        this.repaint();
    }

    private void loadItemsForDate(GregorianCalendar gregorianCalendar, ItemList itemList) {
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        for (int i = 0; i < this.appointments.size(); ++i) {
            AppointmentPanel appointmentPanel = (AppointmentPanel)this.appointments.get(i);
            appointmentPanel.loadItemsForDate(gregorianCalendar2.getTime(), itemList);
            gregorianCalendar2.add(5, 1);
        }
    }

    public void loadItemsForDate(GregorianCalendar gregorianCalendar, ItemList itemList, TimeInterval timeInterval) {
        if (timeInterval == null) {
            this.loadItemsForDate(gregorianCalendar, itemList);
        } else {
            GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
            for (int i = 0; i < this.appointments.size(); ++i) {
                if (timeInterval.contains(gregorianCalendar2)) {
                    AppointmentPanel appointmentPanel = (AppointmentPanel)this.appointments.get(i);
                    appointmentPanel.loadItemsForDate(gregorianCalendar2.getTime(), itemList);
                }
                gregorianCalendar2.add(5, 1);
            }
        }
    }

    public Rectangle getWorkTimeRectangle() {
        int n = 0;
        if (n < this.appointments.size()) {
            AppointmentPanel appointmentPanel = (AppointmentPanel)this.appointments.get(n);
            Rectangle rectangle = appointmentPanel.getWorkTimeRectangle();
            Rectangle rectangle2 = SwingUtilities.convertRectangle(appointmentPanel, rectangle, this);
            return rectangle2;
        }
        return new Rectangle();
    }

    private void navigate(int n, int n2) {
        this.getBox(this.getCurrentDate()).navigate(n, n2);
    }

    public void navigateUP() {
        this.navigate(12, -30);
    }

    public void navigateDOWN() {
        this.navigate(12, 30);
    }

    public void navigateLEFT() {
        this.navigate(5, -1);
    }

    public void navigateRIGHT() {
        this.navigate(5, 1);
    }

    public void quickCreateItem(char c) {
        this.getBox(this.getCurrentDate()).handleQuickCreateItem(c);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ClockAdjustmentListener
    extends ComponentAdapter {
        private ClockAdjustmentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            AppointmentsPanel.this.adjustClock();
        }
    }
}

