/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.level.LevelManager;
import com.appframework.mvc.Command;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.StaticItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.BorderedCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.StaticCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.StaticPopupMenu;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.Glass;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.GlassPanelLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;

public class CalendarItemPanelPopup
extends StaticPopupMenu {
    private StaticCalendarItemPanel contentPanel;
    private JLayeredPane mainPanel;
    private Glass glass;
    private GlassPanelMouseHandler mouseHandler;
    private StaticPopupMenu tipPopup;
    private ActiveItemLabel tipLabel;
    private TipMouseListener tipMouseAdapter;

    public CalendarItemPanelPopup() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.mainPanel = new JLayeredPane();
        this.mainPanel.setLayout(new GlassPanelLayout());
        this.mainPanel.setBorder(null);
        this.glass = new Glass();
        this.mainPanel.add((Component)this.glass, "Glass");
        this.mainPanel.setLayer(this.glass, JLayeredPane.MODAL_LAYER, 0);
        this.mouseHandler = new GlassPanelMouseHandler();
        this.glass.addMouseListener(this.mouseHandler);
        this.glass.addMouseMotionListener(this.mouseHandler);
        this.initToolTips();
        this.add((Component)this.mainPanel, "Center");
    }

    private void initToolTips() {
        this.tipPopup = new StaticPopupMenu();
        this.tipPopup.setOpaque(false);
        this.tipPopup.setLayout(new BorderLayout());
        this.tipPopup.setBorder(BorderFactory.createEmptyBorder());
        this.tipPopup.setFocusOwner(this.getFocusOwner());
        this.tipMouseAdapter = new TipMouseListener();
    }

    public void setContentPanel(StaticCalendarItemPanel staticCalendarItemPanel) {
        if (this.contentPanel != null) {
            this.mainPanel.remove(this.contentPanel);
            LevelManager.getInstance().release(this.contentPanel.getController().getLevel());
            this.contentPanel.removeItems();
        }
        this.contentPanel = staticCalendarItemPanel;
        if (this.contentPanel != null) {
            this.mainPanel.add((Component)this.contentPanel, "Center");
            this.mainPanel.setLayer(this.contentPanel, JLayeredPane.DEFAULT_LAYER, 0);
        }
        this.updateUI();
    }

    public boolean contens(BorderedCalendarItemPanel borderedCalendarItemPanel) {
        if (this.contentPanel != null) {
            return this.contentPanel.getCurrentDate().equals(borderedCalendarItemPanel.getCurrentDate());
        }
        return false;
    }

    private StaticItemLabel getLabel(Point point) {
        Component component = this.contentPanel.getComponentAt(point);
        if (component == null) {
            return null;
        }
        if (component instanceof StaticItemLabel) {
            return (StaticItemLabel)component;
        }
        return null;
    }

    private void handleToolTip(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        StaticItemLabel staticItemLabel = this.getLabel(point);
        if (staticItemLabel == null) {
            return;
        }
        if (staticItemLabel.equals(this.tipLabel)) {
            return;
        }
        this.closeToolTip();
        Rectangle rectangle = staticItemLabel.getBounds();
        Dimension dimension = new Dimension(staticItemLabel.getPreferredSize());
        int n = rectangle.x;
        int n2 = rectangle.y;
        this.tipLabel = (ActiveItemLabel)this.contentPanel.createLabel(false, staticItemLabel.getItem());
        this.tipLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.tipLabel.addMouseListener(this.tipMouseAdapter);
        this.tipLabel.setSelected(staticItemLabel.isSelected());
        this.tipPopup.add((Component)this.tipLabel, "Center");
        dimension.width = dimension.width < this.contentPanel.getWidth() ? this.contentPanel.getWidth() : (dimension.width += 3);
        this.tipPopup.setPreferredSize(dimension);
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            n -= 8;
        }
        this.tipPopup.show(this.contentPanel, n, n2);
    }

    private void closeToolTip() {
        this.tipPopup.setVisible(false);
        if (this.tipLabel != null) {
            this.tipLabel.removeMouseListener(this.tipMouseAdapter);
            this.tipPopup.remove(this.tipLabel);
            LevelManager.getInstance().release(this.tipLabel.getController().getLevel());
            this.tipLabel = null;
        }
    }

    public void close() {
        this.setContentPanel(null);
        this.closeToolTip();
        this.setVisible(false);
    }

    public StaticCalendarItemPanel getContentPanel() {
        return this.contentPanel;
    }

    public GregorianCalendar getCurrentDate() {
        if (this.contentPanel != null) {
            return this.contentPanel.getCurrentDate();
        }
        return null;
    }

    public void setItems(GregorianCalendar gregorianCalendar, IDObjectsCollection iDObjectsCollection, String string) {
        if (this.contentPanel != null) {
            this.contentPanel.setItems(gregorianCalendar, iDObjectsCollection, string);
            this.closeToolTip();
        }
    }

    public void setShowItems(boolean bl, String string) {
        if (this.contentPanel != null) {
            this.contentPanel.setShowItems(bl, string);
        }
    }

    private class TipMouseListener
    extends MouseAdapter {
        private boolean wasPopup;

        private TipMouseListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.wasPopup) {
                this.wasPopup = false;
                CalendarItemPanelPopup.this.closeToolTip();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.wasPopup) {
                this.wasPopup = mouseEvent.isPopupTrigger();
            }
            if (!CalendarItemPanelPopup.this.getFocusOwner().isFocusOwner()) {
                CalendarItemPanelPopup.this.getFocusOwner().grabFocus();
            }
            CalendarItemPanelPopup.this.tipLabel.getController().processCommand(new Command(70, CalendarItemPanelPopup.this.contentPanel.getCurrentDate().getTime()));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.wasPopup) {
                this.wasPopup = mouseEvent.isPopupTrigger();
            }
        }
    }

    private class GlassPanelMouseHandler
    implements MouseListener,
    MouseMotionListener {
        private GlassPanelMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!CalendarItemPanelPopup.this.getFocusOwner().isFocusOwner()) {
                CalendarItemPanelPopup.this.getFocusOwner().grabFocus();
            }
            CalendarItemPanelPopup.this.getContentPanel().getController().processCommand(new Command(70, CalendarItemPanelPopup.this.getContentPanel().getCurrentDate().getTime()));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                StaticCalendarItemPanel staticCalendarItemPanel = CalendarItemPanelPopup.this.contentPanel;
                GWCalendarPopup gWCalendarPopup = new GWCalendarPopup("CalendarItem", staticCalendarItemPanel.getController());
                gWCalendarPopup.setDate(staticCalendarItemPanel.getCurrentDate().getTime());
                gWCalendarPopup.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!CalendarItemPanelPopup.this.contains(mouseEvent.getPoint())) {
                CalendarItemPanelPopup.this.close();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            CalendarItemPanelPopup.this.handleToolTip(mouseEvent);
        }
    }
}

