/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.novell.gw.jclient.application.controls.busysearch.AvailableTimeGrid;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class DayLabelsPanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$DayLabelsPanel == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$DayLabelsPanel = DayLabelsPanel.class$("com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DayLabelsPanel")) : class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$DayLabelsPanel));
    protected int height = 20;
    protected Border labelBorder;
    private GregorianCalendar gcCurrentDay = GWCalendarUtils.getToday();
    private GregorianCalendar gcStartDay = GWCalendarUtils.getToday();
    private DateFormat dateFormat;
    private int daysCount = 7;
    private DayLabelContainerAdapter dayLabelContainerAdapter;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$DayLabelsPanel;

    public DayLabelsPanel(int n) {
        super(new GridLayout());
        this.daysCount = n;
        this.init();
        this.buildDaysPanel();
        this.dayLabelContainerAdapter = new DayLabelContainerAdapter();
        this.addContainerListener(this.dayLabelContainerAdapter);
        this.addComponentListener(new DayLabelComponentAdapter());
    }

    public DayLabelsPanel() {
        this(7);
    }

    protected void init() {
        this.labelBorder = BorderFactory.createLineBorder(Color.darkGray);
        Locale locale = EngineCommandManager.getLocale();
        TimeZone timeZone = OptionManager.getInstance().getDateTimeOptions().getTimeZone();
        this.dateFormat = DateFormat.getDateInstance(3, locale);
        this.dateFormat.setTimeZone(timeZone);
    }

    protected void buildDaysPanel() {
        this.removeAll();
        for (int i = 0; i < this.daysCount; ++i) {
            this.addLabel();
        }
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        super.setMinimumSize(dimension);
    }

    public void setTitles(Date date, Date date2) {
        this.gcStartDay.setTime(date);
        if (date2 == null) {
            this.gcCurrentDay.setTime(new Date(0L));
        } else {
            this.gcCurrentDay.setTime(date2);
        }
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.setTime(date);
        boolean bl = this.isShortTitle();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JLabel jLabel = this.getLabel(i);
            if (jLabel == null) {
                return;
            }
            this.setTextToLabel(jLabel, gregorianCalendar, bl);
            gregorianCalendar.add(5, 1);
        }
    }

    protected JLabel getLabel(int n) {
        return (JLabel)this.getComponent(n);
    }

    private boolean isShortTitle() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("Mon 23/12/04");
        Graphics graphics = this.getGraphics();
        if (graphics != null && graphics.getFontMetrics().getStringBounds(stringBuffer.toString(), graphics).getWidth() > (double)(this.getWidth() / this.getComponentCount() - 10)) {
            bl = true;
        }
        return bl;
    }

    protected void setTextToLabel(JLabel jLabel, GregorianCalendar gregorianCalendar, boolean bl) {
        StringBuffer stringBuffer;
        if (GWCalendarUtils.isSameDate(gregorianCalendar, this.gcCurrentDay)) {
            jLabel.setBackground(ColorConstants.CURRENT_DAY_COLOR);
            jLabel.setForeground(Color.white);
        } else {
            if (GWCalendarUtils.isSameDate(gregorianCalendar, GWCalendarUtils.getToday())) {
                jLabel.setBackground(ColorConstants.TODAY_COLOR);
            } else {
                jLabel.setBackground(this.getBackground());
            }
            jLabel.setForeground(Color.black);
        }
        if (gregorianCalendar.get(7) == 1 || gregorianCalendar.get(7) == 7) {
            jLabel.setForeground(Color.red);
        }
        if (bl) {
            stringBuffer = new StringBuffer(this.dateFormat.format(gregorianCalendar.getTime()));
        } else {
            stringBuffer = new StringBuffer(GWCalendarUtils.dayMediumNames[gregorianCalendar.get(7) - 1]);
            stringBuffer.append(" ").append(this.dateFormat.format(gregorianCalendar.getTime()));
        }
        jLabel.setText(stringBuffer.toString());
    }

    public void addLabel() {
        OrientableLabel orientableLabel = new OrientableLabel(" ");
        orientableLabel.setHorizontalAlignment(0);
        orientableLabel.setBorder(this.labelBorder);
        if (this.getComponentCount() == this.daysCount - 1) {
            orientableLabel.setBorder(new AvailableTimeGrid.BusyDayLabelBorder(true));
        }
        orientableLabel.setOpaque(true);
        this.add(orientableLabel);
    }

    public void removeLabel() {
        if (this.getComponentCount() < 1) {
            return;
        }
        this.remove(this.getComponentCount() - 1);
        this.validate();
    }

    public void setDaysCount(int n) {
        this.daysCount = n;
        this.removeContainerListener(this.dayLabelContainerAdapter);
        this.buildDaysPanel();
        this.addContainerListener(this.dayLabelContainerAdapter);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DayLabelComponentAdapter
    extends ComponentAdapter {
        DayLabelComponentAdapter() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            DayLabelsPanel dayLabelsPanel = DayLabelsPanel.this;
            dayLabelsPanel.setTitles(dayLabelsPanel.gcStartDay.getTime(), dayLabelsPanel.gcCurrentDay.getTime());
        }
    }

    class DayLabelContainerAdapter
    extends ContainerAdapter {
        DayLabelContainerAdapter() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            DayLabelsPanel.this.setTitles(DayLabelsPanel.this.gcStartDay.getTime(), DayLabelsPanel.this.gcCurrentDay.getTime());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            DayLabelsPanel.this.setTitles(DayLabelsPanel.this.gcStartDay.getTime(), DayLabelsPanel.this.gcCurrentDay.getTime());
        }
    }
}

