/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class HourLabel
extends OrientablePanel {
    private Date time;
    private Color background;
    private TimeLabel lbHour;
    private TimeLabel lbAMPM;
    private TimeLabel min00;
    private TimeLabel min30;

    public HourLabel(Date date, DateFormat dateFormat, Color color) {
        this.time = date;
        this.background = color;
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new GridLayout(0, 2));
        this.setBackground(this.background);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.lbHour = new TimeLabel(GWCalendarUtils.HOUR_FORMAT.format(this.time));
        Font font = this.lbHour.getFont();
        this.lbHour.setFont(font.deriveFont(1, font.getSize() + 3));
        jPanel.add((Component)this.lbHour, "Center");
        this.lbAMPM = new TimeLabel(GWCalendarUtils.AMPM_FORMAT.format(this.time));
        font = this.lbAMPM.getFont();
        this.lbAMPM.setFont(font.deriveFont((float)(font.getSize() - 2)));
        jPanel.add((Component)this.lbAMPM, "South");
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        jPanel2.setLayout(new GridLayout(2, 1));
        this.min00 = new TimeLabel(StringResources.ZERO_ZERO);
        jPanel2.add(this.min00);
        this.min30 = new TimeLabel(StringResources.THREE_ZERO);
        jPanel2.add(this.min30);
        this.add(jPanel2);
    }

    public void setSelected(boolean bl, boolean bl2) {
        if (bl) {
            this.setBackground(ColorConstants.CURRENT_DAY_COLOR);
        } else {
            this.setBackground(this.background);
        }
        this.min00.setSelected(bl && bl2);
        this.min30.setSelected(bl && !bl2);
        this.lbHour.setSelected(bl);
        this.lbAMPM.setSelected(bl);
    }

    private class TimeLabel
    extends OrientableLabel {
        public TimeLabel(String string) {
            super(string);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBackground(Color.RED);
            this.setBackground(HourLabel.this.background);
            this.setOpaque(true);
        }

        public void setSelected(boolean bl) {
            if (bl) {
                this.setBackground(ColorConstants.CURRENT_DAY_COLOR);
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(HourLabel.this.background);
                this.setForeground(Color.BLACK);
            }
        }
    }
}

