/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarViewController;
import com.novell.gw.jclient.application.controls.gwcalendar.DayBorder;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.BorderedCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemPanelPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.StaticCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.GlassPanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class MonthlyView
extends CalendarView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$monthly$monthlyview$MonthlyView == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$monthly$monthlyview$MonthlyView = MonthlyView.class$("com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.MonthlyView")) : class$com$novell$gw$jclient$application$controls$gwcalendar$monthly$monthlyview$MonthlyView));
    private static int CAL_SIZE = 42;
    private BorderedCalendarItemPanel[] bxDays;
    private Border borderHeader;
    private Border borderCurrent;
    private Border borderTodayCurrent;
    private Border borderToday;
    private int minimumCellWidth;
    private int minimumCellHeight;
    private GregorianCalendar[] days;
    private TimeInterval viewInterval;
    private GlassPanel glassPanel;
    private DayBorder borderDefault;
    private CalendarItemPanelPopup popup;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$monthly$monthlyview$MonthlyView;

    public MonthlyView(GregorianCalendar gregorianCalendar, TypesToggle typesToggle, MVCController mVCController) {
        super(gregorianCalendar, typesToggle, mVCController);
    }

    protected MVCController createController(MVCController mVCController) {
        return new CalendarViewController(this, mVCController);
    }

    protected void buildUI() {
        super.buildUI();
        this.setFocusable(false);
        this.days = new GregorianCalendar[CAL_SIZE];
        this.bxDays = new BorderedCalendarItemPanel[CAL_SIZE];
        this.borderCurrent = new DayBorder(DayBorder.BORDER_DAY_SELECTED, 2);
        this.borderTodayCurrent = new DayBorder(DayBorder.BORDER_TODAY_SELECTED, 2);
        this.borderToday = new DayBorder(DayBorder.BORDER_TODAY_UNSELECTED);
        this.borderHeader = new LineBorder(Color.GRAY, 1);
        this.borderDefault = new DayBorder(DayBorder.BORDER_DAY_UNSELECTED);
        this.minimumCellWidth = 70;
        this.minimumCellHeight = 50;
        this.lblTitle.setHorizontalAlignment(0);
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(1));
        this.titlePanel.add((Component)this.buildHeader(), "Center");
        this.popup = new CalendarItemPanelPopup();
        this.glassPanel = new GlassPanel(this.buildGrid(), this.popup, this);
        this.add((Component)this.glassPanel, "Center");
    }

    private void adjustItems(boolean bl, String string) {
        this.popup.setShowItems(bl, string);
        for (int i = 0; i < CAL_SIZE; ++i) {
            this.bxDays[i].setShowItems(bl, string);
        }
    }

    protected void adjustTasks() {
        this.adjustItems(this.typesToggle.isShowTasks(), "Task");
    }

    protected void adjustNotes() {
        this.adjustItems(this.typesToggle.isShowNotes(), "Note");
    }

    protected void adjustAppointments() {
        this.adjustItems(this.typesToggle.isShowAppointments(), "AllDayEvent");
    }

    private JPanel buildHeader() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(1, 7, 1, 1));
        int n = GWCalendarUtils.getToday().getFirstDayOfWeek();
        for (int i = 0; i < 7; ++i) {
            int n2 = i + n - 1;
            if (n2 >= 7) {
                n2 %= 7;
            }
            JLabel jLabel = new JLabel(GWCalendarUtils.dayNames[n2]);
            jLabel.setHorizontalAlignment(0);
            jLabel.setOpaque(true);
            jLabel.setBorder(this.borderHeader);
            jLabel.setBackground(Color.white);
            if (n == 1) {
                if (i == 0 || i == 6) {
                    jLabel.setForeground(ColorConstants.clrDaysHoly);
                }
            } else if (i == 5 || i == 6) {
                jLabel.setForeground(ColorConstants.clrDaysHoly);
            }
            orientablePanel.add(jLabel);
        }
        return orientablePanel;
    }

    private JPanel buildGrid() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(6, 7, 1, 1));
        for (int i = 0; i < CAL_SIZE; ++i) {
            this.bxDays[i] = new BorderedCalendarItemPanel(false, this.getController());
            this.bxDays[i].setMinimumSize(new Dimension(this.minimumCellWidth, this.minimumCellHeight));
            orientablePanel.add(this.bxDays[i]);
        }
        return orientablePanel;
    }

    protected int getViewType() {
        return 2;
    }

    public void closePopup() {
        this.popup.close();
    }

    public void change(CalendarStateEvent calendarStateEvent) {
        this.closePopup();
        super.change(calendarStateEvent);
    }

    private void refreshItems(ItemList itemList, TimeInterval timeInterval) {
        if (timeInterval == null) {
            if (this.popup.getContentPanel() != null) {
                this.refreshPopup(itemList);
            }
            for (int i = 0; i < CAL_SIZE; ++i) {
                this.refreshCalendarItemPanel(this.bxDays[i], itemList, this.days[i]);
            }
        } else {
            if (this.popup.getContentPanel() != null && timeInterval.contains(this.popup.getCurrentDate())) {
                this.refreshPopup(itemList);
            }
            for (int i = 0; i < CAL_SIZE; ++i) {
                if (!timeInterval.contains(this.days[i])) continue;
                this.refreshCalendarItemPanel(this.bxDays[i], itemList, this.days[i]);
            }
        }
    }

    private void refreshCalendarItemPanel(BorderedCalendarItemPanel borderedCalendarItemPanel, ItemList itemList, GregorianCalendar gregorianCalendar) {
        Date date = gregorianCalendar.getTime();
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        IDObjectsCollection iDObjectsCollection2 = new IDObjectsCollection();
        IDObjectsCollection iDObjectsCollection3 = new IDObjectsCollection();
        GWCalendarUtils.fillCalendarItems(itemList, date, iDObjectsCollection, iDObjectsCollection2, iDObjectsCollection3);
        borderedCalendarItemPanel.setItems(gregorianCalendar, iDObjectsCollection, "AllDayEvent");
        borderedCalendarItemPanel.setItems(gregorianCalendar, iDObjectsCollection2, "Task");
        borderedCalendarItemPanel.setItems(gregorianCalendar, iDObjectsCollection3, "Note");
    }

    private void refreshPopup(ItemList itemList) {
        Date date = this.popup.getCurrentDate().getTime();
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        IDObjectsCollection iDObjectsCollection2 = new IDObjectsCollection();
        IDObjectsCollection iDObjectsCollection3 = new IDObjectsCollection();
        GWCalendarUtils.fillCalendarItems(itemList, date, iDObjectsCollection, iDObjectsCollection2, iDObjectsCollection3);
        this.popup.setItems(this.popup.getCurrentDate(), iDObjectsCollection, "AllDayEvent");
        this.popup.setItems(this.popup.getCurrentDate(), iDObjectsCollection2, "Task");
        this.popup.setItems(this.popup.getCurrentDate(), iDObjectsCollection3, "Note");
    }

    protected void prepareRefresh(boolean bl) {
        this.refreshedInterval = GWCalendarUtils.getMonthTimeInterval(this.currentDay.getTime());
        this.updateDays();
        this.adjustBorders();
        long l = GWCalendarUtils.getDayTimeInterval(this.days[0].getTime()).getStartDate();
        long l2 = GWCalendarUtils.getDayTimeInterval(this.days[41].getTime()).getEndDate();
        this.viewInterval = new TimeInterval(l, l2);
    }

    protected void refresh(boolean bl, TimeInterval timeInterval) {
        if (this.canRefresh()) {
            this.prepareRefresh(bl);
            this.refreshItems(this.getItemList(), timeInterval);
            this.adjustAppointments();
            this.adjustTasks();
            this.adjustNotes();
        }
    }

    private void updateTitle() {
        this.lblTitle.setText(" " + GWCalendarUtils.monthNames[this.currentDay.get(2)] + " " + this.currentDay.get(1));
    }

    private void updateDays() {
        this.updateTitle();
        GregorianCalendar gregorianCalendar = GWCalendarUtils.initCalendar(this.currentDay);
        for (int i = 0; i < CAL_SIZE; ++i) {
            gregorianCalendar.add(5, 1);
            this.days[i] = (GregorianCalendar)gregorianCalendar.clone();
            this.bxDays[i].setTitle("" + gregorianCalendar.get(5));
            if (this.refreshedInterval.contains(gregorianCalendar.getTime())) {
                if (gregorianCalendar.get(7) == 1 || gregorianCalendar.get(7) == 7) {
                    this.bxDays[i].setForeground(ColorConstants.clrDaysHoly);
                } else {
                    this.bxDays[i].setForeground(ColorConstants.clrDaysWork);
                }
                this.bxDays[i].setBackground(ColorConstants.clrCurrDayBack);
                continue;
            }
            this.bxDays[i].setForeground(Color.gray);
            this.bxDays[i].setBackground(ColorConstants.clrDayBack);
        }
    }

    private void adjustBorders() {
        String string;
        String string2 = GWCalendarUtils.calendarToString(GWCalendarUtils.getToday());
        String string3 = GWCalendarUtils.calendarToString(this.currentDay);
        StaticCalendarItemPanel staticCalendarItemPanel = this.popup.getContentPanel();
        if (staticCalendarItemPanel != null) {
            string = GWCalendarUtils.calendarToString(staticCalendarItemPanel.getCurrentDate());
            this.updateBorder(string, string3, string2, staticCalendarItemPanel);
        }
        for (int i = 0; i < CAL_SIZE; ++i) {
            string = GWCalendarUtils.calendarToString(this.days[i]);
            BorderedCalendarItemPanel borderedCalendarItemPanel = this.bxDays[i];
            this.updateBorder(string, string3, string2, borderedCalendarItemPanel);
        }
    }

    private void updateBorder(String string, String string2, String string3, StaticCalendarItemPanel staticCalendarItemPanel) {
        if (string.equals(string2) && string.equals(string3)) {
            staticCalendarItemPanel.setBorder(this.borderTodayCurrent);
        } else if (string.equals(string2)) {
            staticCalendarItemPanel.setBorder(this.borderCurrent);
        } else if (string.equals(string3)) {
            staticCalendarItemPanel.setBorder(this.borderToday);
        } else {
            staticCalendarItemPanel.setBorder(this.borderDefault);
        }
    }

    protected void adjustCurrentDay() {
        if (this.refreshedInterval.contains(this.currentDay.getTime())) {
            this.adjustBorders();
            this.needRefresh(false);
        } else {
            this.popup.close();
            this.needRefresh(true);
            this.refresh(false);
        }
    }

    public void requestFocus() {
        this.glassPanel.requestFocus();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

