/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DayCell;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CalendarComponent
extends JComponent
implements ListSelectionListener {
    public static final Color CALENDAR_BACKGROUND = Color.WHITE;
    public static final Color LABELS_BACKGROUND = Color.WHITE;
    public static final Color SELECTED_DAY_COLOR = Color.BLUE;
    public static final Color DAYLABELS_LINE_COLOR = Color.GRAY;
    public static final Color TODAY_DAY_FILL_COLOR = new Color(225, 225, 225);
    public static final Color TODAY_DAY_BORDER_COLOR = Color.LIGHT_GRAY;
    private static final int DEFAULT_CELL_WIDTH = PLAFChanger.getFontSize() * 2 - 2;
    private static final int DEFAULT_CELL_HEIGHT = PLAFChanger.getFontSize() + 2;
    private static final int DEFAULT_LABELS_HEIGHT = PLAFChanger.getFontSize() + 4;
    private int cellWidth;
    private int cellHeight;
    private Insets cellInsets = new Insets(1, 1, 1, 1);
    private Dimension size;
    private int labelsHeight;
    private CalendarModel dataModel;
    private ListSelectionModel selectionModel;
    private int fullHeight;
    private int fullWidth;
    private int RTLOffset;
    private boolean isLTR;
    private boolean drawLine;

    public CalendarComponent(CalendarModel calendarModel, ListSelectionModel listSelectionModel) {
        this(calendarModel, listSelectionModel, DEFAULT_CELL_WIDTH, DEFAULT_CELL_HEIGHT, DEFAULT_LABELS_HEIGHT, true);
    }

    public CalendarComponent(CalendarModel calendarModel, ListSelectionModel listSelectionModel, int n, int n2, int n3, boolean bl) {
        this.setDoubleBuffered(true);
        this.isLTR = UIUtils.getComponentOrientation().isLeftToRight();
        this.cellWidth = n;
        this.cellHeight = n2;
        this.labelsHeight = n3;
        this.drawLine = bl;
        this.initSize();
        if (listSelectionModel == null) {
            listSelectionModel = this.createDefaultSelectionModel();
        }
        this.setSelectionModel(listSelectionModel);
        if (calendarModel == null) {
            calendarModel = this.createDefaultDataModel();
        }
        this.setModel(calendarModel);
    }

    private void setModel(CalendarModel calendarModel) {
        if (calendarModel == null) {
            throw new IllegalArgumentException("Cannot set a null CalendarDataModel");
        }
        CalendarModel calendarModel2 = this.dataModel;
        if (calendarModel2 != calendarModel) {
            this.dataModel = calendarModel;
        }
        this.update();
    }

    public void update() {
        this.initCells();
        this.clearSelection();
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            this.selectionModel.addListSelectionListener(this);
            this.repaint();
        }
    }

    private CalendarModel createDefaultDataModel() {
        return new CalendarModel();
    }

    private ListSelectionModel createDefaultSelectionModel() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setSelectionMode(0);
        return defaultListSelectionModel;
    }

    private void initSize() {
        int n = (this.cellInsets.right + this.cellWidth + this.cellInsets.left) * 7 + 1;
        int n2 = this.labelsHeight + (this.cellInsets.top + this.cellHeight + this.cellInsets.bottom) * 6 + 1;
        this.size = new Dimension(n, n2);
        this.fullHeight = this.cellInsets.top + this.cellHeight + this.cellInsets.bottom;
        this.fullWidth = this.cellInsets.right + this.cellWidth + this.cellInsets.left;
        this.RTLOffset = this.size.width - this.cellInsets.right - this.cellWidth;
    }

    private void initCells() {
        int n = 0;
        int n2 = this.cellInsets.top + this.labelsHeight;
        for (int i = 0; i < this.dataModel.size(); ++i) {
            n = this.incDx(i, n, this.fullWidth);
            if (i / 7 == 0) {
                this.dataModel.getLabelCell(i).setBounds(n, 0, this.cellWidth, this.cellHeight);
            }
            if (i % 6 != 0 && i % 7 == 0) {
                n2 += this.fullHeight;
            }
            this.dataModel.getDayCell(i).setBounds(n, n2, this.cellWidth, this.cellHeight);
        }
    }

    private int incDx(int n, int n2, int n3) {
        n2 = n % 7 == 0 ? (this.isLTR ? this.cellInsets.right : this.RTLOffset) : (n2 += this.isLTR ? n3 : -n3);
        return n2;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public void paint(Graphics graphics) {
        graphics = UIUtils.enableAntialiasing(graphics);
        this.drawLabels(graphics);
        this.drawGrid(graphics);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, this.size.width, this.size.height);
    }

    private void drawLabels(Graphics graphics) {
        graphics.setColor(LABELS_BACKGROUND);
        graphics.fillRect(0, 0, this.size.width, this.labelsHeight);
        if (this.drawLine) {
            graphics.setColor(DAYLABELS_LINE_COLOR);
            graphics.drawLine(1, this.labelsHeight - 1, this.size.width - 2, this.labelsHeight - 1);
        }
        for (int i = 0; i < 7; ++i) {
            DayCell dayCell = this.dataModel.getLabelCell(i);
            this.drawString(graphics, dayCell.getText(), dayCell.getBounds(), dayCell.getForeground(), this.getTextFont(graphics, this.drawLine));
        }
    }

    private Font getTextFont(Graphics graphics, boolean bl) {
        Font font = graphics.getFont();
        Font font2 = bl ? new Font(font.getName(), 1, font.getSize()) : new Font(font.getName(), 0, font.getSize());
        return font2;
    }

    private void drawGrid(Graphics graphics) {
        graphics.setColor(CALENDAR_BACKGROUND);
        graphics.fillRect(0, this.labelsHeight, this.size.width, this.size.height);
        for (int i = 0; i < this.dataModel.size(); ++i) {
            this.drawCell(graphics, i);
        }
    }

    private void drawCell(Graphics graphics, int n) {
        DayCell dayCell = this.dataModel.getDayCell(n);
        Rectangle rectangle = dayCell.getBounds();
        if (dayCell.getTime() != null) {
            if (this.isTodayCell(dayCell)) {
                graphics.setColor(TODAY_DAY_FILL_COLOR);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(TODAY_DAY_BORDER_COLOR);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (this.isCellSelected(dayCell)) {
                graphics.setColor(SELECTED_DAY_COLOR);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.drawString(graphics, dayCell.getText(), dayCell.getBounds(), dayCell.getForeground(), this.getTextFont(graphics, dayCell.isBold()));
        }
    }

    private boolean isTodayCell(DayCell dayCell) {
        return GWCalendarUtils.isToday(dayCell.getTime());
    }

    private boolean isCellSelected(DayCell dayCell) {
        return this.selectionModel.isSelectedIndex(dayCell.getIndex());
    }

    private void drawString(Graphics graphics, String string, Rectangle rectangle, Color color, Font font) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        graphics.setFont(font);
        SwingUtilities.layoutCompoundLabel(fontMetrics, string, null, 0, 0, 0, 0, rectangle, rectangle3, rectangle2, 0);
        int n = rectangle2.x;
        int n2 = rectangle2.y + fontMetrics.getAscent();
        graphics.setColor(color);
        graphics.drawString(string, n, n2);
    }

    public void handleKey(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 38: {
                this.updateSelectedCell(-7, bl, bl2);
                break;
            }
            case 40: {
                this.updateSelectedCell(7, bl, bl2);
                break;
            }
            case 37: {
                int n2 = this.isLTR ? -1 : 1;
                this.updateSelectedCell(n2, bl, bl2);
                break;
            }
            case 39: {
                int n3 = this.isLTR ? 1 : -1;
                this.updateSelectedCell(n3, bl, bl2);
                break;
            }
            case 33: {
                this.navigate(-1, bl2);
                break;
            }
            case 34: {
                this.navigate(1, bl2);
            }
        }
    }

    private void updateSelectedCell(int n, boolean bl, boolean bl2) {
        int n2 = this.selectionModel.getLeadSelectionIndex();
        int n3 = this.dataModel.getFirstCell().getIndex();
        int n4 = this.dataModel.getLastCell().getIndex();
        GregorianCalendar gregorianCalendar = this.dataModel.getDate();
        int n5 = n2 + n;
        if (n5 >= n3 && n5 <= n4) {
            if (!bl) {
                this.clearSelection();
            }
            gregorianCalendar.add(5, n);
            this.dataModel.setDate(gregorianCalendar);
        } else {
            if (n5 < n3) {
                int n6 = n - n3 + n2;
                gregorianCalendar.set(5, gregorianCalendar.getActualMinimum(5));
                gregorianCalendar.add(5, n6);
            } else {
                int n7 = n4 - n - n2;
                gregorianCalendar.set(5, gregorianCalendar.getActualMaximum(5));
                gregorianCalendar.add(5, -n7);
            }
            if (bl2) {
                this.dataModel.setDate(gregorianCalendar);
            } else {
                this.dataModel.fireModelChenged(new CalendarEvent(GWCalendarUtils.getChangeMask(this.dataModel.getDate(), gregorianCalendar), gregorianCalendar));
            }
        }
    }

    public void handleClick(Point point, boolean bl) {
        DayCell dayCell = this.dataModel.getDayCell(point);
        if (dayCell == null) {
            return;
        }
        Date date = dayCell.getTime();
        if (date == null) {
            return;
        }
        if (!bl) {
            this.clearSelection();
        }
        GregorianCalendar gregorianCalendar = this.dataModel.getDate();
        gregorianCalendar.set(5, date.getDate());
        this.dataModel.setDate(gregorianCalendar);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl;
        int n = listSelectionEvent.getFirstIndex();
        int n2 = listSelectionEvent.getLastIndex();
        boolean bl2 = bl = this.selectionModel.isSelectionEmpty() && n == n2;
        if (bl) {
            return;
        }
        this.repaint();
    }

    public void navigate(int n, boolean bl) {
        GregorianCalendar gregorianCalendar = this.dataModel.getDate();
        switch (n) {
            case -1: {
                gregorianCalendar.add(2, -1);
                break;
            }
            case 1: {
                gregorianCalendar.add(2, 1);
                break;
            }
            case -2: {
                gregorianCalendar.add(1, -1);
                break;
            }
            case 2: {
                gregorianCalendar.add(1, 1);
            }
        }
        if (bl) {
            this.dataModel.setDate(gregorianCalendar);
        } else {
            this.dataModel.fireModelChenged(new CalendarEvent(GWCalendarUtils.getChangeMask(this.dataModel.getDate(), gregorianCalendar), gregorianCalendar));
        }
    }

    public void updateSelection() {
        DayCell dayCell = this.dataModel.getCurrentCell();
        if (dayCell != null) {
            int n = dayCell.getIndex();
            this.selectionModel.addSelectionInterval(n, n);
        }
    }

    public void gotoToday() {
        this.clearSelection();
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        this.dataModel.setDate(gregorianCalendar);
    }

    public CalendarModel getModel() {
        return this.dataModel;
    }
}

