/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DocumentChangeHandler;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.timepicker.MutableTextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class DateTextField
extends OrientableTextField
implements DateValueChangeListener,
MutableTextField {
    private static final Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DateTextField == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DateTextField = DateTextField.class$("com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateTextField")) : class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DateTextField));
    private DateFormat format;
    private GregorianCalendar calendar;
    private ArrayList listeners;
    private DocumentChangeHandler documentHandler;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DateTextField;

    public DateTextField(DateFormat dateFormat, DocumentChangeHandler documentChangeHandler) {
        this(dateFormat, documentChangeHandler, GWCalendarUtils.getToday());
    }

    public DateTextField(DateFormat dateFormat, DocumentChangeHandler documentChangeHandler, GregorianCalendar gregorianCalendar) {
        if (dateFormat == null) {
            throw new IllegalArgumentException("Date format can not be NULL");
        }
        if (documentChangeHandler == null) {
            throw new IllegalArgumentException("Document handler can not be NULL");
        }
        this.listeners = new ArrayList();
        this.format = dateFormat;
        this.documentHandler = documentChangeHandler;
        this.setDocument(new TextDocument());
        this.addFocusListener(new CommitFocusListener());
        this.addValueChangeListener(this);
        this.setDate(gregorianCalendar);
    }

    public void setDate(GregorianCalendar gregorianCalendar) {
        if (gregorianCalendar == null) {
            throw new IllegalArgumentException("Date can not be NULL");
        }
        if (this.calendar == null) {
            this.calendar = GWCalendarUtils.getToday();
        }
        if (!this.calendar.equals(gregorianCalendar)) {
            this.calendar.setTime(gregorianCalendar.getTime());
            this.fireValueChanged(new DateChangeEvent((GregorianCalendar)this.calendar.clone(), this));
        }
    }

    public void valueChanged(DateChangeEvent dateChangeEvent) {
        this.refreshText();
    }

    private void refreshText() {
        String string = this.format.format(this.calendar.getTime());
        this.setText(string);
    }

    private void handleFocusLost() {
        this.commit();
    }

    public void commit() {
        String string = this.getText();
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        try {
            gregorianCalendar.setTime(this.format.parse(string));
            this.setDate(gregorianCalendar);
        }
        catch (ParseException parseException) {
            try {
                gregorianCalendar.setTime(GWCalendarUtils.getDateFormatMMDD().parse(string));
                gregorianCalendar.set(1, GWCalendarUtils.getToday().get(1));
                this.setDate(gregorianCalendar);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        this.refreshText();
    }

    private void fireValueChanged(DateChangeEvent dateChangeEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            DateValueChangeListener dateValueChangeListener = (DateValueChangeListener)this.listeners.get(i);
            dateValueChangeListener.valueChanged(dateChangeEvent);
        }
    }

    public void addValueChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.listeners.add(dateValueChangeListener);
    }

    public void removeValueChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.listeners.remove(dateValueChangeListener);
    }

    protected boolean handleChange(String string) {
        if (this.documentHandler.canHandle(string)) {
            this.handleChange(this.documentHandler.getField(string), this.documentHandler.getShift(string));
            return true;
        }
        return false;
    }

    private void handleChange(int n, int n2) {
        this.unselectAll();
        this.commit();
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
        gregorianCalendar.add(n, n2);
        this.setDate(gregorianCalendar);
        this.selectAll();
    }

    protected boolean handleRemove(int n, int n2) {
        return false;
    }

    private void unselectAll() {
        this.setCaretPosition(0);
        this.moveCaretPosition(0);
    }

    public GregorianCalendar getDate() {
        return (GregorianCalendar)this.calendar.clone();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TextDocument
    extends PlainDocument {
        private TextDocument() {
        }

        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (!DateTextField.this.handleChange(string)) {
                super.replace(n, n2, string, attributeSet);
            }
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (!DateTextField.this.handleRemove(n, n2)) {
                super.remove(n, n2);
            }
        }
    }

    private class CommitFocusListener
    extends FocusAdapter {
        private CommitFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            DateTextField.this.handleFocusLost();
        }
    }
}

