/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationFormat;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationToken;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationTimeFormat
implements DurationFormat {
    public String format(TimeDuration timeDuration) {
        int n = timeDuration.getDays();
        int n2 = timeDuration.getHours();
        int n3 = timeDuration.getMinutes();
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            stringBuffer.append(n);
            stringBuffer.append(" ");
            stringBuffer.append(n == 1 ? StringResources.DAY : StringResources.DAYS);
        }
        if (n2 > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(n2);
            stringBuffer.append(" ");
            stringBuffer.append(n2 == 1 ? StringResources.HOUR : StringResources.HOURS);
        }
        if (n3 > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(n3);
            stringBuffer.append(" ");
            stringBuffer.append(n3 == 1 ? StringResources.MINUTE : StringResources.MINUTES);
        }
        return stringBuffer.toString();
    }

    public TimeDuration parse(int n, String string) throws ParseException {
        DurationToken[] durationTokenArray;
        Pattern pattern = Pattern.compile("(\\d{1,}\\.\\d{1,})|(\\d{1,}\\.)|(\\d{1,})|(\\.\\d{1,})");
        Matcher matcher = pattern.matcher(string);
        ArrayList<DurationToken> arrayList = new ArrayList<DurationToken>();
        while (matcher.find()) {
            durationTokenArray = matcher.group();
            int n2 = matcher.start();
            int n3 = matcher.end();
            DurationToken durationToken = new DurationToken((String)durationTokenArray, n2, n3);
            arrayList.add(durationToken);
        }
        if (arrayList.size() == 0) {
            throw new ParseException("No duration founded", 0);
        }
        durationTokenArray = new DurationToken[arrayList.size()];
        arrayList.toArray(durationTokenArray);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < durationTokenArray.length; ++i) {
            DurationToken durationToken = durationTokenArray[i];
            double d4 = 0.0;
            try {
                d4 = Double.parseDouble(durationToken.getDigits());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Duration is out of range", 0);
            }
            int n4 = durationToken.getEnd();
            String string2 = string.substring(n4, string.length()).trim().toLowerCase();
            if (string2.startsWith(StringResources.DAYS_FIRST_CHARS_LOWER_CASE)) {
                d += d4;
                continue;
            }
            if (string2.startsWith(StringResources.HOURS_FIRST_CHARS_LOWER_CASE)) {
                d2 += d4;
                continue;
            }
            if (string2.startsWith(StringResources.MINUTES_FIRST_CHARS_LOWER_CASE)) {
                d3 += d4;
                continue;
            }
            if (d4 < 10.0) {
                d2 += d4;
                continue;
            }
            d3 += d4;
        }
        double d5 = 0.0;
        if (d > 0.0) {
            d5 = d * 1440.0;
        }
        if (d2 > 0.0) {
            d5 += d2 * 60.0;
        }
        if (d3 > 0.0) {
            d5 += d3;
        }
        if (d5 > 0.0) {
            return new TimeDuration(n, n + (int)d5);
        }
        throw new ParseException("Can not parse duration", 0);
    }
}

