/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview;

import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.Glass;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.GlassPanelLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class AppointmentsGlassPanel
extends JLayeredPane {
    private JPanel panel;
    private Glass glass;
    private GlassPanelMouseHandler mouseHandler;

    public AppointmentsGlassPanel(JPanel jPanel) {
        this.panel = jPanel;
        this.setLayout(new GlassPanelLayout());
        this.add((Component)this.panel, "Center");
        this.setLayer(this.panel, JLayeredPane.DEFAULT_LAYER, 0);
        this.glass = new Glass();
        this.add((Component)this.glass, "Glass");
        this.setLayer(this.glass, JLayeredPane.MODAL_LAYER, 0);
        this.mouseHandler = new GlassPanelMouseHandler(this.panel);
        this.glass.addMouseListener(this.mouseHandler);
        this.glass.addMouseMotionListener(this.mouseHandler);
    }

    private ActiveItemLabel getPanel(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint(this.glass, mouseEvent.getPoint(), this.panel);
        if (this.panel instanceof AppointmentPanel) {
            Component component = this.panel.getComponentAt(point);
            if (component instanceof ActiveItemLabel) {
                return (ActiveItemLabel)component;
            }
        } else {
            Point point2;
            Component component;
            Component component2 = this.panel.getComponentAt(point);
            if (component2 instanceof AppointmentPanel && (component = component2.getComponentAt(point2 = SwingUtilities.convertPoint(this.panel, point, component2))) instanceof ActiveItemLabel) {
                return (ActiveItemLabel)component;
            }
        }
        return null;
    }

    private void redispatch(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint(this.glass, mouseEvent.getPoint(), this.panel);
        if (this.panel instanceof AppointmentPanel) {
            this.panel.dispatchEvent(new MouseEvent(this.panel, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        } else {
            Component component = this.panel.getComponentAt(point);
            if (component instanceof AppointmentPanel) {
                component.dispatchEvent(new MouseEvent(this.panel, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
            }
        }
    }

    private class GlassPanelMouseHandler
    implements MouseListener,
    MouseMotionListener {
        private ActiveItemLabel label;
        private ActiveItemLabel oldlabel;
        private LabelDragHandler listener;

        public GlassPanelMouseHandler(JPanel jPanel) {
            this.listener = new LabelDragHandler(jPanel);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AppointmentsGlassPanel.this.redispatch(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AppointmentsGlassPanel.this.redispatch(mouseEvent);
        }

        private void disposeDragLabel() {
            if (this.label != null) {
                AppointmentsGlassPanel.this.glass.remove(this.label);
                AppointmentsGlassPanel.this.glass.repaint();
                this.listener.setOriginalLabel(null);
                this.label.removeMouseListener(this.listener);
                this.label.removeMouseMotionListener(this.listener);
                this.label = null;
                this.oldlabel = null;
            }
        }

        private void createDragLabel() {
            if (this.oldlabel != null) {
                this.label = new ActiveItemLabel(true, this.oldlabel.getItem(), AppointmentsGlassPanel.this.getBackground(), this.oldlabel.getController(), false);
                this.label.setBorder(new LineBorder(Color.BLACK, 1));
                this.label.setSize(this.oldlabel.getWidth(), this.oldlabel.getHeight());
                this.listener.setOriginalLabel(this.oldlabel);
                this.label.addMouseListener(this.listener);
                this.label.addMouseMotionListener(this.listener);
                Point point = this.oldlabel.getLocation();
                SwingUtilities.convertPointToScreen(point, this.oldlabel.getParent());
                SwingUtilities.convertPointFromScreen(point, AppointmentsGlassPanel.this.glass);
                AppointmentsGlassPanel.this.glass.add((Component)this.label, point);
                AppointmentsGlassPanel.this.glass.revalidate();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            AppointmentsGlassPanel.this.redispatch(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ActiveItemLabel activeItemLabel = AppointmentsGlassPanel.this.getPanel(mouseEvent);
            if (activeItemLabel != this.oldlabel) {
                this.disposeDragLabel();
                this.oldlabel = activeItemLabel;
                this.createDragLabel();
            }
            AppointmentsGlassPanel.this.redispatch(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            AppointmentsGlassPanel.this.redispatch(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AppointmentsGlassPanel.this.redispatch(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AppointmentsGlassPanel.this.redispatch(mouseEvent);
        }
    }

    private class LabelDragHandler
    implements MouseListener,
    MouseMotionListener {
        private Point pointPressed = null;
        private JPanel panel;
        private ActiveItemLabel original;
        private boolean wasPopupTrigger;
        private boolean dragStarted;

        public LabelDragHandler(JPanel jPanel) {
            this.panel = jPanel;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.wasPopupTrigger = true;
                return;
            }
            this.ensurePopupClosed(mouseEvent.getSource());
            this.wasPopupTrigger = false;
            this.pointPressed = mouseEvent.getPoint();
            this.dragStarted = true;
        }

        private void ensurePopupClosed(Object object) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.setSize(0, 0);
            jPopupMenu.show((Component)object, 0, 0);
            jPopupMenu.setVisible(false);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.wasPopupTrigger) {
                this.wasPopupTrigger = false;
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                this.wasPopupTrigger = true;
                return;
            }
            this.ensurePopupClosed(mouseEvent.getSource());
            this.pointPressed = null;
            this.original.setVisible(true);
            this.dragStarted = true;
        }

        public void setOriginalLabel(ActiveItemLabel activeItemLabel) {
            this.original = activeItemLabel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = this.pointPressed;
            synchronized (point) {
                if (this.pointPressed == null) {
                    return;
                }
                if (this.dragStarted) {
                    this.original.setVisible(false);
                    this.dragStarted = false;
                }
                this.original.setVisible(false);
                ActiveItemLabel activeItemLabel = (ActiveItemLabel)mouseEvent.getSource();
                Point point2 = activeItemLabel.getLocation();
                Point point3 = mouseEvent.getPoint();
                point3.translate(point2.x, point2.y);
                point3.translate(-this.pointPressed.x, -this.pointPressed.y);
                if (point3.x < 0) {
                    point3.x = 0;
                }
                if (point3.x + activeItemLabel.getWidth() > this.panel.getWidth()) {
                    point3.x = this.panel.getWidth() - activeItemLabel.getWidth();
                }
                if (point3.y < 0) {
                    point3.y = 0;
                }
                if (point3.y + activeItemLabel.getHeight() > this.panel.getHeight()) {
                    point3.y = this.panel.getHeight() - activeItemLabel.getHeight();
                }
                Rectangle rectangle = activeItemLabel.getBounds();
                rectangle.setLocation(point3);
                AppointmentsGlassPanel.this.scrollRectToVisible(rectangle);
                activeItemLabel.setLocation(point3);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

