/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarScrollPane;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ActiveHourLabelsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.HourLabelsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.CalendarBoxesPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.DayHeaderPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.WeeklyViewController;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class WeeklyView
extends CalendarView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$weekly$weeklyview$WeeklyView == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$weekly$weeklyview$WeeklyView = WeeklyView.class$("com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.WeeklyView")) : class$com$novell$gw$jclient$application$controls$gwcalendar$weekly$weeklyview$WeeklyView));
    private int daysCount;
    private boolean isVertSplitVisible;
    private JSplitPane spltAppointments;
    private JSplitPane spltTaskNotes;
    private CalendarBoxesPanel tasksBoxesPanel;
    private CalendarBoxesPanel notesBoxesPanel;
    private CalendarBoxesPanel allDayEventsBoxesPanel;
    private JPanel allAppointmentsPanel;
    private JScrollPane scrollAppointments;
    private JComponent compNotes;
    private JComponent compTasks;
    private DayHeaderPanel dayLabels;
    private GregorianCalendar startDay;
    private AppointmentsPanel appointmentsPanel;
    private static final int ALL_DAY_ITEMS_PANEL_HEIGHT = 60;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$weekly$weeklyview$WeeklyView;

    public WeeklyView(GregorianCalendar gregorianCalendar, TypesToggle typesToggle, MVCController mVCController) {
        super(gregorianCalendar, typesToggle, mVCController);
    }

    protected MVCController createController(MVCController mVCController) {
        return new WeeklyViewController(this, mVCController);
    }

    protected void buildUI() {
        super.buildUI();
        this.setFocusable(false);
        this.daysCount = 7;
        this.compNotes = this.buildNotesPanel();
        this.compTasks = this.buildTasksPanel();
        this.spltTaskNotes = new GWSplitPane(0, this.compNotes, this.compTasks);
        this.spltTaskNotes.setOneTouchExpandable(false);
        this.spltTaskNotes.setResizeWeight(0.5);
        this.spltTaskNotes.setBorder(BorderFactory.createEmptyBorder());
        this.spltTaskNotes.addPropertyChangeListener(new DividerPositionListener("CALENDAR_WEEKLY_TASKNOTES_SPLITPOS" + this.optionFrameName, this.spltTaskNotes));
        this.buildAppointmentsPanel();
        this.spltAppointments = new GWSplitPane(0, this.allAppointmentsPanel, this.spltTaskNotes);
        this.spltAppointments.setOneTouchExpandable(false);
        this.spltAppointments.setResizeWeight(0.5);
        this.spltAppointments.setBorder(BorderFactory.createEmptyBorder());
        this.spltAppointments.addPropertyChangeListener(new DividerPositionListener("CALENDAR_WEEKLY_APPOINTMENTS_SPLITPOS" + this.optionFrameName, this.spltAppointments));
        this.add((Component)this.buildDaysLabelPanel(), "North");
        this.add((Component)this.spltAppointments, "Center");
        this.appointmentsPanel.scrollRectToVisible(this.appointmentsPanel.getWorkTimeRectangle());
        this.adjustView();
    }

    private void buildAppointmentsPanel() {
        this.appointmentsPanel = new AppointmentsPanel(this.daysCount, this.getController(), this.getCurrentDate());
        this.appointmentsPanel.setBorder(BorderFactory.createEmptyBorder());
        ActiveHourLabelsPanel activeHourLabelsPanel = new ActiveHourLabelsPanel(BorderFactory.createMatteBorder(1, 1, 1, 0, ColorConstants.HEADER_BORDER_COLOR), this.getController());
        activeHourLabelsPanel.setBorder(BorderFactory.createEmptyBorder());
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.setBorder(BorderFactory.createEmptyBorder());
        orientablePanel.add((Component)activeHourLabelsPanel, "Before");
        orientablePanel.add((Component)this.appointmentsPanel, "Center");
        this.scrollAppointments = new CalendarScrollPane(orientablePanel, 22, 31);
        this.scrollAppointments.setBorder(BorderFactory.createEmptyBorder());
        this.allAppointmentsPanel = new JPanel(new BorderLayout());
        this.allAppointmentsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.allAppointmentsPanel.add((Component)this.buildAllDayPanel(), "North");
        this.allAppointmentsPanel.add((Component)this.scrollAppointments, "Center");
    }

    private JComponent buildNotesPanel() {
        this.notesBoxesPanel = new CalendarBoxesPanel(this.getController(), "Note", this.daysCount, true);
        this.notesBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        return CalendarUtils.createLeftCaptionAndScrollPane(this.notesBoxesPanel, ImageResources.ITM_NOTE_LARGE);
    }

    private JComponent buildTasksPanel() {
        this.tasksBoxesPanel = new CalendarBoxesPanel(this.getController(), "Task", this.daysCount, true);
        this.tasksBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        return CalendarUtils.createLeftCaptionAndScrollPane(this.tasksBoxesPanel, ImageResources.ITM_TASK_LARGE);
    }

    private JComponent buildAllDayPanel() {
        this.allDayEventsBoxesPanel = new CalendarBoxesPanel(this.getController(), "AllDayEvent", this.daysCount, true);
        this.allDayEventsBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        JComponent jComponent = CalendarUtils.createLeftCaptionAndScrollPane(this.allDayEventsBoxesPanel, ImageResources.ITM_ALL_DAY_EVENT_LARGE, BorderFactory.createMatteBorder(1, 0, 1, 0, ColorConstants.HEADER_BORDER_COLOR));
        jComponent.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, jComponent.getBackground()));
        jComponent.setPreferredSize(new Dimension(0, 60));
        return jComponent;
    }

    private JPanel buildDaysLabelPanel() {
        this.dayLabels = new DayHeaderPanel(this.daysCount);
        this.dayLabels.setBorder(BorderFactory.createEmptyBorder());
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.setBorder(BorderFactory.createEmptyBorder());
        orientablePanel.add((Component)this.dayLabels, "Center");
        JLabel jLabel = new JLabel(" ");
        jLabel.setBorder(BorderFactory.createEmptyBorder());
        int n = HourLabelsPanel.getPanelWidth();
        int n2 = (Integer)UIManager.get("ScrollBar.width");
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            orientablePanel.setBorder(BorderFactory.createEmptyBorder(0, n2, 0, n));
        } else {
            orientablePanel.setBorder(BorderFactory.createEmptyBorder(0, n, 0, n2));
        }
        return orientablePanel;
    }

    protected int getViewType() {
        return 1;
    }

    protected void prepareRefresh(boolean bl) {
        logger.debug((Object)"prepareRefresh entered");
        if (this.isNeedRefresh()) {
            this.refreshStartDay();
        }
        this.dayLabels.setTitles(this.startDay.getTime(), this.getCurrentDate());
        logger.debug((Object)"prepareRefresh exited");
    }

    private void refreshStartDay() {
        logger.debug((Object)"refreshStartDay entered");
        this.startDay = GWCalendarUtils.getDateForDayOfWeek(this.currentDay, 1);
        this.startDay.set(11, 0);
        this.startDay.set(12, 0);
        this.startDay.set(13, 0);
        this.startDay.set(14, 0);
        this.refreshedInterval = new TimeInterval(this.startDay.getTime(), this.getEndDay().getTime());
        this.startDay.set(11, 12);
        if (!this.refreshedInterval.contains(this.getCurrentDate())) {
            this.startDay = (GregorianCalendar)this.currentDay.clone();
            this.startDay.set(11, 0);
            this.startDay.set(12, 0);
            this.startDay.set(13, 0);
            this.startDay.set(14, 0);
            this.refreshedInterval = new TimeInterval(this.startDay.getTime(), this.getEndDay().getTime());
            this.startDay.set(11, 12);
        }
        logger.debug((Object)"refreshStartDay exited");
    }

    protected void refreshTasks(ItemList itemList, TimeInterval timeInterval) {
        this.tasksBoxesPanel.loadItemsForDate(this.startDay, itemList, timeInterval);
    }

    protected void refreshNotes(ItemList itemList, TimeInterval timeInterval) {
        this.notesBoxesPanel.loadItemsForDate(this.startDay, itemList, timeInterval);
    }

    protected void refreshAppointments(ItemList itemList, TimeInterval timeInterval) {
        this.appointmentsPanel.loadItemsForDate(this.startDay, itemList, timeInterval);
    }

    protected void refreshAllDayEvents(ItemList itemList, TimeInterval timeInterval) {
        this.allDayEventsBoxesPanel.loadItemsForDate(this.startDay, itemList, timeInterval);
    }

    private GregorianCalendar getEndDay() {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.startDay.clone();
        gregorianCalendar.add(5, this.daysCount - 1);
        gregorianCalendar.set(11, 23);
        gregorianCalendar.set(12, 59);
        gregorianCalendar.set(13, 59);
        gregorianCalendar.set(14, 999);
        return gregorianCalendar;
    }

    private void adjustView() {
        if (!this.typesToggle.isShowAppointments()) {
            this.spltAppointments.remove(this.allAppointmentsPanel);
        }
        if (!this.typesToggle.isShowNotes()) {
            this.spltTaskNotes.remove(this.compNotes);
        }
        if (!this.typesToggle.isShowTasks()) {
            this.spltTaskNotes.remove(this.compTasks);
        }
        if (!this.typesToggle.isShowNotes() && !this.typesToggle.isShowTasks()) {
            this.spltAppointments.remove(this.spltTaskNotes);
            this.isVertSplitVisible = false;
        } else {
            this.isVertSplitVisible = true;
        }
        this.adjustSplitters();
    }

    private void adjustSplitters() {
        int n = ApplicationOptions.getInstance().getInteger("CALENDAR_WEEKLY_APPOINTMENTS_SPLITPOS" + this.optionFrameName, -1);
        this.spltAppointments.setDividerLocation(n);
        n = ApplicationOptions.getInstance().getInteger("CALENDAR_WEEKLY_TASKNOTES_SPLITPOS" + this.optionFrameName, -1);
        this.spltTaskNotes.setDividerLocation(n);
    }

    protected void adjustTasks() {
        if (this.typesToggle.isShowTasks()) {
            if (!this.isVertSplitVisible) {
                this.spltAppointments.add(this.spltTaskNotes);
                this.isVertSplitVisible = true;
            }
            this.spltTaskNotes.add(this.compTasks);
        } else {
            this.spltTaskNotes.remove(this.compTasks);
            if (!this.typesToggle.isShowNotes()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        }
        this.adjustSplitters();
    }

    protected void adjustNotes() {
        if (this.typesToggle.isShowNotes()) {
            if (!this.isVertSplitVisible) {
                this.spltAppointments.add(this.spltTaskNotes);
                this.isVertSplitVisible = true;
            }
            if (this.typesToggle.isShowTasks()) {
                this.spltTaskNotes.remove(this.compTasks);
                this.spltTaskNotes.add(this.compNotes);
                this.spltTaskNotes.add(this.compTasks);
            } else {
                this.spltTaskNotes.add(this.compNotes);
            }
        } else {
            this.spltTaskNotes.remove(this.compNotes);
            if (!this.typesToggle.isShowTasks()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        }
        this.adjustSplitters();
    }

    protected void adjustAppointments() {
        if (this.typesToggle.isShowAppointments()) {
            this.spltAppointments.add(this.allAppointmentsPanel);
            if (!this.typesToggle.isShowTasks() && !this.typesToggle.isShowNotes()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        } else {
            this.spltAppointments.remove(this.allAppointmentsPanel);
        }
        this.adjustSplitters();
    }

    public void setMVCModel(Object object) {
        super.setMVCModel(object);
        if (object instanceof Integer) {
            Serializable serializable;
            int n = (Integer)object;
            if (n == 1) {
                this.dayLabels.addLabel();
                this.dayLabels.setTitles(this.startDay.getTime(), this.getCurrentDate());
                this.appointmentsPanel.addBox(this.getItemList());
                ++this.daysCount;
                serializable = GWCalendarUtils.getTasks(this.getItemList(), this.getEndDay().getTime());
                this.tasksBoxesPanel.addBoxAndLoadData(this.getEndDay(), (IDObjectsCollection)serializable);
                serializable = GWCalendarUtils.getNotes(this.getItemList(), this.getEndDay().getTime());
                this.notesBoxesPanel.addBoxAndLoadData(this.getEndDay(), (IDObjectsCollection)serializable);
                serializable = GWCalendarUtils.getAllDayEvents(this.getItemList(), this.getEndDay().getTime());
                this.allDayEventsBoxesPanel.addBoxAndLoadData(this.getEndDay(), (IDObjectsCollection)serializable);
            } else if (n == -1 && this.daysCount > 1) {
                --this.daysCount;
                this.dayLabels.removeLabel();
                this.appointmentsPanel.removeBox();
                this.tasksBoxesPanel.removeBox();
                this.notesBoxesPanel.removeBox();
                this.allDayEventsBoxesPanel.removeBox();
            }
            serializable = this.getEndDay();
            this.refreshedInterval = new TimeInterval(this.startDay.getTime(), ((Calendar)serializable).getTime());
            if (!this.refreshedInterval.contains(this.getCurrentDate())) {
                ((Calendar)serializable).set(11, this.currentDay.get(11));
                ((Calendar)serializable).set(12, this.currentDay.get(12));
                Command command = new Command(70, ((Calendar)serializable).getTime());
                this.getController().processCommand(command);
            }
            this.validate();
            this.repaint();
        }
    }

    protected void adjustClock() {
        if (this.typesToggle.isShowAppointments()) {
            this.appointmentsPanel.adjustClock();
        }
    }

    protected void adjustCurrentDay() {
        if (this.refreshedInterval.contains(this.getCurrentDate())) {
            this.dayLabels.setTitles(this.startDay.getTime(), this.getCurrentDate());
            this.needRefresh(false);
        } else {
            this.needRefresh(true);
            this.refresh(false);
        }
    }

    public void requestFocus() {
        this.appointmentsPanel.requestFocus();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

