/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar;

import com.appframework.mvc.Command;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarComponent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.CommandListener;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.StaticCalendarModel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.ListSelectionModel;

public class StaticMonthlyCalendar
extends MonthlyCalendar {
    private static final int YEARLY_CELL_WIDTH = PLAFChanger.getFontSize() * 2 - 6;
    private static final int YEARLY_CELL_HEIGHT = PLAFChanger.getFontSize() + 2;
    private static final int YEARLY_LABELS_HEIGHT = PLAFChanger.getFontSize() + 4;
    private static final int YEARLY_HEADER_HEIGHT = PLAFChanger.getFontSize() + 8;
    private static final int YEARLY_FOOTER_HEIGHT = 0;
    private ArrayList commandListeners = new ArrayList();

    public StaticMonthlyCalendar(CalendarModel calendarModel, ListSelectionModel listSelectionModel) {
        super(calendarModel, listSelectionModel, false, YEARLY_HEADER_HEIGHT, 0);
    }

    protected void createCalendar(CalendarModel calendarModel, ListSelectionModel listSelectionModel) {
        this.calendar = new CalendarComponent(calendarModel, listSelectionModel, YEARLY_CELL_WIDTH, YEARLY_CELL_HEIGHT, YEARLY_LABELS_HEIGHT, false);
    }

    public void modelChanged(CalendarEvent calendarEvent) {
        this.fireValueChanged(new DateChangeEvent(calendarEvent.getDate(), this));
    }

    protected void handleClick(Point point, boolean bl, boolean bl2) {
        super.handleClick(point, bl, bl2);
        if (bl2) {
            Command command = new Command(190, this.getDate().getTime());
            this.fireCommand(command);
        }
    }

    private void fireCommand(Command command) {
        for (int i = 0; i < this.commandListeners.size(); ++i) {
            CommandListener commandListener = (CommandListener)this.commandListeners.get(i);
            commandListener.perform(command);
        }
    }

    public void addCommandListener(CommandListener commandListener) {
        this.commandListeners.add(commandListener);
    }

    public void removeCommandListener(CommandListener commandListener) {
        this.commandListeners.remove(commandListener);
    }

    public void clearSelection() {
        this.calendar.clearSelection();
    }

    public void updateSelection() {
        this.calendar.updateSelection();
    }

    public void validateBusyDays(AbstractFolder abstractFolder) {
        ((StaticCalendarModel)this.calendar.getModel()).validateBusyDays(abstractFolder);
        this.calendar.repaint();
    }

    public void requestFocus() {
        super.requestFocus();
    }
}

