/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.CommandListener;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.StaticCalendarModel;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.StaticMonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.YearlyCalendarLayout;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.DefaultListSelectionModel;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class YearlyCalendar
extends JComponent
implements DateValueChangeListener,
CommandListener {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$yearlycalendar$YearlyCalendar == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$yearlycalendar$YearlyCalendar = YearlyCalendar.class$("com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.YearlyCalendar")) : class$com$novell$gw$jclient$application$controls$gwcalendar$yearlycalendar$YearlyCalendar));
    private static final int MAX_ROWS = 4;
    private static final int MAX_COLS = 4;
    private static final int MONTH_COUNT = 12;
    private StaticMonthlyCalendar[] monthes;
    private GregorianCalendar current;
    private boolean allowMultipleSelect;
    private YearlyCalendarLayout layout;
    private Dimension size;
    private ArrayList visibleMonthes;
    private ArrayList listeners;
    private MVCController controller;
    private boolean isInDaylyView;
    private boolean first;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$yearlycalendar$YearlyCalendar;

    public YearlyCalendar(GregorianCalendar gregorianCalendar, boolean bl, MVCController mVCController, boolean bl2) {
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.current = (GregorianCalendar)gregorianCalendar.clone();
        this.allowMultipleSelect = bl;
        this.monthes = new StaticMonthlyCalendar[12];
        this.visibleMonthes = new ArrayList();
        this.listeners = new ArrayList();
        this.controller = mVCController;
        this.isInDaylyView = bl2;
        this.build();
        this.setCurrentDateToMonth();
        if (bl2) {
            GregorianCalendar gregorianCalendar2 = (GregorianCalendar)this.current.clone();
            gregorianCalendar2.add(2, 5);
        }
    }

    protected void build() {
        this.layout = new YearlyCalendarLayout();
        this.layout.setHgap(5);
        this.layout.setVgap(5);
        this.setLayout(this.layout);
        this.initMonthes();
        this.refreshFocusableMonthes();
        this.addComponentListener(new ResizeListener());
    }

    private void initMonthes() {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.current.clone();
        gregorianCalendar.set(2, 0);
        for (int i = 0; i < 12; ++i) {
            DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
            defaultListSelectionModel.setSelectionMode(this.allowMultipleSelect ? 2 : 0);
            String string = ControlsUtils.getUserGuid(this.controller);
            StaticCalendarModel staticCalendarModel = new StaticCalendarModel((GregorianCalendar)gregorianCalendar.clone(), string);
            this.monthes[i] = new StaticMonthlyCalendar(staticCalendarModel, defaultListSelectionModel);
            this.monthes[i].addValueChangeListener(this);
            this.monthes[i].addCommandListener(this);
            this.monthes[i].setFocusable(false);
            gregorianCalendar.add(2, 1);
        }
        this.size = this.monthes[0].getPreferredSize();
    }

    private void handleResize(boolean bl) {
        int n;
        int n2;
        boolean bl2 = this.getSelectedMonth().isFocusOwner();
        Insets insets = this.getInsets();
        int n3 = this.calculateVisibleCols(this.getWidth() - insets.left - insets.right);
        int n4 = this.calculateVisibleRows(this.getHeight() - insets.top - insets.bottom);
        if (n3 == 4 && n4 == 4) {
            n4 = 3;
        }
        if (!bl && this.layout.getColumns() == n3 && this.layout.getRows() == n4) {
            return;
        }
        logger.debug((Object)"handleResize entered");
        this.layout.setColumns(n3);
        this.layout.setRows(n4);
        this.removeMonthes();
        int n5 = n3 * n4;
        int n6 = this.getSelectedMonthIndex();
        if (n6 <= 12 - n5) {
            n2 = n6;
            n = n6 + n5;
        } else {
            n2 = 12 - n5;
            n = 12;
        }
        if (!this.isInDaylyView || !this.first) {
            // empty if block
        }
        for (int i = n2; i < n; ++i) {
            this.addMonth(this.monthes[i]);
        }
        this.validate();
        this.repaint();
        if (bl2) {
            this.getSelectedMonth().requestFocus();
        }
        logger.debug((Object)"handleResize exited");
    }

    private void removeMonthes() {
        this.visibleMonthes.clear();
        this.removeAll();
    }

    private void addMonth(StaticMonthlyCalendar staticMonthlyCalendar) {
        this.visibleMonthes.add(staticMonthlyCalendar);
        this.add(staticMonthlyCalendar);
    }

    public StaticMonthlyCalendar getSelectedMonth() {
        return this.monthes[this.getSelectedMonthIndex()];
    }

    private int getSelectedMonthIndex() {
        return this.current.get(2);
    }

    private int calculateVisibleRows(int n) {
        return Math.max(Math.min(n / (this.size.height + 5), 4), 1);
    }

    private int calculateVisibleCols(int n) {
        return Math.max(Math.min(n / (this.size.width + 5), 4), 1);
    }

    public void valueChanged(DateChangeEvent dateChangeEvent) {
        this.setCurrentDate(dateChangeEvent.getDate());
    }

    public GregorianCalendar getCurrentDate() {
        return this.current;
    }

    private void refreshFocusableMonthes() {
        for (int i = 0; i < this.monthes.length; ++i) {
            StaticMonthlyCalendar staticMonthlyCalendar;
            staticMonthlyCalendar.setFocusable((staticMonthlyCalendar = this.monthes[i]) == this.getSelectedMonth());
        }
    }

    public void setCurrentDate(GregorianCalendar gregorianCalendar) {
        int n = GWCalendarUtils.getChangeMask(this.current, gregorianCalendar);
        if (n == 0) {
            return;
        }
        this.current.setTime(gregorianCalendar.getTime());
        if ((n & 4) != 0) {
            this.initMonthes();
            this.handleResize(true);
        }
        StaticMonthlyCalendar staticMonthlyCalendar = this.getSelectedMonth();
        if ((n & 2) != 0) {
            this.clear();
            if (!this.isMonthVisible(staticMonthlyCalendar)) {
                this.handleResize(true);
            }
        }
        this.setCurrentDateToMonth();
        this.fireValueChanged(new DateChangeEvent(gregorianCalendar, this));
    }

    private void setCurrentDateToMonth() {
        StaticMonthlyCalendar staticMonthlyCalendar = this.getSelectedMonth();
        staticMonthlyCalendar.setDate(this.current);
        this.refreshFocusableMonthes();
        staticMonthlyCalendar.updateSelection();
        Component component = FocusManager.getCurrentManager().getPermanentFocusOwner();
        if (this.isShowing() && (component == null || SwingUtilities.isDescendingFrom(component, this))) {
            staticMonthlyCalendar.requestFocus();
        }
    }

    protected void fireValueChanged(DateChangeEvent dateChangeEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            DateValueChangeListener dateValueChangeListener = (DateValueChangeListener)this.listeners.get(i);
            dateValueChangeListener.valueChanged(dateChangeEvent);
        }
    }

    public void addValueChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.listeners.add(dateValueChangeListener);
    }

    public void removeValueChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.listeners.remove(dateValueChangeListener);
    }

    private void clear() {
        StaticMonthlyCalendar staticMonthlyCalendar = this.getSelectedMonth();
        for (int i = 0; i < this.monthes.length; ++i) {
            StaticMonthlyCalendar staticMonthlyCalendar2 = this.monthes[i];
            if (staticMonthlyCalendar2 == staticMonthlyCalendar) continue;
            staticMonthlyCalendar2.clearSelection();
            staticMonthlyCalendar2.repaint();
        }
    }

    public boolean isMonthVisible(StaticMonthlyCalendar staticMonthlyCalendar) {
        return this.visibleMonthes.contains(staticMonthlyCalendar);
    }

    public void perform(Command command) {
        this.controller.processCommand(command);
    }

    public void validateBusyDays(AbstractFolder abstractFolder) {
        logger.debug((Object)"validateBusyDays entered");
        for (int i = 0; i < this.monthes.length; ++i) {
            StaticMonthlyCalendar staticMonthlyCalendar = this.monthes[i];
            staticMonthlyCalendar.validateBusyDays(abstractFolder);
        }
        logger.debug((Object)"validateBusyDays exited");
    }

    public void requestFocus() {
        this.getSelectedMonth().requestFocus();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            YearlyCalendar.this.handleResize(false);
        }
    }
}

