/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.header;

import com.appframework.event.AppEvent;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.header.HeaderPanelController;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class HeaderPanel
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$header$HeaderPanel == null ? (class$com$novell$gw$jclient$application$controls$header$HeaderPanel = HeaderPanel.class$("com.novell.gw.jclient.application.controls.header.HeaderPanel")) : class$com$novell$gw$jclient$application$controls$header$HeaderPanel));
    public static final Color DEFAULT_HEADER_BACKGROUND_COLOR = new Color(128, 128, 128);
    public static final Color DEFAULT_HEADER_TEXT_COLOR = Color.white;
    public static final Boolean DEFAULT_HEADER_ALIGNED = Boolean.TRUE;
    private JPanel pnlContent;
    private Color background;
    private Color foreground;
    private String textSize;
    private HeaderPanelController controller;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$header$HeaderPanel;

    public HeaderPanel(JPanel jPanel, MVCController mVCController) {
        EnvironmentOptions environmentOptions = OptionManager.getInstance().getEnvironmentOptions();
        this.background = environmentOptions.getHeaderBkColor();
        this.foreground = environmentOptions.getHeaderTextColor();
        this.textSize = environmentOptions.getHeaderTextSize();
        this.controller = new HeaderPanelController(this, mVCController);
        this.pnlContent = jPanel;
        this.setLayout(new BorderLayout());
        this.initComponent(this.pnlContent);
        super.add((Component)this.pnlContent, "Center");
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
    }

    private void initComponent(JComponent jComponent) {
        jComponent.setBackground(this.background);
        jComponent.setForeground(this.foreground);
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            this.initComponent(jComponent.getComponent(i));
        }
    }

    public static HeaderPanel createInstanceWithBoxLayout(JPanel jPanel, MVCController mVCController) {
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        return new HeaderPanel(jPanel, mVCController);
    }

    public static HeaderPanel createOGBPanel(MVCController mVCController) {
        return new HeaderPanel(new OrientablePanel(new GridBagLayout()), mVCController);
    }

    public Component add(Component component) {
        this.initComponent(component);
        return this.pnlContent.add(component);
    }

    public void add(Component component, Object object) {
        this.initComponent(component);
        this.pnlContent.add(component, object);
    }

    private void initComponent(Component component) {
        component.setBackground(this.background);
        component.setForeground(this.foreground);
        if (component instanceof JComponent) {
            Font font = component.getFont();
            if (font != null) {
                component.setFont(Utils.deriveFontForSize(font, Float.valueOf(this.textSize).floatValue()));
            } else {
                component.setFont(new Font(PLAFChanger.getFontName(), 0, Float.valueOf(this.textSize).intValue()));
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.textSize = String.valueOf((int)font.getSize2D());
    }

    public void setBorder(Border border) {
        if (this.pnlContent == null) {
            super.setBorder(border);
        } else {
            this.pnlContent.setBorder(border);
        }
    }

    public void setController(MVCController mVCController) {
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
    }

    public Object getMVCModel() {
        return null;
    }

    public void removeAll() {
        super.removeAll();
        this.pnlContent.removeAll();
    }

    public JComponent getInnerComponent() {
        return this.pnlContent;
    }

    public void handle_HEADER_COLOR_CHANGED(AppEvent appEvent) {
        this.background = (Color)appEvent.getData();
        this.pnlContent.setBackground(this.background);
        for (int i = 0; i < this.pnlContent.getComponents().length; ++i) {
            Component component = this.pnlContent.getComponents()[i];
            component.setBackground(this.background);
        }
        this.validate();
    }

    public void handle_HEADER_TEXT_COLOR_CHANGED(AppEvent appEvent) {
        this.foreground = (Color)appEvent.getData();
        for (int i = 0; i < this.pnlContent.getComponents().length; ++i) {
            Component component = this.pnlContent.getComponents()[i];
            component.setForeground(this.foreground);
        }
        this.validate();
    }

    public void handle_HEADER_TEXT_SIZE_CHANGED(AppEvent appEvent) {
        this.textSize = (String)appEvent.getData();
        for (int i = 0; i < this.pnlContent.getComponents().length; ++i) {
            Component component = this.pnlContent.getComponents()[i];
            component.setFont(Utils.deriveFontForSize(component.getFont(), Float.valueOf(this.textSize).floatValue()));
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.setMaximumSize(jComponent.getPreferredSize());
        }
        this.validate();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

