/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import azcheck.ui.JSpellDialog;
import com.appframework.AppAction;
import com.appframework.SCMouseListener;
import com.appframework.cache.IDObjectsCollection;
import com.appframework.components.htmleditor.HTMLTextEditor;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.MultipleFieldsDirtyStateManager;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.event.AppEvent;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.jclient.application.controls.attachmentlist.ComposeAttachmentView;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelController;
import com.novell.gw.jclient.application.controls.itemedit.ItemViewTabbedPane;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.popedit.ComboEdit;
import com.novell.gw.jclient.application.controls.popedit.ComboEditImpl;
import com.novell.gw.jclient.application.controls.textcomponent.EditableTextComponent;
import com.novell.gw.jclient.application.frames.options.compose.send.ComposeSendOptionPanel;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.sendoptions.AbstractSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public abstract class ItemEditPanel
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$itemedit$ItemEditPanel == null ? (class$com$novell$gw$jclient$application$controls$itemedit$ItemEditPanel = ItemEditPanel.class$("com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel")) : class$com$novell$gw$jclient$application$controls$itemedit$ItemEditPanel));
    protected final int DEVIDER_SIZE = 4;
    public static final String FROM = "From";
    public static final String TO = "To";
    public static final String CC = "CC";
    public static final String BC = "BC";
    public static final String LOCATION = "Location";
    public static final String START_DATE = "Start date";
    public static final String CALLER = "Caller";
    public static final String COMPANY = "Company";
    public static final String PHONE = "Phone";
    public static final String DUE_ON = "Due on";
    public static final String TIME = "Time";
    public static final String SUBJECT = "Subject";
    public static final String PRIORITY = "Priority";
    public static final String DURATION = "Duration";
    public static final String MESSAGE = "Message";
    public static final String TELEPHONED = "Telephoned";
    public static final String WILL_CALL_AGAIN = "Will call again";
    public static final String WANT_TO_SEE_YOU = "Want to see you";
    public static final String URGENT = "Urgent";
    public static final String PLEASE_CALL = "Please call";
    public static final String RETURN_YOUR_CALL = "Return your call";
    public static final String COME_TO_SEE_YOU = "Come to see you";
    private ItemEditPanelController controller;
    protected AbstractItem newItem = null;
    protected JPanel contentPanel;
    protected JLabel lbFrom;
    protected JLabel lbCC;
    protected JLabel lbTo;
    protected JLabel lbBC;
    protected JLabel lbStartDate;
    protected JLabel lbDueOn;
    protected JLabel lbSubject;
    protected OrientableTextField tfFrom;
    protected ComboEdit tfCC;
    protected ComboEdit tfTo;
    protected ComboEdit tfBC;
    protected EditableTextComponent etcTo;
    protected EditableTextComponent etcCC;
    protected EditableTextComponent etcBC;
    protected OrientableTextField tfSubject;
    protected JPanel addressPane;
    protected HTMLTextEditor messageEditor;
    private ComposeSendOptionPanel sendOptionsPanel;
    private JTabbedPane tpMessageOptions;
    protected ItemComposerTraversalPolicy focusTraversalPolicy;
    protected final int iTop = 10;
    protected final int iLeft = 10;
    protected final int iBottom = 10;
    protected final int iRight = 10;
    protected final int iSpace = 10;
    protected final int SPACE_BETWEEN_ROWS = 8;
    protected MultipleFieldsDirtyStateManager dirtyStateManager;
    protected ComposeAttachmentView attachmentList;
    protected boolean postedMode;
    protected JSplitPane messageSplit = new JSplitPane(0);
    protected boolean isSendingFromAddressBook;
    private String propertyID;
    private boolean isReplyMode;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$itemedit$ItemEditPanel;

    public ItemEditPanel(MVCController mVCController, String string) {
        this(mVCController, string, false);
    }

    protected ItemEditPanel(MVCController mVCController, String string, boolean bl) {
        super(new BorderLayout());
        this.propertyID = string;
        this.messageSplit.setBorder(BorderFactory.createEmptyBorder());
        this.messageSplit.setOneTouchExpandable(false);
        this.messageSplit.setResizeWeight(1.0);
        this.messageSplit.setDividerSize(4);
        this.messageSplit.addPropertyChangeListener(new DividerPositionListener(this.propertyID, this.messageSplit));
        this.controller = new ItemEditPanelController(this, mVCController);
        this.dirtyStateManager = new MultipleFieldsDirtyStateManager(this.controller);
        this.tfTo = new ComboEditImpl(this.controller, 1);
        this.tfCC = new ComboEditImpl(this.controller, 2);
        this.tfBC = new ComboEditImpl(this.controller, 4);
        this.tfSubject = new OrientableTextField();
        ApplicationOptions applicationOptions = ApplicationOptions.getInstance();
        boolean bl2 = applicationOptions.getBoolean("SPELL_CHECKER_AS_YOU_TYPE", true);
        if (bl2) {
            try {
                JSpellDialog.enableAutoCheck((JTextComponent)this.tfSubject, (String)OS.getDictLanguage());
            }
            catch (Exception exception) {
                applicationOptions.put("SPELL_CHECKER_AS_YOU_TYPE", new Boolean(false));
            }
        }
        this.tfSubject.addMouseListener(new SCMouseListener());
        this.tfFrom = new OrientableTextField();
        this.tfFrom.setEditable(false);
        this.tfFrom.setFocusable(false);
        this.etcTo = new EditableTextComponent(this.tfTo.getComponent(), this.dirtyStateManager);
        this.etcCC = new EditableTextComponent(this.tfCC.getComponent(), this.dirtyStateManager);
        this.etcBC = new EditableTextComponent(this.tfBC.getComponent(), this.dirtyStateManager);
        this.etcTo.setPreferredSize(new Dimension(200, this.etcTo.getPreferredSize().height));
        this.etcCC.setPreferredSize(new Dimension(200, this.etcCC.getPreferredSize().height));
        this.etcBC.setPreferredSize(new Dimension(200, this.etcBC.getPreferredSize().height));
        this.build();
        int n = HTMLUtils.isDefaultComposeHTML() ? 1 : 3;
        this.setHTMLEditMode(n);
        this.setItemCompositionTypeHTML(HTMLUtils.isDefaultComposeHTML());
        int n2 = applicationOptions.getInteger(this.propertyID, -1);
        if (n2 <= 0) {
            this.messageSplit.resetToPreferredSizes();
        } else {
            this.messageSplit.setDividerLocation(n2);
        }
        AppAction appAction = this.getController().getActionList().getAction("Save Draft");
        appAction.setEnabled(true);
    }

    public HTMLTextEditor getTaMessage() {
        return this.messageEditor;
    }

    public HTMLTextPane getMessageEditor() {
        return this.messageEditor.getHTMLTextPane();
    }

    protected void build() {
        this.setPreferredSize(new Dimension(580, 480));
        this.tpMessageOptions = new ItemViewTabbedPane(this.controller.getActionList());
        this.tpMessageOptions.setComponentOrientation(UIUtils.getComponentOrientation());
        this.add((Component)this.tpMessageOptions, "Center");
        this.contentPanel = new OrientablePanel();
        this.tpMessageOptions.addTab(StringResources.MESSAGE, this.contentPanel);
        this.messageEditor = new HTMLTextEditor(-1, this.dirtyStateManager);
        this.messageEditor.showHeaderPanel(true);
        this.messageEditor.setEnableShortCuts(true);
        this.messageEditor.setPreferredSize(new Dimension(1, 20));
        this.messageEditor.setDragEnabled(true);
        this.messageEditor.setName(MESSAGE);
        this.sendOptionsPanel = new ComposeSendOptionPanel(this.controller);
        this.tpMessageOptions.addTab(StringResources.SEND_OPTIONS, new OrientableScrollPane(this.sendOptionsPanel));
        this.attachmentList = new ComposeAttachmentView(this.controller, this.dirtyStateManager);
        this.attachmentList.setPreferredSize(new Dimension(this.attachmentList.getPreferredSize().width, 80));
    }

    public void switchToPostedMode() {
        this.tfFrom.setEnabled(false);
        this.etcTo.setEnabled(false);
        this.tfTo.getComponent().setEnabled(false);
        this.etcCC.setEnabled(false);
        this.tfCC.getComponent().setEnabled(false);
        this.etcBC.setEnabled(false);
        this.tfBC.getComponent().setEnabled(false);
        this.addressPane.remove(this.etcTo);
        this.addressPane.remove(this.etcBC);
        this.addressPane.remove(this.etcCC);
        this.addressPane.remove(this.lbTo);
        if (this.lbBC != null) {
            this.addressPane.remove(this.lbBC);
        }
        if (this.lbCC != null) {
            this.addressPane.remove(this.lbCC);
        }
        this.postedMode = true;
        this.focusTraversalPolicy.setPostedMode(true);
    }

    public void setSendingFromAddressBook(boolean bl) {
        this.isSendingFromAddressBook = bl;
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.focusTraversalPolicy;
    }

    public void setRecipients(AbstractItem abstractItem) {
        this.tfCC.setRecipients(abstractItem.getCcRecipients());
        this.tfTo.setRecipients(abstractItem.getToRecipients());
        this.tfBC.setRecipients(abstractItem.getBcRecipients());
    }

    public boolean setHTMLEditMode(int n) {
        if (this.messageEditor.getMode() == n) {
            return false;
        }
        if (n == 1) {
            this.messageEditor.showHeaderPanel(true);
            this.messageEditor.setEnableShortCuts(true);
            this.messageEditor.setHTMLButtonsEnabled(true);
        } else {
            this.messageEditor.setHTMLButtonsEnabled(false);
        }
        this.setItemCompositionTypeHTML(n);
        this.repaint();
        this.messageEditor.setMode(n);
        return true;
    }

    private void setItemCompositionTypeHTML(boolean bl) {
        if (this.newItem != null) {
            this.newItem.setHTMLMessageComposition(bl);
        }
    }

    public void setReplyMode(boolean bl) {
        this.isReplyMode = bl;
    }

    private void setItemCompositionTypeHTML(int n) {
        this.setItemCompositionTypeHTML(n == 1);
    }

    public AbstractItem getInitialItem() {
        return this.newItem;
    }

    public AbstractItem getGWItemComposition() {
        ComposeItemSendOptions composeItemSendOptions;
        logger.debug((Object)"getGWItemComposition");
        this.newItem.setAttachments(this.attachmentList.getAttachmentsCompositions());
        if (this.sendOptionsPanel != null && (composeItemSendOptions = this.sendOptionsPanel.getOptions()) != null) {
            this.newItem.setComposeItemSendOptions(composeItemSendOptions);
        }
        this.newItem.setRecipients(this.getRecipientsList());
        this.newItem.setMessage(this.messageEditor.getStyledText());
        return this.newItem;
    }

    public List getRecipientsList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.tfTo.getRecipients());
        arrayList.addAll(this.tfCC.getRecipients());
        arrayList.addAll(this.tfBC.getRecipients());
        return arrayList;
    }

    public void setGWItemComposition(AbstractItem abstractItem) {
        Object object;
        this.newItem = abstractItem;
        this.attachmentList.setItem(this.newItem);
        this.attachmentList.setAttachmentsCompositions(this.newItem.getAttachments());
        this.setItemCompositionTypeHTML(this.messageEditor.getMode());
        if (this.messageEditor.getMode() == 1) {
            object = this.newItem.getMessage().getMessage();
            this.messageEditor.setStyledText((String)object);
        } else if (this.newItem.getMessage().isRTFMessage()) {
            this.messageEditor.setStyledText(this.newItem.getMessage().getRTFMessage());
        } else {
            this.messageEditor.setPlainText(this.newItem.getMessage().getMessage());
        }
        object = (HTMLTextPane)this.messageEditor.getComponent();
        int n = 0;
        if (this.isCursorBottom(((HTMLTextPane)object).getMode())) {
            Document document = ((JTextComponent)object).getDocument();
            n = document.getLength();
            if (OS.isMacOS()) {
                --n;
            }
        }
        ((HTMLTextPane)object).setCaretPosition(n);
    }

    public void setSendOptions(AbstractSendOptions abstractSendOptions) {
        if (this.sendOptionsPanel != null) {
            this.sendOptionsPanel.setOptions(abstractSendOptions);
        }
    }

    public void setFrom(String string) {
        if (this.tfFrom != null) {
            this.tfFrom.setText(string);
        }
    }

    public void setController(MVCController mVCController) {
        this.controller = (ItemEditPanelController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (!(object instanceof AbstractItem)) {
            throw new IllegalArgumentException();
        }
        this.setGWItemComposition((AbstractItem)object);
    }

    private GWAttachment createFileAttachment(File file) {
        String string = this.newItem.getID();
        GWAttachment gWAttachment = new GWAttachment(string, file.getName());
        gWAttachment.setLocalFile(true);
        gWAttachment.setLocalFilePath(file.getAbsolutePath());
        gWAttachment.setGwItem(this.newItem);
        gWAttachment.setSize(file.length());
        gWAttachment.setFileName(file.getName());
        return gWAttachment;
    }

    protected EditableTextComponent createEditableTextComponent(JComponent jComponent) {
        return new EditableTextComponent(jComponent, this.dirtyStateManager);
    }

    public Object getMVCModel() {
        return this.getGWItemComposition();
    }

    public JComponent getComponentForFocus() {
        if (this.isReplyMode) {
            return (HTMLTextPane)this.messageEditor.getComponent();
        }
        if (this.postedMode || this.isSendingFromAddressBook) {
            return this.tfSubject;
        }
        return this.tfTo.getComponent();
    }

    private boolean isCursorBottom(int n) {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        switch (n) {
            case 1: {
                AccountSettings.HTMLReplyFormat hTMLReplyFormat = accountSettings.getHTMLReplyFormat();
                if (hTMLReplyFormat.getReplyType() != 1 || !hTMLReplyFormat.isReplyInsertAtBottom()) break;
                return true;
            }
            case 3: {
                AccountSettings.PlainTextReplyFormat plainTextReplyFormat = accountSettings.getPlainTextReplyFormat();
                if (plainTextReplyFormat.getReplyType() == 0 || !plainTextReplyFormat.isReplyInsertAtBottom()) break;
                return true;
            }
        }
        return false;
    }

    public void setTo(List list) {
        if (this.tfTo != null) {
            this.tfTo.setRecipients(list);
        }
    }

    public void setCC(List list) {
        if (this.tfCC != null) {
            this.tfCC.setRecipients(list);
        }
    }

    public void setBC(List list) {
        if (this.tfBC != null) {
            this.tfBC.setRecipients(list);
        }
    }

    public void setSubject(String string) {
        if (this.tfSubject != null) {
            this.tfSubject.setText(string);
        }
    }

    public void setMessage(String string) {
        if (this.messageEditor != null) {
            this.messageEditor.setPlainText(string);
        }
    }

    public void clearDirtyState() {
        JRootPane jRootPane;
        this.dirtyStateManager.clearDirtyState();
        if (OS.isMacOS() && (jRootPane = this.getRootPane()) != null) {
            jRootPane.putClientProperty("windowModified", Boolean.FALSE);
        }
    }

    public boolean isDirty() {
        return this.dirtyStateManager.isDirty();
    }

    public JFrame getParentFrame(Component component) {
        Container container = component.getParent();
        if (container instanceof JFrame) {
            return (JFrame)container;
        }
        return this.getParentFrame(container);
    }

    public void addFileAttachments(List list) {
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            File file = (File)list.get(i);
            GWAttachment gWAttachment = this.createFileAttachment(file);
            iDObjectsCollection.addIDObject(gWAttachment);
        }
        this.attachmentList.addFileAttachments(iDObjectsCollection);
    }

    protected boolean handle_ACTION_RECURING_DATE_PERFORMED() {
        return false;
    }

    protected boolean handle_ACTION_SET_DATE_PERFORMED() {
        return false;
    }

    protected boolean handle_ACTION_SET_ALL_DAY_EVENT(boolean bl) {
        return false;
    }

    public void handle_ACTION_ATTACH_FILE_PERFORMED(AppEvent appEvent) {
        this.addFileAttachments((List)appEvent.getData());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static abstract class ItemComposerTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        protected boolean isPostedCompose;

        protected ItemComposerTraversalPolicy() {
        }

        public void setPostedMode(boolean bl) {
            this.isPostedCompose = bl;
        }
    }
}

