/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.ActionList;
import com.appframework.cache.IDObjectsCollection;
import com.appframework.cache.IdentifiedObject;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.AbstractAttachmentAction;
import com.novell.gw.jclient.application.actions.ActionAttachmentOpen;
import com.novell.gw.jclient.application.actions.ActionAttachmentSave;
import com.novell.gw.jclient.application.actions.item.AbstractGWItemAction;
import com.novell.gw.jclient.application.actions.item.ActionOpenItem;
import com.novell.gw.jclient.application.actions.item.ActionPrint;
import com.novell.gw.jclient.application.actions.item.ActionSaveGWItem;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.ExtraPopupImpl;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.ItemDescription;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.basic.BasicIconFactory;
import org.apache.log4j.Logger;

class EnvelopMessageTree
extends JPopupMenu {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$itemview$EnvelopMessageTree == null ? (class$com$novell$gw$jclient$application$controls$itemview$EnvelopMessageTree = EnvelopMessageTree.class$("com.novell.gw.jclient.application.controls.itemview.EnvelopMessageTree")) : class$com$novell$gw$jclient$application$controls$itemview$EnvelopMessageTree));
    private IdentifiedObject selectedItem;
    private AbstractItem item;
    private boolean showAttachments;
    private MVCController controller;
    private DefaultListModel model = new DefaultListModel();
    private AttachmentPopupMenu attachmentPopupMenu;
    private ItemPopupMenu itemPopupMenu;
    private JList listMessageTree = new OrientableList();
    private Boolean hideSystemAttachments;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$itemview$EnvelopMessageTree;

    public EnvelopMessageTree(MVCController mVCController) {
        EnvironmentOptions environmentOptions = OptionManager.getInstance().getEnvironmentOptions();
        this.hideSystemAttachments = environmentOptions.isHideSystemAttachments();
        this.controller = mVCController;
        this.listMessageTree.addMouseMotionListener(new MotionListener());
        this.listMessageTree.addMouseListener(new MouseListener());
        this.listMessageTree.setCellRenderer(new Renderer());
        this.attachmentPopupMenu = new AttachmentPopupMenu(this, this.controller.getActionList());
        this.itemPopupMenu = new ItemPopupMenu(this, this.controller.getActionList());
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.listMessageTree);
        orientableScrollPane.setBorder(null);
        this.add(orientableScrollPane);
    }

    public void rebuild(boolean bl) {
        this.model.clear();
        this.showAttachments = bl;
        ItemWrapper itemWrapper = new ItemWrapper(0, this.item);
        this.model.addElement(itemWrapper);
        this.buildTreeNodes(itemWrapper, this.item.getAttachments());
        this.listMessageTree.setModel(this.model);
        this.listMessageTree.updateUI();
    }

    public void rebuild(AbstractItem abstractItem, IdentifiedObject identifiedObject, boolean bl) {
        this.item = abstractItem;
        this.selectedItem = identifiedObject;
        this.rebuild(bl);
    }

    private void buildTreeNodes(ItemWrapper itemWrapper, IDObjectsCollection iDObjectsCollection) {
        for (int i = 0; i < iDObjectsCollection.size(); ++i) {
            GWAttachment gWAttachment = (GWAttachment)iDObjectsCollection.getIDObjectAt(i);
            if (gWAttachment.isMessageAttachment()) {
                String string = ControlsUtils.getUserGuid(this.controller);
                AbstractItem abstractItem = gWAttachment.getEnclosedItem(string);
                ItemWrapper itemWrapper2 = new ItemWrapper(itemWrapper.getItemLevel() + 1, abstractItem);
                this.model.addElement(itemWrapper2);
                this.buildTreeNodes(itemWrapper2, abstractItem.getAttachments());
                continue;
            }
            if (!this.showAttachments || gWAttachment.isSystemAttachment() && Boolean.TRUE.equals(this.hideSystemAttachments)) continue;
            this.model.addElement(new ItemWrapper(itemWrapper.getItemLevel() + 1, gWAttachment));
        }
    }

    private void updateSelection(MouseEvent mouseEvent) {
        int n = this.listMessageTree.locationToIndex(mouseEvent.getPoint());
        this.listMessageTree.setSelectedIndex(n);
    }

    private void selectGWItem() {
        this.selectedItem = ((ItemWrapper)this.listMessageTree.getSelectedValue()).getItem();
        this.setVisible(false);
        Command command = new Command(1030, this.selectedItem);
        this.controller.processCommand(command);
    }

    public void setHideSystemAttachments(Boolean bl) {
        this.hideSystemAttachments = bl;
    }

    private static boolean isLeftToRight() {
        return UIUtils.getComponentOrientation().isLeftToRight();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AttachmentPopupMenu
    extends ExtraPopupImpl {
        private AbstractAttachmentAction actionSave;
        private AbstractAttachmentAction actionOpen;

        public AttachmentPopupMenu(JPopupMenu jPopupMenu, ActionList actionList) {
            super(jPopupMenu);
            this.actionOpen = new ActionAttachmentOpen(actionList);
            this.actionSave = new ActionAttachmentSave(actionList);
            this.add(this.actionOpen);
            this.add(this.actionSave);
        }

        public void setAttachment(GWAttachment gWAttachment) {
            this.actionOpen.setMVCModel(gWAttachment);
            this.actionSave.setMVCModel(gWAttachment);
            this.actionOpen.setEnabled(true);
            this.actionSave.setEnabled(true);
        }
    }

    private static class ItemPopupMenu
    extends ExtraPopupImpl {
        private AbstractGWItemAction actionPrint;
        private AbstractGWItemAction actionOpen;
        private AbstractGWItemAction actionSave;

        public ItemPopupMenu(JPopupMenu jPopupMenu, ActionList actionList) {
            super(jPopupMenu);
            this.actionOpen = new ActionOpenItem(actionList);
            this.actionPrint = new ActionPrint(actionList);
            this.actionSave = new ActionSaveGWItem(actionList);
            this.add(this.actionOpen);
            this.add(this.actionPrint);
            this.add(this.actionSave);
        }

        public void setGWItem(AbstractItem abstractItem) {
            this.actionOpen.setMVCModel(new ItemDescription(abstractItem));
            this.actionPrint.setMVCModel(new ItemDescription(abstractItem));
            this.actionSave.setMVCModel(new ItemDescription(abstractItem));
        }
    }

    private static class ItemWrapper {
        private int itemLevel;
        private IdentifiedObject item;

        public ItemWrapper(int n, IdentifiedObject identifiedObject) {
            this.itemLevel = n;
            this.item = identifiedObject;
        }

        public int getItemLevel() {
            return this.itemLevel;
        }

        public IdentifiedObject getItem() {
            return this.item;
        }

        public String toString() {
            return this.item.toString();
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                EnvelopMessageTree.this.selectGWItem();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Object object;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (EnvelopMessageTree.this.listMessageTree.getParent() instanceof JViewport) {
                    object = (JViewport)EnvelopMessageTree.this.listMessageTree.getParent();
                    n2 -= ((JViewport)object).getViewPosition().y;
                }
                if ((object = ((ItemWrapper)((JList)mouseEvent.getComponent()).getSelectedValue()).getItem()) instanceof GWAttachment) {
                    EnvelopMessageTree.this.attachmentPopupMenu.setAttachment((GWAttachment)object);
                    EnvelopMessageTree.this.attachmentPopupMenu.show(n, n2);
                } else if (object instanceof AbstractItem) {
                    EnvelopMessageTree.this.itemPopupMenu.setGWItem((AbstractItem)object);
                    EnvelopMessageTree.this.itemPopupMenu.show(n, n2);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }
    }

    private class MotionListener
    extends MouseMotionAdapter {
        private MotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            EnvelopMessageTree.this.updateSelection(mouseEvent);
        }
    }

    private static class CheckedBorder
    extends AbstractBorder {
        private Icon icon = BasicIconFactory.getCheckBoxMenuItemIcon();
        public static final int GAP = 5;

        private CheckedBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
            int n5 = n + 2;
            if (!EnvelopMessageTree.isLeftToRight()) {
                n5 = n + component.getSize().width - this.icon.getIconWidth() - 2;
            }
            int n6 = n2 + component.getSize().height / 2 - this.icon.getIconHeight() / 2;
            this.icon.paintIcon(component, graphics, n5, n6);
        }

        private int getBorderWidth() {
            return this.icon.getIconWidth() + 5;
        }

        public Insets getBorderInsets(Component component) {
            if (EnvelopMessageTree.isLeftToRight()) {
                return new Insets(0, this.getBorderWidth(), 0, 0);
            }
            return new Insets(0, 0, 0, this.getBorderWidth());
        }
    }

    private class Renderer
    extends OrientablePanel
    implements ListCellRenderer {
        private AbstractButton cbItem = new OrientableButton();
        public static final int GAP = 10;

        public Renderer() {
            this.cbItem.setBorder(new CheckedBorder());
            this.setLayout(new BorderLayout());
            this.add((Component)this.cbItem, "Before");
            this.cbItem.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ItemWrapper itemWrapper = (ItemWrapper)object;
            IdentifiedObject identifiedObject = itemWrapper.getItem();
            if (identifiedObject instanceof AbstractItem) {
                this.cbItem.setIcon(ControlsUtils.getImageForGWItem((AbstractItem)identifiedObject));
            } else {
                GWAttachment gWAttachment = (GWAttachment)identifiedObject;
                this.cbItem.setIcon(ControlsUtils.getSmallIconForAttachment(gWAttachment.getFileName(), gWAttachment.getDownloadState()));
            }
            this.cbItem.setText(identifiedObject.toString());
            int n2 = 10 * itemWrapper.getItemLevel();
            if (EnvelopMessageTree.isLeftToRight()) {
                this.setBorder(BorderFactory.createEmptyBorder(5, n2, 5, 0));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, n2));
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (identifiedObject.equals(EnvelopMessageTree.this.selectedItem)) {
                this.cbItem.setSelected(true);
            } else {
                this.cbItem.setSelected(false);
            }
            return this;
        }
    }
}

