/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.cache.IdentifiedObject;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.Utils;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.actions.item.ActionComplete;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.header.HeaderPanel;
import com.novell.gw.jclient.application.controls.header.HeaderPopupMenu;
import com.novell.gw.jclient.application.controls.header.QuickViewPopupMenu;
import com.novell.gw.jclient.application.controls.itemview.EnvelopMessageTree;
import com.novell.gw.jclient.application.controls.itemview.GWItemPropertiesPanelController;
import com.novell.gw.jclient.application.controls.itemview.RecipientsMenu;
import com.novell.gw.jclient.application.controls.itemview.RecipientsPanel;
import com.novell.gw.jclient.application.controls.itemview.RecipientsTextField;
import com.novell.gw.jclient.application.controls.itemview.SensitiveLabel;
import com.novell.gw.jclient.application.controls.itemview.UneditableTextField;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.filter.ComponentWithMenu;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class GWItemPropertiesPanel
extends JPanel
implements MVCView {
    private GWItemPropertiesPanelController controller;
    private AbstractItem selectedItem;
    private AbstractItem parentItem;
    private GWAttachment selectedAttachment;
    private JPanel pnlCenter;
    private JPanel pnlCenterContent;
    private JPanel pnlEmpty;
    private SensitiveLabel lbSubject;
    private SensitiveLabel lbFrom;
    private SensitiveLabel lbTo;
    private SensitiveLabel lbCC;
    private SensitiveLabel lbBC;
    private SensitiveLabel lbWhen;
    private SensitiveLabel lbWhere;
    private SensitiveLabel lbDateStart;
    private SensitiveLabel lbDateEnd;
    private SensitiveLabel lbPriority;
    private SensitiveLabel lbCaller;
    private SensitiveLabel lbCompany;
    private SensitiveLabel lbPhone;
    RecipientsTextField tfFrom;
    RecipientsTextField tfTo;
    RecipientsTextField tfCC;
    RecipientsTextField tfBC;
    JTextField tfSubject;
    JTextField tfDate;
    JTextField tfWhen;
    JTextField tfWhere;
    JTextField tfDateStart;
    JTextField tfDateEnd;
    JTextField tfPriority;
    JTextField tfCaller;
    JTextField tfCompany;
    JTextField tfPhone;
    private JLabel lbViewToRecipients = new JLabel();
    private JLabel lbViewCCRecipients = new JLabel();
    private JLabel lbViewBCRecipients = new JLabel();
    private RecipientsMenu recipientsMenuTo = new RecipientsMenu(this);
    private RecipientsMenu recipientsMenuCC = new RecipientsMenu(this);
    private RecipientsMenu recipientsMenuBC = new RecipientsMenu(this);
    private MouseListener headerMouseListener;
    private Font font;
    private Color foreground;
    private Boolean alignColons;
    private boolean isLazyInitialized;
    private MouseListener emptyItemListener;
    private MouseListener nonemptyItemListener;
    private EnvelopMessageTree messageTree;
    private JPanel pnlTemp;
    private JLabel lbEmbeddedMail = new OrientableLabel();
    private Boolean hideSystemAttachments;

    public GWItemPropertiesPanel(MVCController mVCController) {
        super(new BorderLayout());
        this.controller = new GWItemPropertiesPanelController(this, mVCController);
        EnvironmentOptions environmentOptions = OptionManager.getInstance().getEnvironmentOptions();
        this.alignColons = environmentOptions.isHeaderAligned();
        HeaderPopupMenu headerPopupMenu = new HeaderPopupMenu(this.getController().getActionList());
        this.emptyItemListener = AbstractActionsPopupMenu.createMenuMouseListener(headerPopupMenu);
        QuickViewPopupMenu quickViewPopupMenu = new QuickViewPopupMenu(this.getController().getActionList());
        this.nonemptyItemListener = AbstractActionsPopupMenu.createMenuMouseListener(quickViewPopupMenu);
        this.setSelectedItem(null);
    }

    private void initComponent(JTextField[] jTextFieldArray) {
        for (int i = 0; i < jTextFieldArray.length; ++i) {
            jTextFieldArray[i].setForeground(this.foreground);
            jTextFieldArray[i].setFont(this.font);
        }
    }

    private void clearFields() {
        this.clear(this.tfWhere);
        this.clear(this.tfWhen);
        this.clear(this.tfDateStart);
        this.clear(this.tfDateEnd);
        this.clear(this.tfPriority);
        this.clear(this.tfCaller);
        this.clear(this.tfCompany);
        this.clear(this.tfPhone);
        this.clear(this.tfSubject);
        this.clear(this.tfDate);
    }

    private void clear(JTextField jTextField) {
        if (jTextField != null) {
            jTextField.setText(null);
        }
    }

    private void build() {
        Serializable serializable;
        this.removeAll();
        this.createControls();
        this.clearFields();
        this.setData();
        this.pnlCenterContent = new OrientablePanel(new GridBagLayout());
        this.pnlCenter = new HeaderPanel(this.pnlCenterContent, this.controller);
        this.add((Component)this.pnlCenter, "Center");
        this.setBoldFont(this.lbFrom);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.buildFrom(gridBagConstraints);
        this.buildAddresses(gridBagConstraints);
        if (!GWItemPropertiesPanel.isEmptyString(this.tfWhen.getText())) {
            this.buildRow(this.lbWhen, this.tfWhen, gridBagConstraints);
        }
        if (!GWItemPropertiesPanel.isEmptyString(this.tfWhere.getText())) {
            this.buildRow(this.lbWhere, this.tfWhere, gridBagConstraints);
        }
        this.buildCaller(gridBagConstraints);
        this.buildPhone(gridBagConstraints);
        if (!GWItemPropertiesPanel.isEmptyString(this.tfDateStart.getText())) {
            serializable = HeaderPanel.createInstanceWithBoxLayout(new JPanel(), this.getController());
            ((HeaderPanel)serializable).setBorder(null);
            ((HeaderPanel)serializable).add(this.tfDateStart);
            ((HeaderPanel)serializable).getInnerComponent().add(Box.createRigidArea(new Dimension(5, 0)));
            this.setBoldFont(this.lbDateEnd);
            ((HeaderPanel)serializable).add(this.lbDateEnd);
            ((HeaderPanel)serializable).getInnerComponent().add(Box.createRigidArea(new Dimension(5, 0)));
            ((HeaderPanel)serializable).add(this.tfDateEnd);
            ((HeaderPanel)serializable).getInnerComponent().add(Box.createRigidArea(new Dimension(5, 0)));
            this.setBoldFont(this.lbPriority);
            ((HeaderPanel)serializable).add(this.lbPriority);
            ((HeaderPanel)serializable).getInnerComponent().add(Box.createRigidArea(new Dimension(5, 0)));
            ((HeaderPanel)serializable).add(this.tfPriority);
            ((HeaderPanel)serializable).getInnerComponent().add(Box.createHorizontalGlue());
            this.buildRow(this.lbDateStart, (JComponent)serializable, gridBagConstraints);
        }
        if (!GWItemPropertiesPanel.isEmptyString(this.tfSubject.getText())) {
            this.buildRow(this.lbSubject, this.tfSubject, gridBagConstraints);
        }
        this.hideSystemAttachments = OptionManager.getInstance().getEnvironmentOptions().isHideSystemAttachments();
        if (this.hasAttachments()) {
            this.lbEmbeddedMail.setHorizontalAlignment(10);
            this.pnlTemp = new HeaderPanel(new OrientablePanel(new BorderLayout()), this.controller);
            this.lbEmbeddedMail.setText(this.selectedItem.getSubject());
            this.lbEmbeddedMail.setIcon(ImageResources.ICON_ATTACHMENT);
            this.pnlTemp.add((Component)this.lbEmbeddedMail, "Center");
            this.pnlTemp.add((Component)new OrientableLabel(ImageResources.ICON_DOWN_ARROW), "After");
            serializable = this.selectedAttachment == null ? this.selectedItem : this.selectedAttachment;
            this.getEnvelopMessageTree().rebuild(this.parentItem, (IdentifiedObject)((Object)serializable), !this.isAttachmentViewVisible());
            ComponentWithMenu componentWithMenu = new ComponentWithMenu(this.pnlTemp, this.messageTree);
            componentWithMenu.setMaximumSize(componentWithMenu.getPreferredSize());
            gridBagConstraints.anchor = 22;
            --gridBagConstraints.gridy;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.pnlCenter.add((Component)componentWithMenu, gridBagConstraints);
            if (!this.hasEnvelopeMessages() && this.isAttachmentViewVisible()) {
                this.pnlTemp.setVisible(false);
            }
        }
        ++gridBagConstraints.gridy;
        this.alignColons();
    }

    private void setRecipients() {
        this.recipientsMenuTo.setRecipients(GWItemPropertiesPanel.getRecipients(this.selectedItem.getRecipientsList(), 1));
        this.recipientsMenuCC.setRecipients(GWItemPropertiesPanel.getRecipients(this.selectedItem.getRecipientsList(), 2));
        this.recipientsMenuBC.setRecipients(GWItemPropertiesPanel.getRecipients(this.selectedItem.getRecipientsList(), 4));
    }

    private static List getRecipients(List list, int n) {
        ArrayList<Recipient> arrayList = new ArrayList<Recipient>();
        for (int i = 0; i < list.size(); ++i) {
            Recipient recipient = (Recipient)list.get(i);
            if ((recipient.getCopyType() & n) != n) continue;
            arrayList.add(recipient);
        }
        return arrayList;
    }

    private EnvelopMessageTree getEnvelopMessageTree() {
        if (this.messageTree == null) {
            this.messageTree = new EnvelopMessageTree(this.controller);
        }
        return this.messageTree;
    }

    private boolean hasAttachments() {
        boolean bl = false;
        for (int i = 0; i < this.parentItem.getAttachments().size(); ++i) {
            GWAttachment gWAttachment = (GWAttachment)this.parentItem.getAttachments().getIDObjectAt(i);
            if (gWAttachment.isSystemAttachment() && Boolean.TRUE.equals(this.hideSystemAttachments)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean hasEnvelopeMessages() {
        boolean bl = false;
        for (int i = 0; i < this.parentItem.getAttachments().size(); ++i) {
            GWAttachment gWAttachment = (GWAttachment)this.parentItem.getAttachments().getIDObjectAt(i);
            if (!gWAttachment.isMessageAttachment()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void buildFrom(GridBagConstraints gridBagConstraints) {
        HeaderPanel headerPanel;
        if (this.selectedItem instanceof TaskItem) {
            AbstractButton abstractButton = ((ActionComplete)this.controller.getActionList().getAction("Complete")).getCheckBox();
            headerPanel = new HeaderPanel(new OrientablePanel(new GridBagLayout()), this.getController());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 21;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            ((Container)headerPanel).add((Component)this.tfFrom, gridBagConstraints2);
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.insets.left = 5;
            gridBagConstraints2.weightx = 0.0;
            abstractButton.setPreferredSize(new Dimension(abstractButton.getPreferredSize().width, this.tfDate.getPreferredSize().height));
            ((Container)headerPanel).add((Component)abstractButton, gridBagConstraints2);
            gridBagConstraints2.insets.left = 0;
            ((Container)headerPanel).add((Component)this.tfDate, gridBagConstraints2);
        } else {
            headerPanel = new HeaderPanel(new OrientablePanel(new BorderLayout()), this.getController());
            ((Container)headerPanel).add((Component)this.tfFrom, "Before");
            ((Container)headerPanel).add((Component)this.tfDate, "After");
        }
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        this.pnlCenter.add((Component)this.lbFrom, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.pnlCenter.add((Component)headerPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
    }

    private void buildAddresses(GridBagConstraints gridBagConstraints) {
        if (!GWItemPropertiesPanel.isEmptyString(this.tfTo.getText())) {
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.weightx = 0.0;
            this.pnlCenter.add((Component)this.lbTo, gridBagConstraints);
            ComponentWithMenu.initComponent(this.lbViewToRecipients, this.recipientsMenuTo);
            RecipientsPanel recipientsPanel = new RecipientsPanel(this.tfTo, this.lbViewToRecipients);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            this.pnlCenter.add((Component)new HeaderPanel(recipientsPanel, this.controller), gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            ++gridBagConstraints.gridy;
        }
        if (!GWItemPropertiesPanel.isEmptyString(this.tfCC.getText())) {
            this.buildRecipients(this.lbCC, this.tfCC, this.lbViewCCRecipients, gridBagConstraints, this.recipientsMenuCC);
        }
        if (!GWItemPropertiesPanel.isEmptyString(this.tfBC.getText())) {
            this.buildRecipients(this.lbBC, this.tfBC, this.lbViewBCRecipients, gridBagConstraints, this.recipientsMenuBC);
        }
    }

    private void buildRecipients(JLabel jLabel, RecipientsTextField recipientsTextField, JLabel jLabel2, GridBagConstraints gridBagConstraints, JPopupMenu jPopupMenu) {
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.pnlCenter.add((Component)jLabel, gridBagConstraints);
        ComponentWithMenu.initComponent(jLabel2, jPopupMenu);
        RecipientsPanel recipientsPanel = new RecipientsPanel(recipientsTextField, jLabel2);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        this.pnlCenter.add((Component)new HeaderPanel(recipientsPanel, this.controller), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
    }

    private void buildCaller(GridBagConstraints gridBagConstraints) {
        boolean bl = GWItemPropertiesPanel.isEmptyString(this.tfCaller.getText());
        boolean bl2 = GWItemPropertiesPanel.isEmptyString(this.tfCompany.getText());
        if (!bl || !bl2) {
            OrientablePanel orientablePanel = new OrientablePanel();
            HeaderPanel headerPanel = HeaderPanel.createInstanceWithBoxLayout(orientablePanel, this.getController());
            orientablePanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 21;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets.right = 5;
            if (!bl) {
                headerPanel.add((Component)this.tfCaller, gridBagConstraints2);
                if (!bl2) {
                    this.setBoldFont(this.lbCompany);
                    gridBagConstraints2.insets.right = 10;
                    headerPanel.add((Component)this.lbCompany, gridBagConstraints2);
                    gridBagConstraints2.insets.right = 5;
                    gridBagConstraints2.weightx = 1.0;
                    headerPanel.add((Component)this.tfCompany, gridBagConstraints2);
                }
                this.buildRow(this.lbCaller, headerPanel, gridBagConstraints);
            } else {
                headerPanel.add((Component)this.tfCompany, gridBagConstraints2);
                this.buildRow(this.lbCompany, headerPanel, gridBagConstraints);
            }
        }
    }

    private void buildPhone(GridBagConstraints gridBagConstraints) {
        boolean bl = GWItemPropertiesPanel.isEmptyString(this.tfPhone.getText());
        HeaderPanel headerPanel = HeaderPanel.createOGBPanel(this.getController());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 21;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets.right = 14;
        if (!bl) {
            headerPanel.add((Component)this.tfPhone, gridBagConstraints2);
        }
        gridBagConstraints2.weightx = 1.0;
        if (this.selectedItem instanceof PhoneItem) {
            headerPanel.add((Component)new JLabel(((PhoneItem)this.selectedItem).getWideSubject()), gridBagConstraints2);
        }
        this.buildRow(bl ? null : this.lbPhone, headerPanel, gridBagConstraints);
    }

    private void buildRow(JComponent jComponent, JComponent jComponent2, GridBagConstraints gridBagConstraints) {
        if (jComponent != null) {
            this.setBoldFont(jComponent);
        }
        jComponent2.setMaximumSize(jComponent2.getPreferredSize());
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        if (jComponent != null) {
            this.pnlCenter.add((Component)jComponent, gridBagConstraints);
        }
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(3, 5, 0));
        HeaderPanel headerPanel = new HeaderPanel(orientablePanel, this.getController());
        ((Container)headerPanel).add(jComponent2);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        this.pnlCenter.add((Component)headerPanel, gridBagConstraints);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
    }

    public AbstractItem getSelectedItem() {
        return this.selectedItem;
    }

    private void setSelectedItem(AbstractItem abstractItem) {
        this.selectedItem = abstractItem;
        if (this.selectedItem == null) {
            if (this.headerMouseListener != this.emptyItemListener) {
                this.removeMouseListener(this.headerMouseListener);
                this.headerMouseListener = this.emptyItemListener;
                this.addMouseListener(this.headerMouseListener);
            }
            this.clearPane();
            this.recipientsMenuCC.clearRecipients();
            this.recipientsMenuTo.clearRecipients();
            this.recipientsMenuBC.clearRecipients();
        } else {
            if (this.headerMouseListener != this.nonemptyItemListener) {
                this.removeMouseListener(this.headerMouseListener);
                this.headerMouseListener = this.nonemptyItemListener;
                this.addMouseListener(this.headerMouseListener);
            }
            if (this.parentItem == null) {
                this.setParentItem(abstractItem);
            }
            this.setRecipients();
            this.build();
            this.updateUI();
        }
    }

    public void setController(MVCController mVCController) {
        if (!(mVCController instanceof GWItemPropertiesPanelController)) {
            throw new IllegalArgumentException();
        }
        this.controller = (GWItemPropertiesPanelController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        this.selectedAttachment = null;
        if (object == null) {
            this.setSelectedItem(null);
        } else if (object instanceof AbstractItem) {
            this.setSelectedItem((AbstractItem)object);
        } else if (object instanceof GWAttachment) {
            this.selectedAttachment = (GWAttachment)object;
            this.setSelectedItem(((GWAttachment)object).getGwItem());
        }
    }

    public Object getMVCModel() {
        return this.getSelectedItem();
    }

    private void createControls() {
        if (this.isLazyInitialized) {
            return;
        }
        this.lbFrom = new SensitiveLabel(StringResources.FROM_C, this.headerMouseListener);
        this.lbTo = new SensitiveLabel(StringResources.TO_C, this.headerMouseListener);
        this.lbCC = new SensitiveLabel(StringResources.CC_C, this.headerMouseListener);
        this.lbBC = new SensitiveLabel(StringResources.BC_C, this.headerMouseListener);
        this.lbWhen = new SensitiveLabel(StringResources.WHEN_C, this.headerMouseListener);
        this.lbWhere = new SensitiveLabel(StringResources.WHERE_C, this.headerMouseListener);
        this.lbSubject = new SensitiveLabel(StringResources.SUBJECT_C, this.headerMouseListener);
        this.lbDateStart = new SensitiveLabel(StringResources.STARTS_C, this.headerMouseListener);
        this.lbDateEnd = new SensitiveLabel(StringResources.DUE_ON_C, this.headerMouseListener);
        this.lbPriority = new SensitiveLabel(StringResources.PRIORITY_C, this.headerMouseListener);
        this.lbCaller = new SensitiveLabel(StringResources.CALLER_C, this.headerMouseListener);
        this.lbCompany = new SensitiveLabel(StringResources.COMPANY_C, this.headerMouseListener);
        this.lbPhone = new SensitiveLabel(StringResources.PHONE_C, this.headerMouseListener);
        this.tfSubject = new UneditableTextField(this.lbSubject);
        this.tfDate = new UneditableTextField(null);
        if (this.tfDate.getComponentOrientation().isLeftToRight()) {
            this.tfDate.setHorizontalAlignment(4);
        } else {
            this.tfDate.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.tfDate.setHorizontalAlignment(2);
        }
        ArrayList<Recipient> arrayList = new ArrayList<Recipient>();
        arrayList.add(this.selectedItem.getSender().getRecipient());
        this.tfFrom = new RecipientsTextField(arrayList, this.lbFrom);
        this.tfTo = new RecipientsTextField(this.selectedItem.getToRecipients(), this.lbTo);
        this.tfCC = new RecipientsTextField(this.selectedItem.getCcRecipients(), this.lbCC);
        this.tfBC = new RecipientsTextField(this.selectedItem.getBcRecipients(), this.lbBC);
        this.tfWhere = new UneditableTextField(this.lbWhere);
        this.tfWhen = new UneditableTextField(this.lbWhen);
        this.tfDateStart = new UneditableTextField(this.lbDateStart);
        this.tfDateEnd = new UneditableTextField(this.lbDateEnd);
        this.tfPriority = new UneditableTextField(this.lbPriority);
        this.tfCaller = new UneditableTextField(this.lbCaller);
        this.tfCompany = new UneditableTextField(this.lbCompany);
        this.tfPhone = new UneditableTextField(this.lbPhone);
        EnvironmentOptions environmentOptions = OptionManager.getInstance().getEnvironmentOptions();
        String string = environmentOptions.getHeaderTextSize();
        this.font = Utils.deriveFontForSize(this.tfFrom.getFont(), Float.valueOf(string).floatValue());
        this.font = this.tfFrom.getFont();
        this.foreground = environmentOptions.getHeaderTextColor();
        this.initComponent(new JTextField[]{this.tfFrom, this.tfTo, this.tfCC, this.tfBC, this.tfWhen, this.tfWhere, this.tfSubject, this.tfDateStart, this.tfDateEnd, this.tfPriority, this.tfCaller, this.tfCompany, this.tfPhone});
        this.isLazyInitialized = true;
    }

    private void setData() {
        this.tfSubject.setText(this.selectedItem.getSubject());
        this.tfDate.setText(GWCalendarUtils.getDateTimeFormat().format(this.selectedItem.getDate()));
        ArrayList<Recipient> arrayList = new ArrayList<Recipient>();
        arrayList.add(this.selectedItem.getSender().getRecipient());
        this.tfFrom.setRecipients(arrayList);
        this.tfTo.setRecipients(this.selectedItem.getToRecipients());
        this.tfCC.setRecipients(this.selectedItem.getCcRecipients());
        this.tfBC.setRecipients(this.selectedItem.getBcRecipients());
        if (this.selectedItem instanceof AppointmentItem) {
            this.tfWhere.setText(((AppointmentItem)this.selectedItem).getLocation());
            this.tfWhen.setText(GWCalendarUtils.getDateTimeFormatWithDayOfWeek().format(((AppointmentItem)this.selectedItem).getStartDate()) + " " + GWCalendarUtils.getDurationText(((AppointmentItem)this.selectedItem).getDuration()));
        } else if (this.selectedItem instanceof TaskItem) {
            long l = ((TaskItem)this.selectedItem).getDateTaskAssigned();
            this.tfDateStart.setText(GWCalendarUtils.getDateFormat().format(new Date(l)));
            this.tfDateEnd.setText(GWCalendarUtils.getDateFormat().format(((TaskItem)this.selectedItem).getEndDate()));
            this.tfPriority.setText(((TaskItem)this.selectedItem).getTaskPriority());
        } else if (this.selectedItem instanceof PhoneItem) {
            this.tfCaller.setText(((PhoneItem)this.selectedItem).getCaller());
            this.tfCompany.setText(((PhoneItem)this.selectedItem).getCompany());
            this.tfPhone.setText(((PhoneItem)this.selectedItem).getPhone());
            this.tfSubject.setText(null);
        }
        this.tfDateEnd.setCaretPosition(0);
        this.tfDateStart.setCaretPosition(0);
        this.tfPhone.setCaretPosition(0);
        this.tfWhen.setCaretPosition(0);
        this.tfDate.setCaretPosition(0);
        this.tfCaller.setCaretPosition(0);
        this.tfCompany.setCaretPosition(0);
        this.tfWhere.setCaretPosition(0);
        this.tfSubject.setCaretPosition(0);
        this.tfTo.setCaretPosition(0);
        this.tfCC.setCaretPosition(0);
        this.tfBC.setCaretPosition(0);
        this.tfFrom.setCaretPosition(0);
    }

    private void clearPane() {
        this.removeAll();
        if (this.pnlEmpty == null) {
            this.pnlEmpty = new HeaderPanel(new JPanel(), this.controller);
            this.pnlEmpty.setPreferredSize(new Dimension(100, 24));
        }
        this.add((Component)this.pnlEmpty, "Center");
    }

    private static boolean isEmptyString(String string) {
        return string == null || string.length() == 0;
    }

    private void setBoldFont(JComponent jComponent) {
        jComponent.setFont(Utils.deriveFont(jComponent.getFont(), 1));
    }

    public void setAlignColons(boolean bl) {
        this.alignColons = bl;
        this.alignColons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alignColons() {
        final int n = Boolean.TRUE.equals(this.alignColons) && this.selectedItem != null ? 11 : 10;
        this.setColonsAligment(n);
        GWItemPropertiesPanel gWItemPropertiesPanel = this;
        synchronized (gWItemPropertiesPanel) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWItemPropertiesPanel.this.setColonsAligment(n);
                }
            });
        }
    }

    private void setColonsAligment(int n) {
        if (this.pnlCenterContent != null && this.pnlCenterContent.getLayout() != null) {
            GridBagLayout gridBagLayout = (GridBagLayout)this.pnlCenterContent.getLayout();
            int n2 = 0;
            switch (n) {
                case 10: {
                    n2 = 21;
                    break;
                }
                case 11: {
                    n2 = 22;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong alignment constant");
                }
            }
            Component[] componentArray = new Component[]{this.lbFrom, this.lbTo, this.lbWhen, this.lbWhere, this.lbCaller, this.lbPhone, this.lbSubject, this.lbDateStart, this.lbCC, this.lbBC};
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(component);
                gridBagConstraints.anchor = n2;
                gridBagLayout.setConstraints(component, gridBagConstraints);
            }
            gridBagLayout.layoutContainer(this.pnlCenterContent);
            this.validate();
        }
    }

    public void setEmbededMailButtonText(String string) {
        this.lbEmbeddedMail.setText(string);
    }

    public AbstractItem getParentItem() {
        return this.parentItem;
    }

    public void setParentItem(AbstractItem abstractItem) {
        this.parentItem = abstractItem;
    }

    private boolean isAttachmentViewVisible() {
        return ApplicationOptions.getInstance().getBoolean("ATTACHLIST_VISIBLE", false);
    }

    public void updateMessageTree() {
        if (this.pnlTemp != null) {
            boolean bl;
            boolean bl2 = bl = !this.isAttachmentViewVisible() && this.hasAttachments() || this.hasEnvelopeMessages();
            if (bl) {
                if (this.isAttachmentViewVisible() || this.selectedAttachment == null) {
                    this.setEmbededMailButtonText(this.selectedItem.getSubject());
                } else {
                    this.setEmbededMailButtonText(this.selectedAttachment.getName());
                }
            }
            this.pnlTemp.setVisible(bl);
            this.updateUI();
            this.getEnvelopMessageTree().rebuild(true);
        }
    }

    public void setHideSystemAttachments(Boolean bl) {
        this.hideSystemAttachments = bl;
        this.getEnvelopMessageTree().setHideSystemAttachments(this.hideSystemAttachments);
        this.updateMessageTree();
    }
}

