/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemview.ItemProperties;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerController;
import com.novell.gw.jclient.application.controls.itemview.itemviewer.ItemViewer;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.controls.toolbars.QuickViewerSentItemsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.QuickViewerToolBar;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.ItemDescription;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class QuickViewer
extends JPanel
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$itemview$QuickViewer == null ? (class$com$novell$gw$jclient$application$controls$itemview$QuickViewer = QuickViewer.class$("com.novell.gw.jclient.application.controls.itemview.QuickViewer")) : class$com$novell$gw$jclient$application$controls$itemview$QuickViewer));
    private QuickViewerController controller;
    private JComponent quickViewerToolBar;
    private JComponent quickViewerSentItemsToolBar;
    private ItemViewer viewer;
    private JTabbedPane tabView = new OrientableTabbedPane();
    private final JPanel pnlNoItem = new OrientablePanel();
    private boolean isSentItems;
    private JPanel pnlItemProperties;
    private ItemProperties itemPropertiesViewer;
    private ItemDescription mvcModel;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$itemview$QuickViewer;

    public QuickViewer(MVCController mVCController) {
        super(new BorderLayout());
        this.controller = new QuickViewerController(this, mVCController);
        this.setHiden(true);
        this.build();
    }

    private void build() {
        this.pnlNoItem.setName(StringResources.NO_ITEM);
        this.viewer = new ItemViewer(this.controller, "ATTACHLIST_SPLITPOS_QW");
        this.itemPropertiesViewer = new ItemProperties(this.getController());
        this.pnlItemProperties = new JPanel(new BorderLayout());
        this.quickViewerToolBar = new QuickViewerToolBar(this.controller.getActionList());
        this.quickViewerSentItemsToolBar = new QuickViewerSentItemsToolBar(this.controller.getActionList());
        this.tabView.addTab(StringResources.NO_ITEM, this.viewer);
        this.tabView.addTab(StringResources.NO_ITEM, this.pnlItemProperties);
        this.tabView.setSelectedIndex(this.tabView.indexOfComponent(this.viewer));
        this.add((Component)this.tabView, "Center");
        this.tabView.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (QuickViewer.this.mvcModel != null) {
                    Component component = QuickViewer.this.tabView.getSelectedComponent();
                    if (component == QuickViewer.this.pnlItemProperties) {
                        if (QuickViewer.this.pnlItemProperties.getComponentCount() == 0) {
                            QuickViewer.this.pnlItemProperties.add((Component)QuickViewer.this.itemPropertiesViewer, "Center");
                        }
                        QuickViewer.this.itemPropertiesViewer.readHtmlContent();
                        QuickViewer.this.getController().processCommand(new Command(1360));
                    } else if (component == QuickViewer.this.viewer) {
                        QuickViewer.this.getController().processCommand(new Command(1350));
                    }
                }
            }
        });
        this.setShowToolbar();
    }

    public JComponent getTextComponent() {
        return this.viewer.getComponentForFocus();
    }

    public void setController(MVCController mVCController) {
        this.controller = (QuickViewerController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        this.mvcModel = (ItemDescription)object;
        int n = this.tabView.indexOfComponent(this.viewer);
        int n2 = this.tabView.indexOfComponent(this.pnlItemProperties);
        if (this.mvcModel == null) {
            this.tabView.setTitleAt(n, StringResources.NO_ITEM);
            this.tabView.setTitleAt(n2, StringResources.NO_ITEM);
            this.itemPropertiesViewer.clear();
        } else {
            this.tabView.setTitleAt(n, ControlsUtils.getItemTypeName(this.mvcModel.getItem()));
            if (!this.mvcModel.getItem().isPersonal() && this.mvcModel.getItem().canDoInfo()) {
                this.tabView.setTitleAt(n2, StringResources.PROPERTIES_C);
                this.itemPropertiesViewer.setContent(this.mvcModel);
                this.itemPropertiesViewer.readHtmlContent();
            } else {
                this.itemPropertiesViewer.clear();
            }
        }
    }

    public Object getMVCModel() {
        return this.viewer.getContainerItem();
    }

    public void setHiden(boolean bl) {
        this.controller.setEnabled(!bl);
    }

    public boolean isHiden() {
        return !this.controller.isEnabled();
    }

    public void setShowToolbar(boolean bl) {
        this.isSentItems = bl;
        this.setShowToolbar();
    }

    public void setShowToolbar() {
        if (ApplicationOptions.getInstance().getBoolean("ITEM_CONTEXT_TOOLBAR_VISIBLE", true)) {
            if (this.isSentItems) {
                this.remove(this.quickViewerToolBar);
                this.add((Component)this.quickViewerSentItemsToolBar, "North");
            } else {
                this.remove(this.quickViewerSentItemsToolBar);
                this.add((Component)this.quickViewerToolBar, "North");
            }
        } else if (this.isSentItems) {
            this.remove(this.quickViewerSentItemsToolBar);
        } else {
            this.remove(this.quickViewerToolBar);
        }
        this.updateUI();
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.viewer.getFocusPolicy();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

