/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.ApplicationFrame;
import com.appframework.utils.Utils;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemview.SensitiveLabel;
import com.novell.gw.jclient.application.controls.itemview.UneditableTextField;
import com.novell.gw.jclient.application.controls.itemview.actions.AbstractRecipientAction;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionAddToFrequentContacts;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionCopyRecipient;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionEmailToUser;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionViewRecipientInfo;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPopupMenu;

public class RecipientsTextField
extends UneditableTextField {
    private List recipients;
    private static final char[] RECIPIENTS_DELIMITER = new char[]{';'};
    private AbstractRecipientAction actionAddToContacts;
    private AbstractRecipientAction actionViewRecipientInfo;
    private AbstractRecipientAction actionCopyRecipient;
    private AbstractRecipientAction actionSendEmail;

    public RecipientsTextField(List list, SensitiveLabel sensitiveLabel) {
        super(sensitiveLabel);
        this.setRecipients(list);
        this.addMouseListener(new RecipientsTextFieldMouseListener());
    }

    public String getRecipientsText() {
        return ControlsUtils.recipientsToString(this.recipients);
    }

    public void setRecipients(List list) {
        this.recipients = list;
        this.setText(this.getRecipientsText());
    }

    public boolean isAllTextVisible() {
        return ControlsUtils.isComponentTextVisible(this);
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Recipient recipient = this.getSelectedRecipient(mouseEvent.getPoint());
            this.initActions();
            this.actionSendEmail.setRecipient(recipient);
            this.actionAddToContacts.setRecipient(recipient);
            this.actionViewRecipientInfo.setRecipient(recipient);
            this.actionCopyRecipient.setRecipient(recipient);
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (GWClient.USE_EXTERNAL_HTML_VIEWER()) {
                jPopupMenu.setLightWeightPopupEnabled(false);
            }
            jPopupMenu.add(this.actionAddToContacts);
            jPopupMenu.add(this.actionViewRecipientInfo);
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.actionCopyRecipient);
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.actionSendEmail);
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private Recipient getSelectedRecipient(Point point) {
        String string = this.getSeletedDisplayName(point);
        for (int i = 0; i < this.recipients.size(); ++i) {
            Recipient recipient = (Recipient)this.recipients.get(i);
            if (!recipient.getAddressable().getDisplayName().equals(string)) continue;
            return recipient;
        }
        return null;
    }

    private void selectWord(Point point) {
        this.setSelectedTextColor(Utils.invertColor(this.getForeground()));
        this.setSelectionStart(this.getNearestLeftDelimiterIndex(point));
        this.setSelectionEnd(this.getNearestRightDelimiterIndex(point));
        this.setManualSelected(true);
    }

    private int getNearestLeftDelimiterIndex(Point point) {
        String string = this.getText().substring(0, this.viewToModel(point));
        int n = 0;
        for (int i = 0; i < RECIPIENTS_DELIMITER.length; ++i) {
            char c = RECIPIENTS_DELIMITER[i];
            int n2 = string.lastIndexOf(c);
            if (n2 <= n) continue;
            n = n2 + 1;
        }
        return n;
    }

    private int getNearestRightDelimiterIndex(Point point) {
        String string = this.getText().substring(0, this.viewToModel(point));
        int n = string.length();
        int n2 = this.getText().length();
        for (int i = 0; i < RECIPIENTS_DELIMITER.length; ++i) {
            char c = RECIPIENTS_DELIMITER[i];
            int n3 = this.getText().indexOf(c, n);
            if (n3 == -1 || n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private String getSeletedDisplayName(Point point) {
        int n = this.getNearestRightDelimiterIndex(point);
        int n2 = this.getNearestLeftDelimiterIndex(point);
        String string = "";
        string = n2 < 0 || n2 == 0 ? this.getText().substring(0, n) : this.getText().substring(n2 + 1, n);
        return string;
    }

    private void initActions() {
        ApplicationFrame applicationFrame = (ApplicationFrame)ControlsUtils.getWindowForComponent(this);
        if (this.actionAddToContacts == null) {
            this.actionAddToContacts = new ActionAddToFrequentContacts(applicationFrame);
        }
        if (this.actionViewRecipientInfo == null) {
            this.actionViewRecipientInfo = new ActionViewRecipientInfo(applicationFrame);
        }
        if (this.actionCopyRecipient == null) {
            this.actionCopyRecipient = new ActionCopyRecipient();
        }
        if (this.actionSendEmail == null) {
            this.actionSendEmail = new ActionEmailToUser(applicationFrame);
        }
    }

    private class RecipientsTextFieldMouseListener
    extends MouseAdapter {
        private RecipientsTextFieldMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            RecipientsTextField.this.selectWord(mouseEvent.getPoint());
            RecipientsTextField.this.requestFocus();
            RecipientsTextField.this.showPopup(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            RecipientsTextField.this.setCursor(new Cursor(12));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            RecipientsTextField.this.setCursor(new Cursor(0));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            RecipientsTextField.this.showPopup(mouseEvent);
        }
    }
}

