/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.itemviewer;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.components.htmleditor.HTMLExternalTextViewer;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Utils;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionSwitchAttachmentWindow;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentView;
import com.novell.gw.jclient.application.controls.attachmentlist.OpenAttachmentView;
import com.novell.gw.jclient.application.controls.itemview.EmbededParentView;
import com.novell.gw.jclient.application.controls.itemview.GWItemPropertiesPanel;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.ContentViewer;
import com.novell.gw.jclient.application.controls.itemview.itemviewer.ItemViewerController;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageBody;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class ItemViewer
extends JComponent {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$itemview$itemviewer$ItemViewer == null ? (class$com$novell$gw$jclient$application$controls$itemview$itemviewer$ItemViewer = ItemViewer.class$("com.novell.gw.jclient.application.controls.itemview.itemviewer.ItemViewer")) : class$com$novell$gw$jclient$application$controls$itemview$itemviewer$ItemViewer));
    private AttachmentView attachmentView;
    private JSplitPane splitPane;
    private AbstractItem containerItem;
    private AbstractItem currentItem;
    private ContentViewer contentViewer;
    private GWItemPropertiesPanel itemPropertiesPanel;
    private EmbededParentView embededParentView;
    private JPanel mainContent;
    private static final int DEVIDER_SIZE = 4;
    private static long MAX_PREVIEW_FILE_SIZE = 200000L;
    private boolean embededParentViewAdded;
    private DefaultMutableTreeNode itemsTree;
    private ItemViewerController controller;
    private FocusTraversalPolicy focusPolicy;
    private JPanel messagePanel;
    private JPanel attachmentsPanel;
    private String splitterType;
    private boolean attachmentSelected;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$itemview$itemviewer$ItemViewer;

    public ItemViewer(MVCController mVCController, String string) {
        this.splitterType = string;
        this.setLayout(new BorderLayout());
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.controller = new ItemViewerController(this, mVCController);
        this.contentViewer = new ContentViewer(this.controller);
        this.attachmentView = new OpenAttachmentView(true, this.controller);
        this.attachmentView.setPreferredSize(new Dimension(100, 60));
        this.attachmentView.setHideSystemAttachments(this.isHideSystemAttachments());
        this.itemPropertiesPanel = new GWItemPropertiesPanel(this.controller);
        this.embededParentView = new EmbededParentView(this.controller);
        this.focusPolicy = new ViewerFocusPolicy();
        this.itemPropertiesPanel.setVisible(false);
        this.build();
    }

    private void buildEmbededMessageTree() {
        this.itemsTree = new DefaultMutableTreeNode(this.containerItem);
        this.buildTreeNodes(this.itemsTree, this.containerItem.getAttachments());
    }

    private AbstractItem getParentItemFor(AbstractItem abstractItem) {
        return this.getParentItemFor(this.itemsTree, abstractItem);
    }

    private AbstractItem getParentItemFor(DefaultMutableTreeNode defaultMutableTreeNode, AbstractItem abstractItem) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.getUserObject().equals(abstractItem)) {
                return (AbstractItem)defaultMutableTreeNode.getUserObject();
            }
            AbstractItem abstractItem2 = this.getParentItemFor(defaultMutableTreeNode2, abstractItem);
            if (abstractItem2 == null) continue;
            return abstractItem2;
        }
        return null;
    }

    private void buildTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode, IDObjectsCollection iDObjectsCollection) {
        for (int i = 0; i < iDObjectsCollection.size(); ++i) {
            GWAttachment gWAttachment = (GWAttachment)iDObjectsCollection.getIDObjectAt(i);
            if (!gWAttachment.isMessageAttachment()) continue;
            String string = ControlsUtils.getUserGuid(this.controller);
            AbstractItem abstractItem = gWAttachment.getEnclosedItem(string);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(abstractItem);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.buildTreeNodes(defaultMutableTreeNode2, abstractItem.getAttachments());
        }
    }

    public void setItem(AbstractItem abstractItem, boolean bl) {
        boolean bl2 = ApplicationOptions.getInstance().getBoolean("ATTACHLIST_VISIBLE", false);
        this.containerItem = abstractItem;
        if (abstractItem == null) {
            this.contentViewer.clear();
            this.itemPropertiesPanel.setVisible(false);
        } else {
            this.itemPropertiesPanel.setVisible(true);
            if (!bl) {
                bl2 = abstractItem.hasExtendedAttachments();
            }
            this.buildEmbededMessageTree();
            this.setCurrentItem(abstractItem);
            this.setupItemMessage();
            this.getController().updatePlainHTML();
            if (abstractItem instanceof DocumentItem) {
                this.attachmentView.selectAttachment(((DocumentItem)abstractItem).getAttachments().getIDObjectAt(0));
            }
        }
        this.attachmentSelected = false;
        if (ApplicationOptions.getInstance().getBoolean("ATTACHLIST_VISIBLE", false) != bl2) {
            ActionSwitchAttachmentWindow actionSwitchAttachmentWindow = (ActionSwitchAttachmentWindow)this.getController().getActionList().getAction("Attachment Window");
            actionSwitchAttachmentWindow.performSwitch(bl2);
        }
    }

    private void setCurrentItem(AbstractItem abstractItem) {
        this.attachmentView.setMVCModel(abstractItem);
        this.currentItem = abstractItem;
        this.itemPropertiesPanel.setParentItem(this.containerItem);
        this.itemPropertiesPanel.setMVCModel(abstractItem);
    }

    public ItemViewerController getController() {
        return this.controller;
    }

    void setAttachment(Object object) {
        if (object instanceof GWAttachment) {
            GWAttachment gWAttachment = (GWAttachment)object;
            this.refreshAttachment(gWAttachment);
            AbstractItem abstractItem = this.getParentItemFor(this.currentItem);
            if (abstractItem != null) {
                this.currentItem = abstractItem;
            }
            this.updateEmbededParentView();
            this.attachmentSelected = true;
        } else if (object instanceof AbstractItem) {
            AbstractItem abstractItem = (AbstractItem)object;
            if (!abstractItem.equals(this.currentItem) || this.attachmentSelected) {
                this.viewEmbededMessage(abstractItem);
            }
            this.attachmentSelected = false;
        }
    }

    void setEmbededMessage(AbstractItem abstractItem) {
        this.setCurrentItem(abstractItem);
        this.viewEmbededMessage(abstractItem);
        this.getController().updatePlainHTML();
    }

    private void viewEmbededMessage(AbstractItem abstractItem) {
        this.currentItem = abstractItem;
        this.setupItemMessage();
        this.updateEmbededParentView();
    }

    private void updateEmbededParentView() {
        AbstractItem abstractItem = this.getParentItemFor(this.currentItem);
        if (abstractItem != null) {
            this.embededParentView.setMVCModel(abstractItem);
        }
        this.setEmbededParentViewVisible(abstractItem != null);
    }

    public void setupHTMLView() {
        this.setupHTMLMessage();
    }

    public void setupPlainTextMessage() {
        if (this.getMessageBody().isRTFMessage()) {
            String string = this.getMessageBody().getRTFMessage();
            this.setupRTFMessage(string);
        } else {
            this.setupPlainMessage(this.getMessageBody().getMessage());
        }
    }

    private void build() {
        this.messagePanel = new OrientablePanel(new BorderLayout());
        this.messagePanel.setBorder(BorderFactory.createEmptyBorder());
        this.messagePanel.add((Component)this.contentViewer, "Center");
        this.attachmentsPanel = new OrientablePanel(new BorderLayout());
        this.attachmentsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.attachmentsPanel.add((Component)this.attachmentView, "Center");
        this.splitPane = new GWSplitPane(0, this.messagePanel, this.attachmentsPanel);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerSize(4);
        this.splitPane.addPropertyChangeListener(new DividerPositionListener(this.splitterType, this.splitPane));
        this.mainContent = new OrientablePanel(new BorderLayout());
        this.mainContent.setBorder(BorderFactory.createEmptyBorder());
        this.mainContent.add((Component)this.itemPropertiesPanel, "North");
        this.mainContent.add((Component)this.splitPane, "Center");
        this.add((Component)this.mainContent, "Center");
        this.setShowAttachments();
    }

    private void refreshAttachment(GWAttachment gWAttachment) {
        String string = Utils.getExtention(gWAttachment.getFileName());
        this.contentViewer.clear();
        try {
            if (ControlsUtils.isImage(string)) {
                GWEngineUtils.saveAttachment(gWAttachment);
                this.contentViewer.setupImage(ControlsUtils.getAttachmentFilePath(gWAttachment).getAbsolutePath());
            } else if (ControlsUtils.isPDF(string)) {
                this.contentViewer.setupMessage(StringResources.PDF_SHOULD_BE_VIEWED_WITH_AN_EXTERN);
            } else if (gWAttachment.getSize() > MAX_PREVIEW_FILE_SIZE) {
                this.contentViewer.setupMessage(StringResources.THE_ATTACHMENT_IS_TOO_LARGE);
            } else if (ControlsUtils.isHTML(string)) {
                GWEngineUtils.saveAttachment(gWAttachment);
                this.contentViewer.setupHTMLPage(ControlsUtils.getAttachmentFilePath(gWAttachment).getAbsolutePath());
            } else if (ControlsUtils.isText(string)) {
                GWEngineUtils.saveAttachment(gWAttachment);
                this.contentViewer.setupText(ControlsUtils.getAttachmentFilePath(gWAttachment).getAbsolutePath());
            } else if (ControlsUtils.isRTF(string)) {
                GWEngineUtils.saveAttachment(gWAttachment);
                this.contentViewer.setupRTF(ControlsUtils.getAttachmentFilePath(gWAttachment).getAbsolutePath());
            } else {
                this.contentViewer.setupMessage(StringResources.THE_ATTACHMENT_CAN_ONLY_BE);
            }
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException);
            logger.debug((Object)gWCommandException, (Throwable)gWCommandException);
        }
    }

    public void reloadMessage() {
        if (this.contentViewer.getViewMode() == 1) {
            this.setupHTMLMessage();
        } else if (this.contentViewer.getViewMode() == 2) {
            this.setupPlainTextMessage();
        }
    }

    public void zoom(boolean bl) {
        this.contentViewer.zoom(bl);
    }

    public void resetZoom() {
        if (GWClient.USE_EXTERNAL_HTML_VIEWER() && this.contentViewer.getViewMode() == 1) {
            this.contentViewer.resetZoom();
        } else {
            this.reloadMessage();
        }
    }

    private void setupItemMessage() {
        MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
        boolean bl = textOption.isDefaultReadHTML();
        boolean bl2 = textOption.isPlainTextReadForced();
        boolean bl3 = textOption.isHTMLDisallowed();
        if (this.currentItem.isHTMLMessage() && !bl3 && (bl || !this.currentItem.hasBodyText() && !bl2)) {
            this.setupHTMLMessage();
        } else {
            this.setupPlainTextMessage();
        }
    }

    private MessageBody getMessageBody() {
        return this.currentItem != null ? this.currentItem.getMessage() : new MessageBody(null);
    }

    private void setupPlainMessage(String string) {
        this.contentViewer.setupMessage(string);
    }

    private void setupRTFMessage(String string) {
        this.contentViewer.setupRTFMessage(string);
    }

    private void setupHTMLMessage() {
        if (!this.currentItem.isHTMLMessage()) {
            throw new IllegalStateException("Trying to show plain text message as HTML. Current item: [" + this.currentItem + "]");
        }
        String string = this.currentItem.getHTMLBodyTextFile();
        this.contentViewer.setupHTMLPage(string);
    }

    public AbstractItem getContainerItem() {
        return this.containerItem;
    }

    public AbstractItem getCurrentItem() {
        return this.currentItem;
    }

    void setEmbededParentViewVisible(boolean bl) {
        if (bl) {
            if (!this.embededParentViewAdded) {
                this.add((Component)this.embededParentView, "North");
            }
        } else if (this.embededParentViewAdded) {
            this.remove(this.embededParentView);
        }
        this.embededParentViewAdded = bl;
        this.validate();
    }

    public void setShowAttachments() {
        if (ApplicationOptions.getInstance().getBoolean("ATTACHLIST_VISIBLE", false)) {
            this.splitPane.setBottomComponent(this.attachmentsPanel);
            this.splitPane.setDividerSize(4);
            int n = ApplicationOptions.getInstance().getInteger(this.splitterType, -1);
            if (n <= 0) {
                this.splitPane.resetToPreferredSizes();
            } else {
                this.splitPane.setDividerLocation(n);
            }
        } else {
            this.splitPane.setBottomComponent(null);
            this.splitPane.setDividerSize(0);
        }
        this.invalidate();
        this.repaint();
    }

    private Boolean isHideSystemAttachments() {
        EnvironmentOptions environmentOptions = OptionManager.getInstance().getEnvironmentOptions();
        return environmentOptions.isHideSystemAttachments();
    }

    public void openParentMessage() {
        AbstractItem abstractItem = this.getParentItemFor(this.currentItem);
        if (abstractItem != null) {
            AbstractItem abstractItem2 = this.getParentItemFor(abstractItem);
            if (abstractItem2 == null) {
                this.setEmbededParentViewVisible(false);
            } else {
                this.embededParentView.setMVCModel(abstractItem2);
                this.setEmbededParentViewVisible(true);
            }
            this.setCurrentItem(abstractItem);
        }
    }

    public int getViewMode() {
        return this.contentViewer.getViewMode();
    }

    public void setHideSystemAttachments() {
        this.attachmentView.setHideSystemAttachments(this.isHideSystemAttachments());
        this.itemPropertiesPanel.setHideSystemAttachments(this.isHideSystemAttachments());
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.focusPolicy;
    }

    public JComponent getComponentForFocus() {
        return this.contentViewer.getTextComponent();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ViewerFocusPolicy
    extends LayoutFocusTraversalPolicy {
        private ViewerFocusPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            Component component2 = FocusManager.getCurrentManager().getPermanentFocusOwner();
            if (!component.hasFocus()) {
                return component2;
            }
            if (component.equals(ItemViewer.this.attachmentView.getListContent())) {
                return this.getFirstComponent(SwingUtilities.getWindowAncestor(ItemViewer.this));
            }
            return super.getComponentAfter(container, component);
        }

        public Component getComponentBefore(Container container, Component component) {
            if (SwingUtilities.getWindowAncestor(ItemViewer.this) != null && component.equals(this.getFirstComponent(SwingUtilities.getWindowAncestor(ItemViewer.this)))) {
                if (ItemViewer.this.attachmentView.isShowing()) {
                    return ItemViewer.this.attachmentView.getListContent();
                }
                return ItemViewer.this.contentViewer.getTextComponent();
            }
            return super.getComponentBefore(container, component);
        }

        public Component getDefaultComponent(Container container) {
            JComponent jComponent = ItemViewer.this.getComponentForFocus();
            if (jComponent instanceof HTMLExternalTextViewer) {
                return ((HTMLExternalTextViewer)jComponent).getBrowser();
            }
            return jComponent;
        }
    }
}

