/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.popedit;

import com.appframework.ActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.popedit.ComboEdit;
import com.novell.gw.jclient.application.controls.popedit.ComboEditController;
import com.novell.gw.jclient.application.controls.popedit.PopupList;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import org.apache.log4j.Logger;

public class ComboEditImpl
extends SearchTextField
implements MVCView,
ComboEdit {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$popedit$ComboEditImpl == null ? (class$com$novell$gw$jclient$application$controls$popedit$ComboEditImpl = ComboEditImpl.class$("com.novell.gw.jclient.application.controls.popedit.ComboEditImpl")) : class$com$novell$gw$jclient$application$controls$popedit$ComboEditImpl));
    private CustomPopupMenu popup;
    private ComboEditController controller;
    private int copyType;
    private PopupList list;
    private boolean shouldHaveFocus = false;
    private String initialValue = "";
    private boolean initialValueSet = false;
    private FocusListener listFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (component != ComboEditImpl.this && ComboEditImpl.this.list.getRecipients().size() != 0) {
                ComboEditImpl.this.processLostFocus();
            } else {
                ComboEditImpl.this.list.clearSelection();
            }
        }
    };
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$popedit$ComboEditImpl;

    public ComboEditImpl(MVCController mVCController, int n) {
        this.copyType = n;
        this.controller = new ComboEditController(this, mVCController);
        this.popup = new CustomPopupMenu();
        this.popup.setBorderPainted(false);
        this.list = new PopupList(this.controller, this);
        this.list.setComponentOrientation(UIUtils.getComponentOrientation());
        this.popup.add((Component)new OrientableScrollPane(this.list), "Center");
        PEKeyListener pEKeyListener = new PEKeyListener();
        PEMouseListener pEMouseListener = new PEMouseListener();
        CEMouseListener cEMouseListener = new CEMouseListener();
        this.list.addMouseListener(pEMouseListener);
        this.list.addKeyListener(pEKeyListener);
        this.list.addFocusListener(this.listFocusListener);
        this.addMouseListener(cEMouseListener);
        this.addKeyListener(pEKeyListener);
        this.addFocusListener(new PEFocusListener());
        this.addHierarchyBoundsListener(new PEHierarchyBoundsListener());
        this.setListener(new SearchResultListener(){

            public void searchFinished(SearchEvent searchEvent) {
                ComboEditImpl.this.list.addRecipient(new Recipient(searchEvent.getFoundContact(), ComboEditImpl.this.copyType));
                ComboEditImpl.this.showRecipientsPopupList();
            }
        });
        this.setTransferHandler(new CETransferHandler());
    }

    public void setMVCModel(Object object) {
    }

    public Object getMVCModel() {
        return null;
    }

    public OrientableTextField getComponent() {
        return this;
    }

    public void clear() {
        this.list.removeAllRecipients();
        this.setText("");
        this.initialValue = "";
        this.initialValueSet = false;
    }

    public void setRecipients(List list) {
        this.list.removeAllRecipients();
        this.addRecipients(list);
    }

    private void addRecipients(List list) {
        this.list.addRecipients(list);
        this.callPopup();
        this.processRecipientsAdded();
    }

    public void addContact(Addressable addressable) {
        this.list.addRecipient(new Recipient(addressable, this.copyType));
    }

    public List getRecipients() {
        if (this.popup.isVisible() || this.list.getRecipients().isEmpty()) {
            this.addToRecipiensList();
        }
        return this.list.getRecipients();
    }

    private void displayRecipients() {
        String string = this.list.getFormattedString();
        this.setText(string);
        this.setInitialValue(string);
    }

    public void setController(MVCController mVCController) {
        if (!(mVCController instanceof ComboEditController)) {
            throw new IllegalArgumentException();
        }
        this.controller = (ComboEditController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    private void callPopup() {
        if (this.hasFocus() && this.isShowing()) {
            this.showRecipientsPopupList();
        } else if (!this.popup.isVisible()) {
            this.displayRecipients();
        }
    }

    private void showRecipientsPopupList() {
        int n = 0;
        int n2 = this.getHeight();
        if (this.list.getRecipients().size() > 0 && this.hasFocus()) {
            this.showPopupList(n, n2);
        }
    }

    private void showPopupList(int n, int n2) {
        if (!this.popup.isVisible()) {
            this.setText("");
            Dimension dimension = this.popup.getPreferredSize();
            dimension.width = this.getWidth();
            this.popup.setPreferredSize(dimension);
            this.popup.setFocusable(false);
            this.popup.show(this, n, n2);
            this.popup.setFocusable(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ComboEditImpl.this.requestFocus();
                }
            });
        }
    }

    void pasteRecipients() {
        this.paste();
    }

    void copyRecipients() {
        this.list.copyToClipboard();
    }

    void cutRecipients() {
        this.list.cut();
    }

    void removeRecipient(Collection collection) {
        this.list.removeRecipient(collection);
        if (this.list.getModel().getSize() == 0) {
            this.popup.dismiss();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ComboEditImpl.this.requestFocusInWindow(true);
                }
            });
        }
        this.processRecipientsAdded();
    }

    void editSelectedObject(List list) {
        this.list.removeRecipient(list);
        this.addToRecipiensList();
        this.processRecipientsAdded();
        Recipient recipient = (Recipient)list.toArray()[0];
        this.setText(recipient.getAddressable().getDisplayName());
        this.setInitialValue(this.getText());
        if (recipient.getAddressable() instanceof Contact) {
            if (this.foundContacts == null) {
                this.foundContacts = new ArrayList();
            }
            this.foundContacts.add(recipient.getAddressable());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComboEditImpl.this.requestFocusInWindow(true);
                ComboEditImpl.this.selectAll();
            }
        });
    }

    private void processRecipientsAdded() {
        if (this.copyType == 1) {
            String string = this.list.getFormattedString();
            Command command = new Command(1130, string);
            this.controller.processCommand(command);
        }
    }

    PopupList getPopupList() {
        return this.list;
    }

    public int getRecipientsCount() {
        return this.list.getModel().getSize();
    }

    private void processLostFocus() {
        if (this.popup.isVisible()) {
            this.popup.dismiss();
        }
        this.select(0, 0);
        this.addToRecipiensList();
        this.displayRecipients();
        this.processRecipientsAdded();
    }

    private void processAddToList() {
        this.processFocusEvents = false;
        this.addToRecipiensList();
        this.processRecipientsAdded();
        this.processFocusEvents = true;
    }

    public void selectAllRecipients() {
        this.list.selectAll();
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(String string) {
        if (!this.initialValueSet) {
            this.initialValue = string;
            this.initialValueSet = true;
        }
    }

    public boolean isDirty() {
        return !this.initialValue.equals(this.list.getFormattedString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PEKeyListener
    extends KeyAdapter {
        private PEKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n;
            Object object = keyEvent.getSource();
            int n2 = keyEvent.getKeyCode();
            if (object == ComboEditImpl.this) {
                if (n2 == 10) {
                    ComboEditImpl.this.processAddToList();
                } else if (n2 == 40) {
                    if (ComboEditImpl.this.shouldHaveFocus) {
                        int n3 = ComboEditImpl.this.list.getSelectedIndex();
                        int n4 = ComboEditImpl.this.list.getModel().getSize();
                        if (n3 < --n4) {
                            ++n3;
                        }
                        ComboEditImpl.this.list.selectAtIndex(n3);
                    } else {
                        String string = ComboEditImpl.this.getText();
                        if (string == null || string.length() == 0) {
                            ComboEditImpl.this.list.selectAtIndex(0);
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ PEKeyListener this$1;
                                {
                                    this.this$1 = pEKeyListener;
                                }

                                public void run() {
                                    if (OS.isMacOS()) {
                                        ComboEditImpl.access$1902(PEKeyListener.access$2100(this.this$1), true);
                                    }
                                    ComboEditImpl.access$000(PEKeyListener.access$2100(this.this$1)).requestFocus();
                                }
                            });
                        }
                    }
                } else if (n2 == 38) {
                    if (ComboEditImpl.this.shouldHaveFocus) {
                        int n5 = ComboEditImpl.this.list.getSelectedIndex();
                        if (n5 == 0 || n5 == -1) {
                            ComboEditImpl.this.shouldHaveFocus = false;
                            ComboEditImpl.this.list.clearSelection();
                            ComboEditImpl.this.requestFocus();
                        } else {
                            ComboEditImpl.this.list.selectAtIndex(--n5);
                        }
                    }
                } else if (n2 == OptionManager.getInstance().getGeneralOptions().getItemDeleteKey()) {
                    if (ComboEditImpl.this.shouldHaveFocus) {
                        ActionList actionList = (ActionList)ComboEditImpl.this.getController();
                        actionList.performAction("CE_Delete");
                        keyEvent.consume();
                    }
                } else if (ComboEditImpl.this.shouldHaveFocus) {
                    ComboEditImpl.this.shouldHaveFocus = false;
                }
            } else if (object == ComboEditImpl.this.list && n2 == 38 && ((n = ComboEditImpl.this.list.getSelectedIndex()) == 0 || n == -1)) {
                ComboEditImpl.this.requestFocus();
            }
        }

        static /* synthetic */ ComboEditImpl access$2100(PEKeyListener pEKeyListener) {
            return pEKeyListener.ComboEditImpl.this;
        }
    }

    private class PEMouseListener
    extends MouseAdapter {
        private PEMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (OS.isMacOS()) {
                ComboEditImpl.this.shouldHaveFocus = true;
            }
        }
    }

    private class CEMouseListener
    extends MouseAdapter {
        private CEMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ComboEditImpl.this.shouldHaveFocus = false;
        }
    }

    private class PEHierarchyBoundsListener
    implements HierarchyBoundsListener {
        private PEHierarchyBoundsListener() {
        }

        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            ComboEditImpl comboEditImpl = ComboEditImpl.this;
            if (comboEditImpl.popup.isShowing()) {
                SwingUtilities.invokeLater(new Runnable(this, comboEditImpl){
                    private final /* synthetic */ ComboEditImpl val$edit;
                    private final /* synthetic */ PEHierarchyBoundsListener this$1;
                    {
                        this.this$1 = pEHierarchyBoundsListener;
                        this.val$edit = comboEditImpl;
                    }

                    public void run() {
                        int n = this.val$edit.getLocationOnScreen().x;
                        int n2 = this.val$edit.getLocationOnScreen().y;
                        int n3 = this.val$edit.getHeight();
                        ComboEditImpl.access$1300(this.val$edit).setLocation(n, n2 + n3);
                    }
                });
            }
        }

        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ PEHierarchyBoundsListener this$1;
                {
                    this.this$1 = pEHierarchyBoundsListener;
                }

                public void run() {
                    ComboEditImpl comboEditImpl = PEHierarchyBoundsListener.access$1800(this.this$1);
                    if (ComboEditImpl.access$1300(comboEditImpl).isVisible()) {
                        Dimension dimension = ComboEditImpl.access$1300(PEHierarchyBoundsListener.access$1800(this.this$1)).getSize();
                        dimension.width = comboEditImpl.getWidth();
                        ComboEditImpl.access$1300(PEHierarchyBoundsListener.access$1800(this.this$1)).setPreferredSize(dimension);
                        ComboEditImpl.access$1300(PEHierarchyBoundsListener.access$1800(this.this$1)).validate();
                    }
                }
            });
        }

        static /* synthetic */ ComboEditImpl access$1800(PEHierarchyBoundsListener pEHierarchyBoundsListener) {
            return pEHierarchyBoundsListener.ComboEditImpl.this;
        }
    }

    private class PEFocusListener
    implements FocusListener {
        private PEFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!ComboEditImpl.this.popup.isVisible() && ComboEditImpl.this.isShowing()) {
                if (ComboEditImpl.this.list.getRecipients().size() == 0 && !focusEvent.isTemporary()) {
                    ComboEditImpl.this.addToRecipiensList();
                    ComboEditImpl.this.processRecipientsAdded();
                }
                ComboEditImpl.this.showRecipientsPopupList();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (ComboEditImpl.this.processFocusEvents && component != ComboEditImpl.this.popup.getRootPane() && component != ComboEditImpl.this.list && component != ComboEditImpl.this.list.getRootPane()) {
                ComboEditImpl.this.list.clearSelection();
                ComboEditImpl.this.processLostFocus();
            }
        }

        private void walkParentHierarchy(Component component) {
            System.out.println("component hierarchy --------------------------------");
            while (component != null) {
                System.out.println(component.hashCode() + " " + component.getClass().getName());
                component = component.getParent();
            }
        }
    }

    class CustomPopupMenu
    extends JPopupMenu {
        CustomPopupMenu() {
        }

        public void setVisible(boolean bl) {
            if (bl) {
                super.setVisible(true);
            }
        }

        public void dismiss() {
            this.setFocusable(false);
            super.setVisible(false);
            this.setFocusable(true);
        }
    }

    private class CETransferHandler
    extends TransferHandler
    implements UIResource {
        private CETransferHandler() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return Arrays.asList(dataFlavorArray).contains(DataFlavor.stringFlavor);
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                if (transferable.isDataFlavorSupported(GWFlavors.contactsFlavor)) {
                    List list = (List)transferable.getTransferData(GWFlavors.contactsFlavor);
                    for (int i = 0; i < list.size(); ++i) {
                        Addressable addressable = (Addressable)list.get(i);
                        ComboEditImpl.this.addContact(addressable);
                    }
                } else {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    string = string.replace('\n', ';');
                    if ((string = string.replace('\u00a0', ' ')).length() > 0 && string.indexOf(59) == -1) {
                        string = string + ';';
                    }
                    ComboEditImpl.this.parseString(string);
                }
                if (!ComboEditImpl.this.popup.isShowing()) {
                    ComboEditImpl.this.displayRecipients();
                }
                ComboEditImpl.this.processRecipientsAdded();
            }
            catch (Exception exception) {
                logger.error((Object)exception);
                logger.debug((Object)exception, (Throwable)exception);
            }
            return true;
        }
    }
}

