/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.standardgwitemtable;

import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListColumnsModel;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColumnsDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfo;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfos;
import com.novell.gw.jclient.bl.eng_impl.utils.SortOrder;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class HeaderPopupMenu
extends JPopupMenu {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$standardgwitemtable$HeaderPopupMenu == null ? (class$com$novell$gw$jclient$application$controls$standardgwitemtable$HeaderPopupMenu = HeaderPopupMenu.class$("com.novell.gw.jclient.application.controls.standardgwitemtable.HeaderPopupMenu")) : class$com$novell$gw$jclient$application$controls$standardgwitemtable$HeaderPopupMenu));
    private static final int[] DEFAULT_ITEMS_COLUMNS = new int[]{44, 34, 220, 21, 61, 885, 88, 27, 35, 116, 97};
    private static final int[] DEFAULT_CONTACTS_COLUMNS = new int[]{422, 816, 50, 278, 279, 429, 88, 38, 355, 31};
    private JMenuItem miSortAscending = OS.createMenuItemForAction(new ChangeSortingMenuItemAction(StringResources.ASCENDING), true);
    private JMenuItem miSortDescending = OS.createMenuItemForAction(new ChangeSortingMenuItemAction(StringResources.DESCENDING), true);
    private JMenuItem miMoreColumns = OS.createMenuItemForAction(new MoreColumnsMenuItemAction(StringResources.MORE_COLUMNS));
    private JMenuItem miDeleteColumn = OS.createMenuItemForAction(new DeleteColumnMenuItemAction(StringResources.DELETE));
    private ItemListColumnsModel itemListModel;
    private int selectedColumnModelIndex;
    private ColumnInfos allColumnInfos;
    private int[] quickColumnsFildIDs;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$standardgwitemtable$HeaderPopupMenu;

    public ItemListColumnsModel getItemListModel() {
        return this.itemListModel;
    }

    public int getSelectedColumnModelIndex() {
        return this.selectedColumnModelIndex;
    }

    public void show(Component component, Point point, ItemListColumnsModel itemListColumnsModel, int n, String string) {
        this.itemListModel = itemListColumnsModel;
        this.selectedColumnModelIndex = n;
        this.initAllColumnsInfo(string);
        this.rebuildMenu();
        this.setLocation(point);
        this.show(component, point.x, point.y);
    }

    private void initAllColumnsInfo(String string) {
        AbstractFolder abstractFolder = this.getItemListModel().getFolder();
        boolean bl = abstractFolder != null && abstractFolder.getType() == "Contacts";
        this.allColumnInfos = new ColumnInfos(GWCommandManager.getInstance(string).getCurrentDataStore().getDisplayColumnFields(bl));
        this.quickColumnsFildIDs = bl ? DEFAULT_CONTACTS_COLUMNS : DEFAULT_ITEMS_COLUMNS;
    }

    private ColumnInfos getColumnInfos() {
        return this.itemListModel != null ? this.itemListModel.getColumnInfos() : null;
    }

    private ColumnInfos getAllColumnInfos() {
        return this.allColumnInfos;
    }

    private int[] getQuickColumnsFildIDs() {
        return this.quickColumnsFildIDs;
    }

    private void rebuildMenu() {
        this.removeAll();
        if (this.getItemListModel() != null) {
            if (this.getSelectedColumnModelIndex() >= 0) {
                this.selectSortingMenuItems();
                this.add(this.miSortAscending);
                this.add(this.miSortDescending);
                this.addSeparator();
                this.add(this.miDeleteColumn);
                this.addSeparator();
            }
            if (this.getQuickColumnsFildIDs().length > 0) {
                for (int i = 0; i < this.getQuickColumnsFildIDs().length; ++i) {
                    int n = this.getQuickColumnsFildIDs()[i];
                    boolean bl = this.getColumnInfos().getColumnInfo(n) != null;
                    ColumnInfo columnInfo = this.getAllColumnInfos().getColumnInfo(n);
                    if (bl || columnInfo == null) continue;
                    this.add(new JMenuItem(new QuickAddColumnMenuItemAction(columnInfo)));
                }
                this.addSeparator();
            }
            this.add(this.miMoreColumns);
        }
    }

    private void selectSortingMenuItems() {
        ColumnInfo columnInfo = this.getColumnInfos().getColumnInfoAt(this.getSelectedColumnModelIndex());
        this.miSortAscending.setSelected(columnInfo.isSortedAscending());
        this.miSortDescending.setSelected(columnInfo.isSortedDescending());
    }

    private void saveChangedColumnInfos(ColumnInfos columnInfos) {
        AbstractFolder abstractFolder = this.getItemListModel().getFolder();
        if (abstractFolder != null) {
            abstractFolder.getFolderDisplaySettings().setColumnInfos(columnInfos);
            GWClient.getApplication().processCommand(new GlobalCommand(1010, abstractFolder));
            GWClient.getApplication().processCommand(new GlobalCommand(1020, abstractFolder));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DeleteColumnMenuItemAction
    extends AbstractAction {
        public DeleteColumnMenuItemAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = HeaderPopupMenu.this.getSelectedColumnModelIndex();
            if (n >= 0) {
                HeaderPopupMenu.this.getColumnInfos().removeColumnInfoAt(n);
                HeaderPopupMenu.this.saveChangedColumnInfos(HeaderPopupMenu.this.getColumnInfos());
            }
        }
    }

    private class QuickAddColumnMenuItemAction
    extends AbstractAction {
        private ColumnInfo columnInfo;

        public QuickAddColumnMenuItemAction(ColumnInfo columnInfo) {
            super(columnInfo.getName());
            this.columnInfo = columnInfo;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HeaderPopupMenu.this.getColumnInfos().add(this.columnInfo);
            HeaderPopupMenu.this.saveChangedColumnInfos(HeaderPopupMenu.this.getColumnInfos());
        }
    }

    private class MoreColumnsMenuItemAction
    extends AbstractAction {
        public MoreColumnsMenuItemAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ColumnInfos columnInfos = HeaderPopupMenu.this.getColumnInfos();
                ColumnInfos columnInfos2 = HeaderPopupMenu.this.getAllColumnInfos();
                ColumnInfos columnInfos3 = ColumnInfos.getDifferenceByFieldID(columnInfos2, columnInfos);
                ColumnInfos columnInfos4 = (ColumnInfos)columnInfos.clone();
                ColumnsDialog columnsDialog = new ColumnsDialog((JFrame)SwingUtilities.windowForComponent(HeaderPopupMenu.this.getInvoker()), columnInfos4, columnInfos3);
                columnsDialog.showMe();
                if (columnsDialog.isActionCompleteSuccessfully() && !columnInfos.equals(columnInfos4)) {
                    HeaderPopupMenu.this.saveChangedColumnInfos(columnInfos4);
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            }
        }
    }

    private class ChangeSortingMenuItemAction
    extends AbstractAction {
        public ChangeSortingMenuItemAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = HeaderPopupMenu.this.getSelectedColumnModelIndex();
            ColumnInfo columnInfo = HeaderPopupMenu.this.getColumnInfos().getColumnInfoAt(n);
            if (HeaderPopupMenu.this.miSortAscending == actionEvent.getSource() && !columnInfo.isSortedAscending()) {
                this.sortColumn(n, SortOrder.ASCENDING);
            } else if (HeaderPopupMenu.this.miSortDescending == actionEvent.getSource() && !columnInfo.isSortedDescending()) {
                this.sortColumn(n, SortOrder.DESCENDING);
            }
        }

        private void sortColumn(int n, SortOrder sortOrder) {
            HeaderPopupMenu.this.getItemListModel().sortColumnByModelIndex(n, sortOrder);
            HeaderPopupMenu.this.getInvoker().repaint();
        }
    }
}

