/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.standardgwitemtable;

import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.HeaderRenderer;
import com.novell.gw.jclient.application.HeaderSortRenderer;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.standardgwitemtable.GWTableCellRenderer;
import com.novell.gw.jclient.bl.eng_impl.utils.APIUtils;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfo;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfos;
import com.novell.gw.jclient.bl.eng_impl.utils.SortOrder;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CheckListFolder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class ItemListColumnsModel
implements TableColumnModel,
PropertyChangeListener,
Serializable {
    private static final Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListColumnsModel == null ? (class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListColumnsModel = ItemListColumnsModel.class$("com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListColumnsModel")) : class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListColumnsModel));
    protected Vector tableColumns;
    protected int columnMargin;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;
    private int imageColumnWidth;
    private GWTableCellRenderer cellRenderer;
    private HeaderSortRenderer sortHeaderRenderer;
    private HeaderRenderer headerRenderer;
    private ColumnInfos columnInfos;
    private AbstractFolder folder;
    private boolean columnMoved = false;
    private boolean columnSizeChanged = false;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListColumnsModel;
    static /* synthetic */ Class class$javax$swing$event$TableColumnModelListener;

    public ItemListColumnsModel(AbstractFolder abstractFolder, ColumnInfos columnInfos, int n) {
        this.folder = abstractFolder;
        this.tableColumns = new Vector();
        if (OS.isMacOS()) {
            this.setColumnMargin(0);
        } else {
            this.setColumnMargin(1);
        }
        this.invalidateWidthCache();
        this.columnInfos = columnInfos;
        this.imageColumnWidth = n;
        this.cellRenderer = new GWTableCellRenderer();
        this.sortHeaderRenderer = new HeaderSortRenderer(ControlsUtils.getHeaderRendererSize());
        this.headerRenderer = new HeaderRenderer(ControlsUtils.getHeaderRendererSize());
        this.initColumns();
        this.initSortRenderer();
    }

    public ItemListColumnsModel(ColumnInfos columnInfos, int n) {
        this(null, columnInfos, n);
    }

    private void initSortRenderer() {
        ColumnInfo columnInfo = this.columnInfos.getSorted();
        if (columnInfo == null) {
            return;
        }
        boolean bl = APIUtils.isSortAscending(columnInfo.getSortOrder().getID());
        int n = this.getColumnIndex(this.columnInfos.getIndexOf(columnInfo));
        this.sortHeaderRenderer.setSorted(n, bl);
    }

    private void initColumns() {
        TableColumn tableColumn;
        if (this.imageColumnWidth > 0) {
            tableColumn = new TableColumn();
            tableColumn.setPreferredWidth(this.imageColumnWidth);
            tableColumn.setMinWidth(this.imageColumnWidth);
            tableColumn.setMaxWidth(this.imageColumnWidth);
            tableColumn.setCellRenderer(this.cellRenderer);
            tableColumn.setResizable(false);
            tableColumn.setHeaderValue("");
            tableColumn.setHeaderRenderer(this.headerRenderer);
            tableColumn.setModelIndex(0);
            this.addColumn(tableColumn);
        }
        ColumnInfo[] columnInfoArray = this.columnInfos.toArray();
        for (int i = 0; i < columnInfoArray.length; ++i) {
            ColumnInfo columnInfo = columnInfoArray[i];
            tableColumn = new TableColumn();
            tableColumn.setPreferredWidth(columnInfo.getWidth());
            tableColumn.setHeaderValue(columnInfo.getName());
            tableColumn.setCellRenderer(this.cellRenderer);
            if (!(this.folder instanceof CheckListFolder)) {
                tableColumn.setHeaderRenderer(this.sortHeaderRenderer);
            }
            tableColumn.setModelIndex(this.columnInfos.getIndexOf(columnInfo));
            this.addColumn(tableColumn);
        }
    }

    public ColumnInfos getColumnInfos() {
        return this.columnInfos;
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.tableColumns.addElement(tableColumn);
        tableColumn.addPropertyChangeListener(this);
        this.invalidateWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
    }

    public void removeColumn(TableColumn tableColumn) {
        int n = this.tableColumns.indexOf(tableColumn);
        if (n != -1) {
            tableColumn.removePropertyChangeListener(this);
            this.tableColumns.removeElementAt(n);
            this.invalidateWidthCache();
            this.fireColumnRemoved(new TableColumnModelEvent(this, n, 0));
        }
    }

    public void moveColumn(int n, int n2) {
        if (n < 0 || n >= this.getColumnCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        if (n2 == 0 || n == 0) {
            return;
        }
        if (n == n2) {
            this.fireColumnMoved(new TableColumnModelEvent(this, n, n2));
            return;
        }
        TableColumn tableColumn = (TableColumn)this.tableColumns.elementAt(n);
        TableColumn tableColumn2 = (TableColumn)this.tableColumns.elementAt(n2);
        ColumnInfo columnInfo = this.columnInfos.getColumnInfoAt(tableColumn.getModelIndex());
        ColumnInfo columnInfo2 = this.columnInfos.getColumnInfoAt(tableColumn2.getModelIndex());
        this.columnInfos.moveInfos(columnInfo, columnInfo2);
        tableColumn.setModelIndex(this.columnInfos.getIndexOf(columnInfo));
        tableColumn2.setModelIndex(this.columnInfos.getIndexOf(columnInfo2));
        this.tableColumns.set(n, this.tableColumns.set(n2, tableColumn));
        this.initSortRenderer();
        this.columnMoved = true;
        this.fireColumnMoved(new TableColumnModelEvent(this, n, n2));
    }

    private void saveColumnInfos() {
        if (this.folder != null) {
            this.folder.getFolderDisplaySettings().setColumnInfos(this.columnInfos);
        }
    }

    public void setColumnMargin(int n) {
        if (n != this.columnMargin) {
            this.columnMargin = n;
            this.fireColumnMarginChanged();
        }
    }

    public int getColumnCount() {
        return this.tableColumns.size();
    }

    public Enumeration getColumns() {
        return this.tableColumns.elements();
    }

    public int getColumnIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Enumeration enumeration = this.getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (object.equals(tableColumn.getIdentifier())) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    public int getColumnIndex(int n) {
        Enumeration enumeration = this.getColumns();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (tableColumn.getModelIndex() == n) {
                return n2;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    public int getColumnModelIndex(int n) {
        return this.getColumn(n).getModelIndex();
    }

    public TableColumn getColumn(int n) {
        return (TableColumn)this.tableColumns.elementAt(n);
    }

    public int getColumnMargin() {
        return this.columnMargin;
    }

    public int getColumnIndexAtX(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if ((n -= this.getColumn(i).getWidth()) >= 0) continue;
            return i;
        }
        return -1;
    }

    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
    }

    public ListSelectionModel getSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public void setColumnSelectionAllowed(boolean bl) {
    }

    public boolean getColumnSelectionAllowed() {
        return false;
    }

    public int[] getSelectedColumns() {
        return new int[0];
    }

    public int getSelectedColumnCount() {
        return 0;
    }

    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.add(class$javax$swing$event$TableColumnModelListener == null ? (class$javax$swing$event$TableColumnModelListener = ItemListColumnsModel.class$("javax.swing.event.TableColumnModelListener")) : class$javax$swing$event$TableColumnModelListener, tableColumnModelListener);
    }

    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.remove(class$javax$swing$event$TableColumnModelListener == null ? (class$javax$swing$event$TableColumnModelListener = ItemListColumnsModel.class$("javax.swing.event.TableColumnModelListener")) : class$javax$swing$event$TableColumnModelListener, tableColumnModelListener);
    }

    public TableColumnModelListener[] getColumnModelListeners() {
        return (TableColumnModelListener[])this.listenerList.getListeners(class$javax$swing$event$TableColumnModelListener == null ? (class$javax$swing$event$TableColumnModelListener = ItemListColumnsModel.class$("javax.swing.event.TableColumnModelListener")) : class$javax$swing$event$TableColumnModelListener);
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$TableColumnModelListener == null ? ItemListColumnsModel.class$("javax.swing.event.TableColumnModelListener") : class$javax$swing$event$TableColumnModelListener)) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnAdded(tableColumnModelEvent);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$TableColumnModelListener == null ? ItemListColumnsModel.class$("javax.swing.event.TableColumnModelListener") : class$javax$swing$event$TableColumnModelListener)) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnRemoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$TableColumnModelListener == null ? ItemListColumnsModel.class$("javax.swing.event.TableColumnModelListener") : class$javax$swing$event$TableColumnModelListener)) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnMoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$TableColumnModelListener == null ? ItemListColumnsModel.class$("javax.swing.event.TableColumnModelListener") : class$javax$swing$event$TableColumnModelListener)) continue;
            ((TableColumnModelListener)objectArray[i + 1]).columnSelectionChanged(listSelectionEvent);
        }
    }

    protected void fireColumnMarginChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$TableColumnModelListener == null ? ItemListColumnsModel.class$("javax.swing.event.TableColumnModelListener") : class$javax$swing$event$TableColumnModelListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((TableColumnModelListener)objectArray[i + 1]).columnMarginChanged(this.changeEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("width") || string.equals("preferredWidth")) {
            this.invalidateWidthCache();
            this.fireColumnMarginChanged();
        }
        if (string.equals("width") && !propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue())) {
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            TableColumn tableColumn = (TableColumn)propertyChangeEvent.getSource();
            this.updateColumnWidth(n, tableColumn.getModelIndex());
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireColumnSelectionChanged(listSelectionEvent);
    }

    protected void recalcWidthCache() {
        Enumeration enumeration = this.getColumns();
        this.totalColumnWidth = 0;
        while (enumeration.hasMoreElements()) {
            this.totalColumnWidth += ((TableColumn)enumeration.nextElement()).getWidth();
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }

    public void sortColumn(int n) {
        this.sortColumn(n, null);
    }

    public void sortColumn(int n, SortOrder sortOrder) {
        if (n > 0) {
            int n2 = this.getColumnModelIndex(n);
            ColumnInfo columnInfo = this.columnInfos.getColumnInfoAt(n2);
            if (columnInfo.getFieldID() == 21) {
                return;
            }
            SortOrder sortOrder2 = sortOrder != null ? sortOrder : APIUtils.getSortOrder(!columnInfo.isSortedAscending());
            this.columnInfos.setSortColumn(columnInfo, sortOrder2);
            this.saveColumnInfos();
            if (this.folder != null) {
                GWClient.getApplication().processCommand(new GlobalCommand(1020, this.folder));
            }
        }
    }

    public void setSortHeader() {
        ColumnInfo columnInfo = this.getColumnInfos().getSorted();
        boolean bl = columnInfo.isSortedAscending();
        int n = this.getColumnIndex(this.getColumnInfos().getIndexOf(columnInfo));
        this.sortHeaderRenderer.setPressed(n, bl);
    }

    public void setColumnInfos(ColumnInfos columnInfos) {
        this.columnInfos = columnInfos;
    }

    public void sortColumnByModelIndex(int n, SortOrder sortOrder) {
        int n2 = this.getColumnIndex(n);
        this.sortColumn(n2, sortOrder);
    }

    private void updateColumnWidth(int n, int n2) {
        ColumnInfo columnInfo;
        if (n2 > 0 && (columnInfo = this.columnInfos.getColumnInfoAt(n2)).getWidth() != n) {
            columnInfo.setWidth(n);
            this.columnSizeChanged = true;
        }
    }

    public void headerBeginDrag() {
    }

    public void headerEndDrag() {
        if (this.columnMoved || this.columnSizeChanged) {
            this.saveColumnInfos();
            this.columnMoved = false;
            this.columnSizeChanged = false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

