/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.standardgwitemtable;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.cache.IDObjectsCollection;
import com.appframework.cache.IdentifiedObject;
import com.appframework.drag.DragManager;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.ExTableUI;
import com.novell.gw.jclient.application.actions.item.ActionDeleteItem;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.ScrollPaneBorderHighlightFocusListener;
import com.novell.gw.jclient.application.controls.folderstree.TransferableWrapper;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FolderPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWItemPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.controls.standardgwitemtable.CheckImagesPanelEditor;
import com.novell.gw.jclient.application.controls.standardgwitemtable.CheckListTableModel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.DraggableHeader;
import com.novell.gw.jclient.application.controls.standardgwitemtable.EmptyItemListTableModel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.GWTableCellRenderer;
import com.novell.gw.jclient.application.controls.standardgwitemtable.HeaderPopupMenu;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListColumnsModel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTableController;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTableModel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTableSelectionModel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTableUtils;
import com.novell.gw.jclient.application.controls.standardgwitemtable.SortHeader;
import com.novell.gw.jclient.application.controls.standardgwitemtable.SortHeaderListener;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CheckListFolder;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AddToCheckListTableItem;
import com.novell.gw.jclient.bl.om.items.ItemDescription;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.TableItem;
import com.novell.gw.message.Message;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class ItemListTable
extends JTable
implements MVCView,
ListSelectionListener,
SortHeaderListener,
Autoscroll {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListTable == null ? (class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListTable = ItemListTable.class$("com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTable")) : class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListTable));
    private MVCController controller;
    private RefreshTimer timer = new RefreshTimer(ItemListTableUtils.TIMER_DELAY, new RefreshTimerAction());
    private ItemListTableModel defaultDataModel;
    private ListSelectionModel defaultSelectionModel;
    private IDObjectsCollection selected;
    private HeaderPopupMenu headerPopupMenu;
    private Point arrowLocation;
    private DropTarget dropTarget = new DropTarget(this, 3, new ILDTListener());
    private final int row_height;
    private boolean paintArrow;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListTable;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$standardgwitemtable$CheckImagesColumnPanel;
    static /* synthetic */ Class class$java$lang$Object;

    public ItemListTable(MVCController mVCController) {
        this.initUI();
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, new ILTDragGestureListener());
        this.setController(new ItemListTableController(this, mVCController));
        this.addFocusListener(new ScrollPaneBorderHighlightFocusListener(this));
        this.adjustRowHeight();
        this.row_height = this.getRowHeight();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawArrow((Graphics2D)graphics);
    }

    private void drawArrow(Graphics2D graphics2D) {
        if (this.arrowLocation == null || !this.paintArrow) {
            return;
        }
        Image image = ImageResources.ICON_CHECKLIST_ARROW.getImage();
        int n = image.getHeight(this);
        graphics2D.drawImage(image, this.arrowLocation.x, this.arrowLocation.y - n / 2 + 1, this);
    }

    private void initUI() {
        this.setUI(new ItemListTableUI());
        this.setShowGrid(false);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setAutoCreateColumnsFromModel(false);
        this.setAutoscrolls(true);
        this.setAutoResizeMode(0);
        this.setDefaultEditor(class$com$novell$gw$jclient$application$controls$standardgwitemtable$CheckImagesColumnPanel == null ? (class$com$novell$gw$jclient$application$controls$standardgwitemtable$CheckImagesColumnPanel = ItemListTable.class$("com.novell.gw.jclient.application.controls.standardgwitemtable.CheckImagesColumnPanel")) : class$com$novell$gw$jclient$application$controls$standardgwitemtable$CheckImagesColumnPanel, new CheckImagesPanelEditor());
        this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ItemListTable.class$("java.lang.Object")) : class$java$lang$Object, new OrientableTableCellRenderer());
        UIUtils.initTableFocusTraversalKeys(this);
        this.headerPopupMenu = new HeaderPopupMenu();
    }

    private void adjustRowHeight() {
        FontMetrics fontMetrics;
        int n;
        int n2 = 15;
        Font font = this.getFont();
        if (font != null && (n = (fontMetrics = this.getFontMetrics(font)).getHeight()) > n2) {
            n2 = n;
        }
        n2 = (int)((double)n2 * 1.2);
        this.setRowHeight(n2);
    }

    public boolean getAutoCreateColumnsFromModel() {
        return false;
    }

    public void createDefaultColumnsFromModel() {
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return this.getDefaultSelectionModel();
    }

    protected TableModel createDefaultDataModel() {
        return this.getDefaultDataModel();
    }

    protected TableColumnModel createDefaultColumnModel() {
        return this.getDefaultDataModel().getColumnsModel();
    }

    private ItemListTableModel getDefaultDataModel() {
        if (this.defaultDataModel == null) {
            this.defaultDataModel = new EmptyItemListTableModel();
        }
        return this.defaultDataModel;
    }

    private ListSelectionModel getDefaultSelectionModel() {
        if (this.defaultSelectionModel == null) {
            this.defaultSelectionModel = new ItemListTableSelectionModel();
        }
        return this.defaultSelectionModel;
    }

    public void setController(MVCController mVCController) {
        this.controller = mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public Object getMVCModel() {
        return null;
    }

    public void setMVCModel(Object object) {
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.updateTableUI();
        this.fireCountChanged();
        this.clearSelection();
    }

    private void updateTableUI() {
        ItemListTableModel itemListTableModel = (ItemListTableModel)this.getModel();
        if (itemListTableModel instanceof CheckListTableModel) {
            boolean bl;
            CheckListTableModel checkListTableModel = (CheckListTableModel)itemListTableModel;
            int n = checkListTableModel.getChecklistDummyItemIndex();
            boolean bl2 = bl = n != -1;
            if (bl) {
                this.setCheckListUI(checkListTableModel, n);
                return;
            }
        }
        this.setPlainTableUI();
    }

    private void fireCountChanged() {
        if (!(this.getModel() instanceof EmptyItemListTableModel)) {
            ItemListTableModel itemListTableModel = (ItemListTableModel)this.getModel();
            this.getController().processCommand(new Command(820, new Integer(itemListTableModel.getItemList().getDisplayItemCount())));
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.select(listSelectionEvent.getValueIsAdjusting());
    }

    public void clearSelection() {
        this.clearSelection(false);
    }

    public void clearSelection(boolean bl) {
        if (bl || this.selected == null) {
            super.clearSelection();
        } else {
            this.getSelectionModel().removeListSelectionListener(this);
            IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
            this.selected.copy(iDObjectsCollection);
            int n = this.getSelectionModel().getMinSelectionIndex();
            super.clearSelection();
            this.getSelectionModel().addListSelectionListener(this);
            this.restoreSelected(iDObjectsCollection, n);
        }
    }

    private void restoreSelected(IDObjectsCollection iDObjectsCollection, int n) {
        Serializable serializable;
        int n2;
        ItemListTableModel itemListTableModel = (ItemListTableModel)this.getModel();
        int n3 = iDObjectsCollection.size();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n3; ++i) {
            TableItem tableItem = (TableItem)iDObjectsCollection.getIDObjectAt(i);
            n2 = itemListTableModel.getIndex(tableItem);
            if (n2 == -1) continue;
            arrayList.add(new Integer(n2));
        }
        if (arrayList.size() == 0) {
            if (n >= itemListTableModel.getRowCount()) {
                n = itemListTableModel.getRowCount() - 1;
            }
            if (n >= 0) {
                arrayList.add(new Integer(n));
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            serializable = (Integer)arrayList.get(n2);
            nArray[n2] = serializable;
        }
        if (nArray.length > 0) {
            ItemListTableSelectionModel itemListTableSelectionModel = (ItemListTableSelectionModel)this.getSelectionModel();
            itemListTableSelectionModel.setSelectedIndexes(nArray);
            if (this.getAutoscrolls() && (serializable = this.getCellRect(nArray[0], 0, false)) != null) {
                this.scrollRectToVisible((Rectangle)serializable);
            }
        }
        this.select(false);
    }

    private void fireSelectionCommand() {
        this.selected = this.getSelectedItems();
        Command command = new Command(1050, new Integer(this.selected.size()));
        this.getController().processCommand(command);
        this.updateFocusAndSelection(this.selected);
    }

    private void updateFocusAndSelection(IDObjectsCollection iDObjectsCollection) {
        if (iDObjectsCollection.size() == 1) {
            IdentifiedObject identifiedObject = iDObjectsCollection.getIDObjectAt(0);
            if (identifiedObject instanceof AbstractItem) {
                AbstractItem abstractItem = (AbstractItem)identifiedObject;
                ItemDescription itemDescription = new ItemDescription(abstractItem);
                Command command = new Command(20, itemDescription);
                command.setAttribute("FOCUSED", this.isFocusOwner());
                this.getController().processCommand(command);
            } else if (identifiedObject instanceof AbstractFolder) {
                Command command = new Command(470);
                this.getController().processCommand(command);
                if (this.isFocusOwner()) {
                    command = new Command(10, identifiedObject);
                    command.setAttribute("FOCUSED", Boolean.TRUE);
                    this.getController().processCommand(command);
                }
            } else {
                Command command = new Command(470);
                command.setCommandObject(identifiedObject);
                this.getController().processCommand(command);
            }
        } else if (iDObjectsCollection.size() > 1) {
            if (ItemListTableUtils.isFoldersCollection(iDObjectsCollection)) {
                Command command = new Command(470);
                this.getController().processCommand(command);
            } else {
                IDObjectsCollection iDObjectsCollection2 = ItemListTableUtils.extractItems(iDObjectsCollection);
                Command command = new Command(430, iDObjectsCollection2);
                command.setAttribute("FOCUSED", this.isFocusOwner());
                this.getController().processCommand(command);
            }
        } else {
            Command command = new Command(470);
            this.getController().processCommand(command);
        }
    }

    protected IDObjectsCollection getSelectedItems() {
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        ItemListTableModel itemListTableModel = (ItemListTableModel)this.getModel();
        int[] nArray = this.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            TableItem tableItem = itemListTableModel.getItemAt(nArray[i]);
            iDObjectsCollection.addIDObject(tableItem);
        }
        return iDObjectsCollection;
    }

    void setSelextedItems(IDObjectsCollection iDObjectsCollection) {
        ItemListTableModel itemListTableModel = (ItemListTableModel)this.getModel();
        for (int i = 0; i < iDObjectsCollection.size(); ++i) {
            TableItem tableItem = (TableItem)iDObjectsCollection.getIDObjectAt(i);
            int n = itemListTableModel.getIndex(tableItem);
            if (n == -1) continue;
            this.addRowSelectionInterval(n, n);
        }
        if (iDObjectsCollection.size() == 0) {
            this.clearSelection();
        }
        this.drawItFocused(this.isFocusOwner());
    }

    protected TableItem getSelectedItem() {
        int n = this.getSelectedRow();
        return ((ItemListTableModel)this.getModel()).getItemAt(n);
    }

    private void deleteItem(KeyEvent keyEvent) {
        if (!(this.getSelectedItem() instanceof AbstractItem)) {
            return;
        }
        ActionDeleteItem actionDeleteItem = (ActionDeleteItem)this.getController().getActionList().getAction("Delete Item");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
        if (actionDeleteItem.getAppActionModel().getAccelerator().equals(keyStroke) && !actionDeleteItem.isEnabled()) {
            int n = this.getSelectedRowCount();
            if (n == 1) {
                MessageUtils.delete(((ItemListTableModel)this.getModel()).getItemList(), (AbstractItem)this.getSelectedItem(), (Component)this);
            } else if (n > 1) {
                MessageUtils.delete(this.getSelectedItems(), ((ItemListTableModel)this.getModel()).getItemList(), (Component)this);
            }
        }
    }

    private void openItem() {
        IDObjectsCollection iDObjectsCollection = this.getSelectedItems();
        if (iDObjectsCollection.size() == 1 && iDObjectsCollection.getIDObjectAt(0) instanceof AbstractFolder) {
            Command command = new Command(40, iDObjectsCollection.getIDObjectAt(0));
            this.getController().processCommand(command);
        } else {
            ApplicationFrame applicationFrame = (ApplicationFrame)SwingUtilities.getWindowAncestor(this);
            for (int i = 0; i < iDObjectsCollection.size(); ++i) {
                if (!(iDObjectsCollection.getIDObjectAt(i) instanceof AbstractItem) || !((AbstractItem)iDObjectsCollection.getIDObjectAt(i)).canOpen()) continue;
                MessageUtils.doOpenItem(new ItemDescription((AbstractItem)iDObjectsCollection.getIDObjectAt(i)), true, applicationFrame, MessageUtils.getMainFrameController(this.getController()));
            }
        }
    }

    public void drawItFocused(boolean bl) {
        int[] nArray = this.getSelectedRows();
        int n = this.getColumnCount();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            for (int j = 0; j < n; ++j) {
                int n3;
                TableCellRenderer tableCellRenderer = this.getCellRenderer(n2, j);
                if (tableCellRenderer instanceof GWTableCellRenderer) {
                    GWTableCellRenderer gWTableCellRenderer = (GWTableCellRenderer)tableCellRenderer;
                    gWTableCellRenderer.setFocused(bl);
                    this.repaint();
                }
                if ((n3 = this.getEditingRow()) == -1) continue;
                this.getDefaultEditor(class$com$novell$gw$jclient$application$controls$standardgwitemtable$CheckImagesColumnPanel == null ? ItemListTable.class$("com.novell.gw.jclient.application.controls.standardgwitemtable.CheckImagesColumnPanel") : class$com$novell$gw$jclient$application$controls$standardgwitemtable$CheckImagesColumnPanel).stopCellEditing();
            }
        }
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot set a null TableModel");
        }
        if (this.dataModel != tableModel) {
            TableModel tableModel2 = this.dataModel;
            if (tableModel2 != null) {
                tableModel2.removeTableModelListener(this);
            }
            this.dataModel = tableModel;
            tableModel.addTableModelListener(this);
        }
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel != tableColumnModel2) {
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            this.columnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(this);
        }
    }

    public void updateModel(ItemListTableModel itemListTableModel) {
        DraggableHeader draggableHeader;
        this.clearSelection(true);
        this.setModel(itemListTableModel);
        this.updateTableUI();
        this.setColumnModel(itemListTableModel.getColumnsModel());
        if (itemListTableModel instanceof CheckListTableModel) {
            this.setDropTarget(this.dropTarget);
            draggableHeader = itemListTableModel.getFolder() instanceof CheckListFolder ? new DraggableHeader(itemListTableModel.getColumnsModel(), this) : new SortHeader(itemListTableModel.getColumnsModel(), this);
        } else {
            this.setDropTarget(null);
            draggableHeader = new SortHeader(itemListTableModel.getColumnsModel(), this);
        }
        this.setTableHeader(draggableHeader);
        this.configureEnclosingScrollPane();
        this.resizeAndRepaint();
        this.fireCountChanged();
    }

    private void setPlainTableUI() {
        ExTableUI exTableUI = (ExTableUI)this.getUI();
        exTableUI.setRows(new ArrayList());
        exTableUI.setStartFrom(0);
        exTableUI.setMergedCellsCount(0);
    }

    private void setCheckListUI(CheckListTableModel checkListTableModel, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(new Integer(n));
        ExTableUI exTableUI = (ExTableUI)this.getUI();
        exTableUI.setRows(arrayList);
        exTableUI.setStartFrom(1);
        exTableUI.setMergedCellsCount(checkListTableModel.getColumnCount() - 1);
    }

    public void columnSort(int n) {
        if (this.getColumnModel() instanceof ItemListColumnsModel) {
            ((ItemListColumnsModel)this.getColumnModel()).sortColumn(n);
        }
    }

    public void columnShowPopUpMenu(int n, MouseEvent mouseEvent) {
        if (this.getColumnModel() instanceof ItemListColumnsModel) {
            ItemListColumnsModel itemListColumnsModel = (ItemListColumnsModel)this.getColumnModel();
            int n2 = n < 0 ? n : itemListColumnsModel.getColumnModelIndex(n);
            String string = ControlsUtils.getUserGuid(this.controller);
            this.headerPopupMenu.show(this.getTableHeader(), mouseEvent.getPoint(), itemListColumnsModel, n2, string);
        }
    }

    public void columnBeginDrag(int n) {
        if (this.getColumnModel() instanceof ItemListColumnsModel) {
            ((ItemListColumnsModel)this.getColumnModel()).headerBeginDrag();
        }
    }

    public void columnEndDrag(int n) {
        if (this.getColumnModel() instanceof ItemListColumnsModel) {
            ((ItemListColumnsModel)this.getColumnModel()).headerEndDrag();
        }
    }

    public void handleColumnsStructureChanged(AbstractFolder abstractFolder) {
        ItemListTableModel itemListTableModel = (ItemListTableModel)this.getModel();
        itemListTableModel.updateColumns();
        if (abstractFolder.getFolderDisplaySettings().getViewMode() == 7) {
            this.updateModel(new CheckListTableModel(abstractFolder, this.getController()));
        } else {
            this.updateModel(itemListTableModel);
        }
    }

    public void handleColumnsSortChanged(AbstractFolder abstractFolder) {
        ItemListTableModel itemListTableModel = (ItemListTableModel)this.getModel();
        ItemListColumnsModel itemListColumnsModel = (ItemListColumnsModel)this.getColumnModel();
        if (itemListTableModel.getFolder() != null && itemListTableModel.getFolder().equals(abstractFolder)) {
            itemListTableModel.sort();
            itemListColumnsModel.setSortHeader();
            this.getTableHeader().repaint();
        }
    }

    public void setFilter(Filter filter) {
        ItemListTableModel itemListTableModel = (ItemListTableModel)this.getModel();
        itemListTableModel.setFilter(filter);
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        this.changeSelection(n, n2, bl, bl2, true);
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        Rectangle rectangle;
        boolean bl4 = this.isRowSelected(n);
        this.changeSelectionModel(n, bl, bl2, bl4, bl3);
        if (this.getAutoscrolls() && (rectangle = this.getCellRect(n, n2, false)) != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public void scrollToRect(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, false);
        if (rectangle != null) {
            if (rectangle.y > 0) {
                rectangle.setLocation(rectangle.x, rectangle.y - rectangle.height);
            }
            rectangle.setSize(rectangle.width, rectangle.height * 3);
            this.scrollRectToVisible(rectangle);
            this.scrollRectToVisible(rectangle);
        }
    }

    private void changeSelectionModel(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ItemListTableSelectionModel itemListTableSelectionModel = (ItemListTableSelectionModel)this.getSelectionModel();
        itemListTableSelectionModel.setValueIsAdjusting(bl4);
        if (bl2) {
            if (bl) {
                itemListTableSelectionModel.setAnchorSelectionIndex(n);
            } else {
                itemListTableSelectionModel.setLeadSelectionIndex(n);
            }
        } else if (bl) {
            if (bl3) {
                itemListTableSelectionModel.removeSelectionInterval(n, n);
            } else {
                itemListTableSelectionModel.addSelectionInterval(n, n);
            }
        } else {
            itemListTableSelectionModel.setSelectionInterval(n, n);
        }
    }

    public void selectTableItem(TableItem tableItem) {
        ItemListTableModel itemListTableModel = (ItemListTableModel)this.getModel();
        int n = itemListTableModel.getIndex(tableItem);
        if (n != -1) {
            this.changeSelection(n, 0, false, false, false);
            this.scrollToRect(n, 0);
            this.drawItFocused(this.isFocusOwner());
        }
    }

    private void select(boolean bl) {
        if (this.timer == null) {
            return;
        }
        if (bl) {
            this.timer.restart();
        } else {
            this.timer.flash();
        }
    }

    private boolean inSelection(int n) {
        int[] nArray = this.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public Insets getAutoscrollInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle != null) {
            insets.top = rectangle.y + this.row_height;
            insets.left = rectangle.x + this.row_height;
            insets.bottom = this.getHeight() - (rectangle.y + rectangle.height) + this.row_height;
            insets.right = this.getWidth() - (rectangle.x + rectangle.width) + this.row_height;
        }
        return insets;
    }

    public void autoscroll(Point point) {
        UIUtils.scrollComponent(point, this, this.row_height);
        if (this.getModel() instanceof CheckListTableModel && this.paintArrow) {
            this.repaintArrow(point);
        }
    }

    private void repaintArrow(Point point) {
        int n = -1;
        int n2 = this.rowAtPoint(point);
        if (this.arrowLocation != null) {
            n = this.rowAtPoint(this.arrowLocation);
        }
        this.arrowLocation = this.getCellRect(n2, 0, true).getLocation();
        if (point.y > this.arrowLocation.y + this.row_height / 2) {
            this.arrowLocation.y += this.row_height;
        }
        this.repaint(this.getArrowRectForIndex(n));
        this.repaint(this.getArrowRectForIndex(n2));
    }

    private Rectangle getArrowRectForIndex(int n) {
        Rectangle rectangle = this.getCellRect(n, 0, true);
        Image image = ImageResources.ICON_CHECKLIST_ARROW.getImage();
        int n2 = image.getHeight(this);
        rectangle.y -= n2;
        rectangle.height += 2 * n2;
        return rectangle;
    }

    public int[] getSelectedIndicesInItemList() {
        IDObjectsCollection iDObjectsCollection = this.getSelectedItems();
        int[] nArray = new int[iDObjectsCollection.size()];
        for (int i = 0; i < iDObjectsCollection.size(); ++i) {
            TableItem tableItem = (TableItem)iDObjectsCollection.getIDObjectAt(i);
            nArray[i] = ((ItemListTableModel)this.getModel()).getItemList().indexOf(tableItem.getNativeObject());
        }
        return nArray;
    }

    private boolean isUnderChecklistItem(Point point) {
        int n = this.rowAtPoint(point);
        TableItem tableItem = ((ItemListTableModel)this.getModel()).getItemAt(n);
        if (tableItem instanceof AddToCheckListTableItem) {
            return true;
        }
        if (tableItem instanceof AbstractItem) {
            return ((AbstractItem)tableItem).isInChecklist();
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ILDTListener
    extends DropTargetAdapter {
        private ILDTListener() {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            String string = ControlsUtils.getUserGuid(ItemListTable.this.getController());
            Point point = dropTargetDragEvent.getLocation();
            ItemListTable.this.isUnderChecklistItem(point);
            boolean bl = dropTargetDragEvent.getCurrentDataFlavorsAsList().contains(GWFlavors.singleItem);
            boolean bl2 = string.equals(GWFlavors.singleItem.getUserGuid());
            ItemListTable.this.paintArrow = false;
            if (!(ItemListTable.this.getModel() instanceof CheckListTableModel)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getSourceActions());
                if (bl && bl2 && ItemListTable.this.isUnderChecklistItem(point)) {
                    ItemListTable.this.paintArrow = true;
                }
            }
            ItemListTable.this.repaintArrow(dropTargetDragEvent.getLocation());
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            ItemListTable.this.arrowLocation = null;
            ItemListTable.this.repaint();
            if (dropTargetDropEvent.isLocalTransfer() && dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(GWFlavors.itemsFlavor)) {
                this.acceptItemList(dropTargetDropEvent);
            }
        }

        private void acceptItemList(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                int n = ((int[])transferable.getTransferData(GWFlavors.singleItem))[0];
                int n2 = ItemListTable.this.rowAtPoint(dropTargetDropEvent.getLocation());
                if (dropTargetDropEvent.getLocation().y > ItemListTable.this.getCellRect((int)n2, (int)0, (boolean)true).getLocation().y + ItemListTable.this.row_height / 2) {
                    ++n2;
                }
                if (n2 > n) {
                    --n2;
                }
                ItemList itemList = ((ItemListTableModel)ItemListTable.this.getModel()).getItemList();
                if (ItemListTable.this.isUnderChecklistItem(dropTargetDropEvent.getLocation())) {
                    itemList.checklistMoveTo(n, n2);
                } else {
                    Message message = (Message)itemList.getItemAt(n);
                    message.showInChecklist(false);
                }
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Exception exception) {
                logger.error((Object)exception);
                logger.debug((Object)exception, (Throwable)exception);
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            ItemListTable.this.arrowLocation = null;
            ItemListTable.this.repaint();
        }
    }

    public class ItemListTableUI
    extends ExTableUI {
        public ItemListTableUI() {
        }

        public ItemListTableUI(int n, int n2, List list) {
            super(n, n2, list);
        }

        protected MouseInputListener createMouseInputListener() {
            return new ILTMouseInputHandler();
        }

        protected FocusListener createFocusListener() {
            return new ILTFocusListener();
        }

        protected KeyListener createKeyListener() {
            return new ILTKeyListener();
        }
    }

    private class ILTMouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean inSelection;
        private int column;
        private int row;
        private boolean isPopupTrigger;

        private ILTMouseInputHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.isPopupTrigger = mouseEvent.isPopupTrigger();
            this.adjustFocusAndSelection(mouseEvent);
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.dispatchComponent = null;
            this.isPopupTrigger |= mouseEvent.isPopupTrigger();
            if (this.inSelection && !this.isPopupTrigger) {
                ItemListTable itemListTable = ItemListTable.this;
                itemListTable.changeSelection(this.row, this.column, this.isToggleDown(mouseEvent), mouseEvent.isShiftDown(), false);
                this.inSelection = false;
            }
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ItemListTable itemListTable = ItemListTable.this;
                if (ItemListTableUtils.isItemsCollection(itemListTable.selected)) {
                    AbstractActionsPopupMenu abstractActionsPopupMenu;
                    AbstractItem abstractItem = (AbstractItem)itemListTable.selected.getIDObjectAt(0);
                    int n = abstractItem.getNativeItem().getViewFolder().getId();
                    String string = ControlsUtils.getUserGuid(ItemListTable.this.controller);
                    AbstractFolder abstractFolder = FoldersCache.getFolder(String.valueOf(n), string);
                    if (itemListTable.selected.size() > 1) {
                        abstractActionsPopupMenu = GWItemPopupMenu.createMultipleItemsPopupMenu(abstractFolder.getType(), itemListTable.getController().getActionList(), ((ItemListTableModel)itemListTable.getModel()).getItemList(), itemListTable.getSelectedIndicesInItemList());
                    } else {
                        int n2 = ItemListTable.this.columnAtPoint(mouseEvent.getPoint());
                        String string2 = ItemListTable.this.getModel().getColumnName(n2);
                        abstractActionsPopupMenu = GWItemPopupMenu.createGWItemPopupMenu(abstractFolder.getType(), abstractItem, string2, itemListTable.getController().getActionList());
                    }
                    ((JPopupMenu)abstractActionsPopupMenu).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (ItemListTableUtils.isFoldersCollection(itemListTable.selected)) {
                    AbstractFolder abstractFolder = (AbstractFolder)itemListTable.selected.getIDObjectAt(0);
                    ActionList actionList = itemListTable.getController().getActionList();
                    if (actionList instanceof ApplicationFrameActionList && itemListTable.selected.size() == 1) {
                        FolderPopupMenu folderPopupMenu = FolderPopupMenu.createFolderPopupMenu(abstractFolder, (ApplicationFrameActionList)actionList);
                        ((JPopupMenu)folderPopupMenu).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (OS.isDoubleClick(mouseEvent)) {
                ItemListTable.this.openItem();
            }
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            ItemListTable itemListTable = ItemListTable.this;
            Component component = itemListTable.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(itemListTable, point, component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            ItemListTable itemListTable = ItemListTable.this;
            if (this.dispatchComponent == null || !itemListTable.isEditing()) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(itemListTable, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        private void adjustFocusAndSelection(MouseEvent mouseEvent) {
            TableCellEditor tableCellEditor;
            ItemListTable itemListTable = ItemListTable.this;
            Point point = mouseEvent.getPoint();
            this.row = itemListTable.rowAtPoint(point);
            this.column = itemListTable.columnAtPoint(point);
            if (this.column == -1 || this.row == -1) {
                return;
            }
            if (itemListTable.editCellAt(this.row, this.column, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            }
            if (!itemListTable.isFocusOwner()) {
                itemListTable.requestFocus();
            }
            if ((tableCellEditor = itemListTable.getCellEditor()) == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                this.inSelection = itemListTable.inSelection(this.row);
                if (!this.inSelection) {
                    itemListTable.changeSelection(this.row, this.column, this.isToggleDown(mouseEvent), mouseEvent.isShiftDown(), false);
                }
            }
        }

        private boolean isToggleDown(MouseEvent mouseEvent) {
            if (OS.isMacOS()) {
                return mouseEvent.isMetaDown() && SwingUtilities.isLeftMouseButton(mouseEvent);
            }
            return mouseEvent.isControlDown();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }

    private class ILTKeyListener
    extends KeyAdapter {
        private ILTKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            ItemListTable.this.deleteItem(keyEvent);
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 10: {
                    if (keyEvent.getModifiers() != 0) break;
                    ItemListTable.this.openItem();
                    break;
                }
            }
        }
    }

    private class RefreshTimerAction
    implements ActionListener {
        private RefreshTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ItemListTable.this.fireSelectionCommand();
        }
    }

    private class RefreshTimer
    extends Timer {
        public RefreshTimer(int n, RefreshTimerAction refreshTimerAction) {
            super(n, refreshTimerAction);
            this.setRepeats(false);
        }

        public void flash() {
            this.stop();
            this.fireActionPerformed(new ActionEvent(this, 0, null, System.currentTimeMillis(), 0));
        }
    }

    private class ILTFocusListener
    implements FocusListener {
        private ILTFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (FocusManager.getCurrentManager().getPermanentFocusOwner() == null) {
                ItemListTable.this.getController().processCommand(new Command(1160, null));
            }
            ItemListTable.this.drawItFocused(false);
        }

        public void focusGained(FocusEvent focusEvent) {
            IDObjectsCollection iDObjectsCollection = ItemListTable.this.getSelectedItems();
            ItemListTable.this.updateFocusAndSelection(iDObjectsCollection);
            ItemListTable.this.drawItFocused(true);
            ItemListTable.this.getController().processCommand(new Command(1160, ItemListTable.this));
        }
    }

    private class ILTDragSourceListener
    extends DragSourceAdapter {
        private int userAction;

        private ILTDragSourceListener() {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            this.userAction = dragSourceDragEvent.getUserAction();
            if (this.userAction == 1) {
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
            } else if (this.userAction == 2) {
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            this.userAction = dragSourceDragEvent.getUserAction();
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            if (this.userAction == 1) {
                dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
            } else if (this.userAction == 2) {
                dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            super.dragEnter(dragSourceDragEvent);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragManager.getInstance().setItem(null);
        }
    }

    private class ILTDragGestureListener
    implements DragGestureListener {
        private ILTDragGestureListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (dragGestureEvent.getTriggerEvent() instanceof MouseEvent && ((MouseEvent)dragGestureEvent.getTriggerEvent()).getButton() == 2) {
                return;
            }
            if ((dragGestureEvent.getDragAction() & 3) > 0) {
                int[] nArray = ItemListTable.this.getSelectedIndicesInItemList();
                ItemListTableModel itemListTableModel = (ItemListTableModel)ItemListTable.this.getModel();
                ImageIcon imageIcon = ControlsUtils.getImageForTableItem(ItemListTable.this.getSelectedItem());
                if (itemListTableModel.canDeleteItemsAt(nArray)) {
                    Object object;
                    boolean bl = "Documents".equals(itemListTableModel.getType());
                    if (nArray.length == 1 && (object = ItemListTable.this.getSelectedItem()) instanceof AbstractCalendarItem) {
                        DragManager.getInstance().setItem((AbstractCalendarItem)object);
                    }
                    object = ControlsUtils.getUserGuid(ItemListTable.this.getController());
                    dragGestureEvent.startDrag(DragSource.DefaultMoveNoDrop, imageIcon.getImage(), new Point(8, 8), new TransferableWrapper(itemListTableModel, nArray, bl, (String)object), new ILTDragSourceListener());
                }
            }
        }
    }
}

