/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.standardgwitemtable.filter;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelector;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.standardgwitemtable.filter.CustomFilter;
import com.novell.gw.jclient.application.controls.standardgwitemtable.filter.EmptyFilter;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FilterDialog
extends BasicDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$standardgwitemtable$filter$FilterDialog == null ? (class$com$novell$gw$jclient$application$controls$standardgwitemtable$filter$FilterDialog = FilterDialog.class$("com.novell.gw.jclient.application.controls.standardgwitemtable.filter.FilterDialog")) : class$com$novell$gw$jclient$application$controls$standardgwitemtable$filter$FilterDialog));
    private JButton btnOk = new JMnemonicButton(new OkAction());
    private JButton btnCancel = new JMnemonicButton(new CancelAction());
    private JButton btnReset = new JMnemonicButton(new ResetAction());
    private AddressSelector tfFrom;
    private AddressSelector tfToCC;
    private JTextField tfSubject = new OrientableTextField(20);
    private JTextField tfMessage = new OrientableTextField();
    private JMnemonicLabel lbToCC;
    private JMnemonicLabel lbSubject;
    private JMnemonicLabel lbFrom;
    private JMnemonicLabel lbMessage;
    private MVCController controller;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$standardgwitemtable$filter$FilterDialog;

    public FilterDialog(ApplicationFrame applicationFrame, Filter filter) {
        super(applicationFrame);
        this.controller = applicationFrame.getController();
        this.setTitle(StringResources.FILTER);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        this.buildUI();
        this.pack();
        UIUtils.centerWindowOnScreen(this);
        this.setFilter(filter);
    }

    private void setFilter(Filter filter) {
        CustomFilter customFilter = GWEngineUtils.createCustomFilter(filter);
        this.tfFrom.setText(customFilter.getFrom());
        this.tfToCC.setText(customFilter.getToCC());
        this.tfSubject.setText(customFilter.getSubject());
        this.tfMessage.setText(customFilter.getMessage());
        this.selectFirstFilledComponent();
    }

    private void selectFirstFilledComponent() {
        if (!"".equals(this.tfFrom.getText())) {
            this.tfFrom.selectAll();
            this.tfFrom.requestFocus();
            return;
        }
        if (!"".equals(this.tfToCC.getText())) {
            this.tfToCC.selectAll();
            this.tfToCC.requestFocus();
            return;
        }
        if (!"".equals(this.tfSubject.getText())) {
            this.tfSubject.selectAll();
            this.tfSubject.requestFocus();
            return;
        }
        if (!"".equals(this.tfMessage.getText())) {
            this.tfMessage.selectAll();
            this.tfMessage.requestFocus();
            return;
        }
    }

    private void buildUI() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(0, 1, 5, 2));
        this.tfFrom = new AddressSelector(null, this.getController());
        this.lbFrom = new JMnemonicLabel(StringResources.FROM_C, this.tfFrom.getTextComponent());
        orientablePanel.add(this.lbFrom);
        orientablePanel.add(this.tfFrom);
        this.tfToCC = new AddressSelector(null, this.getController());
        this.lbToCC = new JMnemonicLabel(StringResources.TO_CC, this.tfToCC.getTextComponent());
        orientablePanel.add(this.lbToCC);
        orientablePanel.add(this.tfToCC);
        this.lbSubject = new JMnemonicLabel(StringResources.SUBJECT_C, this.tfSubject);
        orientablePanel.add(this.lbSubject);
        orientablePanel.add(this.tfSubject);
        this.lbMessage = new JMnemonicLabel(StringResources.MESSAGE_C, this.tfMessage);
        orientablePanel.add(this.lbMessage);
        orientablePanel.add(this.tfMessage);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)orientablePanel, "Center");
        jPanel.add((Component)this.buildButtonsPane(), "After");
    }

    private JPanel buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        orientablePanel.add(this.btnOk);
        orientablePanel.add(this.btnCancel);
        orientablePanel.add(this.btnReset);
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.add((Component)orientablePanel, "North");
        return orientablePanel2;
    }

    private boolean isEmpty() {
        return this.tfFrom.getText().equals("") && this.tfMessage.getText().equals("") && this.tfSubject.getText().equals("") && this.tfToCC.getText().equals("");
    }

    public MVCController getController() {
        return this.controller;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            super(StringResources.ACTION_RESET);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterDialog.this.setFilter(new CustomFilter());
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterDialog filterDialog = FilterDialog.this;
            filterDialog.hide();
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterDialog filterDialog = FilterDialog.this;
            Filter filter = filterDialog.isEmpty() ? new EmptyFilter() : new CustomFilter(filterDialog.tfFrom.getText(), filterDialog.tfToCC.getText(), filterDialog.tfSubject.getText(), filterDialog.tfMessage.getText());
            Command command = new Command(400, filter);
            filterDialog.getController().processCommand(command);
            filterDialog.hide();
        }
    }
}

