/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.standardgwitemtable.filter;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class FilterFeedbackDialog
extends BasicDialog {
    private JButton btnYes = new JMnemonicButton(new YesAction());
    private JButton btnNo = new JMnemonicButton(new NoAction());
    private JButton btnClear = new JMnemonicButton(new ClearAction());
    private MVCController controller;

    public FilterFeedbackDialog(ApplicationFrame applicationFrame, MVCController mVCController) throws HeadlessException {
        super(applicationFrame);
        this.controller = mVCController;
        this.setTitle(StringResources.FILTER_FEEDBACK);
        this.getRootPane().setDefaultButton(this.btnYes);
        this.setCancelButton(this.btnNo);
        this.buildUI();
    }

    private void buildUI() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout(5, 5));
        orientablePanel.add((Component)new OrientableLabel(StringResources.NO_ITEMS_WERE_FOUND), "North");
        orientablePanel.add((Component)new OrientableLabel(StringResources.MODIFY_YOUR_FILTER), "Center");
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)new OrientableLabel(ImageResources.ICON_FILTER_FEEDBACK), "Before");
        jPanel.add((Component)orientablePanel, "Center");
        jPanel.add((Component)this.buildButtonsPane(), "South");
        this.pack();
        UIUtils.centerWindowOnScreen(this);
    }

    private JPanel buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(2, 10, 10));
        orientablePanel.add(this.btnYes);
        orientablePanel.add(this.btnNo);
        orientablePanel.add(this.btnClear);
        return orientablePanel;
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super(StringResources.FILTER_FEEDBACK_CLEAR);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterFeedbackDialog.this.controller.getActionList().getAction("clear filter").actionPerformed(actionEvent);
            FilterFeedbackDialog.this.dispose();
        }
    }

    private class NoAction
    extends AbstractAction {
        public NoAction() {
            super(StringResources.FILTER_FEEDBACK_NO);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterFeedbackDialog.this.dispose();
        }
    }

    private class YesAction
    extends AbstractAction {
        public YesAction() {
            super(StringResources.FILTER_FEEDBACK_YES);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterFeedbackDialog.this.dispose();
            FilterFeedbackDialog.this.controller.getActionList().getAction("create items filter").actionPerformed(actionEvent);
        }
    }
}

