/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.timepicker;

import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DocumentChangeHandler;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.timepicker.MutableTextField;
import com.novell.gw.jclient.application.controls.timepicker.TimeFormat;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class TimeTextField
extends OrientableTextField
implements MutableTextField {
    private static final Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DurationTextField == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DurationTextField = TimeTextField.class$("com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationTextField")) : class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DurationTextField));
    private ArrayList listeners;
    private TimeFormat format;
    private DocumentChangeHandler documentHandler;
    private GregorianCalendar time;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DurationTextField;

    public TimeTextField(TimeFormat timeFormat, DocumentChangeHandler documentChangeHandler) {
        this(timeFormat, documentChangeHandler, GWCalendarUtils.getToday());
    }

    public TimeTextField(TimeFormat timeFormat, DocumentChangeHandler documentChangeHandler, GregorianCalendar gregorianCalendar) {
        if (timeFormat == null) {
            throw new IllegalArgumentException("Date format can not be NULL");
        }
        if (documentChangeHandler == null) {
            throw new IllegalArgumentException("Document handler can not be NULL");
        }
        this.format = timeFormat;
        this.documentHandler = documentChangeHandler;
        this.listeners = new ArrayList();
        this.setDocument(new TextDocument());
        this.addFocusListener(new CommitFocusListener());
        this.setTime(gregorianCalendar);
    }

    public void setTime(GregorianCalendar gregorianCalendar) {
        if (gregorianCalendar == null) {
            throw new IllegalArgumentException("Time can not be NULL");
        }
        String string = "";
        if (this.time == null) {
            this.time = GWCalendarUtils.getToday();
        } else {
            string = this.format.format(this.time);
        }
        String string2 = this.format.format(gregorianCalendar);
        if (!string.equals(string2)) {
            this.time.setTime(gregorianCalendar.getTime());
            this.refreshText();
            this.fireValueChanged(new DateChangeEvent((GregorianCalendar)this.time.clone(), this));
        }
    }

    private void refreshText() {
        String string = this.format.format(this.time);
        this.setText(string);
        this.setCaretPosition(0);
    }

    private void handleFocusLost() {
        this.commit();
    }

    public void commit() {
        String string = this.getText();
        try {
            GregorianCalendar gregorianCalendar = this.format.parse(string);
            this.setTime(gregorianCalendar);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.refreshText();
    }

    protected boolean handleChange(String string) {
        if (this.documentHandler.canHandle(string)) {
            this.handleChange(this.documentHandler.getField(string), this.documentHandler.getShift(string));
            return true;
        }
        return false;
    }

    private void handleChange(int n, int n2) {
        this.unselectAll();
        this.commit();
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.time.clone();
        gregorianCalendar.add(n, n2);
        this.setTime(gregorianCalendar);
        this.selectAll();
    }

    private void unselectAll() {
        this.setCaretPosition(0);
        this.moveCaretPosition(0);
    }

    public GregorianCalendar getTime() {
        return (GregorianCalendar)this.time.clone();
    }

    private void fireValueChanged(DateChangeEvent dateChangeEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            DateValueChangeListener dateValueChangeListener = (DateValueChangeListener)this.listeners.get(i);
            dateValueChangeListener.valueChanged(dateChangeEvent);
        }
    }

    public void addValueChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.listeners.add(dateValueChangeListener);
    }

    public void removeValueChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.listeners.remove(dateValueChangeListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TextDocument
    extends PlainDocument {
        private TextDocument() {
        }

        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (!TimeTextField.this.handleChange(string)) {
                super.replace(n, n2, string, attributeSet);
            }
        }
    }

    private class CommitFocusListener
    implements FocusListener {
        private CommitFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            TimeTextField.this.handleFocusLost();
        }
    }
}

