/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.backup;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BackupMailBoxDialog
extends GWDialog {
    private JTextField tfFilePath = new OrientableTextField();
    private JCheckBox cbPrompt = new JMnemonicCheckBox(StringResources.DO_NOT_PROMPT_BEFORE_PERFORMING_BACKUP);

    public BackupMailBoxDialog(JFrame jFrame, String string) {
        this.setModal(true);
        this.setTitle(StringResources.GROUPWISE_MAILBOX_BACKUP);
        this.buildUI();
        this.tfFilePath.setText(string);
    }

    private void buildUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)new JMnemonicLabel(StringResources.DIRECTORY, this.tfFilePath), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.tfFilePath, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 0;
        ToolBarButton toolBarButton = new ToolBarButton(new SelectFolderAction());
        toolBarButton.setPreferredSize(new Dimension(toolBarButton.getPreferredSize().width, this.tfFilePath.getPreferredSize().height));
        GWToolBar gWToolBar = new GWToolBar();
        gWToolBar.add(toolBarButton);
        gWToolBar.setBorder(null);
        jPanel.add((Component)gWToolBar, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this.cbPrompt, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this.buildButtonsPane(), gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public String getBackupToPath() {
        return this.tfFilePath.getText();
    }

    public boolean doNotPrompt() {
        return this.cbPrompt.isSelected();
    }

    private Container buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.add(this.btnOK);
        orientablePanel.add(this.btnCancel);
        return orientablePanel;
    }

    private class SelectFolderAction
    extends AbstractAction {
        public SelectFolderAction() {
            super("", ImageResources.ICON_FOLDER);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OS.isMacOS()) {
                File file;
                boolean bl;
                String string = StringResources.SELECT_DIRECTORY;
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(BackupMailBoxDialog.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser gWMacFileChooser = new GWMacFileChooser(frame, string, null, 0);
                gWMacFileChooser.setVisible(true);
                String string2 = gWMacFileChooser.getFile();
                String string3 = gWMacFileChooser.getDirectory();
                if (string2 != null && (bl = (file = new File(string3 + string2)).isDirectory())) {
                    BackupMailBoxDialog.this.tfFilePath.setText(file.getPath());
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                GWFileChooser gWFileChooser = new GWFileChooser(BackupMailBoxDialog.this, StringResources.OPEN, null, 1, 0, false);
                gWFileChooser.setVisible(true);
                String[] stringArray = gWFileChooser.getResult();
                if (stringArray != null) {
                    File file = gWFileChooser.getChooser().getSelectedFile();
                    BackupMailBoxDialog.this.tfFilePath.setText(file.getPath());
                }
            }
        }
    }
}

